<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package    report_usercoursereports
 * @copyright  2024 https://santoshmagar.com.np/
 * @author     santoshtmp7 https://github.com/santoshtmp/moodle-report_usercoursereports
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 */


defined('MOODLE_INTERNAL') || die();


$string['pluginname'] = 'User Course Reports';
$string['usercoursereports'] = 'User Course Reports';
$string['userreports'] = 'User Reports';
$string['coursereports'] = 'Course Reports';
$string['showingreportdatanumber'] = 'Showing {$a->datafrom}-{$a->datato} data out of {$a->datatotal} data.';
$string['usercoursereports:view'] = 'View User Course Reports';
$string['privacy:metadata'] = 'The User Course Reports plugin does not store any personal data.';
$string['courseformat'] = 'Course format';
$string['coursevisibility'] = 'Course visibility';
$string['enrolmentmethods'] = 'Enrolment methods';
$string['enrolledcourses'] = 'Enrolled courses';
$string['createddate'] = 'Created Date';
$string['modifieddate'] = 'Modified Date';
$string['startdateto'] = 'Start Date';
$string['courses'] = 'Courses';
$string['lastaccess'] = 'Last access';
$string['viewdetail'] = 'View Detail';
$string['citycountry'] = 'City Country';
$string['sn'] = 'S.N';
$string['selectcourses'] = 'Select courses';
$string['allcourses'] = 'All courses';
$string['allcountries'] = 'All countries';
$string['allroles'] = 'All roles';
$string['allusers'] = 'All users';
$string['applyfilter'] = 'Apply filter';
$string['coursefilter'] = 'Course filter';
$string['courseuserfilter'] = 'Course user filter';
$string['userfilter'] = 'User filter';
$string['filter'] = 'Filter';
$string['perpage'] = 'Per page';
$string['authmethod'] = 'Authentication method';
$string['accountstatus'] = 'Account Status';
$string['accountsuspended'] = 'Suspended account';
$string['accountsuspended_any'] = 'Suspended account - Any';
$string['accountsuspended_yes'] = 'Suspended account - Yes';
$string['accountsuspended_no'] = 'Suspended account - No (active)';
$string['accountconfirmed'] = 'Confirmed account';
$string['accountconfirmed_any'] = 'Confirmed account - Any';
$string['accountconfirmed_yes'] = 'Confirmed account - Yes';
$string['accountconfirmed_no'] = 'Confirmed account - No';
$string['coursecreateddatefromto'] = 'Course created from - to date';
$string['coursestartdatefromto'] = 'Course Start from - to date';
$string['invalidaccess'] = 'Invalied access.';
$string['invalidtypeparam'] = 'Invalied report type param.';
$string['invalidcreatedfromdate'] = 'Invalied created from date, it must be smaller than created to date.';
$string['invalidcreatedtodate'] = 'Invalied created to date, it must be bigger than created from date.';
$string['invalidstartdatefrom'] = 'Invalied start from date, it must be smaller than start to date.';
$string['invalidstartdateto'] = 'Invalied start to date, it must be bigger than start from date.';
$string['invalidperpage'] = 'Invalied per page, it must be between 1 to 1000.';
$string['currentlogin'] = 'Current login';
$string['accountcreated'] = 'Account created';
$string['accountmodified'] = 'Account modified';
$string['coursename'] = 'Course Name';
$string['enrolldate'] = 'Enroll Date';
$string['courseprogress'] = 'Course Progress';
$string['courserole'] = 'Course Role';
$string['nodata_available'] = 'No data available';
$string['total_enrolled_users'] = 'Total enrolled users';
$string['totalparticipants'] = 'Total participants';
$string['totalaccessparticipants'] = 'Total access participants';
$string['totalcoursesections'] = 'Total course section';
$string['totalcourseactivities'] = 'Total course activities';
$string['nogroupsdefined'] = 'No group available';
$string['readmore'] = 'Read more';
$string['showless'] = 'Show less';
$string['searchusers'] = 'Search users';
