<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for HelloAsso payment gateway (French).
 *
 * @package    paygw_helloasso
 * @copyright  2025 Sebastien Chassande-Barrioz <chassande@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['pluginname'] = 'HelloAsso';
$string['gatewayname'] = 'HelloAsso';
$string['gatewaydescription'] = 'Paiement sécurisé via HelloAsso';
$string['clientid'] = 'Client ID';
$string['clientid_desc'] = 'Votre Client ID HelloAsso API';
$string['clientid_help'] = 'Saisissez votre Client ID de l\'API HelloAsso. Vous le trouverez dans les paramètres de votre compte HelloAsso, section API.';
$string['clientsecret'] = 'Client Secret';
$string['clientsecret_desc'] = 'Votre Client Secret HelloAsso API';
$string['clientsecret_help'] = 'Saisissez votre Client Secret de l\'API HelloAsso. Gardez cette information confidentielle et ne la partagez jamais publiquement.';
$string['org_slug'] = 'Organization slug';
$string['org_slug_desc'] = 'Identifiant de votre organisation HelloAsso';
$string['org_slug_help'] = 'Le slug de votre organisation est l\'identifiant unique dans vos URLs HelloAsso (ex: "mon-organisation" dans https://www.helloasso.com/associations/mon-organisation)';
$string['paymentdesc'] = 'Paiement HelloAsso';
$string['formid'] = 'Form ID (ancien)';
$string['formid_desc'] = '[OBSOLÈTE] Ce champ n\'est plus utilisé avec l\'intégration API Checkout';
$string['formid_help'] = '[OBSOLÈTE] Le plugin utilise maintenant l\'API HelloAsso Checkout qui ne nécessite pas d\'ID de formulaire';
$string['base_url'] = 'URL de base HelloAsso';
$string['base_url_desc'] = 'L\'URL de base de HelloAsso (production ou sandbox). Utilisez helloasso.com pour la production ou helloasso-sandbox.com pour les tests.';
$string['base_url_help'] = 'Entrez uniquement le nom de domaine sans https:// (ex: helloasso.com ou helloasso-sandbox.com)';
$string['payment_success'] = 'Votre paiement a été effectué avec succès via HelloAsso.';
$string['payment_cancelled'] = 'Votre paiement a été annulé.';
$string['payment_technical_error'] = 'Une erreur technique s\'est produite lors du traitement du paiement. Veuillez réessayer ou contacter le support.';
$string['paymentverificationfailed'] = 'Échec de la vérification du paiement';
$string['paymentnotcompleted'] = 'Le paiement n\'a pas été complété avec succès';
$string['payment_error'] = 'Une erreur est survenue lors du traitement du paiement';
$string['missingconfig'] = 'Configuration manquante HelloAsso';
$string['invalidamount'] = 'Montant de paiement invalide';
$string['paymentnotfound'] = 'Paiement non trouvé';
$string['tokenfailed'] = 'Échec de l\'obtention du token d\'authentification HelloAsso';
$string['checkoutfailed'] = 'Échec de la création de l\'intention de paiement';
$string['debugmode'] = 'Mode débogage';
$string['debugmode_desc'] = 'Activer les logs de débogage pour le dépannage. Les logs apparaîtront dans la sortie de débogage Moodle lorsque le débogage est activé.';
$string['manage'] = 'Gérer la passerelle de paiement HelloAsso';
$string['payments_title'] = 'Paiements HelloAsso';
$string['filter_status'] = 'Filtrer par statut';
$string['status_success'] = 'Succès';
$string['status_error'] = 'Erreur';
$string['status_cancelled'] = 'Annulé';
$string['status_fraud'] = 'Fraude détectée';
$string['payment_id'] = 'ID paiement';
$string['action'] = 'Action';
$string['amount'] = 'Montant';
$string['reference'] = 'Référence';
$string['message'] = 'Message';
$string['unknown'] = 'Inconnu';
$string['statistics'] = 'Statistiques';
$string['count'] = 'Nombre';
$string['total_amount'] = 'Montant total';

// Privacy API.
$string['privacy:metadata:paygw_helloasso_logs'] = 'Logs des transactions de paiement pour la passerelle HelloAsso';
$string['privacy:metadata:paygw_helloasso_logs:paymentid'] = 'L\'ID de la transaction de paiement';
$string['privacy:metadata:paygw_helloasso_logs:userid'] = 'L\'ID de l\'utilisateur qui a effectué le paiement';
$string['privacy:metadata:paygw_helloasso_logs:action'] = 'L\'action effectuée (ex: payment_initiation, payment_return)';
$string['privacy:metadata:paygw_helloasso_logs:status'] = 'Le statut de l\'action (success, error, cancelled, fraud_detected)';
$string['privacy:metadata:paygw_helloasso_logs:amount'] = 'Le montant du paiement en euros';
$string['privacy:metadata:paygw_helloasso_logs:reference'] = 'La référence HelloAsso de la transaction';
$string['privacy:metadata:paygw_helloasso_logs:message'] = 'Message additionnel ou détails d\'erreur';
$string['privacy:metadata:paygw_helloasso_logs:response_code'] = 'Code de réponse HTTP de l\'API HelloAsso';
$string['privacy:metadata:paygw_helloasso_logs:ip_address'] = 'L\'adresse IP de l\'utilisateur au moment de l\'action';
$string['privacy:metadata:paygw_helloasso_logs:timecreated'] = 'La date de création de l\'entrée de log';
$string['privacy:metadata:helloasso'] = 'Données de paiement envoyées à la plateforme de paiement HelloAsso';
$string['privacy:metadata:helloasso:email'] = 'Adresse email de l\'utilisateur envoyée à HelloAsso pour le traitement du paiement';
$string['privacy:metadata:helloasso:firstname'] = 'Prénom de l\'utilisateur envoyé à HelloAsso';
$string['privacy:metadata:helloasso:lastname'] = 'Nom de l\'utilisateur envoyé à HelloAsso';
$string['privacy:metadata:helloasso:amount'] = 'Montant du paiement envoyé à HelloAsso';
