define("tiny_orphanedfiles/orphanedfilesmanager",["exports","./options","core/templates","core/notification","./repository"],(function(_exports,Options,_templates,_notification,_repository){var obj;function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,Options=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}
/**
   * Storage helper for the Moodle Tiny orphanedfiles plugin.
   *
   * @module     tiny_orphanedfiles/plugin
   * @copyright  2023 Andreas Siebel <andreas.siebel@schulportal.hessen.de>
   * @copyright  2023 Andreas Schenkel <andreas.schenkel@schulportal.hessen.de>
   * @author     2023 Andreas Siebel <andreas.siebel@schulportal.hessen.de>
   * @author     2023 Andreas Schenkel <andreas.schenkel@schulportal.hessen.de>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */(Options),_templates=(obj=_templates)&&obj.__esModule?obj:{default:obj};return _exports.default=class{constructor(params,editor){this.editor=editor,this.elementId=editor.id,this.editorContainer=editor.editorContainer,this.draftItemId=params.draftItemId,this.userContextId=params.userContextId,this.showReferenceCountEnabled=params.showReferenceCountEnabled,this.orphanedFilesCounterOnly=params.orphanedFilesCounterOnly,this.wwwRoot=params.wwwRoot,this.baseUrl={},this.allFilesSet=new Set,this.usedFilesSet=new Set,this.oldUsedFileNamesInEditor=new Set,this.usedFilenamesInEditor=new Set,this.editorFilenamesHaveChanged=!0,this.oldOrphanedFilesSet=new Set,this.orphanedFilesSet=new Set,this.orphanedFilesSetHaveChanged=!1}createOrphanedArea(){this.orphanedArea=document.createElement("div"),this.orphanedArea.id="tiny-js-orphaned-wrapper-"+this.elementId,this.orphanedArea.className="tiny-orphaned-js-orphaned-wrapper",this.orphanedArea.className="tiny-orphaned",this.editorContainer.after(this.orphanedArea),this.headerDiv=document.createElement("div"),this.headerDiv.id="has-orphaned-files-".concat(this.elementId),this.headerDiv.classList.add("hidden"),this.headerDiv.innerHTML='⟳ ... LOAD "orphaned files indicator", 8, 1',this.orphanedArea.appendChild(this.headerDiv),this.bodyDiv=document.createElement("div"),this.bodyDiv.id="orphaned-files-".concat(this.elementId),this.bodyDiv.classList.add("orphaned-files-content"),this.bodyDiv.classList.add("orphaned-files-content-".concat(this.elementId)),this.bodyDiv.classList.add("hidden"),this.orphanedArea.appendChild(this.bodyDiv)}updateAllFiles(){return new Promise(((resolve,reject)=>{const draftItemId=Options.getDraftItemId(this.editor);(0,_repository.getAllDraftFiles)(draftItemId).then((fileObject=>{const result=JSON.parse(fileObject.files);return this.allFilesSet=new Set([...result]),resolve(result),null})).catch((error=>{reject(error)}))}))}updateUsedFiles(){return new Promise((resolve=>{let i=1;for(const file of this.allFilesSet){file.className="file-"+i,file.image_width&&file.image_height?file.dimensions="".concat(file.image_width,"✕").concat(file.image_height):file.dimensions="";const dateString=new Date(1e3*file.datemodified).toLocaleString();file.datemodifiedFormated=dateString,this.usedFilenamesInEditor.has(file.filepath+file.filename)&&this.usedFilesSet.add(file),i+=1}resolve()}))}updateUsedFilenamesInEditor(){const editorContent=this.editor.getContent(),baseUrl="".concat(this.wwwRoot,"/draftfile.php/").concat(this.userContextId,"/user/draft/").concat(this.draftItemId,"/"),pattern=new RegExp("[\"']"+baseUrl.replace(/[-/\\^$*+?.()|[\]{}]/g,"\\$&")+"(?<filename>.+?)[\\?\"']","gm");this.usedFilenamesInEditor=new Set([...editorContent.matchAll(pattern)].map((match=>"/"+decodeURIComponent(match.groups.filename)))),this.setsAreEqual(this.usedFilenamesInEditor,this.oldUsedFileNamesInEditor)?this.editorFilenamesHaveChanged=!1:this.editorFilenamesHaveChanged=!0,this.oldUsedFileNamesInEditor=this.usedFilenamesInEditor}setsAreEqual(setA,setB){if(setA.size!==setB.size)return!1;for(let item of setA)if(!setB.has(item))return!1;return!0}updateOrphanedFiles(){return new Promise((resolve=>{this.oldOrphanedFilesSet=this.orphanedFilesSet,this.orphanedFilesSet=new Set([...this.allFilesSet].filter((element=>!this.usedFilesSet.has(element))));const setsAreEqual=this.setsAreEqual(this.orphanedFilesSet,this.oldOrphanedFilesSet);this.orphanedFilesSetHaveChanged=!setsAreEqual,resolve()}))}deleteSelectedFiles(files){const draftItemId=Options.getDraftItemId(this.editor);(0,_repository.deleteDraftFiles)(draftItemId,files).then((()=>(this.update(!0),null))).catch((()=>{}))}update(){let forceChanged=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateUsedFilenamesInEditor(),(forceChanged||this.editorFilenamesHaveChanged)&&(this.updateAllFiles().then((()=>this.updateUsedFiles())).then((()=>this.updateOrphanedFiles())).then((()=>(this.orphanedFilesSetHaveChanged&&(this.bodyDiv.classList.remove("hidden"),this.renderBody()),null))).catch((()=>{})),this.orphanedFilesSetHaveChanged=!1)}renderBody(){const numberoforphanedfiles=this.orphanedFilesSet.size;if(0!==numberoforphanedfiles)if(this.orphanedFilesCounterOnly){const context={numberoforphanedfiles:numberoforphanedfiles};_templates.default.renderForPromise("tiny_orphanedfiles/orphanedfilescounteronly",context).then((_ref=>{let{html:html,js:js}=_ref;return _templates.default.replaceNodeContents(".orphaned-files-content-".concat(this.elementId),html,js),null})).catch((()=>{}))}else{const websitesettings=Array();websitesettings.showreferencecountenabled=this.showReferenceCountEnabled,websitesettings.orphanedfilescounteronly=this.orphanedFilesCounterOnly;const context={orphanedFiles:Array.from(this.orphanedFilesSet),numberoforphanedfiles:numberoforphanedfiles,websitesettings:websitesettings,elementId:this.elementId};_templates.default.renderForPromise("tiny_orphanedfiles/orphanedfiles",context).then((_ref2=>{let{html:html,js:js}=_ref2;return _templates.default.replaceNodeContents(".orphaned-files-content-".concat(this.elementId),html,js),null})).then((()=>this.registerListener(Array.from(this.orphanedFilesSet)))).catch((error=>(0,_notification.exception)(error)))}else this.bodyDiv.classList.add("hidden");return null}registerListener(files){files.forEach((file=>{document.querySelector("#orphaned-files-".concat(this.elementId," .orphaned-row.").concat(file.className," span")).addEventListener("click",(()=>{const singleFile=[];singleFile.push({filepath:file.filepath,filename:file.filename}),this.deleteSelectedFiles(singleFile)}))}));let selectedFiles=[];document.querySelector("#orphaned-files-".concat(this.elementId," button.deleteselected")).addEventListener("click",(()=>{for(const file of files){document.querySelector("#orphaned-files-".concat(this.elementId," .orphaned-row.").concat(file.className," input")).checked&&selectedFiles.push({filepath:file.filepath,filename:file.filename})}this.deleteSelectedFiles(selectedFiles)}))}},_exports.default}));

//# sourceMappingURL=orphanedfilesmanager.min.js.map