define("tiny_orphanedfiles/options",["exports","./common","editor_tiny/options","editor_tiny/utils"],(function(_exports,_common,_options,_utils){Object.defineProperty(_exports,"__esModule",{value:!0}),Object.defineProperty(_exports,"getDraftItemId",{enumerable:!0,get:function(){return _options.getDraftItemId}}),Object.defineProperty(_exports,"getFilepickers",{enumerable:!0,get:function(){return _options.getFilepickers}}),_exports.register=_exports.markInitialised=_exports.isInitialised=_exports.getUserContextId=_exports.getShowReferencecountEnabled=_exports.getOrphanedFilesCounterOnly=void 0;
/**
   * Options helper for the Moodle Tiny orphanedfiles plugin.
   *
   * @module     tiny_orphanedfiles/plugin
   * @copyright  2023 Andreas Siebel <andreas.siebel@schulportal.hessen.de>
   * @copyright  2023 Andreas Schenkel <andreas.schenkel@schulportal.hessen.de>
   * @author     2023 Andreas Siebel <andreas.siebel@schulportal.hessen.de>
   * @author     2023 Andreas Schenkel <andreas.schenkel@schulportal.hessen.de>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const initialisedOptionName=(0,_options.getPluginOptionName)(_common.pluginName,"initialised"),userContextIdName=(0,_options.getPluginOptionName)(_common.pluginName,"userContextId"),showReferencecountEnabledName=(0,_options.getPluginOptionName)(_common.pluginName,"showreferencecountenabled"),orphanedFilesCounterOnlyName=(0,_options.getPluginOptionName)(_common.pluginName,"orphanedfilescounteronly");_exports.register=editor=>{const registerOption=editor.options.register;registerOption(userContextIdName,{processor:"number",default:-1}),registerOption(showReferencecountEnabledName,{processor:"boolean",default:!1}),registerOption(orphanedFilesCounterOnlyName,{processor:"boolean",default:!1}),registerOption(initialisedOptionName,{processor:"boolean",default:!1})};_exports.isInitialised=editor=>!!(0,_utils.ensureEditorIsValid)(editor)&&editor.options.get(initialisedOptionName);_exports.getUserContextId=editor=>editor.options.get(userContextIdName);_exports.markInitialised=editor=>editor.options.set(initialisedOptionName,!0);_exports.getShowReferencecountEnabled=editor=>editor.options.get(showReferencecountEnabledName);_exports.getOrphanedFilesCounterOnly=editor=>editor.options.get(orphanedFilesCounterOnlyName)}));

//# sourceMappingURL=options.min.js.map