<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Upgrade information for plagiarism_strike
 *
 * File         upgrade.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @author      Kamil Łuczak <kluczak@intersiec.com.pl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

/**
 * Upgrade script.
 *
 * @param int $oldversion
 * @return bool
 * @throws dml_exception
 * @throws downgrade_exception
 * @throws upgrade_exception
 */
function xmldb_plagiarism_strike_upgrade($oldversion = 0) {
    global $DB;
    $dbman = $DB->get_manager();

    // Perform upgrade tasks.

    // Deprecated strike_use since Moodle 3.9.
    if ($oldversion < 2020083100) {
        if ($enabled = get_config('plagiarism_strike', 'strike_use')) {
            unset_config('strike_use', 'plagiarism_strike');
            set_config('enabled', $enabled, 'plagiarism_strike');
        }

        upgrade_plugin_savepoint(true, 2020083100, 'plagiarism', 'strike');
    }

    if ($oldversion < 2017103002) {
        // Enable plagiarism.
        if (!$DB->record_exists('config', array('name' => 'enableplagiarism'))) {
            $enabledata = new stdClass();
            $enabledata->name = 'enableplagiarism';
            $enabledata->value = 1;
            $DB->insert_record('config', $enabledata);
        } else if ($enabled = $DB->get_record('config', array('name' => 'enableplagiarism'))) {
            if ($enabled->value == 0) {
                $enabled->value = 1;
                $DB->update_record('config', $enabled);
            }
        }
        upgrade_plugin_savepoint(true, 2017103002, 'plagiarism', 'strike');
    }

    if ($oldversion < 2021120601) {
        // Define table plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        // Define field documentkind to be added to plagiarism_strike_files.
        $field = new xmldb_field('documentkind', XMLDB_TYPE_CHAR, '255', null, false, false, null);

        //Conditionally launch add field documentkind.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        upgrade_plugin_savepoint(true, 2021120601, 'plagiarism', 'strike');
    }

    if ($oldversion < 2022022400) {
        // Define table plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        // Define field documentkind to be added to plagiarism_strike_files.
        $field = new xmldb_field('deleted', XMLDB_TYPE_INTEGER, '1', null, false, false, 0);

        //Conditionally launch add field documentkind.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        upgrade_plugin_savepoint(true, 2022022400, 'plagiarism', 'strike');
    }

    if ($oldversion < 2022031500) {

        if ($enabled = get_config('plagiarism', 'strike_use')) {
            unset_config('strike_use', 'plagiarism');
            set_config('enabled', $enabled, 'plagiarism_strike');
        }

        upgrade_plugin_savepoint(true, 2022031500, 'plagiarism', 'strike');
    }

    if ($oldversion < 2022080100) {

        // Define table plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        // Define field documentuserid to be added to plagiarism_strike_files.
        $field = new xmldb_field('documentuserid', XMLDB_TYPE_CHAR, '255', null, false, false, null);

        //Conditionally launch add field documentuserid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        upgrade_plugin_savepoint(true, 2022080100, 'plagiarism', 'strike');
    }

    if ($oldversion < 2022080900) {

        // Define table plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        // Define field documentuserid to be added to plagiarism_strike_files.
        $field = new xmldb_field('assignmentid', XMLDB_TYPE_CHAR, '255', null, false, false, null);

        //Conditionally launch add field assignmentid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        upgrade_plugin_savepoint(true, 2022080900, 'plagiarism', 'strike');
    }

    if ($oldversion < 2024022800) {
        // Define field forumpostid to be added to plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        $field = new xmldb_field('forumpostid', XMLDB_TYPE_CHAR, '255', null, false, false, null);
    
        // Conditionally launch add field forumpostid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
    
        // Plugin savepoint reached.
        upgrade_plugin_savepoint(true, 2024022800, 'plagiarism', 'strike');
    }

    if ($oldversion < 2024070101) {
        // Define table plagiarism_strike_files.
        $table = new xmldb_table('plagiarism_strike_files');
        // Define factor fields to be updated to plagiarism_strike_files.
        $field1 = new xmldb_field('factor1', XMLDB_TYPE_NUMBER, '7, 4', null, null, null, null);
        $field2 = new xmldb_field('factor2', XMLDB_TYPE_NUMBER, '7, 4', null, null, null, null);

        // Update fields.
        if ($dbman->field_exists($table, $field1)) {
            $dbman->change_field_type($table, $field1);
        }

        if ($dbman->field_exists($table, $field2)) {
            $dbman->change_field_type($table, $field2);
        }

        upgrade_plugin_savepoint(true, 2024070101, 'plagiarism', 'strike');
    }

    if ($oldversion < 2024070501) {
        // Define table plagiarism_strike_protocols to be created.
        $table = new xmldb_table('plagiarism_strike_protocols');

        // Adding fields to table plagiarism_strike_protocols.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE );
        $table->add_field('protocoltypeid', XMLDB_TYPE_INTEGER, '10');
        $table->add_field('protocolname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL);
        $table->add_field('protocolfilename', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL);

        // Adding keys to table plagiarism_strike_protocols.
        $table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'));

        // Conditionally launch create table for plagiarism_strike_protocols.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Plagiarism plugin savepoint reached.
        upgrade_plugin_savepoint(true, 2024070501, 'plagiarism', 'strike');
    }

    return true;
}
