<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, EN
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'StrikePlagiarism.com плъгин';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'За повече информация свързана с тази система за антиплагиатство и как работи, вижте: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Синхронизирай StrikePlagiarism.com доклад за документ';
$string['task:getreports'] = 'Синхронизирай StrikePlagiarism.com доклади';
$string['task:sendfiles'] = 'Изпрати файлове до StrikePlagiarism.com API система';
$string['strike:enable'] = 'Позволи StrikePlagiarism.com плъгин';
$string['strike:viewreport'] = 'Покажи Доклад за Сходство на всички студенти';
$string['strike:resetfile'] = 'Изчиства всички грешки и връща статуса на изчакване';
$string['usestrike'] = 'Използвай StrikePlagiarism.com плъгин';
$string['useadminnotifications'] = 'Извести администратор за грешки?';
$string['useadminnotifications_help'] = 'Известява администратор за грешки, когато се появят (например когато комуникира със StrikePlagiarism.com API)';
$string['useteachernotifications'] = 'Извести лектор(и) за грешки?';
$string['useteachernotifications_help'] = 'Известява лектор(и) за грешки, когато се появят (например когато комуникира със StrikePlagiarism.com API)';
$string['strikekey'] = 'StrikePlagiarism.com API Key';
$string['strikekey_help'] = 'API Key към Вашия профил в системата на StrikePlagiarism.com system<br/>Нужен ви е StrikePlagiarism.com ID key, за да използвате този плъгин. За повече информация, моля, свържете се с нас чрез формата на уебсайта <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'StrikePlagiarism.com API Host';
$string['strikeserver_help'] = 'StrikePlagiarism.com домакин на сървъра или IP адрес. Въведете IP адрес с http или https';
$string['studentdisclosuredefault'] = 'Потвърждавам, че всички файлове, които са качени, могат да бъдат прегледани през антиплагиатската система StrikePlagiarism.com за проверка на оригиналността на текста';
$string['strikestudentdisclosure'] = 'Потвърждавам, че всички файлове, които са качени, могат да бъдат прегледани през антиплагиатската система StrikePlagiarism.com за проверка на оригиналността на текста';
$string['studentdisclosure'] = 'Разкриване на информация за студента';
$string['studentdisclosure_help'] = 'Този текст ще бъде видим за всички студенти на страницата за качване на файл. Изисква се съгласие преди да се продължи с подаването на документ.';
$string['strike_enableplugin'] = 'Разрешаване на StrikePlagiarism.com за {$a}';
$string['notifyteachers'] = 'Исвести лектор(и)';
$string['enableapidebugging'] = 'Позволи разрешаване на грешки в API';
$string['enableapidebugging_help'] = 'Включете тази опция ако желаете разширено отстраняване на грешки предложено от StrikePlagiarism.com API.<br/>
Възможни са няколко метода за отстраняване на грешки. Обърнете внимание, че отстраняването на грешки ще се състои <i>only</i> от комуникация/трафик информация на StrikePlagiarism.com API.';
$string['apidebuggingmtrace'] = 'Позволете mtrace отстраняване на грешки?';
$string['apidebuggingmtrace_help'] = 'Позволете тази опция ако желаете да видите отстраняването на грешки на API произведено като mtrace() output.<br/>
Ако позволите тази опция, изходното проследяване ще бъде видимо във фона на изходната задача (CRON).';
$string['apidebuggingerrorlog'] = 'Разрешаване на error_log отстраняване на грешки?';
$string['apidebuggingerrorlog_help'] = 'Разрешете тази опция ако желаете да виждате отстраняването на грешки на API като error_log изход.<br/>
Ако позволите това, изходната следа ще бъде видима в уебсървъра / php error_log.<br/>
БЕЛЕЖКА: Това няма винаги да бъде видимо в зависимост от конфигурацията на Вашия уебсървър или PHP.';
$string['apidebuggingemail'] = 'Разрешете отстраняване на грешки в имейл?';
$string['apidebuggingemail_help'] = 'Позволете тази опция ако желаете да получавате изходното отстраняване на API във Вашия имейл.<br/>
Ако разрешите тази опция, изходната следа за отстраняване ще бъде изпратена на конкретния имейл адрес.<br/>
БЕЛЕЖКА: Това може да позволи изпращането на много имейли.<br/>
БЕЛЕЖКА 2: Този метод използва мейл функцията по подразбиране и няма да бъде винаги достъпна. Работи извън имейл функциите на Moodle.';
$string['apidebuggingemailaddress'] = 'Изпратете имейл до получателя на отстранените грешки.';

$string['str:settings'] = 'Настройки';
$string['str:defaults'] = 'По подразбиране';
$string['str:dump'] = 'Dump';
$string['str:debug'] = 'Отстраняване на грешки';
$string['allowallsupportedfiles'] = 'Разрешаване на всички поддържани файлови формати';
$string['allowallsupportedfiles_help'] = 'Позволява на лектора да ограничи файлови формати, които ще бъдат изпратени на StrikePlagiarism.com за обработка. Това не възпрепятства студентите да качват файлове в различен формат към това задание.';
$string['restrictfiles'] = 'Файлови формати позволени за анализ за антиплагиатство';
$string['form:desc:defaults'] = 'Отдолу можете да въведете всички настройки по подразбиране, които ще бъдат използвани, когато е създаден нов модул с дейности.<br/>
Стойностите, въведени тук, ще служат като стойности по подразбиране за плъгин конфигурацията на StrikePlagiarism.com за заданието на модула.';
$string['docsendmode'] = 'Изпращане на документи за анализ за анти-плагиатство';
$string['docsendmode_help'] = 'Изберете метода за изпращане на документ за анализ. Това може да е по избор (преподавателят избира документите, които да изпрати за анализ), или всички (което означава, че всички документи по подразбиране се изпращат за анализ)';
$string['docsendingchoose'] = 'Изпрати избрани документи';
$string['docsendingall'] = 'Изпрати всички документи';
$string['strike_show_student_status'] = 'Покажи статуса на StrikePlagiarism.com анализа на студент';
$string['strike_show_student_status_help'] = 'Позволява на студента да вижда статуса на подадени документи в системата на StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Покажи Доклада за Сходство на студента';
$string['strike_show_student_report_help'] = 'Докладът за Сходство показва и подчертава броят на заимстваните фрагменти в текста и техния източник.';
$string['strike_show_student_score'] = 'Покажи коефициентите за сходство на студента';
$string['strike_show_student_score_help'] = 'Коефициентите за Сходство пресмятат в какъв процент от анализираният документ се съдържат фрагменти подобни на тези в базата данни за сравнение.';
$string['strike_addref_method'] = 'Добавяне на документи към базата данни за сравнение';
$string['strike_addref_method_help'] = 'Изберете начина за добавяне на документи към Вашата база данни за сравнение. Това може да бъде направено ръчно (лекторът избира документите, които да бъдат добавени към базата данни за сравнение) или автоматично (всички документи се добавят в базата данни по подразбиране) след проверка.<br/>
Препоръчително е да настроите опцията на АВТОМАТИЧНО, за да може проверените документи да бъдат добавени към базата данни автоматично.';
$string['strike_deletereport_method'] = 'Изтриване на Доклади за Сходство за изтрити/обновени качвания';
$string['strike_deletereport_method_help'] = 'Решава дали Докладите за Сходство трябва да бъдат изтрити, когато предаден файл е изтрит или обновен.<br/>
Възможните начини са:
<ul>
<li>keep: Да се запазят старите Доклади за Сходство</li>
<li>remove: Да се изтрият старите Доклади за Сходство</li>
</ul>';
$string['strike_studentemail'] = 'Имейл до студент';
$string['strike_studentemail_help'] = 'Позволява да бъде изпратен имейл до студента, когато е бил обработен файл, за да ги оповести, че има достъпен Доклад за Сходство, имейлът също така съдържа връзка за отказ.';
$string['strike_draft_submit'] = 'Моментът на изпращане за анализ за анти-плагиатство';
$string['strike_defaultlang'] = 'Език на документа по подразбиране';
$string['strike_defaultlang_help'] = 'Определя езикът на документа изпратен за анализ до системата на StrikePlagiarism.com по подразбиране.';
$string['wordcount'] = 'Минимален брой думи за анализ';
$string['wordcount_help'] = 'Задава минимум брой думи за текст в ред (публикации във форуми и вид на онлайн заданието) преди съдържанието да бъде изпратено до системата на StrikePlagiarism.com за преглед.';

$string['addrefauto'] = 'Автоматично след проверка';
$string['addrefmanual'] = 'Ръчно след проверка';

$string['deletereportkeep'] = 'Запази стари Доклади за Сходство';
$string['deletereportremove'] = 'Изтрий стари Доклади за Сходство';

$string['submitondraft'] = 'Когато е качен за първи път';
$string['submitonfinal'] = 'Когато студентът го качва за оценяване';
$string['showwhenclosed'] = 'Когато упражнението е затворено';

$string['pending'] = 'Файлът изчаква да бъде качен в StrikePlagiarism.com';
$string['processing'] = 'Файлът е качен в StrikePlagiarism.com и чака завършен анализ';
$string['toolarge'] = 'Файлът е прекалено голям, за да бъде качен в StrikePlagiarism.com';
$string['unsupported'] = 'Форматът на файла не се поддържа от StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Форматът на файла не се поддържа от StrikePlagiarism.com';
$string['unknownwarning'] = 'Имаше грешка при качването на този файл в StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'Очаква решение за изпращане до StrikePlagiarism.com за анализ';
$string['previouslysubmitted'] = 'По-рано предадено като';
$string['sendforanalysis'] = 'Изпрати заявка за анализ в StrikePlagiarism.com';
$string['indexdocument'] = 'Добавете към Вашата база данни за сравнение в системата на StrikePlagiarism.com';
$string['deletestrikefile'] = 'Оттеглете от Вашата база данни за сравнение от системата на StrikePlagiarism.com';

$string['similarity1'] = 'КС 1';
$string['similarity2'] = 'КС 2';
$string['similarity3'] = 'КС 3';
$string['similarity4'] = 'КС 4';
$string['similarity5'] = 'КС DLA';

$string['filereset'] = 'Един файл е обновен за повторно предаване към StrikePlagiarism.com';
$string['fileresetfailed'] = 'Грешка: файлът не е обновен за повторно предаване към StrikePlagiarism.com';

$string['report'] = 'StrikePlagiarism.com Доклад за Сходство';
$string['report2'] = 'StrikePlagiarism.com интерактивен доклад';
$string['reportclick'] = 'Връзка до Доклада за Сходство в StrikePlagiarism.com';

$string['restrictcontent'] = 'Подай прикрепените файлове и вградения текст';
$string['restrictcontent_help'] = 'StrikePlagiarism.com може да обработва качени файлове или вграден текст от публикации във форуми и видове текстове от онлайн задания. Изберете кои компоненти да се изпратят до системата на StrikePlagiarism.com.';
$string['restrictcontentfiles'] = 'Подай само прикрепените файлове';
$string['restrictcontentno'] = 'Подай прикрепените файлове и вградения текст';
$string['restrictcontenttext'] = 'Подай само вградения текст';

$string['config:plagiarism'] = 'StrikePlagiarism.com глобална конфигурация на антиплагиатски стойности';
$string['config:defaults'] = 'StrikePlagiarism.com конфигурация на антиплагиатски модул по подразбиране';

$string['studentemailsubject'] = 'Предаването е верифицирано от антиплагиатската система StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Уважаем/а {$a->firstname} {$a->lastname},</p>
Файлът, който предадохте в {$a->modulename} в {$a->coursename} е верифициран от StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
Поздрави,
{$a->admin}
';

$string['label:user'] = 'Потребител';
$string['label:author'] = 'Автор';
$string['label:timesubmitted'] = 'Предадено на';
$string['label:analysisstatus'] = 'Коефициент за Сходство (КС)';
$string['label:reportstatus'] = 'Доклад';
$string['label:status'] = 'Статус';
$string['label:filename'] = 'Име на файл';
$string['label:modname'] = 'Модул';
$string['label:actions'] = 'Действие';

$string['report:na'] = 'N/A';
$string['report:ready'] = 'Готово';
$string['report:available'] = 'Налично';
$string['analysis:auto'] = 'Автоматизиране';
$string['analysis:manual'] = 'При поискване';
$string['analysis:awaitchoice'] = 'Чака да бъде избрано за анализ';
$string['cmoverview'] = 'Списък с подадени документи към StrikePlagiarism.com';
$string['notification:subject'] = 'StrikePlagiarism.com системно съобщение [{$a}]';
$string['notification:errormessage'] = '<p>Уважаем/а {$a->fullname}<p>
<p>Изникна грешка в антиплагиатския плъгин на StrikePlagiarism.com в \'{$a->instancename}\' in course \'{$a->coursefullname}\'.<br/>
Изникналата грешка е: {$a->errormessage}.</p>
<p>Below are the file details:<br/>
Author: {$a->strikefileauthor}<br/>
Coordinator: {$a->strikefilecoordinator}<br/>
DocumentKind: {$a->strikefiledocumentkind}<br/>
Title: {$a->strikefiletitle}<br/>
Filename: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Time created: {$a->strikefiletimecreated}
</p>
<p>Please go to <a href="{$a->contexturl}">{$a->contexturlname}</a> for more details</p>
<p>Regards,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'StrikePlagiarism.com известия за грешки';

$string['err:strike_selectfiletypes-empty'] = 'Моля, изберете от възможните файлови формати за подаване.<br/>
В момента няма избрани файлови формати, нито един документ няма да бъде предаден в антиплагиатската система API.';
$string['warn:strike_selectfiletypes-empty'] = 'Моля, изберете позволени файлови формати за предаване отдолу.<br/>
Ако не са избрани файлови формати, нито един документ няма да бъде предаден в антиплагиатската система API.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Тествайте API връзка';
$string['test_api_connection_status'] = 'Статус на API връзката';
$string['test_api_connection_help'] = 'Може да проверите дали сегашния API домакин и API ключ работят правилно.';
$string['api_status_1'] = 'Връзката е добре';
$string['api_status_2'] = 'Ключът не е валиден';
$string['api_status_3'] = 'Твърде дълго време за свързване';
$string['api_status_4'] = 'Връзката е нормална, сървърът не отговаря';
$string['api_status_5'] = 'Код за грешка при свързване: {$a->error}';

$string['privacy:metadata:userid'] = 'Информация за потребителя, който качва файл за анализ за антиплагиатство.';
$string['privacy:metadata:relateduserid'] = 'Информация за използваната свързана информация, която подава файла за антиплагиатски анализ.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Таблица, в която се съхранява информация за файловете, подадени за антиплагиатски анализ.';
$string['privacy:metadata:title'] = 'Заглавие на документа, качен от потребителя.';
$string['privacy:metadata:author'] = 'Име на автора или съавтора на качения файл.';
$string['privacy:metadata:coordinator'] = 'Предоставена информация за промоутър на файла.';
$string['privacy:metadata:md5sum'] = 'MD5 сума на двоичния документ, изпратен за анализ.';
$string['privacy:metadata:ftimesubmitted'] = 'Време за качване на файла към системата на StrikePlagiarism.com.';
$string['privacy:metadata:ftimecreated'] = 'Време за създаване на запис на файла в системата на StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Време за модифициране на файла в системата на StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Boolean true, ако докладът е готов за изтегляне, false в противен случай.';
$string['privacy:metadata:indexed'] = 'Boolean true, ако документът е индексиран.';
$string['privacy:metadata:factor1'] = 'Коефициент на сходство 1.';
$string['privacy:metadata:factor2'] = 'Коефициент на сходство 2.';
$string['privacy:metadata:factor3'] = 'Коефициент на сходство 3.';
$string['privacy:metadata:factor4'] = 'Коефициент на сходство 4.';
$string['privacy:metadata:factor5'] = 'Коефициент на сходство DLA.';

$string['privacy:metadata:strikefileid'] = 'StrikePlagiarism.com файл ИД.';
$string['privacy:metadata:report'] = 'Информация за доклад за сходство в системата на StrikePlagiarism.com.';
$string['privacy:metadata:timemodified'] = 'Време за модификация на доклада за сходство в системата на StrikePlagiarism.com.';
$string['privacy:metadata:timecreated'] = 'Време за създаване на доклад за сходство в системата на StrikePlagiarism.com.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com създава Доклад за сходство за всеки качен файл. Информацията се запазва в базата данни на Moodle. Всеки доклад е свързан с файл, качен от потребител';

$string['privacy:metadata:filename'] = 'Име на файла качен от потребител.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Лични данни, предадени от подсистемата за антиплагиатството.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Този плъгин изпраща информация, използвайки StrikePlagiarism.com API.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com създава guid, който е файл, свързан с подаването към API на StrikePlagiarism.com.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com съхранява файлове, които са били качени в Moodle, за да състави подадените документи в StrikePlagiarism.com.';
$string['assignmenttype'] = 'Вид на заданието';
$string['assignmenttype_0'] = 'Хабилитационен труд';
$string['assignmenttype_1'] = 'Докторска теза';
$string['assignmenttype_2'] = 'Магистърска теза';
$string['assignmenttype_3'] = 'Бакалавърска теза';
$string['assignmenttype_4'] = 'Годишна научна работа';
$string['assignmenttype_6'] = 'Задание';
$string['assignmenttype_7'] = 'Статия';
$string['assignmenttype_8'] = 'Проучване';
$string['assignmenttype_9'] = 'Инженерска теза';
$string['assignmenttype_10'] = 'Теза за димплома';
$string['assignmenttype_16'] = 'Проект';
$string['assignmenttype_25'] = 'Есе';
$string['assignmenttype_40'] = 'Дипломна работа за следдипломна квалификация';
$string['assignmenttype_101'] = 'Монограф';
$string['assignmenttype_102'] = 'Ръководство';
$string['assignmenttype_103'] = 'Трактат';
$string['assignmenttype_300'] = 'Книга';

$string['crosscheckmode'] = 'Режим на кръстосана проверка';
$string['crosscheckmode_help'] = 'Режимът на кръстосана проверка позволява проверка между предадените работи на студентите в заданието. Когато кръстосаната проверка е позволена, проверената секция ще бъде видима в интерактивния Доклад за Сходство';
$string['removeaiquiz'] = 'Скрий настройката за откриване на AI';
$string['aidetection'] = 'Oткриване на AI';

$string['updateprotocols'] = 'Актуализиране на протоколите';
$string['getprotocolsresponse'] = 'Отговор на протоколите';
$string['countprotocols'] = 'Брой на протоколите: ';
$string['errorprotocol'] = 'Грешка';