<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, EN
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'StrikePlagiarism.com-Plugin';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Weitere Informationen zu diesem Antiplagiarismus-System und seiner Funktionsweise finden Sie unter: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'StrikePlagiarism.com-Bericht für Dokument synchronisieren';
$string['task:getreports'] = 'StrikePlagiarism.com-Berichte synchronisieren';
$string['task:sendfiles'] = 'Dateien an die System-API von StrikePlagiarism.com senden';
$string['strike:enable'] = 'StrikePlagiarism.com-Plugin aktivieren';
$string['strike:viewreport'] = 'Ähnlichkeitsberichte aller Studenten anzeigen';
$string['strike:resetfile'] = 'Löscht alle Fehler und setzt den Status wieder auf ausstehend';
$string['usestrike'] = 'StrikePlagiarism.com-Plugin verwenden';
$string['useadminnotifications'] = 'Administrator über Fehler benachrichtigen?';
$string['useadminnotifications_help'] = 'Benachrichtigt den Administrator über Fehler, wenn verschiedene Fehler auftreten (z. B. bei der Kommunikation mit der StrikePlagiarism.com-API)';
$string['useteachernotifications'] = 'Lehrer über Fehler informieren?';
$string['useteachernotifications_help'] = 'Benachrichtigt Lehrer über Fehler, wenn verschiedene Fehler auftreten (z. B. bei der Kommunikation mit der StrikePlagiarism.com-API)';
$string['strikekey'] = 'StrikePlagiarism.com-API-Schlüssel';
$string['strikekey_help'] = 'API-Schlüssel zu Ihrem Konto im StrikePlagiarism.com-System<br/>Sie müssen einen StrikePlagiarism.com-ID-Schlüssel erhalten, um dieses Plugin zu verwenden. Für weitere Informationen kontaktieren Sie uns bitte über das Website-Kontaktformular auf <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'StrikePlagiarism.com-API-Host';
$string['strikeserver_help'] = 'Hostname oder IP-Adresse des StrikePlagiarism.com-Servers. IP-Adresse mit http oder https eingeben';
$string['studentdisclosuredefault'] = 'Ich stimme zu, dass alle Dateien, die ich hochgeladen habe, an das Antiplagiatssystem von StrikePlagiarism.com gesendet werden können, um die Originalität des Textes zu überprüfen';
$string['strikestudentdisclosure'] = 'Ich stimme zu, dass alle Dateien, die ich hochgeladen habe, an das Antiplagiatssystem von StrikePlagiarism.com gesendet werden können, um die Originalität des Textes zu überprüfen';
$string['studentdisclosure'] = 'Student Disclosure';
$string['studentdisclosure_help'] = 'Dieser Text wird allen Studenten auf der Datei-Upload-Seite angezeigt. Es muss vereinbart werden, um mit der Einreichung fortzufahren.';
$string['strike_enableplugin'] = 'StrikePlagiarism.com für {$a} aktivieren';
$string['notifyteachers'] = 'Lehrer benachrichtigen';
$string['enableapidebugging'] = 'API-Debugging aktivieren';
$string['enableapidebugging_help'] = 'Schalten Sie diese Option ein, wenn Sie erweitertes Debugging wünschen, das von der StrikePlagiarism.com-API bereitgestellt wird.<br/>
Es stehen mehrere Debugging-Methoden zur Verfügung. Beachten Sie, dass das Debugging <i>nur</i> aus Kommunikations-/Traffic-Informationen auf der StrikePlagiarism.com-API besteht.';
$string['apidebuggingmtrace'] = 'MTrace-Debugging aktivieren?';
$string['apidebuggingmtrace_help'] = 'Aktivieren Sie diese Option, wenn Sie die API-Debugging-Ausgabe als mtrace()-Ausgabe sehen möchten.<br/>
Wenn Sie dies aktivieren, wird die Trace-Ausgabe in der Ausgabe Ihrer Hintergrundaufgabe (CRON) sichtbar sein.';
$string['apidebuggingerrorlog'] = 'Error_log Debugging aktivieren?';
$string['apidebuggingerrorlog_help'] = 'Aktivieren Sie diese Option, wenn Sie die API-Debugging-Ausgabe als error_log-Ausgabe sehen möchten.<br/>
Wenn Sie dies aktivieren, wird die Trace-Ausgabe in webserver / php error_log sichtbar.<br/>
HINWEIS: Je nachdem, wie Ihr Webserver oder PHP konfiguriert ist, wird dies nicht immer sichtbar sein.';
$string['apidebuggingemail'] = 'E-Mail-Debugging aktivieren?';
$string['apidebuggingemail_help'] = 'Aktivieren Sie diese Option, wenn Sie die API-Debugging-Ausgabe in Ihrer E-Mail erhalten möchten.<br/>
Wenn Sie dies aktivieren, wird die Trace-Ausgabe an die angegebene E-Mail-Adresse gesendet.<br/>
HINWEIS: Dies kann dazu führen, dass viele E-Mails gesendet werden.<br/>
HINWEIS 2: Diese Methode nutzt die Standardfunktion mail() und ist nicht immer verfügbar. Es funktioniert außerhalb der Mailfunktionen von Moodle.';
$string['apidebuggingemailaddress'] = 'E-Mail-Debugging-Empfänger.';

$string['str:settings'] = 'Einstellungen';
$string['str:defaults'] = 'Standard';
$string['str:dump'] = 'Dump';
$string['str:debug'] = 'Debuggen';
$string['allowallsupportedfiles'] = 'Alle unterstützten Dateiformate zulassen';
$string['allowallsupportedfiles_help'] = 'Erlaubt dem Lehrer, Dateiformate einzuschränken, die zur Verarbeitung an StrikePlagiarism.com gesendet werden. Es hindert die Schüler nicht daran, verschiedene Dateitypen in die Aufgabe hochzuladen.';
$string['restrictfiles'] = 'Zugelassene Dateiformate für die Antiplagiatsanalyse';
$string['form:desc:defaults'] = 'Unten können Sie alle Standardeinstellungen eingeben, die verwendet werden, wenn ein neues Aktivitätsmodul erstellt und konfiguriert wird.<br/>
Die hier eingegebenen Werte dienen als Standardwerte für die Plug-in-Konfiguration von StrikePlagiarism.com für dieses Aktivitätsmodul.';
$string['docsendmode'] = 'Dokumente zur Antiplagiatsanalyse senden';
$string['docsendmode_help'] = 'Wählen Sie die Methode zum Senden des Dokuments zur Analyse. Dies kann entweder nach Wahl erfolgen (was bedeutet, dass der Lehrer Dokumente auswählt, die zur Analyse gesendet werden sollen) oder alle (was bedeutet, dass alle Dokumente standardmäßig zur Analyse gesendet werden)';
$string['docsendingchoose'] = 'Ausgewählte Dokumente senden';
$string['docsendingall'] = 'Alle Dokumente senden';
$string['strike_show_student_status'] = 'StrikePlagiarism.com-Analysestatus für Studenten anzeigen';
$string['strike_show_student_status_help'] = 'Ermöglicht den Schülern, den Status der Einreichungen im StrikePlagiarism.com-System zu sehen.';
$string['strike_show_student_report'] = 'Schüler Ähnlichkeitsbericht anzeigen';
$string['strike_show_student_report_help'] = 'Der Ähnlichkeitsbericht zeigt die Anzahl und hebt entlehnte Fragmente im Text hervor und gibt ihre Quelle an.';
$string['strike_show_student_score'] = 'Ähnlichkeitskoeffizienten für Schüler anzeigen';
$string['strike_show_student_score_help'] = 'Die Ähnlichkeitskoeffizienten bestimmen, zu wie viel Prozent das analysierte Dokument aus Fragmenten besteht, die denen ähneln, die in Vergleichsdatenbanken gefunden wurden.';
$string['strike_addref_method'] = 'Dokumente zur vergleichenden Datenbank hinzufügen';
$string['strike_addref_method_help'] = 'Wählen Sie die Methode zum Hinzufügen von Dokumenten zu Ihrer vergleichenden Datenbank. Dies kann entweder manuell (d. h. der Lehrer wählt Dokumente aus, die der vergleichenden Datenbank hinzugefügt werden sollen) oder automatisch (d. h. alle Dokumente werden standardmäßig der vergleichenden Datenbank hinzugefügt) nach Überprüfung erfolgen.<br/>
Es wird dringend empfohlen, dies auf AUTOMATISCH zu setzen, damit geprüfte Dokumente automatisch zur Vergleichsdatenbank hinzugefügt werden.';
$string['strike_deletereport_method'] = 'Löschung von Ähnlichkeitsberichten für gelöschte/aktualisierte Einreichungen';
$string['strike_deletereport_method_help'] = 'Legt fest, ob Ähnlichkeitsberichte gelöscht werden sollen, wenn ein Beitrag gelöscht oder aktualisiert wird.<br/>
Mögliche Methoden sind:
<ul>
<li>behalten: Alte Ähnlichkeitsberichte aufbewahren</li>
<li>remove: Alte Ähnlichkeitsberichte löschen</li>
</ul>';
$string['strike_studentemail'] = 'E-Mail an Studenten';
$string['strike_studentemail_help'] = 'Aktiviert eine E-Mail, die an den Studenten gesendet wird, wenn eine Datei verarbeitet wurde, um ihn darüber zu informieren, dass ein Ähnlichkeitsbericht verfügbar ist, die E-Mail enthält auch den Opt-out-Link.';
$string['strike_draft_submit'] = 'Zeitpunkt des Sendens zur Antiplagiatsanalyse';
$string['strike_defaultlang'] = 'Standarddokumentsprache';
$string['strike_defaultlang_help'] = 'Definiert die Standardsprache des Dokuments, das zur Analyse an das StrikePlagiarism.com-System gesendet wird.';
$string['wordcount'] = 'Mindestwortanzahl für die Analyse';
$string['wordcount_help'] = 'Legt eine Mindestanzahl von Wörtern fest, die für Inline-Text (Forenbeiträge und Online-Aufgabentyp) erforderlich sind, bevor der Inhalt zur Analyse an das System von StrikePlagiarism.com gesendet wird.';

$string['addrefauto'] = 'Automatisch nach Überprüfung';
$string['addrefmanual'] = 'Manuell nach Überprüfung';

$string['deletereportkeep'] = 'Alte Ähnlichkeitsberichte behalten';
$string['deletereportremove'] = 'Alte Ähnlichkeitsberichte löschen';

$string['submitondraft'] = 'Beim ersten Hochladen';
$string['submitonfinal'] = 'Wenn Schüler zur Benotung einreichen';
$string['showwhenclosed'] = 'Wenn Aktivität geschlossen ist';

$string['pending'] = 'Die Übermittlung der Datei an StrikePlagiarism.com steht noch aus';
$string['processing'] = 'Datei wurde an StrikePlagiarism.com übermittelt und wartet auf den Abschluss der Analyse';
$string['toollarge'] = 'Datei ist zu groß, um sie an StrikePlagiarism.com zu senden';
$string['unsupported'] = 'Dateiformat wird von StrikePlagiarism.com nicht unterstützt';
$string['unsupportedfiletype'] = 'Dateiformat wird von StrikePlagiarism.com nicht unterstützt';
$string['unknownwarning'] = 'Beim Senden dieser Datei an StrikePlagiarism.com ist ein Fehler aufgetreten';
$string['awaitanalysischoice'] = 'Warte auf Entscheidung zum Senden an StrikePlagiarism.com zur Analyse';
$string['priorlysubmitted'] = 'Zuvor eingereicht als';
$string['sendforanalysis'] = 'Einreichung zur Analyse an StrikePlagiarism.com senden';
$string['indexdocument'] = 'Einreichung zu Ihrer Vergleichsdatenbank im StrikePlagiarism.com-System hinzufügen';
$string['deletestrikefile'] = 'Einreichung aus Ihrer Vergleichsdatenbank im StrikePlagiarism.com-System zurückziehen';

$string['ähnlichkeit1'] = 'ÄK 1';
$string['ähnlichkeit2'] = 'ÄK 2';
$string['similarity3'] = 'ÄK 3';
$string['similarity4'] = 'ÄK 4';
$string['ähnlichkeit5'] = 'ÄK DLA';

$string['filereset'] = 'Eine Datei wurde zur erneuten Übermittlung an StrikePlagiarism.com zurückgesetzt';
$string['fileresetfailed'] = 'Fehler: Datei wurde nicht zur erneuten Übermittlung an StrikePlagiarism.com zurückgesetzt';

$string['report'] = 'StrikePlagiarism.com-Ähnlichkeitsbericht';
$string['report2'] = 'Interaktiver Bericht von StrikePlagiarism.com';
$string['reportclick'] = 'Link zum StrikePlagiarism.com-Ähnlichkeitsbericht';

$string['restrictcontent'] = 'Angehängte Dateien und Inline-Text übermitteln';
$string['restrictcontent_help'] = 'StrikePlagiarism.com kann hochgeladene Dateien oder Inline-Text aus Forenbeiträgen und Text aus dem Übermittlungstyp für Online-Textaufgaben verarbeiten. Wählen Sie aus, welche Komponenten an das StrikePlagiarism.com-System gesendet werden sollen.';
$string['restrictcontentfiles'] = 'Nur angehängte Dateien übermitteln';
$string['restrictcontentno'] = 'Angehängte Dateien und Inline-Text senden';
$string['restrictcontenttext'] = 'Nur Inline-Text übermitteln';

$string['config:plagiarism'] = 'Globale Konfigurationswerte des Antiplagiarism-Moduls von StrikePlagiarism.com';
$string['config:defaults'] = 'Konfigurationsvorgaben für das StrikePlagiarism.com Antiplagiarism-Modul';

$string['studentemailsubject'] = 'Einreichung vom Antiplagiatssystem von StrikePlagiarism.com verifiziert';
$string['studentemailcontent'] = '<p>Sehr geehrter {$a->firstname} {$a->lastname},</p>
Die Datei, die Sie an {$a->modulename} in {$a->coursename} gesendet haben, wurde von StrikePlagiarism.com verifiziert.<br/>
{$a->Modullink}<br/>
Grüße,
{$a->Administrator}
';
$string['label:user'] = 'Benutzer';
$string['label:author'] = 'Autor';
$string['label:timesubmitted'] = 'Eingereicht am';
$string['label:analysisstatus'] = 'Ähnlichkeitskoeffizienten (SC)';
$string['label:reportstatus'] = 'Bericht';
$string['label:status'] = 'Status';
$string['label:filename'] = 'Dateiname';
$string['label:modname'] = 'Modul';
$string['label:actions'] = 'Aktion(en)';

$string['report:na'] = 'N/A';
$string['report:ready'] = 'Bereit';
$string['report:available'] = 'Verfügbar';
$string['analysis:auto'] = 'Automatisiert';
$string['analysis:manual'] = 'Auf Anfrage';
$string['analysis:awaitchoice'] = 'Warten auf Auswahl zur Analyse';
$string['cmoverview'] = 'Liste der Einreichungen auf StrikePlagiarism.com';
$string['notification:subject'] = 'StrikePlagiarism.com-Systemmeldung [{$a}]';
$string['notification:errormessage'] = '<p>Sehr geehrter/geehrte {$a->vollständiger Name}<p>
<p>Im Antiplagiats-Plugin von StrikePlagiarism.com ist in \'{$a->instancename}\' im Kurs \'{$a->coursefullname}\' ein Fehler aufgetreten.<br/>
Der ausgelöste Fehler war: {$a->errormessage}.</p>
<p>Nachstehend finden Sie die Dateidetails:<br/>
Autor: {$a->strikefileauthor}<br/>
Koordinator: {$a->strikefilecoordinator}<br/>
DocumentKind: {$a->strikefiledocumentkind}<br/>
Titel: {$a->Strikefiletitle}<br/>
Dateiname: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Erstellungszeit: {$a->strikefiletimecreated}
</p>
<p>Weitere Informationen finden Sie unter <a href="{$a->contexturl}">{$a->contexturlname}</a></p>
<p>Mit freundlichen Grüßen<br/>{$a->Signoff}</p>';
$string['messageprovider:strikenotification'] = 'StrikePlagiarism.com-Fehlerbenachrichtigungen';

$string['err:strike_selectfiletypes-empty'] = 'Bitte treffen Sie eine Auswahl zulässiger Dateiformate zum Senden.<br/>
Da jetzt keine Dateiformate ausgewählt werden, würde kein Dokument jemals an die API des Antiplagiatssystems übermittelt werden.';
$string['warn:strike_selectfiletypes-empty'] = 'Bitte treffen Sie unten eine Auswahl zulässiger Dateiformate zum Einreichen.<br/>
Wenn keine Dateiformate ausgewählt werden, werden niemals Dokumente an die API des Antiplagiatssystems übermittelt.';

// Hinzugefügt von INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'API-Verbindung testen';
$string['test_api_connection_status'] = 'API-Verbindungsstatus';
$string['test_api_connection_help'] = 'Sie können überprüfen, ob die aktuell eingegebene Host-API und der API-Schlüssel korrekt funktionieren.';
$string['api_status_1'] = 'Verbindung ok';
$string['api_status_2'] = 'Schlüssel ist nicht gültig';
$string['api_status_3'] = 'Verbindungszeitüberschreitung';
$string['api_status_4'] = 'Verbindung ok, Server antwortet nicht';
$string['api_status_5'] = 'Verbindungsfehlercode: {$a->error}';

$string['privacy:metadata:userid'] = 'Informationen über den Benutzer, der die Datei zur Antiplagiatsanalyse einreicht.';
$string['privacy:metadata:relateduserid'] = 'Informationen zu verwandten Benutzern, die Dateien zur Antiplagiatsanalyse einreichen.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Tabelle, die Informationen zu Dateien speichert, die zur Antiplagiatsanalyse eingereicht wurden.';
$string['privacy:metadata:title'] = 'Titel des vom Benutzer eingereichten Dokuments.';
$string['privacy:metadata:author'] = 'Autor oder Co-Autor der eingereichten Datei.';
$string['privacy:metadata:coordinator'] = 'Übermittelter Dateipromotor.';
$string['privacy:metadata:md5sum'] = 'MD5-Summe des zur Analyse gesendeten Binärdokuments.';
$string['privacy:metadata:ftimesubmitted'] = 'StrikePlagiarism.com-Dateiübermittlungszeit.';
$string['privacy:metadata:ftimecreated'] = 'Erstellungszeit des StrikePlagiarism.com-Dateieintrags.';
$string['privacy:metadata:ftimemodified'] = 'Änderungszeit der Einreichung von StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Boolean true, wenn der Bericht zum Download bereit ist, andernfalls false.';
$string['privacy:metadata:indexed'] = 'Boolean wahr, wenn das Dokument indiziert wurde.';
$string['privacy:metadata:factor1'] = 'Wert des Ähnlichkeitskoeffizienten 1.';
$string['privacy:metadata:factor2'] = 'Wert des Ähnlichkeitskoeffizienten 2.';
$string['privacy:metadata:factor3'] = 'Wert des Ähnlichkeitskoeffizienten 3.';
$string['privacy:metadata:factor4'] = 'Wert des Ähnlichkeitskoeffizienten 4.';
$string['privacy:metadata:factor5'] = 'Wert des Ähnlichkeitskoeffizienten DLA.';

$string['privacy:metadata:strikefileid'] = 'ID der Einreichungsdatei von StrikePlagiarism.com.';
$string['privacy:metadata:report'] = 'Daten des Submission StrikePlagiarism.com-Ähnlichkeitsberichts.';
$string['privacy:metadata:timemodified'] = 'Änderungszeit des Submission StrikePlagiarism.com-Ähnlichkeitsberichts.';
$string['privacy:metadata:timecreated'] = 'Erstellungszeit des Submission StrikePlagiarism.com-Ähnlichkeitsberichts.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com erstellt einen Ähnlichkeitsbericht für jede eingereichte Datei. Dieser Datensatz wird in der Moodle-Datenbank gespeichert. Jeder Bericht bezieht sich auf die Übermittlung von Benutzerdateien.';

$string['privacy:metadata:filename'] = 'Dateiname der vom Benutzer eingereichten Datei.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Personenbezogene Daten, die vom Antiplagiats-Subsystem übermittelt wurden.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Dieses Plugin sendet Daten extern über die API von StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com erstellt eine GUID, die eine Dateibeziehung zur Übermittlung an die StrikePlagiarism.com-API darstellt.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com speichert Dateien, die auf Moodle hochgeladen wurden, um eine StrikePlagiarism.com-Einreichung zu bilden.';
$string['assignmenttype'] = 'Der Typ der Aufgabe';
$string['assignmenttype_0'] = 'Habilitationsschrift';
$string['assignmenttype_1'] = 'Doktorarbeit';
$string['assignmenttype_2'] = 'Masterarbeit';
$string['assignmenttype_3'] = 'Bachelorarbeit';
$string['assignmenttype_4'] = 'Jahresarbeit';
$string['assignmenttype_6'] = 'Zuweisung';
$string['assignmenttype_7'] = 'Artikel';
$string['assignmenttype_8'] = 'Forschung';
$string['assignmenttype_9'] = 'Ingenieurarbeit';
$string['assignmenttype_10'] = 'Diplomarbeit';
$string['assignmenttype_16'] = 'Projekt';
$string['assignmenttype_25'] = 'Papier';
$string['assignmenttype_40'] = 'Diplomarbeit';
$string['assignmenttype_101'] = 'Monographie';
$string['assignmenttype_102'] = 'Manuell';
$string['assignmenttype_103'] = 'Abhandlung';
$string['assignmenttype_300'] = 'Buch';

$string['crosscheckmode'] = 'Crosscheck-Modus';
$string['crosscheckmode_help'] = 'Der Cross-Check-Modus ermöglicht den 1:1-Vergleich zwischen den Abgaben der Studenten innerhalb der Aufgabe. Wenn der Cross-Check aktiviert ist, wird der Cross-Check-Bereich im interaktiven Ähnlichkeitsbericht angezeigt.';
$string['removeaiquiz'] = 'Verstecke die KI-Erkennungs-Einstellung';
$string['aidetection'] = 'KI-Erkennung';
$string['aidetection_help'] = 'Durch Aktivieren der Funktion sucht das System nach dem von KI-Tools generierten Text. Wenn der Dienst nicht verfügbar ist, wird der KI-Inhaltsbericht nicht erstellt. Um diese Funktion zu aktivieren, wenden Sie sich bitte an den Systemadministrator.';

$string['updateprotocols'] = 'Protokolle aktualisieren';
$string['getprotocolsresponse'] = 'Protokollantwort';
$string['countprotocols'] = 'Anzahl der Protokolle: ';
$string['errorprotocol'] = 'Fehler';