<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, finnish
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'StrikePlagiarism.comliitännäinen';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Lisätietoja tästä plagiaatintunnistusjärjestelmästä ja sen toiminnasta: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Synkronoi StrikePlagiarism.com-raportti asiakirjalle';
$string['task:getreports'] = 'Synkronoi StrikePlagiarism.com-raportit';
$string['task:sendfiles'] = 'Lähetä tiedostoja StrikePlagiarism.com-järjestelmän API:lle';
$string['strike:enable'] = 'Ota StrikePlagiarism.com-liitännäinen käyttöön';
$string['strike:viewreport'] = 'Näytä samankaltaisuusraportit kaikille opiskelijoille';
$string['strike:resetfile'] = 'Tyhjennä kaikki virheet ja aseta tila uudelleen odottavaksi';
$string['usestrike'] = 'Käytä StrikePlagiarism.com-liitännäistä';
$string['useadminnotifications'] = 'Ilmoitetaanko ylläpitäjälle virheistä?';
$string['useadminnotifications_help'] = 'Ilmoittaa ylläpitäjälle virheistä, kun erilaisia virheitä tapahtuu (esim. yhteydenpidossa StrikePlagiarism.com API:hen).';
$string['useteachernotifications'] = 'Ilmoitetaanko opettajalle virheistä?';
$string['useteachernotifications_help'] = 'Ilmoittaa opettajalle virheistä, kun erilaisia virheitä tapahtuu (esim. yhteydenpidossa StrikePlagiarism.com API:hen).';
$string['strikekey_help'] = 'API-avain StrikePlagiarism.com-tilillesi.<br/>Hanki StrikePlagiarism.com ID -avain käyttääksesi tätä liitännäistä. Lisätietoja saat verkkosivustomme yhteydenottolomakkeella osoitteessa <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'StrikePlagiarism.com API-isäntä';
$string['strikeserver_help'] = 'StrikePlagiarism.com-palvelimen isäntänimi tai IP-osoite. Syötä IP-osoite HTTP- tai HTTPS-alkuisena.';
$string['studentdisclosuredefault'] = 'Hyväksyn, että kaikki lataamani tiedostot voidaan lähettää StrikePlagiarism.com-järjestelmään tekstin alkuperäisyyden tarkistamiseksi.';
$string['strikestudentdisclosure'] = 'Hyväksyn, että kaikki lataamani tiedostot voidaan lähettää StrikePlagiarism.com-järjestelmään tekstin alkuperäisyyden tarkistamiseksi.';
$string['studentdisclosure'] = 'Opiskelijan ilmoitus';
$string['studentdisclosure_help'] = 'Tämä teksti näytetään kaikille opiskelijoille tiedostojen lataussivulla. Se on hyväksyttävä ennen lähettämistä.';
$string['strike_enableplugin'] = 'Ota StrikePlagiarism.com käyttöön {$a}';
$string['notifyteachers'] = 'Ilmoita opettajille';
$string['enableapidebugging'] = 'Ota API-virheenkorjaus käyttöön';
$string['enableapidebugging_help'] = 'Ota tämä vaihtoehto käyttöön, jos haluat StrikePlagiarism.com API:n tarjoaman laajennetun virheenkorjauksen.<br/>
Erilaisia virheenkorjausmenetelmiä on saatavilla. Huomaa, että virheenkorjaus sisältää <i>vain</i> tietoja StrikePlagiarism.com API:n liikenteestä.';
$string['apidebuggingmtrace'] = 'Ota mtrace-virheenkorjaus käyttöön?';
$string['apidebuggingmtrace_help'] = 'Ota tämä vaihtoehto käyttöön, jos haluat nähdä API-virheenkorjaustuloksen mtrace()-lähtönä.<br/>
Jos otat tämän käyttöön, jälkiseuranta näkyy taustatehtävien tulosteessa (CRON).';
$string['apidebuggingerrorlog'] = 'Ota error_log-virheenkorjaus käyttöön?';
$string['apidebuggingerrorlog_help'] = 'Ota tämä vaihtoehto käyttöön, jos haluat nähdä API-virheenkorjaustuloksen error_log-lähdössä.<br/>
Jos otat tämän käyttöön, jälkiseuranta näkyy verkkopalvelimen/PHP:n virhelokissa.<br/>
HUOM: Tämä ei aina ole näkyvissä riippuen verkkopalvelimen tai PHP:n asetuksista.';
$string['apidebuggingemail'] = 'Ota sähköposti-virheenkorjaus käyttöön?';
$string['apidebuggingemail_help'] = 'Ota tämä vaihtoehto käyttöön, jos haluat vastaanottaa API-virheenkorjaustuloksen sähköpostiisi.<br/>
Jos otat tämän käyttöön, jälkiseuranta lähetetään määritettyyn sähköpostiosoitteeseen.<br/>
HUOM: Tämä voi aiheuttaa suuren määrän sähköpostiviestejä.<br/>
HUOM 2: Tämä menetelmä käyttää oletus mail()-toimintoa, eikä se ole aina käytettävissä. Se toimii Moodle-postitoimintojen ulkopuolella.';
$string['apidebuggingemailaddress'] = 'Virheenkorjauksen vastaanottajan sähköpostiosoite.';

$string['str:settings'] = 'Asetukset';
$string['str:defaults'] = 'Oletukset';
$string['str:dump'] = 'Dumppi';
$string['str:debug'] = 'Debug';
$string['allowallsupportedfiles'] = 'Salli kaikki tuetut tiedostomuodot';
$string['allowallsupportedfiles_help'] = 'Mahdollistaa opettajan rajoittaa tiedostomuodot, jotka lähetetään StrikePlagiarism.com-analyysiin. Tämä ei estä opiskelijoita lataamasta muita tiedostotyyppejä tehtävään.';
$string['restrictfiles'] = 'Tiedostomuodot, jotka sallitaan plagiointianalyysille';
$string['form:desc:defaults'] = 'Alla voit syöttää oletusasetukset, joita käytetään, kun uusi aktiviteettimoduuli luodaan ja konfiguroidaan.<br/>
Tähän syötetyt arvot toimivat oletusarvoina StrikePlagiarism.com-laajennuksen asetuksille kyseisessä aktiviteettimoduulissa.';
$string['docsendmode'] = 'Asiakirjojen lähetys plagiointianalyysiin';
$string['docsendmode_help'] = 'Valitse tapa, jolla asiakirjat lähetetään analyysiin. Tämä voi olla valinnan mukaan (opettaja valitsee asiakirjat analyysiin) tai kaikki (kaikki asiakirjat lähetetään analyysiin oletusarvoisesti).';
$string['docsendingchoose'] = 'Lähetä valitut asiakirjat';
$string['docsendingall'] = 'Lähetä kaikki asiakirjat';
$string['strike_show_student_status'] = 'Näytä StrikePlagiarism.com-analyysitila opiskelijalle';
$string['strike_show_student_status_help'] = 'Mahdollistaa opiskelijoille nähdä lähetyksen tila StrikePlagiarism.com-järjestelmässä.';
$string['strike_show_student_report'] = 'Näytä samankaltaisuusraportti opiskelijalle';
$string['strike_show_student_report_help'] = 'Samankaltaisuusraportti osoittaa kopioitujen tekstiosuuksien määrän, korostaen ne tekstissä ja ilmoittaen niiden lähteen.';
$string['strike_show_student_score'] = 'Näytä samankaltaisuuskertoimet opiskelijalle';
$string['strike_show_student_score_help'] = 'Samankaltaisuuskertoimet ilmaisevat, kuinka suuri osa analysoidusta asiakirjasta koostuu tekstiosuuksista, jotka ovat samankaltaisia vertailutietokannoissa havaittujen kanssa.';
$string['strike_addref_method'] = 'Asiakirjojen lisääminen vertailutietokantaan';
$string['strike_addref_method_help'] = 'Valitse tapa lisätä asiakirjat vertailutietokantaan. Tämä voi olla manuaalinen (opettaja valitsee asiakirjat lisättäväksi vertailutietokantaan) tai automaattinen (kaikki asiakirjat lisätään vertailutietokantaan oletusarvoisesti) tarkistuksen jälkeen.<br/>
Suositellaan valitsemaan AUTOMAATTINEN, jotta tarkistetut asiakirjat lisätään automaattisesti vertailutietokantaan.';
$string['strike_deletereport_method'] = 'Samankaltaisuusraporttien poistaminen, kun lähetyksiä poistetaan/päivitetään';
$string['strike_deletereport_method_help'] = 'Määrittää, poistetaanko samankaltaisuusraportit aina, kun lähetys poistetaan tai päivitetään.<br/>
Mahdolliset menetelmät:
<ul>
<li>säilytä: Säilytä vanhat samankaltaisuusraportit</li>
<li>poista: Poista vanhat samankaltaisuusraportit</li>
</ul>';
$string['strike_studentemail'] = 'Sähköposti opiskelijalle';
$string['strike_studentemail_help'] = 'Mahdollistaa sähköpostin lähettämisen opiskelijalle, kun tiedosto on käsitelty. Sähköposti ilmoittaa, että samankaltaisuusraportti on saatavilla, ja sisältää myös opt-out-linkin.';
$string['strike_draft_submit'] = 'Hetki lähettämisestä plagiaatin analyysiin';
$string['strike_defaultlang'] = 'Dokumentin oletuskieli';
$string['strike_defaultlang_help'] = 'Määrittää dokumentin oletuskielen, joka lähetetään StrikePlagiarism.com-järjestelmän analysoitavaksi.';
$string['wordcount'] = 'Minimisanamäärä analyysiä varten';
$string['wordcount_help'] = 'Asettaa minimimäärän sanoja, joita tarvitaan tekstille (keskusteluviestit ja verkkotehtävät), ennen kuin sisältö lähetetään StrikePlagiarism.com-järjestelmän analysoitavaksi.';

$string['addrefauto'] = 'Automaattisesti tarkistuksen jälkeen';
$string['addrefmanual'] = 'Manuaalisesti tarkistuksen jälkeen';

$string['deletereportkeep'] = 'Säilytä vanhat samankaltaisuusraportit';
$string['deletereportremove'] = 'Poista vanhat samankaltaisuusraportit';

$string['submitondraft'] = 'Kun tiedosto ladataan ensimmäisen kerran';
$string['submitonfinal'] = 'Kun opiskelija lähettää arvioitavaksi';
$string['showwhenclosed'] = 'Kun aktiviteetti on suljettu';

$string['pending'] = 'Tiedosto odottaa lähettämistä StrikePlagiarism.com-järjestelmään';
$string['processing'] = 'Tiedosto on lähetetty StrikePlagiarism.com-järjestelmään ja odottaa analyysin valmistumista';
$string['toolarge'] = 'Tiedosto on liian suuri lähetettäväksi StrikePlagiarism.com-järjestelmään';
$string['unsupported'] = 'Tiedostomuotoa ei tueta StrikePlagiarism.com-järjestelmässä';
$string['unsupportedfiletype'] = 'Tiedostomuotoa ei tueta StrikePlagiarism.com-järjestelmässä';
$string['unknownwarning'] = 'Tiedoston lähettämisessä StrikePlagiarism.com-järjestelmään tapahtui virhe';
$string['awaitanalysischoice'] =  'Odottaa päätöstä lähettämisestä StrikePlagiarism.com-järjestelmään analyysiä varten';
$string['previouslysubmitted'] = 'Aiemmin lähetetty nimellä';
$string['sendforanalysis'] = 'Lähetä tiedosto StrikePlagiarism.com-järjestelmän analysoitavaksi';
$string['indexdocument'] = 'Lisää tiedosto vertailutietokantaan StrikePlagiarism.com-järjestelmässä';
$string['deletestrikefile'] = 'Poista tiedosto vertailutietokannasta StrikePlagiarism.com-järjestelmässä';

$string['similarity1'] = 'SK 1';
$string['similarity2'] = 'SK 2';
$string['similarity3'] = 'SK 3';
$string['similarity4'] = 'SK 4';
$string['similarity5'] = 'SK LAD';

$string['filereset'] = 'Tiedosto on nollattu uudelleenlähetystä varten StrikePlagiarism.comiin';
$string['fileresetfailed'] = 'Virhe: tiedostoa ei ole nollattu uudelleenlähetystä varten StrikePlagiarism.comiin';

$string['report'] = 'StrikePlagiarism.com-samankaltaisuusraportti';
$string['report2'] = 'StrikePlagiarism.com-interaktiivinen raportti';
$string['reportclick'] = 'Linkki StrikePlagiarism.com-samankaltaisuusraporttiin';

$string['restrictcontent'] = 'Lähetä liitetyt tiedostot ja sisäiset tekstit';
$string['restrictcontent_help'] = 'StrikePlagiarism.com voi käsitellä ladattuja tiedostoja tai sisäisiä tekstejä foorumiviesteistä ja verkkotekstitehtävien palautuksista. Valitse, mitkä osat lähetetään StrikePlagiarism.com-järjestelmään.';
$string['restrictcontentfiles'] = 'Lähetä vain liitetyt tiedostot';
$string['restrictcontentno'] = 'Lähetä liitetyt tiedostot ja sisäiset tekstit';
$string['restrictcontenttext'] = 'Lähetä vain sisäiset tekstit';

$string['config:plagiarism'] = 'StrikePlagiarism.com-antiplagiointimoduulin yleiset asetukset';
$string['config:defaults'] = 'StrikePlagiarism.com-antiplagiointimoduulin oletusasetukset';

$string['studentemailsubject'] = 'StrikePlagiarism.com-antiplagiointijärjestelmä tarkisti palautuksen';
$string['studentemailcontent'] = '<p>Hyvä {$a->firstname} {$a->lastname},</p>
Tiedosto, jonka palautit kohteeseen {$a->modulename} kurssilla {$a->coursename}, on tarkistettu StrikePlagiarism.com-järjestelmässä.<br/>
{$a->modulelink}<br/>
Terveisin,
{$a->admin}
';

$string['label:user'] = 'Käyttäjä';
$string['label:author'] = 'Tekijä';
$string['label:timesubmitted'] = 'Palautettu';
$string['label:analysisstatus'] = 'Samankaltaisuuskerroin (SK)';
$string['label:reportstatus'] = 'Raportti';
$string['label:status'] = 'Tila';
$string['label:filename'] = 'Tiedoston nimi';
$string['label:modname'] = 'Moduuli';
$string['label:actions'] = 'Toiminnot';

$string['report:na'] = 'Ei saatavilla';
$string['report:ready'] = 'Valmis';
$string['report:available'] = 'Saatavilla';
$string['analysis:auto'] = 'Automaattinen';
$string['analysis:manual'] = 'Pyynnöstä';
$string['analysis:awaitchoice'] = 'Odottaa analyysin valintaa';
$string['cmoverview'] = 'StrikePlagiarism.com-palautusten lista';
$string['notification:subject'] = 'StrikePlagiarism.com-järjestelmän viesti [{$a}]';
$string['notification:errormessage'] = '<p>Hyvä {$a->fullname}<p>
<p>StrikePlagiarism.com-antiplagiointiliitännäisessä kurssilla \'{$a->coursefullname}\' ja tehtävässä \'{$a->instancename}\' tapahtui virhe.<br/>
Ilmennyt virhe oli: {$a->errormessage}.</p>
<p>Tiedoston tiedot:<br/>
Tekijä: {$a->strikefileauthor}<br/>
Ohjaaja: {$a->strikefilecoordinator}<br/>
Dokumenttityyppi: {$a->strikefiledocumentkind}<br/>
Otsikko: {$a->strikefiletitle}<br/>
Tiedoston nimi: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Luontiaika: {$a->strikefiletimecreated}
</p>
<p>Lisätietoja saat osoitteesta <a href="{$a-> kontekstin url }">{$a->contexturlname}</a></p>
<p>Ystävällisin terveisin,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'StrikePlagiarism.com-virheilmoitukset';

$string['err:strike_selectfiletypes-empty'] = 'Valitse sallitut tiedostomuodot lähettämistä varten.<br/>
Koska yhtään tiedostomuotoa ei ole valittu, yhtään dokumenttia ei voida lähettää plagiaatintunnistusjärjestelmään.';
$string['warn:strike_selectfiletypes-empty'] = 'Valitse alla sallitut tiedostomuodot lähettämistä varten.<br/>
Jos tiedostomuotoja ei valita, yhtään dokumenttia ei voida lähettää plagiaatintunnistusjärjestelmään.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Testaa API-yhteys';
$string['test_api_connection_status'] = 'API-yhteyden tila';
$string['test_api_connection_help'] = 'Voit tarkistaa, toimivatko nykyinen API-isäntä ja API-avain oikein.';
$string['api_status_1'] = 'Yhteys kunnossa';
$string['api_status_2'] = 'Avain ei ole kelvollinen';
$string['api_status_3'] = 'Yhteyden aikakatkaisu';
$string['api_status_4'] = 'Yhteys kunnossa, palvelin ei vastaa';
$string['api_status_5'] = 'Yhteysvirhekoodi: {$a->error}';

$string['privacy:metadata:userid'] = 'Tietoa käyttäjästä, joka lähettää tiedoston plagiaatintunnistusanalyysia varten.';
$string['privacy:metadata:relateduserid'] = 'Tietoa liittyvästä käyttäjästä, joka lähettää tiedoston plagiaatintunnistusanalyysia varten.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Taulukko, joka tallentaa tiedot plagiaatintunnistusanalyysia varten lähetetyistä tiedostoista.';
$string['privacy:metadata:title'] = 'Käyttäjän lähettämän dokumentin otsikko.';
$string['privacy:metadata:author'] = 'Lähetetyn tiedoston tekijän tai yhteistekijän nimi.';
$string['privacy:metadata:coordinator'] = 'Lähetetyn tiedoston ohjaaja.';
$string['privacy:metadata:md5sum'] = 'Analyysiin lähetetyn binaarisen dokumentin MD5-tarkistussumma.';
$string['privacy:metadata:ftimesubmitted'] = 'StrikePlagiarism.com file submission time.';
$string['privacy:metadata:ftimecreated'] = 'StrikePlagiarism.com-tiedoston tietueen luontiaika.';
$string['privacy:metadata:ftimemodified'] = 'StrikePlagiarism.com-lähetyksen muokkausaika.';

$string['privacy:metadata:reportready'] = 'Totuusarvo true, jos raportti on ladattavissa, false muuten.';
$string['privacy:metadata:indexed'] = 'Totuusarvo true, jos dokumentti on indeksoitu.';
$string['privacy:metadata:factor1'] = ' Samanlaisuuskerroin 1.';
$string['privacy:metadata:factor2'] = ' Samanlaisuuskerroin 2.';
$string['privacy:metadata:factor3'] = ' Samanlaisuuskerroin 3.';
$string['privacy:metadata:factor4'] = ' Samanlaisuuskerroin 4.';
$string['privacy:metadata:factor5'] = ' Samanlaisuuskerroin LAD.';

$string['privacy:metadata:strikefileid'] = 'StrikePlagiarism.com-lähetyksen tiedoston ID.';
$string['privacy:metadata:report'] = 'StrikePlagiarism.com-lähetyksen samanlaisuusraportin tiedot.';
$string['privacy:metadata:timemodified'] = 'StrikePlagiarism.com-raportin muokkausaika.';
$string['privacy:metadata:timecreated'] = 'StrikePlagiarism.com-raportin luontiaika.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com luo samanlaisuusraportin jokaiselle lähetetylle tiedostolle. Tämä tietue tallennetaan Moodle-tietokantaan. Jokainen raportti liittyy käyttäjän tiedoston lähetykseen.';

$string['privacy:metadata:filename'] = 'Käyttäjän lähettämän tiedoston nimi.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Henkilötiedot, jotka välitetään plagiaatintunnistuksen alijärjestelmästä.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Tämä lisäosa lähettää tietoja ulkoisesti StrikePlagiarism.com-API:n kautta.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com luo GUID:n, joka liittyy tiedoston lähetykseen StrikePlagiarism.com-API:lle.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com tallentaa tiedostot, jotka on ladattu Moodleen StrikePlagiarism.com-lähetyksiä varten.';
$string['assignmenttype'] = 'Tehtävän tyyppi';
$string['assignmenttype_0'] = 'Habilitaatioväite';
$string['assignmenttype_1'] = 'Väitöskirja';
$string['assignmenttype_2'] = 'Pro gradu -tutkielma';
$string['assignmenttype_3'] = 'Kandidaatintutkielma';
$string['assignmenttype_4'] = 'Lukuvuoden työ';
$string['assignmenttype_6'] = 'Tehtävä';
$string['assignmenttype_7'] = 'Artikkeli';
$string['assignmenttype_8'] = 'Tutkimus';
$string['assignmenttype_9'] = 'Insinöörityö';
$string['assignmenttype_10'] = 'Diplomityö';
$string['assignmenttype_16'] = 'Projekti';
$string['assignmenttype_25'] = 'Artikkeli';
$string['assignmenttype_40'] = 'Jatko-opintojen tutkielma';
$string['assignmenttype_101'] = 'Monografia';
$string['assignmenttype_102'] = 'Käsikirja';
$string['assignmenttype_103'] = 'Tutkielma';
$string['assignmenttype_300'] = 'Kirja';

$string['crosscheckmode'] = 'Ristivertailutila';
$string['crosscheckmode_help'] = 'Ristivertailutila mahdollistaa 1:1-vertailun opiskelijoiden tehtävien välillä. Kun ristivertailu on käytössä, ristivertailuosio näkyy interaktiivisessa samanlaisuusraportissa.';
$string['removeaiquiz'] = 'Piilota AI-tunnistusasetukset';
$string['aidetection'] = 'AI-tunnistus';
$string['aidetection_help'] = 'Ottamalla tämän toiminnon käyttöön järjestelmä etsii AI-työkalujen tuottamaa tekstiä. Jos palvelu ei ole käytettävissä, AI-sisältöraporttia ei luoda. Ota yhteyttä järjestelmänvalvojaan tämän toiminnon aktivoimiseksi.';

$string['updateprotocols'] = 'Päivitä protokollat';
$string['getprotocolsresponse'] = 'Protokollien vastaus';
$string['countprotocols'] = 'Protokollien määrä: ';
$string['errorprotocol'] = 'Virhe';
