<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, EN
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'Plagiat.pl';
$string['strike'] = 'wtyczka Plagiat.pl';
$string['strikeplagiarism'] = 'Plagiat.pl';
$string['strikeexplain'] = 'Aby uzyskać więcej informacji na temat systemu Antyplagiat firmy Plagiat.pl oraz jego działnia odzwiedź: <a href="http://www.plagiat.pl">www.plagiat.pl</a>';
$string['task:syncreport'] = 'Synchronizuj Raport podobieństwa dokumentu';
$string['task:getreports'] = 'Synchronizuj Raporty podobieństwa';
$string['task:sendfiles'] = 'Wyslij pliki o API systemu Antyplagiat';
$string['strike:enable'] = 'Włącz wtyczkę Plagiat.pl';
$string['strike:viewreport'] = 'Pokaż Raport podobieństwa studentom';
$string['strike:resetfile'] = 'Wyczyść błędy i ponownie wyślij do sprawdzenia';
$string['usestrike'] = 'Użyj wtyczki Plagiat.pl';
$string['useadminnotifications'] = 'Powiadamiaj administratora o błędach';
$string['useadminnotifications_help'] = 'Wyświetla powiadomienia administratorowi w przypadku wystąpienia błędów wtyczki (na przykład podczas błędów komunikacji z interfejsem API Plagiat.pl)';
$string['useteachernotifications'] = 'Powiadamiaj nauczyciela o błędach';
$string['useteachernotifications_help'] = 'Wyświetla powiadomienia wykładowcy w przypadku wystąpienia róznych bledów wtyczki (na przykład podczas błędów komunikacji z interfejsem API  Plagiat.pl)';
$string['strikekey'] = 'Klucz API do systemu Antyplagiat';
$string['strikekey_help'] = 'Klucz API do Twojego konta w systemie Antyplagiat firmy Plagiat.pl <br/> Aby korzystać z tej wtyczki musisz uzyskać klucz dostępu. Więcej informacji dostępnych za pomocą formularza kontaktowego na stronie <a href="http://www.plagiat.pl">www.plagiat.pl</a>';
$string['strikeserver'] = 'Host API';
$string['strikeserver_help'] = 'Nazwa serwera Plagiat.pl lub adres IP. Wprowadź adres IP Plagiat.pl z http lub https';
$string['studentdisclosuredefault'] = 'Wyrażam zgodę, aby wszystkie przesłane przeze mnie pliki zostały przekazane do systemu Antyplagiat firmy Plagiat.pl w celu sprawdzenia oryginalności tekstu.';
$string['strikestudentdisclosure'] = 'Wyrażam zgodę, aby wszystkie przesłane przeze mnie pliki zostały przekazane do systemu Antyplagiat firmy Plagiat.pl w celu sprawdzenia oryginalności tekstu.';
$string['studentdisclosure'] = 'Oświadczenie studenta';
$string['studentdisclosure_help'] = 'Ten tekst będzie wyświetlany wszystkim studetom na stronie przesyłania plików. Jego akceptacja jest niezbędna dla przesłania plików.';
$string['strike_enableplugin'] = 'Włacz wtyczkę Plagiat.pl dla {$a}';
$string['notifyteachers'] = 'Powiadom nauczyciela';
$string['enableapidebugging'] = 'Włącz debugowanie API';
$string['enableapidebugging_help'] = 'Włącz tę opcję jeśli chcesz uzyskać dostęp do rozszerzone debugowania API.<br/>
Dostępnych jest wiele metod debugowania <i>tylko</i> składających się z komunikacji/ruchu na API Plagiat.pl.';
$string['apidebuggingmtrace'] = 'Włącz debugowanie mtrace?';
$string['apidebuggingmtrace_help'] = 'Włącz tę opcję, jeśli chcesz zobaczyć wyjście degugowania API jako mtrace().<br/>
Jeśli właczysz tę opcję, opuszczenie  będzie widoczne w tle zadania (CRON).';
$string['apidebuggingerrorlog'] = 'Włącz debugowanie error_log?';
$string['apidebuggingerrorlog_help'] = 'Włącz tę opcję, aby wyświetlić wyjście debugowania protokołu API jako error_log.<br/>
Jesli włączysz tę opcję, wyjście śledzenia będzie widoczne w webserwerze / php error_log.<br/>
Uwaga: Opcja będzie widoczna w zależności od konfiguracji webservera lub PHP.';
$string['apidebuggingemail'] = 'Włącz debugowanie na pocztę e-mail?';
$string['apidebuggingemail_help'] = 'Włącz tę opcję, jeżeli chcesz otrzymywać wynik debugowania API w wiadomośći e-mail.<br/>
Jeśli opcja zostanie włączona, wyjście śledzenia zostanie wysłane na wskazany adres e-mail.<br/>
Uwaga 1: Może spowodować wysłanie wielu wiadomości e-mail.<br/>
Uwaga 2: Ta metoda wykorzystuje domyślną funkcję skrzynki mailowej() , i nie zawsze będzie dostępna. Działa poza fukcjami poczty Moodle.';
$string['apidebuggingemailaddress'] = 'Adresat debugowania na pocztę e-mail.';

$string['str:settings'] = 'Konfiguracja';
$string['str:defaults'] = 'Ustawienia domyślne';
$string['str:dump'] = 'Zrzut zawartośći';
$string['str:debug'] = 'Debugowanie';
$string['allowallsupportedfiles'] = 'Zezwalaj na wszystkie obsługiwane formaty plików';
$string['allowallsupportedfiles_help'] = 'Pozwala wykładowcy ograniczyć formaty plików wysyłane do systemu Antyplagiat w celu ich weryfikacji. Nie zapobiega wgrywaniu przez studentów plików w innych formatach zadania';
$string['restrictfiles'] = 'Dozwolone formaty plików';
$string['form:desc:defaults'] = 'Poniżej możesz wprowadzić wszystkie domyślne ustawienia, które będą używane podczas tworzenia i konfigurowania nowego modułu aktywności.<br/>
Wpisane tutaj wartości będą służyć jako wartości domyślne wtyczki Plagiat.pl dla aktywności.';
$string['docsendmode'] = 'Wysyłaj do analizy antyplagiatowej dokumenty';
$string['docsendmode_help'] = 'Wybierz domyślną metodę wysyłania dokumentów do analizy. Możliwe jest wysłanie jedynie dokumentów wybranych przez nauczyciela lub wszystkich automatycznie';
$string['docsendingchoose'] = 'Wybrane przez nauczyciela';
$string['docsendingall'] = 'Wszystkie';
$string['strike_show_student_status'] = 'Pokazuj status analizy antyplagiatowej studentowi';
$string['strike_show_student_status_help'] = 'Pozwala studentom śledzenie statusu prac zgłoszonych do systemu Antyplagiat.';
$string['strike_show_student_report'] = 'Pokazuj Raport podobieństwa studentowi';
$string['strike_show_student_report_help'] = 'Raport podobieństwa wskazuje liczbę zapożyczonych fragmentów wraz z zaznaczeniem ich w tekście oraz podaniem ich źródła.';
$string['strike_show_student_score'] = 'Pokazuj Współczynniki podobieństwa studentowi';
$string['strike_show_student_score_help'] = 'Współczynniki podobieństwa określają, w jakim stopniu analizowany dokument składa się z fragmentów podobnych do tych wykrytych w bazach porównawczych.';
$string['strike_addref_method'] = 'Dodawaj do bazy porównawczej dokumenty';
$string['strike_addref_method_help'] = 'Wybierz domyślną metodę dodawania dokumentów do bazy porównawczej. Możliwe jest dodawanie dokumentów ręczne (nauczyciel wybiera dokumenty do dodania do bazy) lub automatyczne (wszystkie dokumenty są automatycznie dodawane do bazy) po sprawdzeniu.';
$string['strike_deletereport_method'] = 'Usuwaj Raporty podobieństwa dla dokumentów usuniętych/edytowanych';
$string['strike_deletereport_method_help'] = 'Określa czy Raporty podobieństwa zostaną usunięte przy kazdej zmianie lub aktualizacji zgłoszenia.<br/>
Możliwe jest zachowanie poprzednich Raportów podobieństwa lub ich usunięcie.';
$string['strike_studentemail'] = 'Wysyłaj wiadomość e-mail do studenta';
$string['strike_studentemail_help'] = 'Wysłanie wiadomości e-mail do studanta, gdy plik został sprawdzony w systemie antyplagiatowym, aby poinformować go, że Raport podobieństwa jest dostępny. Wiadomość e-mail zawiera również link do rezygnacji z powiadomień.';
$string['strike_draft_submit'] = 'Moment wysłania pracy do analizy antyplagiatowej';
$string['strike_defaultlang'] = 'Domyślny język dokumentu';
$string['strike_defaultlang_help'] = 'Określa domyślny język wgłaszanych do sprawdzenia dokumentów na potrzeby systemu antyplagiatowego.';
$string['wordcount'] = 'Minimalna liczba słów analizowanego tekstu';
$string['wordcount_help'] = 'Określa minimalną liczbę słów, jaką musi mieć tekst wysyłany do analizy antyplagiatowej. Parametr wymagany do sprawdzenia treści wpisywanych bezpośrednio do aktywności Moodle.';

$string['addrefauto'] = 'Automatycznie po ich sprawdzeniu';
$string['addrefmanual'] = 'Ręcznie (wybrane dokumenty)';

$string['deletereportkeep'] = 'Zachowaj stare Raporty podobieństwa';
$string['deletereportremove'] = 'Usuń stare Raporty podobieństwa';

$string['submitondraft'] = 'Po wgraniu do aktywności';
$string['submitonfinal'] = 'Po wysłaniu do oceny';
$string['showwhenclosed'] = 'Po zamknięciu aktywności';

$string['pending'] = 'Plik oczekuje na wysłanie do systemu Antyplagiat';
$string['processing'] = 'Plik został wysłany do systemu Antyplagiat oczekuje na zakończenie analizy';
$string['toolarge'] = 'Plik jest zbyt duży aby przesłać go do systemu Antyplagiat';
$string['unsupported'] = 'Format pliku nie jest wspierany przez system Antyplagiat';
$string['unsupportedfiletype'] = 'Format pliku nie jest wspierany przez system Antyplagiat';
$string['unknownwarning'] = 'Wystąpił błąd podczas wysyłania pliku do systemu Antyplagiat';
$string['awaitanalysischoice'] = 'Oczekuje na wybór pliku do analizy antyplagiatowej';
$string['previouslysubmitted'] = 'Poprzednio zgłoszono jako';
$string['sendforanalysis'] = 'Wyślij plik do analizy antyplagiatowej';
$string['indexdocument'] = 'Dodaj plik do swojej bazy porównawczej w systemie Antyplagiat';
$string['deletestrikefile'] = 'Wycofaj pracę z bazy porównawczej w systemie Antyplagiat.';

$string['similarity1'] = 'WP 1';
$string['similarity2'] = 'WP 2';
$string['similarity3'] = 'WP 3';
$string['similarity4'] = 'WP 4';
$string['similarity5'] = 'WP BAP';

$string['filereset'] = 'Plik został zresetowany w celu ponownej wysyłki do systemu Antyplagiat';
$string['fileresetfailed'] = 'Błąd: Nie udało się zresetować pliku w celu ponownej wysyłki do systemu Antyplagiat';

$string['report'] = 'Raport podobieństwa Plagiat.pl';
$string['report2'] = 'Interaktywny Raport podobieństwa';
$string['reportclick'] = 'Przejdż do Raportu podobieństwa Plagiat.pl';

$string['restrictcontent'] = 'Sprawdzanie wgranych plików i wpisanych tesktów';
$string['restrictcontent_help'] = 'System Antyplagiat może wysyłać do sprawdzenia zarówno wgrywane do aktuwności pliki, jak i teksty wpisywane online (np. wiersze z postów na forum). Ustawienie określa, które elementy bedą wysłane do sprawdzenia.';
$string['restrictcontentfiles'] = 'Sprawdzaj tylko wgrane pliki';
$string['restrictcontentno'] = 'Sprawdzaj wgrane pliki i wpisane teksty';
$string['restrictcontenttext'] = 'Sprawdzaj tylko wpisany tekst';

$string['config:plagiarism'] = 'Globalna konfiguracja wtyczki antyplagiatowej Plagiat.pl';
$string['config:defaults'] = 'Domyślna konfiguracja wtyczki antyplagiatowej Plagiat.pl';

$string['studentemailsubject'] = 'Zgłoszenia praca została sprawdzona w systemie Antyplagiat';
$string['studentemailcontent'] = '<p>Szanowny/a {$a->firstname} {$a->lastname},</p>
Uprzejmie informujemy, że przesłany plik {$a->modulename} z zadania {$a->coursename} został sprawdzony w systemie Antyplagiat firmy Plagiat.pl<br/>
{$a->modulelink}<br/>
Z poważaniem,
{$a->admin}
';

$string['label:user'] = 'Użytkownik';
$string['label:author'] = 'Autor';
$string['label:timesubmitted'] = 'Złożone w dniu';
$string['label:analysisstatus'] = 'Współczynniki podobieństwa (WP)';
$string['label:reportstatus'] = 'Raport';
$string['label:status'] = 'Status';
$string['label:filename'] = 'Nazwa pliku';
$string['label:modname'] = 'Moduł';
$string['label:actions'] = 'Akcje';

$string['report:na'] = 'N/A';
$string['report:ready'] = 'Gotowy';
$string['report:available'] = 'Dostępny';
$string['analysis:auto'] = 'Analiza automatyczna';
$string['analysis:manual'] = 'Analiza na żądanie';
$string['analysis:awaitchoice'] = 'Oczekuje na wybranie do analizy';
$string['cmoverview'] = 'Lista prac zgłoszonych do systemu Antyplagiat';
$string['notification:subject'] = 'Wiadomość [{$a}]';
$string['notification:errormessage'] = '<p>Szanowny/a {$a->firstname} {$a->lastname}<p>
<p>Wystąpił błąd we wtyczce antyplagiatowej Plagiat.pl w \'{$a->instancename}\' w kursie \'{$a->coursefullname}\'.<br/>
Wykryty błąd to: {$a->errormessage}.</p>
<p>Poniżej znajdują się szczegóły pliku:<br/>
Autor: {$a->strikefileauthor}<br/>
Opiekun pracy: {$a->strikefilecoordinator}<br/>
Rodzaj dokumentu: {$a->strikefiledocumentkind}<br/>
Tytuł: {$a->strikefiletitle}<br/>
Nazwa pliku: {$a->strikefilename}<br/>
Identyfikator GUID: {$a->strikefileguid}<br/>
Czas utworzenia: {$a->strikefiletimecreated}
</p>
<p>Przejdź do <a href="{$a->contexturl}">{$a->contexturlname}</a>, aby uzyskać więcej informacji.</p>
<p>Z poważaniem,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'Plagiat.pl - powiadomienie o błędzie';

$string['err:strike_selectfiletypes-empty'] = 'Wybierz formaty plików, które będą poddawane analizie antyplagiatowej.<br/>
Jeśli żaden format nie zostanie wybrany, dokumenty nie będą wysyłane do sprawdzenia w systemie antyplagiatowym.';
$string['warn:strike_selectfiletypes-empty'] = 'Wybierz formaty plików, które będą poddawane analizie antyplagiatowej.<br/>
Jeśli żaden format nie zostanie wybrany, dokumenty nie będą wysyłane do sprawdzenia w systemie antyplagiatowym.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Testuj połączeni API';
$string['test_api_connection_status'] = 'Status połączenia API';
$string['test_api_connection_help'] = 'Możesz sprawdzić czy wprowadzone host i klucz API są poprawne i czy można połączyć się z systemem antyplagiatowym.';
$string['api_status_1'] = 'Połączenie poprawne';
$string['api_status_2'] = 'Nieprawidłowy klucz API';
$string['api_status_3'] = 'PRzekroczona czas połączenia';
$string['api_status_4'] = 'Połączenie poprawne, serwer nie odpoiwada';
$string['api_status_5'] = 'Błąd połączenia: {$a->error}';

$string['privacy:metadata:userid'] = 'Informacja o użytkowniku przesyłającym plik do analizy antyplagiatowej.';
$string['privacy:metadata:relateduserid'] = 'Informacja o użytkowniku przesyłającym plik do analizy antyplagiatowej.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Tabela przechowuje informacje o plikach zgłoszonych do analizy antyplagiatowej.';
$string['privacy:metadata:title'] = 'Tytuł dokumentu zgłoszonego przez użytkownika';
$string['privacy:metadata:author'] = 'Autor/zy';
$string['privacy:metadata:coordinator'] = 'Opiekun pracy';
$string['privacy:metadata:md5sum'] = 'Suma binarna MD5 dokumentu przesłanego do analizy.';
$string['privacy:metadata:ftimesubmitted'] = 'Czas przesłania pliku do systemu Antyplagiat.';
$string['privacy:metadata:ftimecreated'] = 'Czas utworzenia wpisu o pliku w systemie Antyplagiat';
$string['privacy:metadata:ftimemodified'] = 'Czas modyfikacji zgłoszenia pliku w systemie Antyplagiat';

$string['privacy:metadata:reportready'] = 'Wartość "prawda", jeśli Raport podobieństwa jest gotowy do pobrania.';
$string['privacy:metadata:indexed'] = 'Wartość "prawda", jeśli dokument został dodany do bazy porównawczej.';
$string['privacy:metadata:factor1'] = 'Współczynnik podobieństwa 1.';
$string['privacy:metadata:factor2'] = 'Współczynnik podobieństwa 2.';
$string['privacy:metadata:factor3'] = 'Współczynnik podobieństwa 3.';
$string['privacy:metadata:factor4'] = 'Współczynnik podobieństwa 4.';
$string['privacy:metadata:factor5'] = 'Współczynnik podobieństwa BAP.';

$string['privacy:metadata:strikefileid'] = 'Identyfikator pliku wysyłanego do sprawdzenia w systemie Antyplagiat.';
$string['privacy:metadata:report'] = 'Dane Raportu podobieństwa Plagiat.pl dla zgłoszonej pracy.';
$string['privacy:metadata:timemodified'] = 'Data modyfikacji Raportu podobieństwa Plagiat.pl dla zgłoszonej pracy.';
$string['privacy:metadata:timecreated'] = 'Data utworzenia Raportu podobieństwa Plagiat.pl dla zgłoszonej pracy.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'System Antyplagiat tworzy Raport podobieństwa dla każdego przesłanego pliku/tekstu. Każdy raport jest związany z użytownikiem przesyłającym plik.';

$string['privacy:metadata:filename'] = 'Nazwa pliku wgranego przez użytkownika';
$string['privacy:metadata:plagiarism_strike:data'] = 'Dane osobowe przesyłane do systemu Antyplagiat firmy Plagiat.pl.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Ta wtyczka przesyła dane do API zewnętrzengo systemu Antyplagiat firmy Plagiat.pl.';

$string['privacy:metadata:guid'] = 'System Plagiat.pl tworzy identyfikator GUID, który stanowi powiązanie dla pliku przesyłanego poprzez API do systemu antyplagiatowego.';
$string['privacy:metadata:core_files'] = 'System Plagiat.pl przechowuje pliki, kóre były wgrane do Moodle i a następnie przesłasłane do analizy antyplagiatowej.';
$string['assignmenttype'] = 'Rodzaj dokumentu';
$string['assignmenttype_0'] = 'Praca habilitacyjna';
$string['assignmenttype_1'] = 'Praca doktorska';
$string['assignmenttype_2'] = 'Praca magisterska';
$string['assignmenttype_3'] = 'Praca licencjacka';
$string['assignmenttype_4'] = 'Praca roczna';
$string['assignmenttype_6'] = 'Praca zaliczeniowa';
$string['assignmenttype_7'] = 'Artykuł';
$string['assignmenttype_8'] = 'Opracowanie';
$string['assignmenttype_9'] = 'Praca inżynierska';
$string['assignmenttype_10'] = 'Praca dyplomowa';
$string['assignmenttype_16'] = 'Projekt';
$string['assignmenttype_25'] = 'Referat';
$string['assignmenttype_40'] = 'Praca podyplomowa';
$string['assignmenttype_101'] = 'Monografia';
$string['assignmenttype_102'] = 'Podręcznik';
$string['assignmenttype_103'] = 'Opracowanie naukowe';
$string['assignmenttype_300'] = 'Książka';

$string['crosscheckmode'] = 'Porównaj wewnątrz kolekcji';
$string['crosscheckmode_help'] = 'Porównanie wewnątrz kolekcji umożliwia porównanie podobieństwa 1:1 zgłoszonych prac uczniów w ramach zadania. Gdy opcja jest włączona, dodatkowa sekcja będzie widoczna w interaktywnym Raporcie podobieństwa.';
$string['removeaiquiz'] = 'Ukryj ustawienie wykrywania AI';
$string['aidetection'] = 'Wykrywanie AI';
$string['aidetection_help'] = 'Po włączeniu tej funkcjonalności system rozpocznie wyszukiwanie tekstu wygenerowanego przez AI. Brak raportu AI oznacza niedostępność usługi. Aby włączyć tę funkcję, skontaktuj się z administratorem systemu.';

$string['updateprotocols'] = 'Aktualizuj protokoły';
$string['getprotocolsresponse'] = 'Odpowiedź protokołów';
$string['countprotocols'] = 'Liczba protokołów: ';
$string['errorprotocol'] = 'Błąd';