<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, Portuguese
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'Plugin StrikePlagiarism.com';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Para mais informações sobre este sistema antiplágio e como ele funciona, veja: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Sincronizar Relatório StrikePlagiarism.com para o documento';
$string['task:getreports'] = 'Sincronizar relatórios StrikePlagiarism.com';
$string['task:sendfiles'] = 'Enviar arquivos para a API do sistema StrikePlagiarism.com';
$string['strike:enable'] = 'Habilitar plugin StrikePlagiarism.com';
$string['strike:viewreport'] = 'Exibir Relatórios de Similaridade para todos os estudantes';
$string['strike:resetfile'] = 'Limpar todos os erros e definir o status como pendente novamente';
$string['usestrike'] = 'Usar plugin StrikePlagiarism.com';
$string['useadminnotifications'] = 'Notificar o administrador sobre erros?';
$string['useadminnotifications_help'] = 'Notifica o administrador sobre erros quando diversos erros ocorrem (por exemplo, ao se comunicar com a API do StrikePlagiarism.com)';
$string['useteachernotifications'] = 'Notificar o(s) professor(es) sobre erros?';
$string['useteachernotifications_help'] = 'Notifica o(s) professor(es) sobre erros quando diversos erros ocorrem (por exemplo, ao se comunicar com a API do StrikePlagiarism.com)';
$string['strikekey'] = 'Chave API StrikePlagiarism.com';
$string['strikekey_help'] = 'Chave API para sua conta no sistema StrikePlagiarism.com<br/>Você precisa obter uma chave de ID StrikePlagiarism.com para usar este plugin. Para mais informações, entre em contato conosco pelo formulário de contato no site <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'Host da API StrikePlagiarism.com';
$string['strikeserver_help'] = 'Nome do servidor ou endereço IP do StrikePlagiarism.com. Insira o endereço IP com http ou https';
$string['studentdisclosuredefault'] = 'Concordo que todos os arquivos que eu enviei possam ser submetidos ao sistema antiplágio StrikePlagiarism.com para verificar a originalidade do texto';
$string['strikestudentdisclosure'] = 'Concordo que todos os arquivos que eu enviei possam ser submetidos ao sistema antiplágio StrikePlagiarism.com para verificar a originalidade do texto';
$string['studentdisclosure'] = 'Declaração do Estudante';
$string['studentdisclosure_help'] = 'Este texto será exibido para todos os estudantes na página de envio de arquivos. Ele deve ser aceito para prosseguir com o envio.';
$string['strike_enableplugin'] = 'Habilitar StrikePlagiarism.com para {$a}';
$string['notifyteachers'] = 'Notificar o(s) professor(es)';
$string['enableapidebugging'] = 'Habilitar depuração da API';
$string['enableapidebugging_help'] = 'Ative esta opção se desejar uma depuração mais detalhada fornecida pela API do StrikePlagiarism.com.<br/>
Diversos métodos de depuração estão disponíveis. Observe que a depuração consistirá <i>somente</i> nas informações de comunicação/tráfego da API do StrikePlagiarism.com.';
$string['apidebuggingmtrace'] = 'Habilitar depuração mtrace?';
$string['apidebuggingmtrace_help'] = 'Ative esta opção se você deseja ver a saída de depuração da API como a saída do mtrace().<br/>
Se você ativar isso, a saída de rastreamento será visível na saída da tarefa em segundo plano (CRON).';
$string['apidebuggingerrorlog'] = 'Habilitar depuração do error_log?';
$string['apidebuggingerrorlog_help'] = 'Ative esta opção se você deseja ver a saída de depuração da API como a saída do error_log.<br/>
Se você ativar isso, a saída de rastreamento será visível no error_log do servidor web/php.<br/>
NOTA: Isso pode não ser visível dependendo da configuração do seu servidor web ou PHP.';
$string['apidebuggingemail'] = 'Habilitar depuração por e-mail?';
$string['apidebuggingemail_help'] = 'Ative esta opção se você deseja receber a saída de depuração da API no seu e-mail.<br/>
Se você ativar isso, a saída de rastreamento será enviada para o endereço de e-mail especificado.<br/>
NOTA: Isso pode gerar o envio de muitos e-mails.<br/>
NOTA 2: Esse método utiliza a função mail() padrão e pode não estar disponível. Ele funciona fora das funções de e-mail do Moodle.';
$string['apidebuggingemailaddress'] = 'Endereço de e-mail para depuração.';

$string['str:settings'] = 'Configurações';
$string['str:defaults'] = 'Padrões';
$string['str:dump'] = 'Despejo';
$string['str:debug'] = 'Depuração';
$string['allowallsupportedfiles'] = 'Permitir todos os formatos de arquivo suportados';
$string['allowallsupportedfiles_help'] = 'Permite que o professor restrinja os formatos de arquivo que serão enviados para o StrikePlagiarism.com para processamento. Isso não impede os estudantes de enviarem tipos de arquivos diferentes para a tarefa.';
$string['restrictfiles'] = 'Formatos de arquivo permitidos para análise antiplágio';
$string['form:desc:defaults'] = 'Abaixo, você pode inserir todas as configurações padrão que serão usadas quando um novo módulo de atividade for criado e configurado.<br/>
Os valores inseridos aqui servirão como valores padrão para a configuração do plugin StrikePlagiarism.com para esse módulo de atividade.';
$string['docsendmode'] = 'Envio de documentos para análise antiplágio';
$string['docsendmode_help'] = 'Escolha o método de envio de documentos para análise. Isso pode ser por escolha (onde o professor seleciona os documentos para enviar para análise) ou por todos (onde todos os documentos são enviados por padrão para análise)';
$string['docsendingchoose'] = 'Enviar documentos escolhidos';
$string['docsendingall'] = 'Enviar todos os documentos';
$string['strike_show_student_status'] = 'Exibir status da análise StrikePlagiarism.com para o estudante';
$string['strike_show_student_status_help'] = 'Permite que os estudantes vejam o status dos envios para o sistema StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Exibir Relatório de Similaridade para o estudante';
$string['strike_show_student_report_help'] = 'O Relatório de Similaridade indica o número de fragmentos e destaca as partes copiadas no texto, informando suas fontes.';
$string['strike_show_student_score'] = 'Exibir Coeficientes de Similaridade para o estudante';
$string['strike_show_student_score_help'] = 'Os Coeficientes de Similaridade determinam em que porcentagem o documento analisado consiste de fragmentos semelhantes aos detectados nas bases de dados comparativas.';
$string['strike_addref_method'] = 'Adicionar documentos ao banco de dados comparativo';
$string['strike_addref_method_help'] = 'Escolha o método de adicionar documentos ao seu banco de dados comparativo. Isso pode ser manual (onde o professor seleciona os documentos para serem adicionados ao banco de dados comparativo) ou automático (onde todos os documentos são adicionados ao banco de dados comparativo por padrão) após a verificação.<br/>
É altamente recomendável definir isso como AUTOMÁTICO, para que os documentos verificados sejam adicionados automaticamente ao banco de dados comparativo.';
$string['strike_deletereport_method'] = 'Exclusão de Relatórios de Similaridade para envios deletados/atualizados';
$string['strike_deletereport_method_help'] = 'Define se os Relatórios de Similaridade devem ser excluídos sempre que um envio for excluído ou atualizado.<br/>
Os métodos possíveis são:
<ul>
<li>manter: Manter os Relatórios de Similaridade antigos</li>
<li>remover: Excluir os Relatórios de Similaridade antigos</li>
</ul>';
$string['strike_studentemail'] = 'E-mail para o estudante';
$string['strike_studentemail_help'] = 'Habilita o envio de um e-mail para o estudante quando um arquivo for processado, informando que um Relatório de Similaridade está disponível. O e-mail também incluirá o link para opt-out.';
$string['strike_draft_submit'] = 'Momento de envio para análise antiplágio';
$string['strike_defaultlang'] = 'Idioma padrão do documento';
$string['strike_defaultlang_help'] = 'Define o idioma padrão do documento enviado para análise no sistema StrikePlagiarism.com.';
$string['wordcount'] = 'Contagem mínima de palavras para análise';
$string['wordcount_help'] = 'Define o número mínimo de palavras necessárias para o texto inserido (postagens em fóruns e tipos de tarefas online) antes que o conteúdo seja enviado para o sistema StrikePlagiarism.com para análise.';

$string['addrefauto'] = 'Automaticamente após a verificação';
$string['addrefmanual'] = 'Manual após a verificação';

$string['deletereportkeep'] = 'Manter Relatórios de Similaridade antigos';
$string['deletereportremove'] = 'Excluir Relatórios de Similaridade antigos';

$string['submitondraft'] = 'Quando o arquivo for carregado pela primeira vez';
$string['submitonfinal'] = 'Quando o estudante submeter para avaliação';
$string['showwhenclosed'] = 'Quando a Atividade estiver fechada';

$string['pending'] = 'Arquivo pendente de envio para StrikePlagiarism.com';
$string['processing'] = 'Arquivo foi enviado para StrikePlagiarism.com e aguarda a conclusão da análise';
$string['toolarge'] = 'Arquivo muito grande para ser enviado para StrikePlagiarism.com';
$string['unsupported'] = 'Formato de arquivo não suportado pelo StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Formato de arquivo não suportado pelo StrikePlagiarism.com';
$string['unknownwarning'] = 'Ocorreu um erro ao enviar este arquivo para StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'Aguardando decisão sobre o envio para análise no StrikePlagiarism.com';
$string['previouslysubmitted'] = 'Enviado anteriormente como';
$string['sendforanalysis'] = 'Enviar submissão para análise no StrikePlagiarism.com';
$string['indexdocument'] = 'Adicionar submissão ao seu banco de dados comparativo no sistema StrikePlagiarism.com';
$string['deletestrikefile'] = 'Retirar submissão do seu banco de dados comparativo no sistema StrikePlagiarism.com';

$string['similarity1'] = 'CS 1';
$string['similarity2'] = 'CS 2';
$string['similarity3'] = 'CS 3';
$string['similarity4'] = 'CS 4';
$string['similarity5'] = 'CS DLA';

$string['filereset'] = 'Arquivo foi redefinido para reenvio para StrikePlagiarism.com';
$string['fileresetfailed'] = 'Erro: o arquivo não foi redefinido para reenvio para StrikePlagiarism.com';

$string['report'] = 'Relatório de Similaridade do StrikePlagiarism.com';
$string['report2'] = 'Relatório interativo do StrikePlagiarism.com';
$string['reportclick'] = 'Link para Relatório de Similaridade do StrikePlagiarism.com';

$string['restrictcontent'] = 'Enviar arquivos anexados e texto em linha';
$string['restrictcontent_help'] = 'O StrikePlagiarism.com pode processar arquivos enviados ou texto em linha de postagens de fóruns e de tarefas enviadas no formato de texto online. Escolha quais componentes enviar para o sistema StrikePlagiarism.com.';
$string['restrictcontentfiles'] = 'Enviar apenas arquivos anexados';
$string['restrictcontentno'] = 'Enviar arquivos anexados e texto em linha';
$string['restrictcontenttext'] = 'Enviar apenas texto em linha';

$string['config:plagiarism'] = 'Valores de configuração globais do módulo de antiplágio StrikePlagiarism.com';
$string['config:defaults'] = 'Configurações padrão do módulo de antiplágio StrikePlagiarism.com';

$string['studentemailsubject'] = 'Submissão verificada pelo sistema antiplágio StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Prezado(a) {$a->firstname} {$a->lastname},</p>
O arquivo que você enviou para {$a->modulename} no {$a->coursename} foi verificado pelo StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
Atenciosamente,
{$a->admin}
';

$string['label:user'] = 'Usuário';
$string['label:author'] = 'Autor';
$string['label:timesubmitted'] = 'Enviado em';
$string['label:analysisstatus'] = 'Coeficientes de Similaridade (SC)';
$string['label:reportstatus'] = 'Relatório';
$string['label:status'] = 'Status';
$string['label:filename'] = 'Nome do arquivo';
$string['label:modname'] = 'Módulo';
$string['label:actions'] = 'Ação(ões)';

$string['report:na'] = 'N/D';
$string['report:ready'] = 'Pronto';
$string['report:available'] = 'Disponível';
$string['analysis:auto'] = 'Automático';
$string['analysis:manual'] = 'Sob demanda';
$string['analysis:awaitchoice'] = 'Aguardando seleção para análise';
$string['cmoverview'] = 'Lista de submissões do StrikePlagiarism.com';
$string['notification:subject'] = 'Mensagem do sistema StrikePlagiarism.com [{$a}]';
$string['notification:errormessage'] = '<p>Prezado(a) {$a->fullname}<p>
<p>Ocorreu um erro no plugin antiplágio StrikePlagiarism.com em \'{$a->instancename}\' no curso \'{$a->coursefullname}\'.<br/>
O erro gerado foi: {$a->errormessage}.</p>
<p>Abaixo estão os detalhes do arquivo:<br/>
Autor: {$a->strikefileauthor}<br/>
Coordenador: {$a->strikefilecoordinator}<br/>
Tipo de Documento: {$a->strikefiledocumentkind}<br/>
Título: {$a->strikefiletitle}<br/>
Nome do arquivo: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Data de criação: {$a->strikefiletimecreated}
</p>
<p>Por favor, acesse <a href="{$a->contexturl}">{$a->contexturlname}</a> para mais detalhes</p>
<p>Atenciosamente,<br/>{$a->signoff}</p>';
$string['message_provider:strikenotification'] = 'Notificações de erro do StrikePlagiarism.com';

$string['err:strike_selectfiletypes-empty'] = 'Por favor, faça uma seleção de formatos de arquivo permitidos para envio.<br/>
Como nenhum formato de arquivo foi escolhido, nenhum documento será enviado para a API do sistema antiplágio.';
$string['warn:strike_selectfiletypes-empty'] = 'Por favor, faça uma seleção de formatos de arquivo permitidos para envio abaixo.<br/>
Se nenhum formato de arquivo for escolhido, nenhum documento será enviado para a API do sistema antiplágio.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Testar conexão API';
$string['test_api_connection_status'] = 'Status da conexão API';
$string['test_api_connection_help'] = 'Você pode verificar se o host API atual e a chave API estão funcionando corretamente.';
$string['api_status_1'] = 'Conexão ok';
$string['api_status_2'] = 'Chave não válida';
$string['api_status_3'] = 'Timeout de conexão';
$string['api_status_4'] = 'Conexão ok, servidor não respondendo';
$string['api_status_5'] = 'Erro de conexão código: {$a->error}';

$string['privacy:metadata:userid'] = 'Informações sobre o usuário que está enviando o arquivo para análise antiplágio.';
$string['privacy:metadata:relateduserid'] = 'Informações sobre o usuário relacionado que está enviando o arquivo para análise antiplágio.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Tabela que armazena informações sobre os arquivos enviados para análise antiplágio.';
$string['privacy:metadata:title'] = 'Título do documento enviado pelo usuário.';
$string['privacy:metadata:author'] = 'Nome do autor ou coautor do arquivo enviado.';
$string['privacy:metadata:coordinator'] = 'Promotor do arquivo enviado.';
$string['privacy:metadata:md5sum'] = 'Soma MD5 do documento binário enviado para análise.';
$string['privacy:metadata:ftimesubmitted'] = 'Hora de envio do arquivo para o StrikePlagiarism.com.';
$string['privacy:metadata:ftimecreated'] = 'Hora de criação do registro do arquivo no StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Hora de modificação do envio do arquivo para o StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Valor booleano verdadeiro se o relatório estiver pronto para download, falso caso contrário.';
$string['privacy:metadata:indexed'] = 'Valor booleano verdadeiro se o documento foi indexado.';
$string['privacy:metadata:factor1'] = 'Número do Coeficiente de Similaridade 1.';
$string['privacy:metadata:factor2'] = 'Número do Coeficiente de Similaridade 2.';
$string['privacy:metadata:factor3'] = 'Número do Coeficiente de Similaridade 3.';
$string['privacy:metadata:factor4'] = 'Número do Coeficiente de Similaridade 4.';
$string['privacy:metadata:factor5'] = 'Número do Coeficiente de Similaridade DLA.';

$string['privacy:metadata:strikefileid'] = 'ID do arquivo de envio para o StrikePlagiarism.com.';
$string['privacy:metadata:report'] = 'Dados do relatório de Similaridade do envio para o StrikePlagiarism.com.';
$string['privacy:metadata:timemodified'] = 'Hora de modificação do relatório de Similaridade do envio para o StrikePlagiarism.com.';
$string['privacy:metadata:timecreated'] = 'Hora de criação do relatório de Similaridade do envio para o StrikePlagiarism.com.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'O StrikePlagiarism.com cria um relatório de Similaridade para cada arquivo enviado. Esse registro é armazenado no banco de dados Moodle. Cada relatório está relacionado ao envio do arquivo do usuário.';

$string['privacy:metadata:filename'] = 'Nome do arquivo enviado pelo usuário.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Dados pessoais passados pelo subsistema de antiplágio.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Este plugin envia dados externamente usando a API do StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'O StrikePlagiarism.com cria um GUID que é a relação do arquivo com o envio à API do StrikePlagiarism.com.';
$string['privacy:metadata:core_files'] = 'O StrikePlagiarism.com armazena arquivos que foram carregados no Moodle para formar um envio ao StrikePlagiarism.com.';
$string['assignmenttype'] = 'Tipo de trabalho';
$string['assignmenttype_0'] = 'Tese de Habilitação';
$string['assignmenttype_1'] = 'Tese de Doutorado';
$string['assignmenttype_2'] = 'Tese de Mestrado';
$string['assignmenttype_3'] = 'Tese de Bacharelado';
$string['assignmenttype_4'] = 'Trabalho de Ano';
$string['assignmenttype_6'] = 'Trabalho';
$string['assignmenttype_7'] = 'Artigo';
$string['assignmenttype_8'] = 'Pesquisa';
$string['assignmenttype_9'] = 'Tese de Engenharia';
$string['assignmenttype_10'] = 'Tese de Diploma';
$string['assignmenttype_16'] = 'Projeto';
$string['assignmenttype_25'] = 'Artigo';
$string['assignmenttype_40'] = 'Tese de Pós-graduação';
$string['assignmenttype_101'] = 'Monografia';
$string['assignmenttype_102'] = 'Manual';
$string['assignmenttype_103'] = 'Tratado';
$string['assignmenttype_300'] = 'Livro';

$string['crosscheckmode'] = 'Modo de verificação cruzada';
$string['crosscheckmode_help'] = 'O modo de verificação cruzada permite a comparação 1:1 entre os envios dos alunos dentro do trabalho. Quando a verificação cruzada está habilitada, a seção de verificação cruzada será visível no Relatório Interativo de Similaridade';
$string['removeaiquiz'] = 'Ocultar configuração de detecção de IA';
$string['aidetection'] = 'Detecção de IA';
$string['aidetection_help'] = 'Ao habilitar a funcionalidade, o sistema buscará o texto gerado por ferramentas de IA. Se o serviço não estiver disponível, o relatório de conteúdo de IA não será gerado. Para habilitar essa funcionalidade, entre em contato com o administrador do sistema.';

$string['updateprotocols'] = 'Atualizar protocolos';
$string['getprotocolsresponse'] = 'Resposta dos protocolos';
$string['countprotocols'] = 'Contagem de protocolos: ';
$string['errorprotocol'] = 'Erro';
