<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, EN
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'Плагін StrikePlagiarism.com';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Для отримання додаткової інформації про цю систему антиплагіату та її роботу див.: <a href=\'http://www.strikeplagiarism.com\'>www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Синхронізувати звіт StrikePlagiarism.com для документа';
$string['task:getreports'] = 'Синхронізувати звіти StrikePlagiarism.com';
$string['task:sendfiles'] = 'Надсилати файли до системного API StrikePlagiarism.com';
$string['strike:enable'] = 'Увімкнути плагін StrikePlagiarism.com';
$string['strike:viewreport'] = 'Показати звіти подібності усім студентам';
$string['strike:resetfile'] = 'Очищає всі помилки та знову передає статус в очікування';
$string['usestrike'] = 'Використовувати плагін StrikePlagiarism.com';
$string['useadminnotifications'] = 'Повідомити адміністратора про помилки?';
$string['useadminnotifications_help'] = 'Повідомляє адміністратора про помилки при їх виникненні(наприклад, під час комунікації з API StrikePlagiarism.com)';
$string['useteachernotifications'] = 'Повідомити вчителя(ів) про помилки?';
$string['useteachernotifications_help'] = 'Повідомляє вчителя(ів) про помилки при їх виникненні(наприклад, під час комунікації з API StrikePlagiarism.com)';
$string['strikekey'] = 'Ключ API StrikePlagiarism.com';
$string['strikekey_help'] = 'Ключ API для вашого облікового запису в системі StrikePlagiarism.com<br/>Щоб використовувати цей плагін, вам потрібно отримати ідентифікаційний ключ StrikePlagiarism.com. Щоб отримати додаткову інформацію, зв’яжіться з нами за допомогою контактної форми веб-сайту <a href=\'http://www.strikeplagiarism.com\'>www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'Хост API StrikePlagiarism.com';
$string['strikeserver_help'] = 'Ім‘я хоста або IP-адреса сервера StrikePlagiarism.com. Введіть IP-адресу за допомогою http або https';
$string['studentdisclosuredefault'] = 'Я згоден, що всі файли, які я завантажив, можуть бути відправлені в антиплагіатну систему StrikePlagiarism.com для перевірки оригінальності тексту';
$string['strikestudentdisclosure'] = 'Я згоден, що всі файли, які я завантажив, можуть бути надіслані до антиплагіатної системи StrikePlagiarism.com для перевірки оригінальності тексту';
$string['studentdisclosure'] = 'Повідомлення студента';
$string['studentdisclosure_help'] = 'Цей текст буде відображатися для всіх студентів на сторінці завантаження файлу. Він має бути прийнятий для продовження перевірки.';
$string['strike_enableplugin'] = 'Увімкнути StrikePlagiarism.com для {$a}';
$string['notifyteachers'] = 'Повідомити викладача(ів)';
$string['enableapidebugging'] = 'Увімкнути налагодження API';
$string['enableapidebugging_help'] = 'Увімкніть цю опцію, якщо ви бажаєте розширене налагодження, яке забезпечує StrikePlagiarism.com API.<br/>
Доступно кілька методів налагодження. Зауважте, що налагодження <i>тільки</i> складатиметься з інформації про зв’язок/трафік через API StrikePlagiarism.com.';
$string['apidebuggingmtrace'] = 'Увімкнути налагодження mtrace?';
$string['apidebuggingmtrace_help'] = 'Увімкніть цей параметр, якщо ви хочете бачити вихідні дані налагодження API як вихідні дані mtrace().<br/>
Якщо ви ввімкнете це, вихідні дані трасування будуть видимі у вихідних даних вашого фонового завдання (CRON).';
$string['apidebuggingerrorlog'] = 'Увімкнути налагодження error_log?';
$string['apidebuggingerrorlog_help'] = 'Увімкніть цей параметр, якщо ви хочете бачити вихідні дані налагодження API як вихідні дані error_log.<br/>
Якщо ви ввімкнете це, вихід трасування буде видно у веб-сервері / php error_log.<br/>
ПРИМІТКА. Це не завжди буде видно залежно від того, як налаштовано ваш веб-сервер або PHP.';
$string['apidebuggingemail'] = 'Увімкнути налагодження електронної пошти?';
$string['apidebuggingemail_help'] = 'Увімкніть цей параметр, якщо ви хочете отримувати вихідні дані налагодження API на свою електронну пошту.<br/>
Якщо ви ввімкнете це, вихід трасування буде надіслано на вказану адресу електронної пошти.<br/>
ПРИМІТКА. Це може призвести до надсилання великої кількості електронних листів.<br/>
ПРИМІТКА 2. Цей метод використовує стандартну функцію mail() і не завжди буде доступним. Він працює поза функціями пошти Moodle.';
$string['apidebuggingemailaddress'] = 'Одержувач електронної пошти для налагодження.';
$string['str:settings'] = 'Налаштування';
$string['str:defaults'] = 'За замовчуванням';
$string['str:dump'] = 'Скидати';
$string['str:debug'] = 'Налагодження';
$string['allowallsupportedfiles'] = 'Дозволити всі підтримувані типи файлів';
$string['allowallsupportedfiles_help'] = 'Ця опція дозволяє викладачеві обмежити типи файлів, що завантажуються  на перевірку';
$string['restrictfiles'] = 'Типи файлів';
$string['form:desc:defaults'] = 'Нижче ви можете ввести всі налаштування за замовчуванням, які використовуватимуться під час створення та налаштування нового модуля діяльності.<br/>
Введені тут значення слугуватимуть значеннями за замовчуванням для конфігурації плагіна StrikePlagiarism.com для цього модуля діяльності.';
$string['docsendmode'] = 'Надсилання документів для аналізу на наявність плагіату';
$string['docsendmode_help'] = 'Виберіть спосіб надсилання документа для аналізу. Вручну, тобто викладач повинен нажати на документ, після його завантаження студентом, або автоматично, коли документ відправляється на перевірку одразу після його завантаження.';
$string['docsendingchoose'] = 'Надсилання вручну';
$string['docsendingall'] = 'Автоматичне надсилання всіх документів';
$string['strike_show_student_status'] = 'Показати статус StrikePlagiarism.com студенту';
$string['strike_show_student_status_help'] = 'Ця опція дозволяє студентам бачити статус відправлення документу в StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Показати студенту звіт подібності';
$string['strike_show_student_report_help'] = 'Звіт подібності дає інформацію про запозичені фрагменти в тексті та показує джерело, де вони знаходяться.';
$string['strike_show_student_score'] = 'Показувати студенту коефіцієнти подібності';
$string['strike_show_student_score_help'] = 'Коефіцієнти подібності - це відсоткове співвідношення тексту роботи з подібними фрагментами, які знайдені в різних джерелах';
$string['strike_addref_method'] = 'Додати документи до бази даних';
$string['strike_addref_method_help'] = 'Дана опція дозволяє добавляти документи, перевірені в системі Strikeplagiarism.com, в базу даних системи вручну викладачем, або автоматично після перевірки.';
$string['strike_deletereport_method'] = 'Видалення звітів подібності для видалених/оновлених документів';
$string['strike_deletereport_method_help'] = 'Дана опція дозволяє видаляти звіти подібності кожного разу, коли документи видаляється або оновляється в завданні.<br/>
Можливі методи:
<ul>
<li>зберігає старі звіти подібності </li>
<li>видаляє старі звіти подібності </li>
</ul>';
$string['strike_studentemail'] = 'Надіслати студенту повідомлення через електронну пошту';
$string['strike_studentemail_help'] = 'Дана опція дозволяє інформувати студента про завершення перевірки';
$string['strike_draft_submit'] = 'Час відправлення документа';
$string['strike_defaultlang'] = 'Мова документа за замовчуванням';
$string['strike_defaultlang_help'] = 'Визначає мову за замовчуванням для документа, який надсилається на аналіз до системи StrikePlagiarism.com. Він є обов‘язковим параметром для їх API, але Moodle не розпізнає цей тип інформації.';
$string['wordcount'] = 'Мінімальна кількість слів для аналізу';
$string['wordcount_help'] = 'Даний параметр встановлює мінімальну кількість слів, яка потрібна для завантаження тексту (документу).';

$string['addrefauto'] = 'Автоматично додавати документ в базу даних після перевірки';
$string['addrefmanual'] = 'Додавати документ в базу даних після перевірки вручну';

$string['deletereportkeep'] = 'Зберігати старі звіти подібності для видалених / оновлених документів';
$string['deletereportremove'] = 'Видалити старі звіти подібності для видалених /  оновлених документів';

$string['submitondraft'] = 'При попередній перевірці';
$string['submitonfinal'] = 'При завантаженні роботи на оцінювання';
$string['showwhenclosed'] = 'Коли завдання закрито';

$string['pending'] = 'Файл очікує на надсилання для аналізу в StrikePlagiarism.com';
$string['processing'] = 'Файл надіслано в StrikePlagiarism.com і очікує на завершення аналізу';
$string['toolarge'] = 'Файл перевищує максимальний розмір для відправлення в StrikePlagiarism.com';
$string['unsupported'] = 'Тип файлу не підтримується StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Тип файлу не підтримується StrikePlagiarism.com';
$string['unknownwarning'] = 'Сталася помилка під час надсилання цього файлу на StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'Очікується рішення щодо надсилання в StrikePlagiarism.com для аналізу';
$string['previouslysubmitted'] = 'Попередньо завантажений як';
$string['sendforanalysis'] = 'Відправити в StrikePlagiarism.com для аналізу';
$string['indexdocument'] = 'Додати документ в базу даних StrikePlagiarism.com';
$string['deletestrikefile'] = 'Вилучити документ з бази даних StrikePlagiarism.com';
$string['similarity1'] = 'КП 1';
$string['similarity2'] = 'КП 2';
$string['similarity3'] = 'КП 3';
$string['similarity4'] = 'КП 4';
$string['similarity5'] = 'КП БЮА';

$string['filereset'] = 'Файл скинуто для повторного надсилання на StrikePlagiarism.com';
$string['fileresetfailed'] = 'Помилка: файл не було скинуто для повторного надсилання на StrikePlagiarism.com';

$string['report'] = 'Звіт подібності StrikePlagiarism.com';
$string['report2'] = 'Інтерактивний звіт подібності StrikePlagiarism.com';
$string['reportclick'] = 'Посилання на звіт подібності StrikePlagiarism.com';

$string['restrictcontent'] = 'Надіслати прикріплений файл і текст';
$string['restrictcontent_help'] = 'StrikePlagiarism.com дозволяє перевіряти файли, текст з повідомлень з форуму і вставлений онлайн текст. ';
$string['restrictcontentfiles'] = 'Відправити лише прикріпленні файли';
$string['restrictcontentno'] = 'Відправити все';
$string['restrictcontenttext'] = 'Відправити текст';

$string['config:plagiarism'] = 'Значення глобальної конфігурації антиплагіатного модуля StrikePlagiarism.com';
$string['config:defaults'] = 'Налаштування модуля антиплагіату StrikePlagiarism.com за замовчуванням';

$string['studentemailsubject'] = 'Документ був перевірений StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Шановний {$a->firstname} {$a->lastname},</p>
файл, який ви надіслали до {$a->modulename} у {$a->coursename}, було перевірено StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
З повагою,
{$a->admin}
';
$string['label:user'] = 'Користувач';
$string['label:author'] = 'Автор';
$string['label:timesubmitted'] = 'Надіслано';
$string['label:analysisstatus'] = 'Статус аналізу';
$string['label:reportstatus'] = 'Статус звіту';
$string['label:status'] = 'Статус';
$string['label:filename'] = 'Назва файлу';
$string['label:modname'] = 'Модуль';
$string['label:actions'] = 'Дії';

$string['report:na'] = 'Недоступний';
$string['report:ready'] = 'Готовий';
$string['report:available'] = 'Доступний';
$string['analysis:auto'] = 'Автоматично';
$string['analysis:manual'] = 'Вручну';
$string['analysis:awaitchoice'] = 'Очікування надсилання на перевірку';
$string['cmoverview'] = 'Стасут модуля курсу StrikePlagiarism.com';
$string['notification:subject'] = 'Системне повідомлення StrikePlagiarism.com [{$a}]';
$string['notification:errormessage'] = '<p>Шановний {$a->fullname}<p>
<p>Сталася помилка в плагіні StrikePlagiarism.com у \‘{$a->instancename}\‘ у курсі \‘{$a->coursefullname}\‘.<br/>
Виникла помилка: {$a->errormessage}.</p>
<p>Нижче наведено дані файлу:<br/>
Автор: {$a->strikefileauthor}<br/>
Науковий керівник: {$a->strikefilecoordinator}<br/>
Тип документа: {$a->strikefiledocumentkind}<br/>
Назва: {$a->strikefiletitle}<br/>
Назва файлу: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Час створення: {$a->strikefiletimecreated}
</p>
<p>Будь ласка, перейдіть на <a href=\'{$a->contexturl}\'>{$a->contexturlname}</a>, щоб дізнатися більше</p>
<p>З повагою,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'Сповіщення про помилки StrikePlagiarism.com';

$string['err:strike_selectfiletypes-empty'] = 'Будь ласка, виберіть формат файлу для відправлення на аналіз.<br/>
Якщо формат файлу не буде вибраний, документ не буде відправлений на антиплагіатний аналіз.';
$string['warn:strike_selectfiletypes-empty'] = 'Будь ласка, виберіть формат файлу для відправлення на аналіз<br/>
Якщо формат файлу не буде вибраний, документ не буде відправлений на антиплагіатний аналіз.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Перевірити з‘єднання API';
$string['test_api_connection_status'] = 'Статус з‘єднання API';
$string['test_api_connection_help'] = 'Ви можете перевірити, чи введений API хоста та ключ API працюють правильно.';
$string['api_status_1'] = 'З‘єднання в порядку';
$string['api_status_2'] = 'Ключ недійсний';
$string['api_status_3'] = 'Час очікування підключення';
$string['api_status_4'] = 'З‘єднання в порядку, сервер не відповідає';
$string['api_status_5'] = 'Код помилки підключення: {$a->error}';

$string['privacy:metadata:userid'] = 'Інформація про користувача, який надсилає файл для перевірки на плагіат.';
$string['privacy:metadata:relateduserid'] = 'Інформація про пов‘язаних користувачів, які надсилають файл для перевірки на плагіат.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Таблиця, яка зберігає інформацію про файли, відправлені для перевірки на плагіат.';
$string['privacy:metadata:title'] = 'Назва документу';
$string['privacy:metadata:author'] = 'Ім‘я автора або співавтора надісланого файлу.';
$string['privacy:metadata:coordinator'] = 'Надісланий промоутер файлу.';
$string['privacy:metadata:md5sum'] = 'Сума MD5 двійкового документа, надісланого на аналіз.';
$string['privacy:metadata:ftimesubmitted'] = 'Час надсилання файлу StrikePlagiarism.com';
$string['privacy:metadata:ftimecreated'] = 'Час створення запису файлу StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Час зміни відправлення StrikePlagiarism.com';
$string['privacy:metadata:reportready'] = 'Логічне значення true, якщо звіт готовий для завантаження, інакше - false.';
$string['privacy:metadata:indexed'] = 'Логічний істинний, якщо документ було проіндексовано.';
$string['privacy:metadata:factor1'] = 'Значення коефіцієнта подібності 1.';
$string['privacy:metadata:factor2'] = 'Значення коефіцієнта подібності 2.';
$string['privacy:metadata:factor3'] = 'Значення коефіцієнта подібності 3.';
$string['privacy:metadata:factor4'] = 'Значення коефіцієнта подібності 4.';
$string['privacy:metadata:factor5'] = 'Значення коефіцієнта подібності БЮА.';

$string['privacy:metadata:strikefileid'] = 'Ідентифікатор файлу відправлення StrikePlagiarism.com';
$string['privacy:metadata:report'] = 'Відправити дані звіту подібності StrikePlagiarism.com.';
$string['privacy:metadata:timemodified'] = 'Час зміни звіту подібності StrikePlagiarism.com';
$string['privacy:metadata:timecreated'] = 'Час створення звіту подібності StrikePlagiarism.com.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com створює звіт подібності для кожного відправленого файлу. Цей запис зберігається в базі даних Moodle. Кожен звіт пов‘язаний з відправленням файлу користувача.';

$string['privacy:metadata:filename'] = 'Назва файлу, надісланого користувачем.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Персональні дані, передані з підсистеми антиплагіату.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Цей плагін надсилає дані назовні за допомогою API StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com створює guid, який є зв‘язком файлу з відправленням до StrikePlagiarism.com API.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com зберігає файли, які було завантажено до Moodle.';
$string['assignmenttype'] = 'Тип документу';
$string['assignmenttype_0'] = 'Абілітаційна робота';
$string['assignmenttype_1'] = 'Докторська дисертація';
$string['assignmenttype_2'] = 'Магістерська робота';
$string['assignmenttype_3'] = 'Бакалаврська робота';
$string['assignmenttype_4'] = 'Курсова робота';
$string['assignmenttype_6'] = 'Есе';
$string['assignmenttype_7'] = 'Стаття';
$string['assignmenttype_8'] = 'Дослідження';
$string['assignmenttype_9'] = 'Інженерна робота';
$string['assignmenttype_10'] = 'Дипломна робота';
$string['assignmenttype_16'] = 'Проект';
$string['assignmenttype_25'] = 'Публікація';
$string['assignmenttype_29'] = 'Інше';
$string['assignmenttype_40'] = 'Автореферат';
$string['assignmenttype_101'] = 'Монографія';
$string['assignmenttype_102'] = 'Інструкція';
$string['assignmenttype_103'] = 'Наукова робота';
$string['assignmenttype_300'] = 'Книга';

$string['crosscheckmode'] = 'Режим перехресної перевірки';
$string['crosscheckmode_help'] = 'Режим перехресної перевірки дозволяє порівнювати роботи студентів в завданні в форматі 1:1. Розділ перехресної перевірки відображається в інтерактивному звіті подібності в вигляді джерела і не впливає на загальний КП.';
$string['removeaiquiz'] = 'Приховати налаштування виявлення ШІ';
$string['aidetection'] = 'Виявлення ШІ';
$string['aidetection_help'] = 'Після включення даного функціоналу система розпочне пошук тексту, згенерованого інструментами ШІ. Відсутність звіту про наявність ШІ означає недоступність послуги. Щоб включити даний функціонал, зверніться до системного адміністратора.';

$string['updateprotocols'] = 'Оновити протоколи';
$string['getprotocolsresponse'] = 'Відповідь протоколів';
$string['countprotocols'] = 'Кількість протоколів: ';
$string['errorprotocol'] = 'Помилка';