<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Script to display download protocol.
 *
 * @package    plagiarism_strike
 * @copyright  UAB "Vextur" <info@vextur.com>
 * @author     2024, Andrius Martinkėnas <andrius@vextur.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
global $DB, $CFG;
require_once(__DIR__.'/../../config.php');
require_once($CFG->dirroot.'/plagiarism/strike/lib.php');
require_once($CFG->dirroot . '/plagiarism/strike/3rdp/strikeplagiarism/apitoken.php');
require_once($CFG->dirroot . '/plagiarism/strike/3rdp/strikeplagiarism/api/document/getreport2.php');

require_login();

$fid = required_param('pid', PARAM_INT);
$protocolid = required_param('protocolid', PARAM_INT);
$params = array('pid' => $fid, 'protocolid' => $protocolid);
$pageurl = new moodle_url('/plagiarism/strike/protocol.php', $params);

$sf = plagiarism_strike\strikefile::get_by_id($fid);

list($course, $cm) = get_course_and_cm_from_cmid($sf->cm);
$context = context_course::instance($course->id);

$PAGE->set_url($pageurl);
$PAGE->set_context($context);
$key = \plagiarism_strike\configplagiarism::get('strike_key');
$server = \plagiarism_strike\configplagiarism::get('strike_server');

$sf = plagiarism_strike\strikefile::get_by_id($fid);
$downloadlink = $server . '/api/v2/documents/protocol'  . '?APIKEY=' . $key . '&id=' . $sf->guid . '&protocolTypeId=' . $protocolid;

$protocol = $DB->get_record('plagiarism_strike_protocols', ['protocoltypeid' =>$protocolid]);

// Initialize cURL session.
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $downloadlink);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Execute cURL session and fetch file contents.
$fileContents = curl_exec($ch);

// Check for errors.
if (curl_errno($ch)) {
    print_error('Curl error: ' . curl_error($ch));
}

// Get HTTP response code.
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Check for 403 Forbidden response.
if ($http_code == 403) {
    print_error('Access forbidden. Please check your API key and permissions.');
}

if ($fileContents === false) {
    print_error('Unable to retrieve the document from the server.');
}

// Set headers to force download.
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . $protocol->protocolfilename . '.pdf"');
header('Content-Length: ' . strlen($fileContents));

// Output the file contents.
echo $fileContents;

exit;
