<?php

/**
 * Report GET implementation for Strike Plagiarism
 *
 * File         getreport2.php
 * Encoding     UTF-8
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace strikeplagiarism\api\document;

/**
 * strikeplagiarism\api\document\getreport2
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class getreport2 extends \strikeplagiarism\apitoken {

    /**
     * Request method
     * @var string
     */
    protected $requesttype = self::REQUEST_TYPE_POST;
    /**
     * API action
     * @var string
     */
    protected $action = 'report/api/token';

    /**
     * Document ID as returned by Strike Antiplagiarism.
     *
     * @var string
     */
    protected $documentid;
    /**
     * If true report is not editable
     *
     * @var boolean
     */
    protected $viewonly;
    /**
     * Leading language of the document
     *
     * @var string
     */
    protected $documentlanguage;

    public function get_documentid() {
        return $this->documentid;
    }

    public function set_documentid($documentid) {
        $this->documentid = $documentid;
        return $this;
    }

    public function get_viewonly() {
        return $this->viewonly;
    }

    public function set_viewonly($viewonly) {
        $this->viewonly = $viewonly;
        return $this;
    }

    public function get_documentlanguage() {
        return $this->documentlanguage;
    }

    public function set_documentlanguage($documentlanguage) {
        $this->documentlanguage = $documentlanguage;
        return $this;
    }

    protected function gather_postdata() {
        global $USER;

        $this->clear_postdata();

        $this->add_postdata('apiKey', $this->apitoken);
        $this->add_postdata('userId', $USER->id);
        $this->add_postdata('userName', "$USER->firstname $USER->lastname");
        if (!empty($this->documentid)) {
            $this->add_postdata('documentId', $this->documentid);
        }
        $this->add_postdata('viewOnly', $this->viewonly);
        if (!empty($this->documentlanguage)) {
            $this->add_postdata('lang', $this->documentlanguage);
        }

        return parent::gather_postdata();
    }

    protected function process_result($data) {
        return parent::process_result($data);
    }

    protected function validate_result($result) {
        if (is_scalar($result)) {
            return true;
        } else {
            if (isset($result['message'])) {
                throw new \strikeplagiarism\api\exception($result['message']);
            }
        }
    }

}
