// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * plagiarism_strike - JS code
 *
 * @package    plagiarism_strike
 * @copyright  UAB "Vextur" <info@vextur.com>
 * @author     2024, Andrius Martinkėnas <andrius@vextur.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(['jquery', 'core/ajax'], function ($, Ajax) {
    "use strict";

    function get_protocols(key, server) {
        return Ajax.call([{
            methodname: 'plagiarism_strike_get_protocols',
            args: {key: key, server: server}
        }]);
    }

    return {
        init: function () {
            $("#id_strike_get_protocols").click(function () {
                var key = $('#id_strike_key').val();
                var server = $('#id_strike_server').val();
                var promise = get_protocols(key, server);
                promise[0].then(function (results) {
                    if (results.call){
                        results = '<b style="color: green;">' + results.response + '</b>';
                    }else {
                        results = '<b style="color: red;">' + results.response + '</b>';
                    }
                $('.get_protocols_response').html(results);
                })
            });
        }
    };
});