<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Main "util" class for plagiarism_strike
 *
 * @package    plagiarism_strike
 * @copyright  UAB "Vextur" <info@vextur.com>
 * @author     2024, Andrius Martinkėnas <andrius@vextur.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace plagiarism_strike;

defined('MOODLE_INTERNAL') || die();

/**
 * plagiarism_strike\strikeplagiarism
 *
 * @package    plagiarism_strike
 * @copyright  UAB "Vextur" <info@vextur.com>
 * @author     2024, Andrius Martinkėnas <andrius@vextur.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class strikegetprotocols
{

    /**
     * Get protocols
     *
     * @param string|null $key api key
     * @param string|null $server api server address
     * @return \stdClass|bool
     */
    public static function get_protocols($key = null, $server = null)
    {
        // Retrieve the key and server if not provided
        if (!$key) {
            $key = configplagiarism::get('strike_key');
        }
        if (!$server) {
            $server = configplagiarism::get('strike_server');
        }
        $url = $server . '/api/v2/documents/protocols' . '?APIKEY=' . urlencode($key);
        // Initialize cURL session
        $ch = curl_init();

        // Set cURL options
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $key,
            'Content-Type: application/json'
        ]);

        global $CFG;
        if (!empty($CFG->proxyhost)) {
            $proxyhost = $CFG->proxyhost . (!empty($CFG->proxyport) ? ':' . $CFG->proxyport : '');
            $proxytype = (!empty($CFG->proxytype) && $CFG->proxytype == 'SOCKS5') ? CURLPROXY_SOCKS5 : CURLPROXY_HTTP;
            $proxyuserpwd = (!empty($CFG->proxyuser) && !empty($CFG->proxypassword)) ? $CFG->proxyuser . ':' . $CFG->proxypassword : null;

            curl_setopt($ch, CURLOPT_PROXY, $proxyhost);
            curl_setopt($ch, CURLOPT_PROXYTYPE, $proxytype);
            if ($proxyuserpwd !== null) {
                curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyuserpwd);
            }
        }


        // Execute cURL request
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            curl_close($ch);
            return false;
        }

        // Close cURL session
        curl_close($ch);
        // Decode the JSON response
        $decodedresponse = json_decode($response, true);

        // Check for JSON errors
        if (json_last_error() !== JSON_ERROR_NONE) {
            return false;
        }

        foreach ($decodedresponse as $protocol){
            if (!isset($protocol['protocolTypeId'])){
                return false;
            }
        }

        return $decodedresponse;
    }
}