<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * SYnc report adhoc task for plagiarism_strike
 *
 * File         syncreport.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace plagiarism_strike\task\adhoc;

defined('MOODLE_INTERNAL') || die();

/**
 * plagiarism_strike\task\adhoc\syncreport
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class syncreport extends \core\task\adhoc_task {

    /**
     * Get humanly readable task name
     * @return string
     */
    public function get_name() {
        return get_string('task:syncreport', 'plagiarism_strike');
    }

    /**
     * Execute this task
     */
    public function execute() {
        mtrace("Sync reports plagiarism");
        $data = $this->get_custom_data();
        \plagiarism_strike\strikeplagiarism::sync_report_for_guid($data->guid);
    }

}