<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Event information for plagiarism_strike
 *
 * File         events.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$observers = array(
    array(
        'eventname' => '\mod_assign\event\assessable_submitted',
        'callback' => '\\plagiarism_strike\\observer::assignsubmission_submitted',
        'priority'    => 1500,
    ),
    array(
        'eventname' => '\assignsubmission_file\event\assessable_uploaded',
        'callback' => '\\plagiarism_strike\\observer::assignsubmission_file_uploaded',
        'priority'    => 200,
    ),
    array(
        'eventname' => '\assignsubmission_onlinetext\event\assessable_uploaded',
        'callback' => '\\plagiarism_strike\\observer::assignsubmission_onlinetext_uploaded',
        'priority'    => 200,
    ),
    array(
        'eventname' => '\mod_workshop\event\assessable_uploaded',
        'callback' => '\\plagiarism_strike\\observer::workshop_file_uploaded',
        'priority'    => 1000,
    ),
    array(
        'eventname' => '\mod_forum\event\assessable_uploaded',
        'callback' => '\\plagiarism_strike\\observer::forum_file_uploaded',
        'priority'    => 1000,
    ),

    array(
        'eventname' => '\mod_coursework\event\assessable_uploaded',
        'callback'  => '\\plagiarism_strike\\observer::coursework_submitted',
        'priority'    => 1000,
    ),
    array(
        'eventname' => '\mod_quiz\event\attempt_submitted',
        'callback' => '\\plagiarism_strike\\observer::quiz_submitted',
        'priority'    => 1000,
    ),
    array(
        'eventname' => '\core\event\course_module_deleted',
        'callback'  => '\\plagiarism_strike\\observer::course_module_deleted',
        'priority'    => 1000,
    ),
    array(
        'eventname' => '\core\event\course_module_updated',
        'callback'  => '\\plagiarism_strike\\observer::course_module_updated',
        'priority'    => 1000,
    ),
    array(
        'eventname' => '\core\event\course_reset_ended',
        'callback'  => 'plagiarism_plugin_strike::course_reset',
        'priority'    => 1000,
    )
);
