<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Script to display report to end user.
 *
 * File         report2.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__.'/../../config.php');

require_login();

$context = context_course::instance(SITEID);
require_capability('moodle/site:config', $context);

$items = $DB->get_records('plagiarism_strike_files', [], 'id desc');
echo '<table border="1" cellpadding="10" cellspacing="1">';
echo '<tr><td>id</td>';
echo '<td>cm</td>';
echo '<td>userid </td>';
echo '<td>relateduserid</td>';
echo '<td>filename</td>';
echo '<td>attempt</td>';
echo '<td>statuscode</td>';
echo '<td>errorresponse</td>';
echo '<td>timecreated)</td></tr>';
foreach($items as $item) {
    echo '<tr><td>'.$item->id.'</td>';
    echo '<td>'.$item->cm.'</td>';
    echo '<td>'.$item->userid.'</td>';
    echo '<td>'.$item->relateduserid.'</td>';
    echo '<td>'.$item->filename.'</td>';
    echo '<td>'.$item->attempt.'</td>';
    echo '<td>'.$item->statuscode.'</td>';
    echo '<td>'.$item->errorresponse.'</td>';
    echo '<td>'.date('Y-m-d H:i:s', $item->timecreated).'</td></tr>';
}
echo '</table>';

$items = $DB->get_records('plagiarism_strike_config');
echo '<table border="1" cellpadding="10" cellspacing="1">';
echo '<tr><td>id</td>';
echo '<td>cm</td>';
echo '<td>name</td>';
echo '<td>value</td>';
echo '<td>config_hash</td><tr></tr>';
foreach($items as $item) {
    echo '<tr><td>'.$item->id.'</td>';
    echo '<td>'.$item->cm.'</td>';
    echo '<td>'.$item->name.'</td>';
    echo '<td>'.$item->value.'</td>';
    echo '<td>'.$item->config_hash.'</td></tr>';
}
echo '</table>';
