<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, ES
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'Complemento de StrikePlagiarism.com';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Para obtener más información sobre este sistema antiplagio y cómo funciona, consulte: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Sincronizar el informe de StrikePlagiarism.com para el documento';
$string['task:getreports'] = 'Sincronizar informes de StrikePlagiarism.com';
$string['task:sendfiles'] = 'Enviar archivos a la API del sistema StrikePlagiarism.com';
$string['strike:enable'] = 'Habilitar el complemento StrikePlagiarism.com';
$string['strike:viewreport'] = 'Mostrar informes de similitud a todos los estudiantes';
$string['strike:resetfile'] = 'Borra todos los errores y vuelve a poner el estado en pendiente';
$string['usestrike'] = 'Usar el complemento StrikePlagiarism.com';
$string['useadminnotifications'] = '¿Notificar al administrador sobre los errores?';
$string['useadminnotifications_help'] = 'Notifica al administrador sobre los errores cuando ocurren varios errores (por ejemplo, cuando se comunica con la API de StrikePlagiarism.com)';
$string['useteachernotifications'] = '¿Notificar a los maestros sobre errores?';
$string['useteachernotifications_help'] = 'Notifica a los maestros sobre errores cuando ocurren varios errores (por ejemplo, al comunicarse con la API de StrikePlagiarism.com)';
$string['strikekey'] = 'Clave API de StrikePlagiarism.com';
$string['strikekey_help'] = 'Clave API para su cuenta en el sistema StrikePlagiarism.com<br/>Necesita obtener una clave de ID de StrikePlagiarism.com para usar este complemento. Para obtener más información, comuníquese con nosotros a través del formulario de contacto del sitio web en <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'StrikePlagiarism.com API Host';
$string['strikeserver_help'] = 'StrikePlagiarism.com nombre de host o dirección IP del servidor. Ingrese la dirección IP con http o https';
$string['studentdisclosuredefault'] = 'Acepto que todos los archivos que cargué se envíen al sistema antiplagio de StrikePlagiarism.com para verificar la originalidad del texto';
$string['strikestudentdisclosure'] = 'Acepto que todos los archivos que cargué se envíen al sistema antiplagio de StrikePlagiarism.com para verificar la originalidad del texto';
$string['studentdisclosure'] = 'Divulgación del estudiante';
$string['studentdisclosure_help'] = 'Este texto se mostrará a todos los estudiantes en la página de carga de archivos. Tiene que estar de acuerdo con el fin de proceder con la presentación.';
$string['strike_enableplugin'] = 'Habilitar StrikePlagiarism.com para {$a}';
$string['notifyteachers'] = 'Notificar a los profesores';
$string['enableapidebugging'] = 'Habilitar depuración de API';
$string['enableapidebugging_help'] = 'Active esta opción si desea una depuración extendida proporcionada por la API de StrikePlagiarism.com.<br/>
Hay varios métodos de depuración disponibles. Tenga en cuenta que la depuración <i>solo</i> consistirá en información de comunicación/tráfico en la API de StrikePlagiarism.com.';
$string['apidebuggingmtrace'] = '¿Habilitar la depuración de mtrace?';
$string['apidebuggingmtrace_help'] = 'Habilite esta opción si desea ver la salida de depuración de la API como salida de mtrace().<br/>
Si habilita esto, la salida de seguimiento será visible en la salida de su tarea en segundo plano (CRON).';
$string['apidebuggingerrorlog'] = '¿Habilitar la depuración de error_log?';
$string['apidebuggingerrorlog_help'] = 'Habilite esta opción si desea ver la salida de depuración de la API como salida de error_log.<br/>
Si habilita esto, la salida de seguimiento será visible en el servidor web / php error_log.<br/>
NOTA: Esto no siempre será visible dependiendo de cómo esté configurado su servidor web o PHP.';
$string['apidebuggingemail'] = '¿Habilitar la depuración de correo electrónico?';
$string['apidebuggingemail_help'] = 'Habilite esta opción si desea recibir el resultado de la depuración de la API en su correo electrónico.<br/>
Si habilita esto, el resultado del seguimiento se enviará a la dirección de correo electrónico especificada.<br/>
NOTA: Esto puede hacer que se envíen muchos correos electrónicos.<br/>
NOTA 2: este método utiliza la función mail() predeterminada y no siempre estará disponible. Funciona fuera de las funciones de correo de Moodle.';
$string['apidebuggingemailaddress'] = 'Destinatario de depuración de correo electrónico';

$string['str:settings'] = 'Configuración';
$string['str:defaults'] = 'Predeterminados';
$cadena['str:volcado'] = 'Volcado';
$string['str:debug'] = 'Depurar';
$string['allowallsupportedfiles'] = 'Permitir todos los formatos de archivo admitidos';
$string['allowallsupportedfiles_help'] = 'Permite al profesor restringir los formatos de archivo que se enviarán a StrikePlagiarism.com para su procesamiento. No evita que los estudiantes carguen diferentes tipos de archivos en la tarea.';
$string['restrictfiles'] = 'Formatos de archivo permitidos para el análisis antiplagio';
$string['form:desc:defaults'] = 'Abajo puede ingresar todas las configuraciones predeterminadas que se usarán cuando se cree y configure un nuevo módulo de actividad.<br/>
Los valores ingresados ​​aquí servirán como valores predeterminados para la configuración del complemento StrikePlagiarism.com para ese módulo de actividad.';
$string['docsendmode'] = 'Envío de documentos para análisis antiplagio';
$string['docsendmode_help'] = 'Elija el método de envío del documento para su análisis. Esto puede ser por elección (lo que significa que el profesor selecciona los documentos para enviarlos para su análisis) o todos (lo que significa que todos los documentos se envían para su análisis de manera predeterminada)';
$string['docsendingchoose'] = 'Enviar documentos elegidos';
$string['docsendingall'] = 'Enviar todos los documentos';
$string['strike_show_student_status'] = 'Mostrar el estado de análisis de StrikePlagiarism.com al estudiante';
$string['strike_show_student_status_help'] = 'Permite a los estudiantes ver el estado de los envíos al sistema StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Mostrar informe de similitud al estudiante';
$string['strike_show_student_report_help'] = 'El Informe de similitud indica el número de fragmentos prestados y los resalta en el texto y proporciona su fuente.';
$string['strike_show_student_score'] = 'Mostrar coeficientes de similitud al estudiante';
$string['strike_show_student_score_help'] = 'Los Coeficientes de Similitud determinan en qué porcentaje el documento analizado consta de fragmentos similares a los detectados en bases de datos comparativas.';
$string['strike_addref_method'] = 'Agregar documentos a la base de datos comparativa';
$string['strike_addref_method_help'] = 'Elija el método para agregar documentos a su base de datos comparativa. Esto puede ser manual (lo que significa que el profesor selecciona los documentos que se agregarán a la base de datos comparativa) o automáticamente (lo que significa que todos los documentos se agregan a la base de datos comparativa de forma predeterminada) después de verificar.<br/>
Se recomienda encarecidamente configurarlo en AUTOMÁTICO, de modo que los documentos comprobados se agreguen automáticamente a la base de datos comparativa.';
$string['strike_deletereport_method'] = 'Eliminación de informes de similitud para envíos eliminados/actualizados';
$string['strike_deletereport_method_help'] = 'Define si los informes de similitud se eliminarán cada vez que se elimine o actualice un envío.<br/>
Los métodos posibles son:
<ul>
<li>mantener: conservar los informes de similitud antiguos</li>
<li>remove: elimina los informes de similitud antiguos</li>
</ul>';
$string['strike_studentemail'] = 'Correo electrónico al estudiante';
$string['strike_studentemail_help'] = 'Habilita el envío de un correo electrónico al estudiante cuando se ha procesado un archivo para informarle que hay un Informe de similitud disponible, el correo electrónico también incluye el enlace de exclusión voluntaria.';
$string['strike_draft_submit'] = 'Momento de envío a análisis antiplagio';
$string['strike_defaultlang'] = 'Idioma predeterminado del documento';
$string['strike_defaultlang_help'] = 'Define el idioma predeterminado del documento enviado para análisis al sistema StrikePlagiarism.com.';
$string['wordcount'] = 'Recuento mínimo de palabras para el análisis';
$string['wordcount_help'] = 'Establece un número mínimo de palabras necesarias para el texto en línea (publicaciones en foros y tipo de tarea en línea) antes de que el contenido se envíe al sistema StrikePlagiarism.com para su análisis.';

$string['addrefauto'] = 'Automáticamente después de verificar';
$string['addrefmanual'] = 'Manualmente después de verificar';

$string['deletereportkeep'] = 'Conservar informes de similitud antiguos';
$string['deletereportremove'] = 'Eliminar informes de similitud antiguos';

$string['submitondraft'] = 'Cuando se subió por primera vez';
$string['submitonfinal'] = 'Cuando el estudiante envía para calificar';
$string['showwhenclosed'] = 'Cuando se cierra la actividad';

$string['pending'] = 'El archivo está pendiente de envío a StrikePlagiarism.com';
$string['processing'] = 'El archivo se envió a StrikePlagiarism.com y está esperando que se complete el análisis';
$string['toolarge'] = 'El archivo es demasiado grande para enviarlo a StrikePlagiarism.com';
$string['unsupported'] = 'StrikePlagiarism.com no admite el formato de archivo';
$string['unsupportedfiletype'] = 'StrikePlagiarism.com no admite el formato de archivo';
$string['unknownwarning'] = 'Hubo un error al enviar este archivo a StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'En espera de decisión sobre el envío a StrikePlagiarism.com para su análisis';
$string['previouslysubmitted'] = 'Previamente enviado como';
$string['sendforanalysis'] = 'Enviar envío a StrikePlagiarism.com para su análisis';
$string['indexdocument'] = 'Agregar presentación a su base de datos comparativa en el sistema StrikePlagiarism.com';
$string['deletestrikefile'] = 'Retirar el envío de su base de datos comparativa en el sistema StrikePlagiarism.com';

$cadena['similitud1'] = 'CS 1';
$cadena['similitud2'] = 'CS 2';
$cadena['similitud3'] = 'CS 3';
$cadena['similitud4'] = 'CS 4';
$cadena['similitud5'] = 'CS DLA';

$string['filereset'] = 'Se ha restablecido un archivo para volver a enviarlo a StrikePlagiarism.com';
$string['fileresetfailed'] = 'Error: el archivo no se ha restablecido para volver a enviarlo a StrikePlagiarism.com';

$string['report'] = 'StrikePlagiarism.com Informe de similitud';
$string['report2'] = 'StrikePlagiarism.com informe interactivo';
$string['reportclick'] = 'Enlace al informe de similitud de StrikePlagiarism.com';

$string['restrictcontent'] = 'Enviar archivos adjuntos y texto en línea';
$string['restrictcontent_help'] = 'StrikePlagiarism.com puede procesar archivos cargados o texto en línea de publicaciones en foros y texto del tipo de envío de asignación de texto en línea. Elija qué componentes enviar al sistema StrikePlagiarism.com.';
$string['restrictcontentfiles'] = 'Enviar solo archivos adjuntos';
$string['restrictcontentno'] = 'Enviar archivos adjuntos y texto en línea';
$string['restrictcontenttext'] = 'Enviar solo texto en línea';

$string['config:plagiarism'] = 'Valores de configuración global del módulo antiplagio de StrikePlagiarism.com';
$string['config:defaults'] = 'Configuración predeterminada del módulo antiplagio de StrikePlagiarism.com';

$string['studentemailsubject'] = 'Envío verificado por el sistema antiplagio de StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Estimado {$a->nombre} {$a->apellido},</p>
El archivo que envió a {$a->modulename} en {$a->coursename} ha sido verificado por StrikePlagiarism.com.<br/>
{$a->enlace de módulo}<br/>
Saludos,
{$a->administrador}
';

$cadena['etiqueta:usuario'] = 'Usuario';
$cadena['etiqueta:autor'] = 'Autor';
$string['label:timesubmitted'] = 'Enviado el';
$string['label:analysisstatus'] = 'Coeficientes de similitud (SC)';
$string['label:reportstatus'] = 'Informe';
$cadena['etiqueta:estado'] = 'Estado';
$cadena['etiqueta:nombre de archivo'] = 'Nombre de archivo';
$string['label:modname'] = 'Módulo';
$string['label:actions'] = 'Acción(es)';

$cadena['informe:na'] = 'N/A';
$cadena['informe:listo'] = 'Listo';
$cadena['informe:disponible'] = 'Disponible';
$string['analysis:auto'] = 'Automatizado';
$string['analysis:manual'] = 'A pedido';
$string['analysis:awaitchoice'] = 'Esperando ser seleccionado para análisis';
$string['cmoverview'] = 'Lista de presentaciones de StrikePlagiarism.com';
$string['notification:subject'] = 'Mensaje del sistema de StrikePlagiarism.com [{$a}]';
$string['notification:errormessage'] = '<p>Estimado {$a->nombre completo}<p>
<p>Se produjo un error en el complemento antiplagio de StrikePlagiarism.com en \'{$a->instancename}\' en el curso \'{$a->coursefullname}\'.<br/>
El error generado fue: {$a->mensaje de error}.</p>
<p>Abajo están los detalles del archivo:<br/>
Autor: {$a->strikefileauthor}<br/>
Coordinador: {$a->strikefilecoordinator}<br/>
Tipo de documento: {$a->strikefiledocumentkind}<br/>
Título: {$a->strikefiletitle}<br/>
Nombre de archivo: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Hora de creación: {$a->strikefiletimecreated}
</p>
<p>Vaya a <a href="{$a->contexturl}">{$a->contexturlname}</a> para obtener más detalles</p>
<p>Saludos,<br/>{$a->firmar</p>';
$string['messageprovider:strikenotification'] = 'Notificaciones de error de StrikePlagiarism.com';

$string['err:strike_selectfiletypes-empty'] = 'Seleccione los formatos de archivo permitidos para enviar.<br/>
Dado que ahora no se eligen formatos de archivo, nunca se enviará ningún documento a la API del sistema antiplagio.';
$string['warn:strike_selectfiletypes-empty'] = 'Seleccione los formatos de archivo permitidos para enviar a continuación.<br/>
Si no se eligen formatos de archivo, nunca se enviará ningún documento a la API del sistema antiplagio.';

// Añadido por INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Probar conexión API';
$string['test_api_connection_status'] = 'Estado de conexión de la API';
$string['test_api_connection_help'] = 'Puede verificar que la API del host y la clave API ingresadas actualmente funcionan correctamente.';
$string['api_status_1'] = 'Conexión ok';
$string['api_status_2'] = 'La clave no es válida';
$string['api_status_3'] = 'Tiempo de espera de conexión';
$string['api_status_4'] = 'Conexión correcta, el servidor no responde';
$string['api_status_5'] = 'Código de error de conexión: {$a->error}';

$string['privacy:metadata:userid'] = 'Información sobre el usuario que envía el archivo para el análisis antiplagio.';
$string['privacy:metadata:relateduserid'] = 'Información sobre el uso relacionado que está enviando un archivo para el análisis antiplagio.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Tabla que almacena información sobre archivos enviados para análisis antiplagio.';
$string['privacy:metadata:title'] = 'Título del documento enviado por el usuario.';
$string['privacy:metadata:author'] = 'Nombre del autor o coautor del archivo enviado.';
$string['privacy:metadata:coordinator'] = 'Promotor de archivo enviado.';
$string['privacy:metadata:md5sum'] = 'MD5 suma del documento binario enviado para análisis.';
$string['privacy:metadata:ftimesubmitted'] = 'Hora de envío del archivo StrikePlagiarism.com.';
$string['privacy:metadata:ftimecreated'] = 'Hora de creación del registro del archivo StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Hora de modificación del envío de StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Booleano verdadero si el informe está listo para descargar, falso de lo contrario.';
$string['privacy:metadata:indexed'] = 'Booleano verdadero si el documento ha sido indexado.';
$string['privacy:metadata:factor1'] = 'Valor del coeficiente de similitud 1.';
$string['privacy:metadata:factor2'] = 'Valor del coeficiente de similitud 2.';
$string['privacy:metadata:factor3'] = 'Valor del coeficiente de similitud 3.';
$string['privacy:metadata:factor4'] = 'Valor del coeficiente de similitud 4.';
$string['privacy:metadata:factor5'] = 'Valor del coeficiente de similitud DLA.';

$string['privacy:metadata:strikefileid'] = 'StrikePlagiarism.com ID del archivo de envío';
$string['privacy:metadata:report'] = 'Envío StrikePlagiarism.com Datos del informe de similitud.';
$string['privacy:metadata:timemodified'] = 'Envío StrikePlagiarism.com Hora de modificación del informe de similitud.';
$string['privacy:metadata:timecreated'] = 'Envío StrikePlagiarism.com Hora de creación del informe de similitud.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com crea un informe de similitud para cada archivo enviado. Ese registro se almacena en la base de datos de Moodle. Cada informe está relacionado con el envío del archivo del usuario.';

$string['privacy:metadata:filename'] = 'Nombre de archivo enviado por el usuario.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Datos personales transmitidos desde el subsistema antiplagio.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Este complemento envía datos externamente usando la API de StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com crea un GUID que es una relación de archivo con el envío a la API de StrikePlagiarism.com.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com almacena archivos que han sido subidos a Moodle para formar un envío de StrikePlagiarism.com.';
$string['assignmenttype'] = 'El tipo de tarea';
$string['assignmenttype_0'] = 'Tesis de Habilitación';
$string['assignmenttype_1'] = 'Tesis de Doctorado';
$string['assignmenttype_2'] = 'Tesis de Maestría';
$string['assignmenttype_3'] = 'Tesis de licenciatura';
$string['assignmenttype_4'] = 'Papel anual';
$string['assignmenttype_6'] = 'Asignación';
$string['assignmenttype_7'] = 'Artículo';
$string['assignmenttype_8'] = 'Investigar';
$string['assignmenttype_9'] = 'Tesis de Ingeniería';
$string['assignmenttype_10'] = 'Tesis de Diploma';
$string['assignmenttype_16'] = 'Proyecto';
$string['assignmenttype_25'] = 'Papel';
$string['assignmenttype_40'] = 'Tesis de Posgrado';
$string['assignmenttype_101'] = 'Monografía';
$string['assignmenttype_102'] = 'Manual';
$string['assignmenttype_103'] = 'Tratado';
$string['assignmenttype_300'] = 'Libro';

$string['crosscheckmode'] = 'Modo de verificación cruzada';
$string['crosscheckmode_help'] = 'El modo de verificación cruzada permite una comparación 1:1 entre los envíos de los estudiantes dentro de la tarea. Cuando la verificación cruzada está habilitada, la sección de verificación cruzada será visible en el Informe de similitud interactivo';
$string['removeaiquiz'] = 'Ocultar la configuración de detección de IA';
$string['aidetection'] = 'Detección de IA';
$string['aidetection_help'] = 'Al habilitar la funcionalidad, el sistema buscará el texto generado por las herramientas de IA. Si no se generó el informe de contenido de IA, este servicio no está disponible. Para habilitar esta funcionalidad, comuníquese con el administrador del sistema.';

$string['updateprotocols'] = 'Actualizar protocolos';
$string['getprotocolsresponse'] = 'Respuesta de protocolos';
$string['countprotocols'] = 'Número de protocolos: ';
$string['errorprotocol'] = 'Error';