<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, French
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'Plugin StrikePlagiarism.com';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Pour plus d\'informations sur ce système anti-plagiat et son fonctionnement, voir : <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Synchroniser le rapport StrikePlagiarism.com pour le document';
$string['task:getreports'] = 'Synchroniser les rapports StrikePlagiarism.com';
$string['task:sendfiles'] = 'Envoyer les fichiers à l\'API du système StrikePlagiarism.com';
$string['strike:enable'] = 'Activer le plugin StrikePlagiarism.com';
$string['strike:viewreport'] = 'Afficher les rapports de similarité pour tous les étudiants';
$string['strike:resetfile'] = 'Efface toutes les erreurs et remet le statut à en attente';
$string['usestrike'] = 'Utiliser le plugin StrikePlagiarism.com';
$string['useadminnotifications'] = 'Notifier l\'administrateur des erreurs ?';
$string['useadminnotifications_help'] = 'Notifie l\'administrateur des erreurs lorsque diverses erreurs surviennent (par exemple, lors de la communication avec l\'API StrikePlagiarism.com)';
$string['useteachernotifications'] = 'Notifier le(s) enseignant(s) des erreurs ?';
$string['useteachernotifications_help'] = 'Notifie le(s) enseignant(s) des erreurs lorsque diverses erreurs surviennent (par exemple, lors de la communication avec l\'API StrikePlagiarism.com)';
$string['strikekey'] = 'Clé API StrikePlagiarism.com';
$string['strikekey_help'] = 'Clé API de votre compte dans le système StrikePlagiarism.com<br/>Vous devez obtenir une clé ID StrikePlagiarism.com pour utiliser ce plugin. Pour plus d\'informations, veuillez nous contacter via le formulaire de contact sur <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'Hôte API StrikePlagiarism.com';
$string['strikeserver_help'] = 'Nom d\'hôte ou adresse IP du serveur StrikePlagiarism.com. Entrez l\'adresse IP avec http ou https';
$string['studentdisclosuredefault'] = 'Je suis d\'accord pour que tous les fichiers que j\'ai téléchargés puissent être soumis au système anti-plagiat StrikePlagiarism.com pour vérifier l\'originalité du texte';
$string['strikestudentdisclosure'] = 'Je suis d\'accord pour que tous les fichiers que j\'ai téléchargés puissent être soumis au système anti-plagiat StrikePlagiarism.com pour vérifier l\'originalité du texte';
$string['studentdisclosure'] = 'Déclaration de l\'étudiant';
$string['studentdisclosure_help'] = 'Ce texte sera affiché à tous les étudiants sur la page de téléchargement de fichiers. Il doit être accepté pour poursuivre la soumission.';
$string['strike_enableplugin'] = 'Activer StrikePlagiarism.com pour {$a}';
$string['notifyteachers'] = 'Notifier le(s) enseignant(s)';
$string['enableapidebugging'] = 'Activer le débogage de l\'API';
$string['enableapidebugging_help'] = 'Activez cette option si vous souhaitez un débogage étendu fourni par l\'API StrikePlagiarism.com.<br/>
Plusieurs méthodes de débogage sont disponibles. Notez que le débogage ne consistera <i>que</i> en des informations de communication/flux sur l\'API StrikePlagiarism.com.';
$string['apidebuggingmtrace'] = 'Activer le débogage mtrace ?';
$string['apidebuggingmtrace_help'] = 'Activez cette option si vous souhaitez voir la sortie de débogage API sous forme de sortie mtrace().<br/>
Si vous l\'activez, la sortie de trace sera visible dans la sortie de tâche en arrière-plan (CRON).';
$string['apidebuggingerrorlog'] = 'Activer le débogage error_log ?';
$string['apidebuggingerrorlog_help'] = 'Activez cette option si vous souhaitez voir la sortie de débogage API sous forme de sortie error_log.<br/>
Si vous l\'activez, la sortie de trace sera visible dans le fichier error_log du serveur web / PHP.<br/>
REMARQUE : Cela ne sera pas toujours visible en fonction de la configuration de votre serveur web ou de PHP.';
$string['apidebuggingemail'] = 'Activer le débogage par e-mail ?';
$string['apidebuggingemail_help'] = 'Activez cette option si vous souhaitez recevoir la sortie de débogage API dans votre e-mail.<br/>
Si vous l\'activez, la sortie de trace sera envoyée à l\'adresse e-mail spécifiée.<br/>
REMARQUE : Cela peut entraîner l\'envoi d\'un grand nombre d\'e-mails.<br/>
REMARQUE 2 : Cette méthode utilise la fonction mail() par défaut, et ne sera pas toujours disponible. Elle fonctionne en dehors des fonctions de courrier Moodle.';
$string['apidebuggingemailaddress'] = 'Destinataire du débogage par e-mail.';

$string['str:settings'] = 'Paramètres';
$string['str:defaults'] = 'Par défaut';
$string['str:dump'] = 'Vidage';
$string['str:debug'] = 'Déboguer';
$string['allowallsupportedfiles'] = 'Autoriser tous les formats de fichiers pris en charge';
$string['allowallsupportedfiles_help'] = 'Permet à l\'enseignant de restreindre les formats de fichiers qui seront envoyés à StrikePlagiarism.com pour traitement. Cela n\'empêche pas les étudiants de téléverser d\'autres types de fichiers dans l\'activité.';
$string['restrictfiles'] = 'Formats de fichiers autorisés pour l\'analyse anti-plagiat';
$string['form:desc:defaults'] = 'Ci-dessous, vous pouvez saisir tous les paramètres par défaut qui seront utilisés lors de la création et de la configuration d\'un nouveau module d\'activité.<br/>
Les valeurs saisies ici serviront de valeurs par défaut pour la configuration du plugin StrikePlagiarism.com pour ce module d\'activité.';
$string['docsendmode'] = 'Envoi de documents pour l\'analyse anti-plagiat';
$string['docsendmode_help'] = 'Choisissez la méthode d\'envoi des documents pour analyse. Cela peut être soit par choix (l\'enseignant sélectionne les documents à envoyer pour analyse), soit tous (tous les documents sont envoyés pour analyse par défaut).';
$string['docsendingchoose'] = 'Envoyer les documents choisis';
$string['docsendingall'] = 'Envoyer tous les documents';
$string['strike_show_student_status'] = 'Afficher l\'état de l\'analyse StrikePlagiarism.com à l\'étudiant';
$string['strike_show_student_status_help'] = 'Permet aux étudiants de voir l\'état des soumissions dans le système StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Afficher le rapport de similitude à l\'étudiant';
$string['strike_show_student_report_help'] = 'Le rapport de similitude indique le nombre et met en évidence les fragments empruntés dans le texte, en indiquant leur source.';
$string['strike_show_student_score'] = 'Afficher les coefficients de similitude à l\'étudiant';
$string['strike_show_student_score_help'] = 'Les coefficients de similitude déterminent en pourcentage à quel point le document analysé contient des fragments similaires à ceux détectés dans les bases de données comparatives.';
$string['strike_addref_method'] = 'Ajout de documents à la base de données comparative';
$string['strike_addref_method_help'] = 'Choisissez la méthode d\'ajout des documents à votre base de données comparative. Cela peut être soit manuellement (l\'enseignant sélectionne les documents à ajouter), soit automatiquement (tous les documents sont ajoutés par défaut) après vérification.<br/>
Il est fortement conseillé de définir cette option sur AUTOMATIQUE, afin que les documents vérifiés soient ajoutés automatiquement à la base de données comparative.';
$string['strike_deletereport_method'] = 'Suppression des rapports de similitude pour les soumissions supprimées/mises à jour';
$string['strike_deletereport_method_help'] = 'Définit si les rapports de similitude doivent être supprimés lorsqu\'une soumission est supprimée ou mise à jour.<br/>
Méthodes possibles :
<ul>
<li>garder : Conserver les anciens rapports de similitude</li>
<li>supprimer : Supprimer les anciens rapports de similitude</li>
</ul>';
$string['strike_studentemail'] = 'Email à l\'étudiant';
$string['strike_studentemail_help'] = 'Active l\'envoi d\'un e-mail à l\'étudiant lorsque son fichier a été traité, l\'informant qu\'un rapport de similitude est disponible. L\'e-mail inclut également un lien de désinscription.';
$string['strike_draft_submit'] = 'Moment d\'envoi pour analyse anti-plagiat';
$string['strike_defaultlang'] = 'Langue par défaut du document';
$string['strike_defaultlang_help'] = 'Définit la langue par défaut du document envoyé pour analyse au système StrikePlagiarism.com.';
$string['wordcount'] = 'Nombre minimum de mots pour l\'analyse';
$string['wordcount_help'] = 'Définit le nombre minimum de mots requis pour un texte en ligne (messages de forum et type de devoir en ligne) avant que le contenu ne soit envoyé au système StrikePlagiarism.com pour analyse.';

$string['addrefauto'] = 'Automatiquement après vérification';
$string['addrefmanual'] = 'Manuellement après vérification';

$string['deletereportkeep'] = 'Conserver les anciens rapports de similitude';
$string['deletereportremove'] = 'Supprimer les anciens rapports de similitude';

$string['submitondraft'] = 'Lors du premier téléversement';
$string['submitonfinal'] = 'Lorsque l\'étudiant soumet pour évaluation';
$string['showwhenclosed'] = 'Lorsque l\'activité est fermée';

$string['pending'] = 'Le fichier est en attente de soumission à StrikePlagiarism.com';
$string['processing'] = 'Le fichier a été soumis à StrikePlagiarism.com et est en attente de l’analyse';
$string['toolarge'] = 'Le fichier est trop volumineux pour être soumis à StrikePlagiarism.com';
$string['unsupported'] = 'Le format de fichier n’est pas pris en charge par StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Le format de fichier n’est pas pris en charge par StrikePlagiarism.com';
$string['unknownwarning'] = 'Une erreur s’est produite lors de la soumission de ce fichier à StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'En attente d’une décision pour l’envoi à StrikePlagiarism.com pour analyse';
$string['previouslysubmitted'] = 'Déjà soumis en tant que';
$string['sendforanalysis'] = 'Envoyer la soumission à StrikePlagiarism.com pour analyse';
$string['indexdocument'] = 'Ajouter la soumission à votre base de données comparative dans le système StrikePlagiarism.com';
$string['deletestrikefile'] = 'Retirer la soumission de votre base de données comparative dans le système StrikePlagiarism.com';

$string['similarity1'] = 'CS 1';
$string['similarity2'] = 'CS 2';
$string['similarity3'] = 'CS 3';
$string['similarity4'] = 'CS 4';
$string['similarity5'] = 'CS DAJ';

$string['filereset'] = 'Un fichier a été réinitialisé pour une nouvelle soumission à StrikePlagiarism.com';
$string['fileresetfailed'] = 'Erreur : le fichier n’a pas été réinitialisé pour une nouvelle soumission à StrikePlagiarism.com';

$string['report'] = 'Rapport de similarité StrikePlagiarism.com';
$string['report2'] = 'Rapport interactif StrikePlagiarism.com';
$string['reportclick'] = 'Lien vers le rapport de similarité StrikePlagiarism.com';

$string['restrictcontent'] = 'Soumettre les fichiers joints et le texte en ligne';
$string['restrictcontent_help'] = 'StrikePlagiarism.com peut traiter les fichiers téléchargés ou le texte en ligne provenant des messages de forum et des soumissions de type texte en ligne. Choisissez les composants à envoyer au système StrikePlagiarism.com.';
$string['restrictcontentfiles'] = 'Soumettre uniquement les fichiers joints';
$string['restrictcontentno'] = 'Soumettre les fichiers joints et le texte en ligne';
$string['restrictcontenttext'] = 'Soumettre uniquement le texte en ligne';

$string['config:plagiarism'] = 'Valeurs globales de configuration du module antiplagiat StrikePlagiarism.com';
$string['config:defaults'] = 'Paramètres par défaut de configuration du module antiplagiat StrikePlagiarism.com';

$string['studentemailsubject'] = 'Soumission vérifiée par le système antiplagiat StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Cher/Chère {$a->firstname} {$a->lastname},</p>
Le fichier que vous avez soumis à {$a->modulename} dans {$a->coursename} a été vérifié par StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
Cordialement, 
{$a->admin}
';

$string['label:user'] = 'Utilisateur';
$string['label:author'] = 'Auteur';
$string['label:timesubmitted'] = 'Soumis le';
$string['label:analysisstatus'] = 'Coefficients de Similarité (SC)';
$string['label:reportstatus'] = 'Rapport';
$string['label:status'] = 'Statut';
$string['label:filename'] = 'Nom du fichier';
$string['label:modname'] = 'Module';
$string['label:actions'] = 'Action(s)';

$string['report:na'] = 'N/D';
$string['report:ready'] = 'Prêt';
$string['report:available'] = 'Disponible';
$string['analysis:auto'] = 'Automatique';
$string['analysis:manual'] = 'Sur demande';
$string['analysis:awaitchoice'] = 'En attente de sélection pour analyse';
$string['cmoverview'] = 'Liste des soumissions à StrikePlagiarism.com';
$string['notification:subject'] = 'Message du système StrikePlagiarism.com [{$a}]';
$string['notification:errormessage'] = '<p>Cher/Chère {$a->fullname}<p>
<p>Une erreur s’est produite dans le plugin antiplagiat StrikePlagiarism.com dans \'{$a->instancename}\' du cours \'{$a->coursefullname}\'.<br/>
L’erreur signalée est : {$a->errormessage}.</p>
<p>Voici les détails du fichier :<br/>
Auteur : {$a->strikefileauthor}<br/>
Coordinateur : {$a->strikefilecoordinator}<br/>
Type de document : {$a->strikefiledocumentkind}<br/>
Titre : {$a->strikefiletitle}<br/>
Nom du fichier : {$a->strikefilename}<br/>
GUID : {$a->strikefileguid}<br/>
Date de création : {$a->strikefiletimecreated}
</p>
<p>Veuillez consulter <a href="{$a->contexturl}">{$a->contexturlname}</a> pour plus de détails</p>
<p>Cordialement,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'Notifications d’erreur de StrikePlagiarism.com';

$string['err:strike_selectfiletypes-empty'] = 'Veuillez sélectionner les formats de fichier autorisés à soumettre.<br/>
Puisqu’aucun format de fichier n’est actuellement choisi, aucun document ne sera soumis au système API antiplagiat.';
$string['warn:strike_selectfiletypes-empty'] = 'Veuillez sélectionner ci-dessous les formats de fichier autorisés à soumettre.<br/>
Si aucun format de fichier n’est choisi, aucun document ne sera soumis au système API antiplagiat.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'Tester la connexion API';
$string['test_api_connection_status'] = 'Statut de la connexion API';
$string['test_api_connection_help'] = 'Vous pouvez vérifier que l’hôte API et la clé API actuellement saisis fonctionnent correctement.';
$string['api_status_1'] = 'Connexion ok';
$string['api_status_2'] = 'Clé non valide';
$string['api_status_3'] = 'Délai de connexion dépassé';
$string['api_status_4'] = 'Connexion ok, le serveur ne répond pas';
$string['api_status_5'] = 'Erreur de connexion, code : {$a->error}';

$string['privacy:metadata:userid'] = 'Informations sur l’utilisateur qui soumet un fichier pour analyse antiplagiat.';
$string['privacy:metadata:relateduserid'] = 'Informations sur l’utilisateur associé qui soumet un fichier pour analyse antiplagiat.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Table qui stocke les informations sur les fichiers soumis pour analyse antiplagiat.';
$string['privacy:metadata:title'] = 'Titre du document soumis par l’utilisateur.';
$string['privacy:metadata:author'] = 'Nom de l’auteur ou co-auteur du fichier soumis.';
$string['privacy:metadata:coordinator'] = 'Promoteur du fichier soumis.';
$string['privacy:metadata:md5sum'] = 'Somme MD5 du document binaire envoyé pour analyse.';
$string['privacy:metadata:ftimesubmitted'] = 'Heure de soumission du fichier à StrikePlagiarism.com.';
$string['privacy:metadata:ftimecreated'] = 'Heure de création de l’enregistrement du fichier dans StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Heure de modification de la soumission dans StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Booléen vrai si le rapport est prêt à être téléchargé, faux sinon.';
$string['privacy:metadata:indexed'] = 'Booléen vrai si le document a été indexé.';
$string['privacy:metadata:factor1'] = 'Coefficient de Similarité 1.';
$string['privacy:metadata:factor2'] = 'Coefficient de Similarité 2.';
$string['privacy:metadata:factor3'] = 'Coefficient de Similarité 3.';
$string['privacy:metadata:factor4'] = 'Coefficient de Similarité 4.';
$string['privacy:metadata:factor5'] = 'Coefficient de Similarité DLA.';

$string['privacy:metadata:strikefileid'] = 'ID du fichier soumis à StrikePlagiarism.com.';
$string['privacy:metadata:report'] = 'Données du rapport de similarité StrikePlagiarism.com pour la soumission.';
$string['privacy:metadata:timemodified'] = 'Heure de modification du rapport de similarité StrikePlagiarism.com.';
$string['privacy:metadata:timecreated'] = 'Heure de création du rapport de similarité StrikePlagiarism.com.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com génère un rapport de similarité pour chaque fichier soumis. Cet enregistrement est stocké dans la base de données Moodle. Chaque rapport est lié à la soumission d’un fichier utilisateur.';

$string['privacy:metadata:filename'] = 'Nom du fichier soumis par l’utilisateur.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Données personnelles transmises via le sous-système antiplagiat.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Ce plugin envoie des données à l’extérieur en utilisant l’API de StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com génère un GUID qui relie le fichier à sa soumission via l’API.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com stocke les fichiers téléchargés dans Moodle pour former une soumission à StrikePlagiarism.com.';
$string['assignmenttype'] = 'Type de devoir';
$string['assignmenttype_0'] = 'Thèse d’habilitation';
$string['assignmenttype_1'] = 'Thèse de doctorat';
$string['assignmenttype_2'] = 'Mémoire de master';
$string['assignmenttype_3'] = 'Mémoire de licence';
$string['assignmenttype_4'] = 'Travail annuel';
$string['assignmenttype_6'] = 'Devoir';
$string['assignmenttype_7'] = 'Article';
$string['assignmenttype_8'] = 'Recherche';
$string['assignmenttype_9'] = 'Thèse d’ingénieur';
$string['assignmenttype_10'] = 'Mémoire de diplôme';
$string['assignmenttype_16'] = 'Projet';
$string['assignmenttype_25'] = 'Document';
$string['assignmenttype_40'] = 'Thèse de troisième cycle';
$string['assignmenttype_101'] = 'Monographie';
$string['assignmenttype_102'] = 'Manuel';
$string['assignmenttype_103'] = 'Traité';
$string['assignmenttype_300'] = 'Livre';

$string['crosscheckmode'] = 'Mode de vérification croisée';
$string['crosscheckmode_help'] = 'Le mode de vérification croisée permet une comparaison 1:1 entre les soumissions des étudiants dans le cadre du devoir. Lorsque la vérification croisée est activée, la section de vérification croisée sera visible dans le rapport de similarité interactif.';
$string['removeaiquiz'] = 'Masquer le paramètre de détection d’IA';
$string['aidetection'] = 'Détection d’IA';
$string['aidetection_help'] = 'En activant cette fonctionnalité, le système recherchera le texte généré par des outils d’IA. Si le service n’est pas disponible, le rapport de contenu IA ne sera pas généré. Pour activer cette fonctionnalité, veuillez contacter l’administrateur système.';

$string['updateprotocols'] = 'Mettre à jour les protocoles';
$string['getprotocolsresponse'] = 'Réponse des protocoles';
$string['countprotocols'] = 'Nombre de protocoles : ';
$string['errorprotocol'] = 'Erreur';
