<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, Dutch
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'StrikePlagiarism.com plugin';
$string['strikeplagiarism'] = 'StrikePlagiarism.com';
$string['strikeexplain'] = 'Voor meer informatie over dit antiplagiarisme-systeem en hoe het werkt, zie: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Synchroniseer StrikePlagiarism.com-rapport voor document';
$string['task:getreports'] = 'Synchroniseer StrikePlagiarism.com-rapporten';
$string['task:sendfiles'] = 'Stuur bestanden naar StrikePlagiarism.com API-systeem';
$string['strike:enable'] = 'Activeer StrikePlagiarism.com plugin';
$string['strike:viewreport'] = 'Toon gelijkenisrapporten aan alle studenten';
$string['strike:resetfile'] = 'Wis alle fouten en zet de status opnieuw op in afwachting';
$string['usestrike'] = 'Gebruik StrikePlagiarism.com plugin';
$string['useadminnotifications'] = 'Beheerder op de hoogte stellen van fouten?';
$string['useadminnotifications_help'] = 'Stelt de beheerder op de hoogte van fouten wanneer verschillende fouten optreden (bijvoorbeeld bij communicatie met de StrikePlagiarism.com API).';
$string['useteachernotifications'] = 'Docent(en) op de hoogte stellen van fouten?';
$string['useteachernotifications_help'] = 'Stelt docent(en) op de hoogte van fouten wanneer verschillende fouten optreden (bijvoorbeeld bij communicatie met de StrikePlagiarism.com API).';
$string['strikekey'] = 'StrikePlagiarism.com API-sleutel';
$string['strikekey_help'] = 'API-sleutel voor uw account in het StrikePlagiarism.com-systeem<br/>U moet een StrikePlagiarism.com ID-sleutel verkrijgen om deze plugin te gebruiken. Voor meer informatie kunt u contact met ons opnemen via het contactformulier op <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'StrikePlagiarism.com API-host';
$string['strikeserver_help'] = 'StrikePlagiarism.com server hostnaam of IP-adres. Voer IP-adres in met http of https.';
$string['studentdisclosuredefault'] = 'Ik ga ermee akkoord dat alle bestanden die ik heb geüpload, kunnen worden ingediend bij het StrikePlagiarism.com antiplagiarisme-systeem om de originaliteit van de tekst te controleren.';
$string['strikestudentdisclosure'] = 'Ik ga ermee akkoord dat alle bestanden die ik heb geüpload, kunnen worden ingediend bij het StrikePlagiarism.com antiplagiarisme-systeem om de originaliteit van de tekst te controleren.';
$string['studentdisclosure'] = 'Studentverklaring';
$string['studentdisclosure_help'] = 'Deze tekst wordt weergegeven aan alle studenten op de pagina voor het uploaden van bestanden. Het moet worden goedgekeurd om door te gaan met de indiening.';
$string['strike_enableplugin'] = 'Activeer StrikePlagiarism.com voor {$a}';
$string['notifyteachers'] = 'Docent(en) op de hoogte stellen';
$string['enableapidebugging'] = 'Activeer API-debugging';
$string['enableapidebugging_help'] = 'Schakel deze optie in als u uitgebreide debugging wilt ontvangen van de StrikePlagiarism.com API.<br/>
Er zijn meerdere debugmethoden beschikbaar. Houd er rekening mee dat debugging alleen zal bestaan uit communicatie-/verkeersinformatie over de StrikePlagiarism.com API.';
$string['apidebuggingmtrace'] = 'Mtrace-debugging inschakelen?';
$string['apidebuggingmtrace_help'] = 'Schakel deze optie in als u de API-debuguitvoer als mtrace()-uitvoer wilt zien.<br/>
Als u dit inschakelt, is de trace-uitvoer zichtbaar in uw achtergrondtaakuitvoer (CRON).';
$string['apidebuggingerrorlog'] = 'Error_log debugging inschakelen?';
$string['apidebuggingerrorlog_help'] = 'Schakel deze optie in als u de API-debuguitvoer wilt zien als error_log-uitvoer.<br/>
Als u dit inschakelt, is de trace-uitvoer zichtbaar in de webserver-/PHP-error_log.<br/>
OPMERKING: Dit is niet altijd zichtbaar, afhankelijk van hoe uw webserver of PHP is geconfigureerd.';
$string['apidebuggingemail'] = 'E-maildebugging inschakelen?';
$string['apidebuggingemail_help'] = 'Schakel deze optie in als u de API-debuguitvoer in uw e-mail wilt ontvangen.<br/>
Als u dit inschakelt, wordt de trace-uitvoer verzonden naar het opgegeven e-mailadres.<br/>
OPMERKING: Dit kan ervoor zorgen dat er veel e-mails worden verzonden.<br/>
OPMERKING 2: Deze methode maakt gebruik van de standaard mail()-functie en is niet altijd beschikbaar. Het werkt buiten de Moodle-mailfuncties.';
$string['apidebuggingemailaddress'] = 'E-mailadres voor debugging.';

$string['str:settings'] = 'Instellingen';
$string['str:defaults'] = 'Standaardinstellingen';
$string['str:dump'] = 'Dump';
$string['str:debug'] = 'Debug';
$string['allowallsupportedfiles'] = 'Alle ondersteunde bestandsformaten toestaan';
$string['allowallsupportedfiles_help'] = 'Staat de docent toe om bestandsformaten te beperken die naar StrikePlagiarism.com worden verzonden voor verwerking. Het voorkomt niet dat studenten andere bestandstypen uploaden naar de opdracht.';
$string['restrictfiles'] = 'Bestandsformaten toegestaan voor antiplagiaatanalyse';
$string['form:desc:defaults'] = 'Hieronder kunt u alle standaardinstellingen invoeren die worden gebruikt wanneer een nieuwe activiteitmodule wordt gemaakt en geconfigureerd.<br/>
De hier ingevoerde waarden dienen als standaardwaarden voor de configuratie van de StrikePlagiarism.com plugin voor die activiteitmodule.';
$string['docsendmode'] = 'Documenten verzenden voor antiplagiaatanalyse';
$string['docsendmode_help'] = 'Kies de methode om documenten te verzenden voor analyse. Dit kan door keuze (wat betekent dat de docent documenten selecteert om te verzenden) of allemaal (wat betekent dat alle documenten standaard worden verzonden).';
$string['docsendingchoose'] = 'Geselecteerde documenten verzenden';
$string['docsendingall'] = 'Alle documenten verzenden';
$string['strike_show_student_status'] = 'Toon StrikePlagiarism.com analysestatus aan student';
$string['strike_show_student_status_help'] = 'Staat studenten toe de status van inzendingen naar het StrikePlagiarism.com-systeem te zien.';
$string['strike_show_student_report'] = 'Toon gelijkenisrapport aan student';
$string['strike_show_student_report_help'] = 'Het gelijkenisrapport geeft het aantal en markeert overgenomen fragmenten in de tekst en geeft hun bron aan.';
$string['strike_show_student_score'] = 'Toon gelijkeniscoëfficiënten aan student';
$string['strike_show_student_score_help'] = 'De gelijkeniscoëfficiënten bepalen in welk percentage het geanalyseerde document bestaat uit fragmenten die vergelijkbaar zijn met die in vergelijkende databases.';
$string['strike_addref_method'] = 'Documenten toevoegen aan de vergelijkingsdatabase';
$string['strike_addref_method_help'] = 'Kies de methode om documenten toe te voegen aan uw vergelijkingsdatabase. Dit kan handmatig zijn (wat betekent dat de docent documenten selecteert om toe te voegen) of automatisch (wat betekent dat alle documenten standaard worden toegevoegd na controle).<br/>
Het wordt sterk aanbevolen om dit in te stellen op AUTOMATISCH, zodat gecontroleerde documenten automatisch aan de vergelijkingsdatabase worden toegevoegd.';
$string['strike_deletereport_method'] = 'Verwijderen van gelijkenisrapporten voor verwijderde/bijgewerkte inzendingen';
$string['strike_deletereport_method_help'] = 'Definieert of gelijkenisrapporten moeten worden verwijderd wanneer een inzending wordt verwijderd of bijgewerkt.<br/>
Mogelijke methoden zijn:
<ul>
<li>behouden: Oude gelijkenisrapporten behouden</li>
<li>verwijderen: Oude gelijkenisrapporten verwijderen</li>
</ul>';
$string['strike_studentemail'] = 'E-mail naar student';
$string['strike_studentemail_help'] = 'Maakt het mogelijk om een e-mail naar de student te sturen wanneer een bestand is verwerkt, zodat ze weten dat er een gelijkenisrapport beschikbaar is. De e-mail bevat ook een opt-out-link.';
$string['strike_draft_submit'] = 'Moment van verzending voor antiplagiaatanalyse';
$string['strike_defaultlang'] = 'Standaard documenttaal';
$string['strike_defaultlang_help'] = 'Definieert de standaardtaal van het document dat wordt verzonden voor analyse naar het StrikePlagiarism.com-systeem.';
$string['wordcount'] = 'Minimaal aantal woorden voor analyse';
$string['wordcount_help'] = 'Stelt een minimum aantal woorden in dat vereist is voor inline tekst (forumberichten en online opdrachtentypen) voordat de inhoud wordt verzonden naar het StrikePlagiarism.com-systeem voor analyse.';

$string['addrefauto'] = 'Automatisch na controle';
$string['addrefmanual'] = 'Handmatig na controle';

$string['deletereportkeep'] = 'Oude gelijkenisrapporten behouden';
$string['deletereportremove'] = 'Oude gelijkenisrapporten verwijderen';

$string['submitondraft'] = 'Bij eerste upload';
$string['submitonfinal'] = 'Bij indiening door student voor beoordeling';
$string['showwhenclosed'] = 'Wanneer activiteit is gesloten';

$string['pending'] = 'Bestand wacht op verzending naar StrikePlagiarism.com';
$string['processing'] = 'Bestand is verzonden naar StrikePlagiarism.com en wacht op voltooiing van analyse';
$string['toolarge'] = 'Bestand is te groot om te verzenden naar StrikePlagiarism.com';
$string['unsupported'] = 'Bestandsformaat wordt niet ondersteund door StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Bestandsformaat wordt niet ondersteund door StrikePlagiarism.com';
$string['unknownwarning'] = 'Er was een fout bij het verzenden van dit bestand naar StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'In afwachting van beslissing over verzending naar StrikePlagiarism.com voor analyse';
$string['previouslysubmitted'] = 'Eerder ingediend als';
$string['sendforanalysis'] = 'Inzending verzenden naar StrikePlagiarism.com voor analyse';
$string['indexdocument'] = 'Inzending toevoegen aan uw vergelijkingsdatabase in het StrikePlagiarism.com-systeem';
$string['deletestrikefile'] = 'Inzending terugtrekken uit uw vergelijkingsdatabase in het StrikePlagiarism.com-systeem';

$string['similarity1'] = 'GC 1';
$string['similarity2'] = 'GC 2';
$string['similarity3'] = 'GC 3';
$string['similarity4'] = 'GC 4';
$string['similarity5'] = 'GC DVR';

$string['filereset'] = 'Een bestand is gereset voor herindiening naar StrikePlagiarism.com';
$string['fileresetfailed'] = 'Fout: bestand is niet gereset voor herindiening naar StrikePlagiarism.com';

$string['report'] = 'StrikePlagiarism.com Similariteitsrapport';
$string['report2'] = 'StrikePlagiarism.com interactief rapport';
$string['reportclick'] = 'Link naar StrikePlagiarism.com Similariteitsrapport';

$string['restrictcontent'] = 'Bijgevoegde bestanden en inline tekst indienen';
$string['restrictcontent_help'] = 'StrikePlagiarism.com kan geüploade bestanden of inline tekst van forumberichten en tekst van de online tekstopdrachtverzendingssoort verwerken. Kies welke componenten naar het StrikePlagiarism.com-systeem moeten worden verzonden.';
$string['restrictcontentfiles'] = 'Alleen bijgevoegde bestanden indienen';
$string['restrictcontentno'] = 'Bijgevoegde bestanden en inline tekst indienen';
$string['restrictcontenttext'] = 'Alleen inline tekst indienen';

$string['config:plagiarism'] = 'StrikePlagiarism.com anti-plagiaat module globale configuratiewaarden';
$string['config:defaults'] = 'StrikePlagiarism.com anti-plagiaat module standaardconfiguratie';

$string['studentemailsubject'] = 'Inzending geverifieerd door StrikePlagiarism.com anti-plagiaatsysteem';
$string['studentemailcontent'] = '<p>Beste {$a->firstname} {$a->lastname},</p>
Het bestand dat u hebt ingediend voor {$a->modulename} in {$a->coursename} is geverifieerd door StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
Met vriendelijke groet,
{$a->admin}
';

$string['label:user'] = 'Gebruiker';
$string['label:author'] = 'Auteur';
$string['label:timesubmitted'] = 'Ingediend op';
$string['label:analysisstatus'] = 'Similariteitscoëfficiënten (SC)';
$string['label:reportstatus'] = 'Rapport';
$string['label:status'] = 'Status';
$string['label:filename'] = 'Bestandsnaam';
$string['label:modname'] = 'Module';
$string['label:actions'] = 'Actie(s)';

$string['report:na'] = 'N.V.T.';
$string['report:ready'] = 'Klaar';
$string['report:available'] = 'Beschikbaar';
$string['analysis:auto'] = 'Geautomatiseerd';
$string['analysis:manual'] = 'Op aanvraag';
$string['analysis:awaitchoice'] = 'Wachtend om geselecteerd te worden voor analyse';
$string['cmoverview'] = 'Lijst van StrikePlagiarism.com inzendingen';
$string['notification:subject'] = 'StrikePlagiarism.com systeembericht [{$a}]';
$string['notification:errormessage'] = '<p>Beste {$a->fullname}<p>
<p>Er is een fout opgetreden in de StrikePlagiarism.com anti-plagiaat plugin in \'{$a->instancename}\' in cursus \'{$a->coursefullname}\'.<br/>
De opgetreden fout was: {$a->errormessage}.</p>
<p>Hieronder staan de bestanddetails:<br/>
Auteur: {$a->strikefileauthor}<br/>
Coördinator: {$a->strikefilecoordinator}<br/>
Documenttype: {$a->strikefiledocumentkind}<br/>
Titel: {$a->strikefiletitle}<br/>
Bestandsnaam: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Tijd aangemaakt: {$a->strikefiletimecreated}
</p>
<p>Ga naar <a href="{$a->contexturl}">{$a->contexturlname}</a> voor meer details</p>
<p>Met vriendelijke groet,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'StrikePlagiarism.com foutmeldingen';

$string['err:strike_selectfiletypes-empty'] = 'Maak een selectie van toegestane bestandsformaten om in te dienen.<br/>
Aangezien er nu geen bestandsformaten zijn gekozen, zal er geen document ooit naar de anti-plagiaatsysteem-API worden verzonden.';
$string['warn:strike_selectfiletypes-empty'] = 'Maak hieronder een selectie van toegestane bestandsformaten om in te dienen.<br/>
Als er geen bestandsformaten worden gekozen, zullen er geen documenten naar de anti-plagiaatsysteem-API worden verzonden.';

// Added by INTERSIEC Kamil Łuczak @ 01.08.2018.
$string['test_api_connection'] = 'API-verbinding testen';
$string['test_api_connection_status'] = 'API-verbinding status';
$string['test_api_connection_help'] = 'U kunt controleren of de huidige ingevoerde host-API en API-sleutel correct werken.';
$string['api_status_1'] = 'Verbinding ok';
$string['api_status_2'] = 'Sleutel is niet geldig';
$string['api_status_3'] = 'Verbinding time-out';
$string['api_status_4'] = 'Verbinding ok, server reageert niet';
$string['api_status_5'] = 'Verbindingsfoutcode: {$a->error}';

$string['privacy:metadata:userid'] = 'Informatie over de gebruiker die een bestand indient voor anti-plagiaatanalyse.';
$string['privacy:metadata:relateduserid'] = 'Informatie over de gerelateerde gebruiker die een bestand indient voor anti-plagiaatanalyse.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Tabel die informatie opslaat over bestanden die zijn ingediend voor anti-plagiaatanalyse.';
$string['privacy:metadata:title'] = 'Titel van het document ingediend door de gebruiker.';
$string['privacy:metadata:author'] = 'Naam van de auteur of mede-auteur van het ingediende bestand.';
$string['privacy:metadata:coordinator'] = 'Promotor van het ingediende bestand.';
$string['privacy:metadata:md5sum'] = 'MD5-som van het binaire document dat is verzonden voor analyse.';
$string['privacy:metadata:ftimesubmitted'] = 'StrikePlagiarism.com tijd van bestandinzending.';
$string['privacy:metadata:ftimecreated'] = 'StrikePlagiarism.com tijd van aanmaken van het bestandsrecord.';
$string['privacy:metadata:ftimemodified'] = 'StrikePlagiarism.com tijd van wijziging van inzending.';

$string['privacy:metadata:reportready'] = 'Boolean true als het rapport klaar is voor download, anders false.';
$string['privacy:metadata:indexed'] = 'Boolean true als het document is geïndexeerd.';
$string['privacy:metadata:factor1'] = 'Nummer Gelijksoortigheidscoëfficiënt 1.';
$string['privacy:metadata:factor2'] = 'Nummer Gelijksoortigheidscoëfficiënt 2.';
$string['privacy:metadata:factor3'] = 'Nummer Gelijksoortigheidscoëfficiënt 3.';
$string['privacy:metadata:factor4'] = 'Nummer Gelijksoortigheidscoëfficiënt 4.';
$string['privacy:metadata:factor5'] = 'Nummer Gelijksoortigheidscoëfficiënt DVR.';

$string['privacy:metadata:strikefileid'] = 'StrikePlagiarism.com indient bestand ID.';
$string['privacy:metadata:report'] = 'Indient StrikePlagiarism.com Similarity rapport gegevens.';
$string['privacy:metadata:timemodified'] = 'Indient StrikePlagiarism.com Similarity rapport wijzigingstijd.';
$string['privacy:metadata:timecreated'] = 'Indient StrikePlagiarism.com Similarity rapport aanmaak tijd.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com maakt een Similarity rapport voor elk ingediend bestand. Dit record wordt opgeslagen in de Moodle database. Elk rapport is gekoppeld aan de indient bestand.';

$string['privacy:metadata:filename'] = 'Bestandsnaam van het bestand ingediend door de gebruiker.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Persoonsgegevens doorgestuurd van het antiplagiarism subsysteem.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Deze plugin stuurt gegevens extern via de StrikePlagiarism.com API.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com maakt een guid die het bestand relateert aan de indiening in de StrikePlagiarism.com API.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com slaat bestanden op die zijn geüpload naar Moodle om een StrikePlagiarism.com indiening te vormen.';
$string['assignmenttype'] = 'Type van de opdracht';
$string['assignmenttype_0'] = 'Habilitatie Thesis';
$string['assignmenttype_1'] = 'Doctorale Thesis';
$string['assignmenttype_2'] = 'Master Thesis';
$string['assignmenttype_3'] = 'Bachelor Thesis';
$string['assignmenttype_4'] = 'Jaarwerk';
$string['assignmenttype_6'] = 'Opdracht';
$string['assignmenttype_7'] = 'Artikel';
$string['assignmenttype_8'] = 'Onderzoek';
$string['assignmenttype_9'] = 'Ingenieur Thesis';
$string['assignmenttype_10'] = 'Diploma Thesis';
$string['assignmenttype_16'] = 'Project';
$string['assignmenttype_25'] = 'Papier';
$string['assignmenttype_40'] = 'Postdoctorale Thesis';
$string['assignmenttype_101'] = 'Monografie';
$string['assignmenttype_102'] = 'Handleiding';
$string['assignmenttype_103'] = 'Verhandeling';
$string['assignmenttype_300'] = 'Boek';

$string['crosscheckmode'] = 'Cross-check modus';
$string['crosscheckmode_help'] = 'Cross-check modus maakt een 1:1 vergelijking mogelijk tussen inzendingen van de studenten binnen de opdracht. Wanneer de cross-check is ingeschakeld, wordt de cross-check sectie zichtbaar in het interactieve Similarity Rapport';
$string['removeaiquiz'] = 'Verberg AI detectie instelling';
$string['aidetection'] = 'AI detectie';
$string['aidetection_help'] = 'Door de functionaliteit in te schakelen, zoekt het systeem naar tekst die is gegenereerd door AI-tools. Als de service niet beschikbaar is, wordt het AI-inhoudrapport niet gegenereerd. Neem contact op met de systeembeheerder om deze functionaliteit in te schakelen.';

$string['updateprotocols'] = 'Update protocollen';
$string['getprotocolsresponse'] = 'Protocollen respons';
$string['countprotocols'] = 'Aantal protocollen: ';
$string['errorprotocol'] = 'Fout';
