<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file for plagiarism_strike, EN
 *
 * File         plagiarism_strike.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// General.
$string['pluginname'] = 'StrikePlagiarism.com';
$string['strike'] = 'плагин StrikePlagiarism.com';
$string['strikeplagiarism'] = 'Strike plagiarism';
$string['strikeexplain'] = 'Для получения дополнительной информации об этой системе и о том, как она работает, см.: <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['task:syncreport'] = 'Синхронизировать отчет StrikePlagiarism.com';
$string['task:getreports'] = 'Синхронизация отчетов StrikePlagiarism.com';
$string['task:sendfiles'] = 'Отправить файлы в StrikePlagiarism.com API';
$string['usestrike'] = 'Использовать плагин';
$string['useadminnotifications'] = 'Уведомлять администратора об ошибках?';
$string['useadminnotifications_help'] = 'Сообщает администратору об ошибках при их возникновении (например, при общении с API StrikePlagiarism.com)';
$string['useteachernotifications'] = 'Уведомлять преподавателя(ей) об ошибках?';
$string['useteachernotifications_help'] = 'Уведомляет преподавателя(ей) об ошибках при их возникновении (например, при коммуникации с API StrikePlagiarism.com)';
$string['strikekey'] = 'Strike API Ключ';
$string['strikekey_help'] = 'API-ключ для использования со strike<br/> Вам нужно получить ключ StrikePlagiarism.com ID, чтобы использовать этот плагин. Для получения дополнительной информации свяжитесь с нами через контактную форму на сайте <a href="http://www.strikeplagiarism.com">www.StrikePlagiarism.com</a>';
$string['strikeserver'] = 'Strike API Host';
$string['strikeserver_help'] = 'Strike server hostname или ip адрес. Введите адрес IP StrikePlagiarism.com с http или https';
$string['studentdisclosuredefault'] = 'Я согласен, что все файлы, которые я загрузил, могут быть отправлены в антиплагиатную систему Strikeplagiarism.com с целью проверки оригинальности текста.';
$string['strikestudentdisclosure'] = 'Я согласен, что все файлы, которые я загрузил, могут быть отправлены в антиплагиатную систему Strikeplagiarism.com с целью проверки оригинальности текста.';
$string['studentdisclosure'] = 'Заявление студента';
$string['studentdisclosure_help'] = 'Этот текст будет отображаться всем учащимся на странице загрузки файлов. Он должен быть принят для продолжения проверки.';
$string['strike_enableplugin'] = 'Включить StrikePlagiarism.com для {$a}';
$string['notifyteachers'] = 'Уведомить преподавателя (ей)';
$string['enableapidebugging'] = 'Включить отладку API';
$string['enableapidebugging_help'] = 'Включите эту опцию, если вы хотите расширенную отладку, предоставляемую API StrikePlagiarism.com.<br/>
Доступны несколько методов отладки. Обратите внимание, что отладка будет <i> только </ i> состоять из информации о связи / трафике на API StrikePlagiarism.com.
';
$string['apidebuggingmtrace'] = 'Включить отладку mtrace?';
$string['apidebuggingmtrace_help'] = 'Включите эту опцию, если вы хотите видеть вывод отладки API как вывод mtrace (). <br/>
Если вы включите это, вывод трассировки будет виден на выходе фоновой задачи (CRON).
';
$string['apidebuggingerrorlog'] = 'Включить отладку error_log?';
$string['apidebuggingerrorlog_help'] = 'Включите эту опцию, если вы хотите видеть вывод отладки API как вывод ошибки. <br/>
Если вы включите это, вывод трассировки будет виден в webserver / php error_log. <br/>
ПРИМЕЧАНИЕ. Это не всегда будет отображаться в зависимости от того, как настроен ваш веб-сервер или PHP.
';
$string['apidebuggingemail'] = 'Включить отладку электронной почты?';
$string['apidebuggingemail_help'] = 'Включите эту опцию, если вы хотите получить вывод отладки API в своем письме. <br/>
Если вы включите это, вывод трассировки будет отправлен на указанный адрес электронной почты. <br/>
ПРИМЕЧАНИЕ. Это может привести к отправке большого количества писем. <br/>
ПРИМЕЧАНИЕ 2. Этот метод использует функцию mail () по умолчанию и не будет всегда доступен. Он работает вне функций почты Moodle.';
$string['apidebuggingemailaddress'] = 'Получатель отладки электронной почты.';
$string['str:settings'] = 'Strike настройки';
$string['str:defaults'] = 'Strike значения по умолчанию';
$string['str:dump'] = 'Strike Dump';
$string['str:debug'] = 'Strike отладка';
$string['allowallsupportedfiles'] = 'Разрешить все поддерживаемые типы файлов';
$string['allowallsupportedfiles_help'] = 'Данная опция позволяет преподавателю ограничь типы файлов, загружаемых на проверку.';
$string['restrictfiles'] = 'Типы файлов';
$string['form:desc:defaults'] = 'Ниже вы можете ввести все параметры по умолчанию, которые будут использоваться при создании и настройке нового модуля активности. <br/>
Значения, введенные здесь, будут служить в качестве значений по умолчанию для конфигурации StrikePlagiarism для этого модуля активности.';
$string['docsendmode'] = 'Отправка документа';
$string['docsendmode_help'] = 'Выберите метод отправки документа на анализ. Вручную, тем самым преподаватель должен будет нажать на документ после его загрузки студентм или, автоматически, когда документ будет отправлен на проверку сразу после загрузи студентом.';
$string['docsendingchoose'] = 'Отправка вручную';
$string['docsendingall'] = 'Автоматическая отправка всех документов';
$string['strike_show_student_status'] = 'Показать статус StrikePlagiarism.com студенту';
$string['strike_show_student_status_help'] = 'Опция позволяет студентам видеть статус отправки документа в StrikePlagiarism.com.';
$string['strike_show_student_report'] = 'Показать отчет подобия студенту';
$string['strike_show_student_report_help'] = 'Отчет подобия дает информацию о фрагментах, найденных как подобные и ссылки на источники, где находятся подобные фрагменты.';
$string['strike_show_student_score'] = 'Показать коэффициент подобия студенту';
$string['strike_show_student_score_help'] = 'Коэффициент подобия - это процентная доля материала, которая совпала с контентом, находящимся в различных источниках.';
$string['strike_addref_method'] = 'Добавить документы в базу данных.';
$string['strike_addref_method_help'] = 'Данная опция позволяет добавлять документы, проверенные в StrikePlagiarism.com, в базу данных системы либо вручную преподавателем либо автоматически после проверки.';
$string['strike_deletereport_method_help'] = 'Данная опция позволяет удалять отчеты подобия всякий раз, когда удаляется или обновляется документ в задании. <br/>
Возможные методы:
<UL>
<li> сохраняет старые отчеты подобия 
<li> удаляет старые отчеты подобия';
$string['strike_deletereport_method'] = 'Удаление отчетов подобия для удаленных/обновленных документов';
$string['strike_studentemail'] = 'Отправить студенту сообщение через электронную почту';
$string['strike_studentemail_help'] = 'Данная опция позволяет информировать студента о заврешении анализа.';
$string['strike_draft_submit'] = 'Время отправки документа';
$string['strike_defaultlang'] = 'Язык документа по умолчанию';
$string['strike_defaultlang_help'] = 'Это язык по умолчанию, используемый для отправки документов на StrikePlagiarism.com. Он является обязательным параметром для их API, однако Moodle не знает этот тип информации';
$string['wordcount'] = 'Минимальное количество слов';
$string['wordcount_help'] = 'Данняй параметр устанавливает минимальное количество слов, которое требуются для загружаемого на анализ текста (документа).';
$string['addrefauto'] = 'Автоматически добавлять докумет в базу данных после проверки';
$string['addrefmanual'] = 'Добавление документа в базу данных после проверки вручную';
$string['deletereportkeep'] = 'Сохранять старые отчеты подобия для удаленных / обновленных документов';
$string['deletereportremove'] = 'Удалять старые отчеты подобия для удаленных / обновленных документов';
$string['submitondraft'] = 'При предворительной проверке';
$string['submitonfinal'] = 'При загрузке работы для оценки';
$string['showwhenclosed'] = 'Когда задание закрыто';
$string['pending'] = 'Файл ожидает отправки на анализ в StrikePlagiarism.com';
$string['processing'] = 'Файл был отправлен в StrikePlagiarism.com и ожидает завершения анализа';
$string['toolarge'] = 'Файл превышает максимальный размер для отправки на StrikePlagiarism.com';
$string['unsupported'] = 'Тип файла не поддерживается StrikePlagiarism.com';
$string['unsupportedfiletype'] = 'Тип файла не поддерживается StrikePlagiarism.com';
$string['unknownwarning'] = 'Произошла ошибка при отправке этого файла в StrikePlagiarism.com';
$string['awaitanalysischoice'] = 'В ожидании отправки на анализ в StrikePlagiarism.com';
$string['previouslysubmitted'] = 'Ранее загружен как';
$string['sendforanalysis'] = 'Отправить на анализ в StrikePlagiarism.com';
$string['indexdocument'] = 'Добавить документ в базу данных StrikePlagiarism.com';
$string['deletestrikefile'] = 'Изъять документ из базы данных StrikePlagiarism.com';
$string['similarity1'] = 'Коэффициент подобия 1';
$string['similarity2'] = 'Коэффициент подобия 2';
$string['similarity3'] = 'Коэффициент подобия 3';
$string['similarity4'] = 'Коэффициент подобия 4';
$string['similarity5'] = 'Коэффициент подобия 5';
$string['filereset'] = 'Файл был удален для повторной отправки в StrikePlagiarism.com';
$string['fileresetfailed'] = 'Ошибка: файл не был удален для повторной отправки в StrikePlagiarism.com';
$string['report'] = 'Отчет подобия StrikePlagiarism.com';
$string['report2'] = 'Интерактивный отчет подобия StrikePlagiarism.com';
$string['reportclick'] = 'Ссылка на отчет подобия StrikePlagiarism.com';
$string['restrictcontent'] = 'Отправить прикрепленный файлы и текст';
$string['restrictcontent_help'] = 'StrikePlagiarism.com позволяет проверять файлы, текст из сообщений форума и вставленный онлайн текст. ';
$string['restrictcontentfiles'] = 'Отправить только прикрепленные файлы';
$string['restrictcontentno'] = 'Отправить все';
$string['restrictcontenttext'] = 'Отправить текст';
$string['config:plagiarism'] = 'Значения конфигурации глобальных настроек StrikePlagiarism.com';
$string['config:defaults'] = 'Настройки по умолчанию модуля StrikePlagiarism.com';
$string['studentemailsubject'] = 'Документ был проверен StrikePlagiarism.com';
$string['studentemailcontent'] = '<p>Уважаемый(-ая) {$a->name} {$a->surname},</p>
Файл, который вы выслали в {$a->modulename}  {$a->coursename} был обработан StrikePlagiarism.com.<br/>
{$a->modulelink}<br/>
c уважением,
{$a->admin}
';

$string['label:user'] = 'Пользователь';
$string['label:author'] = 'Автор';
$string['label:timesubmitted'] = 'Выслан';
$string['label:analysisstatus'] = 'Статус анализа';
$string['label:reportstatus'] = 'Статус отчета';
$string['label:status'] = 'Статус';
$string['label:filename'] = 'Название';
$string['label:modname'] = 'Модуль';
$string['label:actions'] = 'Дайствия';
$string['report:na'] = 'Недоступен';
$string['report:ready'] = 'Готов';
$string['report:available'] = 'Доступен';
$string['analysis:auto'] = 'автоматический';
$string['analysis:manual'] = 'вручную';
$string['analysis:awaitchoice'] = 'ожидание отправки на проверку';
$string['cmoverview'] = 'Статус модуля курса в Strike';
$string['notification:subject'] = 'Сообщение StrikePlagiarism.com  [{$a}]';
$string['notification:errormessage'] = '<p>Уважаемый {$a->fullname}<p>
<p>Произошла ошибка в плагине StrikePlagiarism.com в \'{$a->instancename}\' в курсе \'{$a->coursefullname}\'.<br/>
Возникла ошибка: {$a->errormessage}.</p>
<p>Ниже приведены данные файла:<br/>
Автор: {$a->strikefileauthor}<br/>
Научный руководитель: {$a->strikefilecoordinator}<br/>
Тип документа: {$a->strikefiledocumentkind}<br/>
Название: {$a->strikefiletitle}<br/>
Название файла: {$a->strikefilename}<br/>
GUID: {$a->strikefileguid}<br/>
Время создания: {$a->strikefiletimecreated}
</p>
<p>Пожалуйста, перейдите к <a href="{$a->contexturl}">{$a->contexturlname}</a> подробнее</p>
<p>с уважением,<br/>{$a->signoff}</p>';
$string['messageprovider:strikenotification'] = 'Уведомления об ошибках в StrikePlagiarism.com';
$string['err:strike_selectfiletypes-empty'] = 'Пожалуйста, выберите формат файла для отправки на анализ.<br/>
Если формат файла не будет выбран,  документ не будет отправлен на анатиплагиатный анализ.';
$string['warn:strike_selectfiletypes-empty'] = 'Пожалуйста, выберите формат файла для отправки  на анализ.<br/>
Если формат файла не будет выбран,  документ не будет отправлен на анатиплагиатный анализ.';

$string['test_api_connection'] = 'Проверить API-соединение';
$string['test_api_connection_status'] = 'Статус соединения API';
$string['test_api_connection_help'] = 'Вы можете проверить правильность работы текущего введенного API хоста и ключа API.';
$string['api_status_1'] = 'Соединение в порядке';
$string['api_status_2'] = 'Ключ недействителен';
$string['api_status_3'] = 'Время ожидания соединения';
$string['api_status_4'] = 'Соединение в порядке, сервер не отвечает';
$string['api_status_5'] = 'Код ошибки подключения: {$a->error}';

$string['privacy:metadata:userid'] = 'Информация о пользователе, отправляющем файл на проверку на плагиат.';
$string['privacy:metadata:relateduserid'] = 'Информация о связанных пользователях, отправляющих файл на проверку на плагиат.';
$string['privacy:metadata:plagiarism_strike_files'] = 'Таблица, в которой хранится информация о файлах, отправленных на проверку на антиплагиат.';
$string['privacy:metadata:title'] = 'Название документа.';
$string['privacy:metadata:author'] = 'Имя автора или соавтора отправленного файла.';
$string['privacy:metadata:coordinator'] = 'Промоутер отправленного файла.';
$string['privacy:metadata:md5sum'] = 'Сумма MD5 двоичного документа, отправленного на анализ.';
$string['privacy:metadata:ftimesubmitted'] = 'Время отправки файла StrikePlagiarism.com.';
$string['privacy:metadata:ftimecreated'] = 'Время создания записи файла StrikePlagiarism.com.';
$string['privacy:metadata:ftimemodified'] = 'Время модификации отправки StrikePlagiarism.com.';

$string['privacy:metadata:reportready'] = 'Boolean true, если отчет готов к загрузке, иначе false.';
$string['privacy:metadata:indexed'] = 'Boolean true, если документ был проиндексирован.';
$string['privacy:metadata:factor1'] = 'Значение Коэффициент подобия 1.';
$string['privacy:metadata:factor2'] = 'Значение Коэффициент подобия 2.';
$string['privacy:metadata:factor3'] = 'Значение Коэффициент подобия 3.';
$string['privacy:metadata:factor4'] = 'Значение Коэффициент подобия 4.';
$string['privacy:metadata:factor5'] = 'Значение Коэффициент подобия DLA.';

$string['privacy:metadata:strikefileid'] = 'Идентификатор файла отправки StrikePlagiarism.com.';
$string['privacy:metadata:report'] = 'Отправить данные отчета подобия StrikePlagiarism.com.';
$string['privacy:metadata:timemodified'] = 'Время изменения отчетаподобия StrikePlagiarism.com.';
$string['privacy:metadata:timecreated'] = 'Время создания отчета подобия StrikePlagiarism.com.';
$string['privacy:metadata:plagiarism_strike_reports'] = 'StrikePlagiarism.com создает отчет подобия для каждого отправленного файла. Эта запись хранится в базе данных Moodle. Каждый отчет связан с отправкой пользовательского файла.';

$string['privacy:metadata:filename'] = 'Имя файла, отправленного пользователем.';
$string['privacy:metadata:plagiarism_strike:data'] = 'Персональные данные, переданные из подсистемы антиплагиата.';
$string['privacy:metadata:plagiarism_strike:externalpurpose'] = 'Данный модуль отправляет данные вовне, используя API StrikePlagiarism.com.';

$string['privacy:metadata:guid'] = 'StrikePlagiarism.com создает guid, который является файлом, связанным с отправкой в API StrikePlagiarism.com.';
$string['privacy:metadata:core_files'] = 'StrikePlagiarism.com хранит файлы, которые были загружены в Moodle.';


$string['assignmenttype'] = 'Тип документа';
$string['assignmenttype_0'] = 'Хабилитационная диссертация';
$string['assignmenttype_1'] = 'Докторская диссертация';
$string['assignmenttype_2'] = 'Магистерская диссертация';
$string['assignmenttype_3'] = 'Дипломная работа';
$string['assignmenttype_4'] = 'Курсовая';
$string['assignmenttype_6'] = 'Эссе';
$string['assignmenttype_7'] = 'Статья';
$string['assignmenttype_8'] = 'Кейс стади';
$string['assignmenttype_9'] = 'Инжинерная работа';
$string['assignmenttype_10'] = 'Выпускная квалификационная работа';
$string['assignmenttype_16'] = 'Проект';
$string['assignmenttype_25'] = 'Публикация';
$string['assignmenttype_29'] = 'Другое';
$string['assignmenttype_40'] = 'Автореферат';
$string['assignmenttype_101'] = 'Монография';
$string['assignmenttype_103'] = 'Научный труд';
$string['assignmenttype_300'] = 'Книга';

$string['crosscheckmode'] = 'Режим перекрестной проверки';
$string['crosscheckmode_help'] = 'Режим перекрестной проверки позволяет сравнивать работы студентов в задании в формате 1:1. Раздел перекрестной проверки отображаться в интерактивном отчете подобия в виде источника и не влияет на общий КП.';
$string['removeaiquiz'] = 'Скрыть настройку обнаружения ИИ';
$string['aidetection'] = 'Обнаружение ИИ';
$string['aidetection_help'] = 'После включения данного функционала система начнет поиск текста, сгенерированного инструментами ИИ. Отсутствие отчета о наличии ИИ означает недоступность услуги. Чтобы включить данный функционал, обратитесь к системному администратору.';

$string['updateprotocols'] = 'Обновить протоколы';
$string['getprotocolsresponse'] = 'Ответ протоколов';
$string['countprotocols'] = 'Количество протоколов: ';
$string['errorprotocol'] = 'Ошибка';