<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Script to reset sending a file to STRIKE.
 *
 * File         reset.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @author      R.J. van Dongen <rogier@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


require_once(__DIR__.'/../../config.php');
require_once($CFG->dirroot . '/plagiarism/strike/lib.php');
require_once($CFG->dirroot.'/mod/quiz/locallib.php');


require_login();
require_sesskey();

require_capability('moodle/site:config', context_system::instance());

$redirect = optional_param('redirect', get_local_referer(false), PARAM_URL);
$userid = required_param('userid', PARAM_INT);
$courseid = required_param('courseid', PARAM_INT);
$objectid = required_param('objectid', PARAM_INT);
$contextid = required_param('contextid', PARAM_INT);
$cmid = required_param('cmid', PARAM_INT);

$pageurl = new moodle_url($CFG->wwwroot . '/plagiarism/strike/repeat_event.php');

$params = array();
$params['eventname'] = '\mod_quiz\event\attempt_submitted';
$params['component'] = 'mod_quiz';
$params['target'] = 'attempt';
$params['objectid'] = $objectid;
$params['contextid'] = $contextid;
$params['contextinstanceid'] = $cmid;
$params['userid'] = $userid;

if($event = $DB->get_record('logstore_standard_log', $params)) {
    $eventdata = array();
    $eventdata['eventtype'] = 'quiz_submitted';
    $eventdata['eventname'] = '\mod_quiz\event\attempt_submitted';
    $eventdata['component'] = 'mod_quiz';
    $eventdata['target'] = 'attempt';
    $eventdata['objecttable'] = 'quiz_attempts';
    $eventdata['objectid'] = $objectid;
    $eventdata['contextid'] = $contextid;
    $eventdata['contextinstanceid'] = $cmid;
    $eventdata['userid'] = $userid;
    $eventdata['relateduserid'] = $userid;
    $eventdata['courseid'] = $courseid;
    $eventdata['other']['eventtype'] = 'content_uploaded';
    $eventdata['other']['modulename'] = 'quiz';

    $strike = new \plagiarism_plugin_strike();
    $strike->event_handler($eventdata);

    redirect($redirect, get_string('filereset', 'plagiarism_strike'));
}
redirect($redirect, get_string('fileresetfailed', 'plagiarism_strike'));






