<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Script to display report to end user.
 *
 * File         report2.php
 * Encoding     UTF-8
 *
 * @package     plagiarism_strike
 *
 * @copyright   Sebsoft.nl / Strikeplagiarism.com
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__.'/../../config.php');
require_once($CFG->dirroot.'/plagiarism/strike/lib.php');
require_once($CFG->dirroot . '/plagiarism/strike/3rdp/strikeplagiarism/apitoken.php');
require_once($CFG->dirroot . '/plagiarism/strike/3rdp/strikeplagiarism/api/document/getreport2.php');

require_login();

$fid = required_param('pid', PARAM_INT);
$cmid = required_param('cm', PARAM_INT);
$params = array('pid' => $fid, 'cm' => $cmid);
$pageurl = new moodle_url($CFG->wwwroot . '/plagiarism/strike/report2.php', $params);

$sf = plagiarism_strike\strikefile::get_by_id($fid);

list($course, $cm) = get_course_and_cm_from_cmid($sf->cm);
$context = context_course::instance($course->id);

$PAGE->set_url($pageurl);
$PAGE->set_context($context);

$viewonly = true;

$ismemebergroup = false;
if( $cm->modname == 'assign') {
    require_once("$CFG->dirroot/mod/assign/locallib.php");

    $modulecontext = context_module::instance($cm->id);
    $assign = new assign($modulecontext, false, false);

    if (!empty($assign->get_instance()->teamsubmission)) {
        $authorgroups = groups_get_user_groups($assign->get_course()->id, $sf->userid);
        $authorgroupid = 0;
        if (count($authorgroups) == 1) {
            $authorgroup = reset($authorgroups);
            if(count($authorgroup)) {
                $authorgroupid = $authorgroup[0];
            }
        }
        $mygroups = groups_get_user_groups($assign->get_course()->id, $USER->id);
        $mygroupid = 0;
        if (count($mygroups) == 1) {
            $mygroup = reset($mygroups);
            if(count($mygroup) == 1) {
                $mygroupid = $mygroup[0];
            }
        }
        if($authorgroupid == $mygroupid) {
            $ismemebergroup = true;
        }
    }
}

if (($USER->id !== $sf->userid) && !$ismemebergroup)  {
    require_capability('plagiarism/strike:viewreport', $context);
} else if(!has_capability('plagiarism/strike:viewreport', $context)) { // IT's not teacher
    // Check if student can see this report.
    $config = new \plagiarism_strike\config($sf->cm);
    if ($config->get('strike_show_student_report') == PLAGIARISM_STRIKE_SHOW_NEVER) {
        throw new moodle_exception('nopermissions', 'error', '', 'see report');
    }
}

//It's teacher
if(has_capability('plagiarism/strike:viewreport', $context)) {
    $viewonly = false;
}

$url = \plagiarism_strike\configplagiarism::get('strike_server');
$api = new \strikeplagiarism\api\document\getreport2();
$api->set_viewonly($viewonly);
$api->set_apitoken(\plagiarism_strike\configplagiarism::get('strike_key'));
$api->set_apiurl($url);
$api->set_apisecure(true);
$api->set_documentid($sf->guid);
$api->set_documentlanguage(\plagiarism_strike\configplagiarism::get('strike_defaultlang'));

try {
    $auth = $api->do_request();
} catch (Exception $ex) {
    strikeplagiarism\notifier\report::send_error($ex->getMessage());
}

redirect($url.'/report/?auth='.$auth);

exit;
