<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * this file contains the mandatory filterset class for the dynamic editlog table
 *
 * File         editlog_filterset.php
 * Encoding     UTF-8
 *
 * @package     block_coupon
 *
 * @copyright   Sebsoft.nl
 * @author      RvD <helpdesk@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_coupon\table;

use core_table\local\filter\string_filter;
use core_table\local\filter\integer_filter;

/**
 * this file contains the mandatory filterset class for the dynamic editlog table
 *
 * @package     block_coupon
 *
 * @copyright   Sebsoft.nl
 * @author      RvD <helpdesk@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class editlog_filterset extends \core_table\local\filter\filterset {
    /**
     * Get required filters
     *
     * @return array
     */
    protected function get_required_filters(): array {
        return [
            'fortype' => string_filter::class,
            'procaggregate' => integer_filter::class, // Since we have no "boolean_filter".
        ];
    }

    /**
     * Get optional filters
     *
     * @return array
     */
    protected function get_optional_filters(): array {
        return [];
    }
}
