<?php
/**
 * Chat
 *
 * PHP version 5
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Textmagic API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.22
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace TextMagic\Models;

use \ArrayAccess;
use \TextMagic\ObjectSerializer;

/**
 * Chat Class Doc Comment
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class Chat implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Chat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'originalId' => 'int',
        'phone' => 'string',
        'contact' => '\TextMagic\Models\Contact',
        'unsubscribedContactId' => 'int',
        'unread' => 'int',
        'updatedAt' => '\DateTime',
        'status' => 'string',
        'mute' => 'int',
        'lastMessage' => 'string',
        'direction' => 'string',
        'replyOptionsType' => 'string',
        'from' => 'string',
        'mutedUntil' => '\DateTime',
        'timeLeftMute' => 'int',
        'country' => '\TextMagic\Models\Country',
        'pinned' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => null,
        'originalId' => null,
        'phone' => null,
        'contact' => null,
        'unsubscribedContactId' => null,
        'unread' => null,
        'updatedAt' => 'date-time',
        'status' => null,
        'mute' => null,
        'lastMessage' => null,
        'direction' => null,
        'replyOptionsType' => null,
        'from' => null,
        'mutedUntil' => 'date-time',
        'timeLeftMute' => null,
        'country' => null,
        'pinned' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'originalId' => 'originalId',
        'phone' => 'phone',
        'contact' => 'contact',
        'unsubscribedContactId' => 'unsubscribedContactId',
        'unread' => 'unread',
        'updatedAt' => 'updatedAt',
        'status' => 'status',
        'mute' => 'mute',
        'lastMessage' => 'lastMessage',
        'direction' => 'direction',
        'replyOptionsType' => 'replyOptionsType',
        'from' => 'from',
        'mutedUntil' => 'mutedUntil',
        'timeLeftMute' => 'timeLeftMute',
        'country' => 'country',
        'pinned' => 'pinned'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'originalId' => 'setOriginalId',
        'phone' => 'setPhone',
        'contact' => 'setContact',
        'unsubscribedContactId' => 'setUnsubscribedContactId',
        'unread' => 'setUnread',
        'updatedAt' => 'setUpdatedAt',
        'status' => 'setStatus',
        'mute' => 'setMute',
        'lastMessage' => 'setLastMessage',
        'direction' => 'setDirection',
        'replyOptionsType' => 'setReplyOptionsType',
        'from' => 'setFrom',
        'mutedUntil' => 'setMutedUntil',
        'timeLeftMute' => 'setTimeLeftMute',
        'country' => 'setCountry',
        'pinned' => 'setPinned'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'originalId' => 'getOriginalId',
        'phone' => 'getPhone',
        'contact' => 'getContact',
        'unsubscribedContactId' => 'getUnsubscribedContactId',
        'unread' => 'getUnread',
        'updatedAt' => 'getUpdatedAt',
        'status' => 'getStatus',
        'mute' => 'getMute',
        'lastMessage' => 'getLastMessage',
        'direction' => 'getDirection',
        'replyOptionsType' => 'getReplyOptionsType',
        'from' => 'getFrom',
        'mutedUntil' => 'getMutedUntil',
        'timeLeftMute' => 'getTimeLeftMute',
        'country' => 'getCountry',
        'pinned' => 'getPinned'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    const STATUS_A = 'a';
    const STATUS_C = 'c';
    const STATUS_D = 'd';
    const DIRECTION_CI = 'ci';
    const DIRECTION_CO = 'co';
    const DIRECTION_I = 'i';
    const DIRECTION_O = 'o';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_A,
            self::STATUS_C,
            self::STATUS_D,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_CI,
            self::DIRECTION_CO,
            self::DIRECTION_I,
            self::DIRECTION_O,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['originalId'] = isset($data['originalId']) ? $data['originalId'] : null;
        $this->container['phone'] = isset($data['phone']) ? $data['phone'] : null;
        $this->container['contact'] = isset($data['contact']) ? $data['contact'] : null;
        $this->container['unsubscribedContactId'] = isset($data['unsubscribedContactId']) ? $data['unsubscribedContactId'] : null;
        $this->container['unread'] = isset($data['unread']) ? $data['unread'] : null;
        $this->container['updatedAt'] = isset($data['updatedAt']) ? $data['updatedAt'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['mute'] = isset($data['mute']) ? $data['mute'] : null;
        $this->container['lastMessage'] = isset($data['lastMessage']) ? $data['lastMessage'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['replyOptionsType'] = isset($data['replyOptionsType']) ? $data['replyOptionsType'] : null;
        $this->container['from'] = isset($data['from']) ? $data['from'] : null;
        $this->container['mutedUntil'] = isset($data['mutedUntil']) ? $data['mutedUntil'] : null;
        $this->container['timeLeftMute'] = isset($data['timeLeftMute']) ? $data['timeLeftMute'] : null;
        $this->container['country'] = isset($data['country']) ? $data['country'] : null;
        $this->container['pinned'] = isset($data['pinned']) ? $data['pinned'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['originalId'] === null) {
            $invalidProperties[] = "'originalId' can't be null";
        }
        if ($this->container['phone'] === null) {
            $invalidProperties[] = "'phone' can't be null";
        }
        if ($this->container['contact'] === null) {
            $invalidProperties[] = "'contact' can't be null";
        }
        if ($this->container['unsubscribedContactId'] === null) {
            $invalidProperties[] = "'unsubscribedContactId' can't be null";
        }
        if ($this->container['unread'] === null) {
            $invalidProperties[] = "'unread' can't be null";
        }
        if ($this->container['updatedAt'] === null) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'status', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['mute'] === null) {
            $invalidProperties[] = "'mute' can't be null";
        }
        if ($this->container['lastMessage'] === null) {
            $invalidProperties[] = "'lastMessage' can't be null";
        }
        if ($this->container['direction'] === null) {
            $invalidProperties[] = "'direction' can't be null";
        }
        $allowedValues = $this->getDirectionAllowableValues();
        if (!is_null($this->container['direction']) && !in_array($this->container['direction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'direction', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['replyOptionsType'] === null) {
            $invalidProperties[] = "'replyOptionsType' can't be null";
        }
        if ($this->container['from'] === null) {
            $invalidProperties[] = "'from' can't be null";
        }
        if ($this->container['mutedUntil'] === null) {
            $invalidProperties[] = "'mutedUntil' can't be null";
        }
        if ($this->container['timeLeftMute'] === null) {
            $invalidProperties[] = "'timeLeftMute' can't be null";
        }
        if ($this->container['country'] === null) {
            $invalidProperties[] = "'country' can't be null";
        }
        if ($this->container['pinned'] === null) {
            $invalidProperties[] = "'pinned' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id Chat ID.
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets originalId
     *
     * @return int
     */
    public function getOriginalId()
    {
        return $this->container['originalId'];
    }

    /**
     * Sets originalId
     *
     * @param int $originalId originalId
     *
     * @return $this
     */
    public function setOriginalId($originalId)
    {
        $this->container['originalId'] = $originalId;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string $phone Chat partner's phone number.
     *
     * @return $this
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \TextMagic\Models\Contact
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \TextMagic\Models\Contact $contact contact
     *
     * @return $this
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets unsubscribedContactId
     *
     * @return int
     */
    public function getUnsubscribedContactId()
    {
        return $this->container['unsubscribedContactId'];
    }

    /**
     * Sets unsubscribedContactId
     *
     * @param int $unsubscribedContactId If this field has a value, it means that the chat phone number has been unsubscribed from you and this value is an ID of an Unsubscribed contact entity. See [Get all unsubscribed contacts](https://docs.textmagic.com/#operation/getUnsubscribers).
     *
     * @return $this
     */
    public function setUnsubscribedContactId($unsubscribedContactId)
    {
        $this->container['unsubscribedContactId'] = $unsubscribedContactId;

        return $this;
    }

    /**
     * Gets unread
     *
     * @return int
     */
    public function getUnread()
    {
        return $this->container['unread'];
    }

    /**
     * Sets unread
     *
     * @param int $unread Total unread incoming messages.
     *
     * @return $this
     */
    public function setUnread($unread)
    {
        $this->container['unread'] = $unread;

        return $this;
    }

    /**
     * Gets updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt
     *
     * @param \DateTime $updatedAt Time when the last incoming message arrived at this chat.
     *
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status Chat status:   * **a** - Active;   * **c** - Closed;   * **d** - Deleted.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'status', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets mute
     *
     * @return int
     */
    public function getMute()
    {
        return $this->container['mute'];
    }

    /**
     * Sets mute
     *
     * @param int $mute Indicates when the chat is muted.
     *
     * @return $this
     */
    public function setMute($mute)
    {
        $this->container['mute'] = $mute;

        return $this;
    }

    /**
     * Gets lastMessage
     *
     * @return string
     */
    public function getLastMessage()
    {
        return $this->container['lastMessage'];
    }

    /**
     * Sets lastMessage
     *
     * @param string $lastMessage The last message content of a chat.
     *
     * @return $this
     */
    public function setLastMessage($lastMessage)
    {
        $this->container['lastMessage'] = $lastMessage;

        return $this;
    }

    /**
     * Gets direction
     *
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     *
     * @param string $direction Last message type: * **ci** - incoming call; * **co** - outgoing call; * **i** - incoming message; * **o** - outgoing message.
     *
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowedValues = $this->getDirectionAllowableValues();
        if (!in_array($direction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'direction', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets replyOptionsType
     *
     * @return string
     */
    public function getReplyOptionsType()
    {
        return $this->container['replyOptionsType'];
    }

    /**
     * Sets replyOptionsType
     *
     * @param string $replyOptionsType Used for chats prices.
     *
     * @return $this
     */
    public function setReplyOptionsType($replyOptionsType)
    {
        $this->container['replyOptionsType'] = $replyOptionsType;

        return $this;
    }

    /**
     * Gets from
     *
     * @return string
     */
    public function getFrom()
    {
        return $this->container['from'];
    }

    /**
     * Sets from
     *
     * @param string $from If filled, the value will be used as a sender number for all outgoing messages of a chat.
     *
     * @return $this
     */
    public function setFrom($from)
    {
        $this->container['from'] = $from;

        return $this;
    }

    /**
     * Gets mutedUntil
     *
     * @return \DateTime
     */
    public function getMutedUntil()
    {
        return $this->container['mutedUntil'];
    }

    /**
     * Sets mutedUntil
     *
     * @param \DateTime $mutedUntil Date and time until the chat will be muted.
     *
     * @return $this
     */
    public function setMutedUntil($mutedUntil)
    {
        $this->container['mutedUntil'] = $mutedUntil;

        return $this;
    }

    /**
     * Gets timeLeftMute
     *
     * @return int
     */
    public function getTimeLeftMute()
    {
        return $this->container['timeLeftMute'];
    }

    /**
     * Sets timeLeftMute
     *
     * @param int $timeLeftMute Time left untill the chat will be unmuted (seconds).
     *
     * @return $this
     */
    public function setTimeLeftMute($timeLeftMute)
    {
        $this->container['timeLeftMute'] = $timeLeftMute;

        return $this;
    }

    /**
     * Gets country
     *
     * @return \TextMagic\Models\Country
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param \TextMagic\Models\Country $country country
     *
     * @return $this
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets pinned
     *
     * @return bool
     */
    public function getPinned()
    {
        return $this->container['pinned'];
    }

    /**
     * Sets pinned
     *
     * @param bool $pinned Indicates when the chat is pinned.
     *
     * @return $this
     */
    public function setPinned($pinned)
    {
        $this->container['pinned'] = $pinned;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


