<?php
/**
 * MessagesIcs
 *
 * PHP version 5
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Textmagic API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.22
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace TextMagic\Models;

use \ArrayAccess;
use \TextMagic\ObjectSerializer;

/**
 * MessagesIcs Class Doc Comment
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class MessagesIcs implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'MessagesIcs';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'nextSend' => '\DateTime',
        'rrule' => 'string',
        'session' => '\TextMagic\Models\MessageSession',
        'lastSent' => '\DateTime',
        'contactName' => 'string',
        'parameters' => '\TextMagic\Models\MessagesIcsParameters',
        'type' => 'string',
        'summary' => 'string',
        'textParameters' => '\TextMagic\Models\MessagesIcsTextParameters',
        'firstOccurrence' => '\DateTime',
        'lastOccurrence' => '\DateTime',
        'recipientsCount' => 'int',
        'timezone' => 'string',
        'completed' => 'bool',
        'avatar' => 'string',
        'createdAt' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => null,
        'nextSend' => 'date-time',
        'rrule' => null,
        'session' => null,
        'lastSent' => 'date-time',
        'contactName' => null,
        'parameters' => null,
        'type' => null,
        'summary' => null,
        'textParameters' => null,
        'firstOccurrence' => 'date-time',
        'lastOccurrence' => 'date-time',
        'recipientsCount' => null,
        'timezone' => null,
        'completed' => null,
        'avatar' => null,
        'createdAt' => 'date-time'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'nextSend' => 'nextSend',
        'rrule' => 'rrule',
        'session' => 'session',
        'lastSent' => 'lastSent',
        'contactName' => 'contactName',
        'parameters' => 'parameters',
        'type' => 'type',
        'summary' => 'summary',
        'textParameters' => 'textParameters',
        'firstOccurrence' => 'firstOccurrence',
        'lastOccurrence' => 'lastOccurrence',
        'recipientsCount' => 'recipientsCount',
        'timezone' => 'timezone',
        'completed' => 'completed',
        'avatar' => 'avatar',
        'createdAt' => 'createdAt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'nextSend' => 'setNextSend',
        'rrule' => 'setRrule',
        'session' => 'setSession',
        'lastSent' => 'setLastSent',
        'contactName' => 'setContactName',
        'parameters' => 'setParameters',
        'type' => 'setType',
        'summary' => 'setSummary',
        'textParameters' => 'setTextParameters',
        'firstOccurrence' => 'setFirstOccurrence',
        'lastOccurrence' => 'setLastOccurrence',
        'recipientsCount' => 'setRecipientsCount',
        'timezone' => 'setTimezone',
        'completed' => 'setCompleted',
        'avatar' => 'setAvatar',
        'createdAt' => 'setCreatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'nextSend' => 'getNextSend',
        'rrule' => 'getRrule',
        'session' => 'getSession',
        'lastSent' => 'getLastSent',
        'contactName' => 'getContactName',
        'parameters' => 'getParameters',
        'type' => 'getType',
        'summary' => 'getSummary',
        'textParameters' => 'getTextParameters',
        'firstOccurrence' => 'getFirstOccurrence',
        'lastOccurrence' => 'getLastOccurrence',
        'recipientsCount' => 'getRecipientsCount',
        'timezone' => 'getTimezone',
        'completed' => 'getCompleted',
        'avatar' => 'getAvatar',
        'createdAt' => 'getCreatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    const TYPE_ONCE = 'Once';
    const TYPE_HOURLY = 'Hourly';
    const TYPE_DAILY = 'Daily';
    const TYPE_WEEKLY = 'Weekly';
    const TYPE_MONTHLY = 'Monthly';
    const TYPE_YEARLY = 'Yearly';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ONCE,
            self::TYPE_HOURLY,
            self::TYPE_DAILY,
            self::TYPE_WEEKLY,
            self::TYPE_MONTHLY,
            self::TYPE_YEARLY,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['nextSend'] = isset($data['nextSend']) ? $data['nextSend'] : null;
        $this->container['rrule'] = isset($data['rrule']) ? $data['rrule'] : null;
        $this->container['session'] = isset($data['session']) ? $data['session'] : null;
        $this->container['lastSent'] = isset($data['lastSent']) ? $data['lastSent'] : null;
        $this->container['contactName'] = isset($data['contactName']) ? $data['contactName'] : null;
        $this->container['parameters'] = isset($data['parameters']) ? $data['parameters'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['summary'] = isset($data['summary']) ? $data['summary'] : null;
        $this->container['textParameters'] = isset($data['textParameters']) ? $data['textParameters'] : null;
        $this->container['firstOccurrence'] = isset($data['firstOccurrence']) ? $data['firstOccurrence'] : null;
        $this->container['lastOccurrence'] = isset($data['lastOccurrence']) ? $data['lastOccurrence'] : null;
        $this->container['recipientsCount'] = isset($data['recipientsCount']) ? $data['recipientsCount'] : null;
        $this->container['timezone'] = isset($data['timezone']) ? $data['timezone'] : null;
        $this->container['completed'] = isset($data['completed']) ? $data['completed'] : null;
        $this->container['avatar'] = isset($data['avatar']) ? $data['avatar'] : null;
        $this->container['createdAt'] = isset($data['createdAt']) ? $data['createdAt'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['nextSend'] === null) {
            $invalidProperties[] = "'nextSend' can't be null";
        }
        if ($this->container['rrule'] === null) {
            $invalidProperties[] = "'rrule' can't be null";
        }
        if ($this->container['session'] === null) {
            $invalidProperties[] = "'session' can't be null";
        }
        if ($this->container['lastSent'] === null) {
            $invalidProperties[] = "'lastSent' can't be null";
        }
        if ($this->container['contactName'] === null) {
            $invalidProperties[] = "'contactName' can't be null";
        }
        if ($this->container['parameters'] === null) {
            $invalidProperties[] = "'parameters' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['summary'] === null) {
            $invalidProperties[] = "'summary' can't be null";
        }
        if ($this->container['textParameters'] === null) {
            $invalidProperties[] = "'textParameters' can't be null";
        }
        if ($this->container['firstOccurrence'] === null) {
            $invalidProperties[] = "'firstOccurrence' can't be null";
        }
        if ($this->container['lastOccurrence'] === null) {
            $invalidProperties[] = "'lastOccurrence' can't be null";
        }
        if ($this->container['recipientsCount'] === null) {
            $invalidProperties[] = "'recipientsCount' can't be null";
        }
        if ($this->container['timezone'] === null) {
            $invalidProperties[] = "'timezone' can't be null";
        }
        if ($this->container['completed'] === null) {
            $invalidProperties[] = "'completed' can't be null";
        }
        if ($this->container['avatar'] === null) {
            $invalidProperties[] = "'avatar' can't be null";
        }
        if ($this->container['createdAt'] === null) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id Schedule ID.
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets nextSend
     *
     * @return \DateTime
     */
    public function getNextSend()
    {
        return $this->container['nextSend'];
    }

    /**
     * Sets nextSend
     *
     * @param \DateTime $nextSend The next send date in [ISO 8601](https://en.wikipedia.org/?title=ISO_8601) format.
     *
     * @return $this
     */
    public function setNextSend($nextSend)
    {
        $this->container['nextSend'] = $nextSend;

        return $this;
    }

    /**
     * Gets rrule
     *
     * @return string
     */
    public function getRrule()
    {
        return $this->container['rrule'];
    }

    /**
     * Sets rrule
     *
     * @param string $rrule [iCal RRULE](http://www.kanzaki.com/docs/ical/rrule.html) string.
     *
     * @return $this
     */
    public function setRrule($rrule)
    {
        $this->container['rrule'] = $rrule;

        return $this;
    }

    /**
     * Gets session
     *
     * @return \TextMagic\Models\MessageSession
     */
    public function getSession()
    {
        return $this->container['session'];
    }

    /**
     * Sets session
     *
     * @param \TextMagic\Models\MessageSession $session session
     *
     * @return $this
     */
    public function setSession($session)
    {
        $this->container['session'] = $session;

        return $this;
    }

    /**
     * Gets lastSent
     *
     * @return \DateTime
     */
    public function getLastSent()
    {
        return $this->container['lastSent'];
    }

    /**
     * Sets lastSent
     *
     * @param \DateTime $lastSent The date and time when the last message was sent.
     *
     * @return $this
     */
    public function setLastSent($lastSent)
    {
        $this->container['lastSent'] = $lastSent;

        return $this;
    }

    /**
     * Gets contactName
     *
     * @return string
     */
    public function getContactName()
    {
        return $this->container['contactName'];
    }

    /**
     * Sets contactName
     *
     * @param string $contactName Aggregated contact information. If the message was scheduled to be sent to a single contact, a full name will be returned here. Otherwise, a total amount of contacts will be returned.
     *
     * @return $this
     */
    public function setContactName($contactName)
    {
        $this->container['contactName'] = $contactName;

        return $this;
    }

    /**
     * Gets parameters
     *
     * @return \TextMagic\Models\MessagesIcsParameters
     */
    public function getParameters()
    {
        return $this->container['parameters'];
    }

    /**
     * Sets parameters
     *
     * @param \TextMagic\Models\MessagesIcsParameters $parameters parameters
     *
     * @return $this
     */
    public function setParameters($parameters)
    {
        $this->container['parameters'] = $parameters;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets summary
     *
     * @return string
     */
    public function getSummary()
    {
        return $this->container['summary'];
    }

    /**
     * Sets summary
     *
     * @param string $summary A human-readable summary of the sending schedule.
     *
     * @return $this
     */
    public function setSummary($summary)
    {
        $this->container['summary'] = $summary;

        return $this;
    }

    /**
     * Gets textParameters
     *
     * @return \TextMagic\Models\MessagesIcsTextParameters
     */
    public function getTextParameters()
    {
        return $this->container['textParameters'];
    }

    /**
     * Sets textParameters
     *
     * @param \TextMagic\Models\MessagesIcsTextParameters $textParameters textParameters
     *
     * @return $this
     */
    public function setTextParameters($textParameters)
    {
        $this->container['textParameters'] = $textParameters;

        return $this;
    }

    /**
     * Gets firstOccurrence
     *
     * @return \DateTime
     */
    public function getFirstOccurrence()
    {
        return $this->container['firstOccurrence'];
    }

    /**
     * Sets firstOccurrence
     *
     * @param \DateTime $firstOccurrence First occurence date.
     *
     * @return $this
     */
    public function setFirstOccurrence($firstOccurrence)
    {
        $this->container['firstOccurrence'] = $firstOccurrence;

        return $this;
    }

    /**
     * Gets lastOccurrence
     *
     * @return \DateTime
     */
    public function getLastOccurrence()
    {
        return $this->container['lastOccurrence'];
    }

    /**
     * Sets lastOccurrence
     *
     * @param \DateTime $lastOccurrence Last occurence date (could be `null` if the schedule is endless).
     *
     * @return $this
     */
    public function setLastOccurrence($lastOccurrence)
    {
        $this->container['lastOccurrence'] = $lastOccurrence;

        return $this;
    }

    /**
     * Gets recipientsCount
     *
     * @return int
     */
    public function getRecipientsCount()
    {
        return $this->container['recipientsCount'];
    }

    /**
     * Sets recipientsCount
     *
     * @param int $recipientsCount Amount of actual recipients.
     *
     * @return $this
     */
    public function setRecipientsCount($recipientsCount)
    {
        $this->container['recipientsCount'] = $recipientsCount;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return string
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param string $timezone User-friendly timezone name (with spaces replaced by underscores).
     *
     * @return $this
     */
    public function setTimezone($timezone)
    {
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets completed
     *
     * @return bool
     */
    public function getCompleted()
    {
        return $this->container['completed'];
    }

    /**
     * Sets completed
     *
     * @param bool $completed Indicates that scheduling has been completed.
     *
     * @return $this
     */
    public function setCompleted($completed)
    {
        $this->container['completed'] = $completed;

        return $this;
    }

    /**
     * Gets avatar
     *
     * @return string
     */
    public function getAvatar()
    {
        return $this->container['avatar'];
    }

    /**
     * Sets avatar
     *
     * @param string $avatar A relative link to the contact avatar.
     *
     * @return $this
     */
    public function setAvatar($avatar)
    {
        $this->container['avatar'] = $avatar;

        return $this;
    }

    /**
     * Gets createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt
     *
     * @param \DateTime $createdAt Scheduling creation time.
     *
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        $this->container['createdAt'] = $createdAt;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


