<?php
/**
 * MessagingStatItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Textmagic API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.22
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace TextMagic\Models;

use \ArrayAccess;
use \TextMagic\ObjectSerializer;

/**
 * MessagingStatItem Class Doc Comment
 *
 * @category Class
 * @package  TextMagic
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class MessagingStatItem implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'MessagingStatItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'replyRate' => 'float',
        'date' => '\DateTime',
        'deliveryRate' => 'float',
        'costs' => 'float',
        'messagesReceived' => 'int',
        'messagesSentDelivered' => 'int',
        'messagesSentAccepted' => 'int',
        'messagesSentBuffered' => 'int',
        'messagesSentFailed' => 'int',
        'messagesSentRejected' => 'int',
        'messagesSentParts' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'replyRate' => 'float',
        'date' => 'date-time',
        'deliveryRate' => 'float',
        'costs' => 'float',
        'messagesReceived' => null,
        'messagesSentDelivered' => null,
        'messagesSentAccepted' => null,
        'messagesSentBuffered' => null,
        'messagesSentFailed' => null,
        'messagesSentRejected' => null,
        'messagesSentParts' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'replyRate' => 'replyRate',
        'date' => 'date',
        'deliveryRate' => 'deliveryRate',
        'costs' => 'costs',
        'messagesReceived' => 'messagesReceived',
        'messagesSentDelivered' => 'messagesSentDelivered',
        'messagesSentAccepted' => 'messagesSentAccepted',
        'messagesSentBuffered' => 'messagesSentBuffered',
        'messagesSentFailed' => 'messagesSentFailed',
        'messagesSentRejected' => 'messagesSentRejected',
        'messagesSentParts' => 'messagesSentParts'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'replyRate' => 'setReplyRate',
        'date' => 'setDate',
        'deliveryRate' => 'setDeliveryRate',
        'costs' => 'setCosts',
        'messagesReceived' => 'setMessagesReceived',
        'messagesSentDelivered' => 'setMessagesSentDelivered',
        'messagesSentAccepted' => 'setMessagesSentAccepted',
        'messagesSentBuffered' => 'setMessagesSentBuffered',
        'messagesSentFailed' => 'setMessagesSentFailed',
        'messagesSentRejected' => 'setMessagesSentRejected',
        'messagesSentParts' => 'setMessagesSentParts'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'replyRate' => 'getReplyRate',
        'date' => 'getDate',
        'deliveryRate' => 'getDeliveryRate',
        'costs' => 'getCosts',
        'messagesReceived' => 'getMessagesReceived',
        'messagesSentDelivered' => 'getMessagesSentDelivered',
        'messagesSentAccepted' => 'getMessagesSentAccepted',
        'messagesSentBuffered' => 'getMessagesSentBuffered',
        'messagesSentFailed' => 'getMessagesSentFailed',
        'messagesSentRejected' => 'getMessagesSentRejected',
        'messagesSentParts' => 'getMessagesSentParts'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['replyRate'] = isset($data['replyRate']) ? $data['replyRate'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['deliveryRate'] = isset($data['deliveryRate']) ? $data['deliveryRate'] : null;
        $this->container['costs'] = isset($data['costs']) ? $data['costs'] : null;
        $this->container['messagesReceived'] = isset($data['messagesReceived']) ? $data['messagesReceived'] : null;
        $this->container['messagesSentDelivered'] = isset($data['messagesSentDelivered']) ? $data['messagesSentDelivered'] : null;
        $this->container['messagesSentAccepted'] = isset($data['messagesSentAccepted']) ? $data['messagesSentAccepted'] : null;
        $this->container['messagesSentBuffered'] = isset($data['messagesSentBuffered']) ? $data['messagesSentBuffered'] : null;
        $this->container['messagesSentFailed'] = isset($data['messagesSentFailed']) ? $data['messagesSentFailed'] : null;
        $this->container['messagesSentRejected'] = isset($data['messagesSentRejected']) ? $data['messagesSentRejected'] : null;
        $this->container['messagesSentParts'] = isset($data['messagesSentParts']) ? $data['messagesSentParts'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['replyRate'] === null) {
            $invalidProperties[] = "'replyRate' can't be null";
        }
        if ($this->container['date'] === null) {
            $invalidProperties[] = "'date' can't be null";
        }
        if ($this->container['deliveryRate'] === null) {
            $invalidProperties[] = "'deliveryRate' can't be null";
        }
        if ($this->container['costs'] === null) {
            $invalidProperties[] = "'costs' can't be null";
        }
        if ($this->container['messagesReceived'] === null) {
            $invalidProperties[] = "'messagesReceived' can't be null";
        }
        if ($this->container['messagesSentDelivered'] === null) {
            $invalidProperties[] = "'messagesSentDelivered' can't be null";
        }
        if ($this->container['messagesSentAccepted'] === null) {
            $invalidProperties[] = "'messagesSentAccepted' can't be null";
        }
        if ($this->container['messagesSentBuffered'] === null) {
            $invalidProperties[] = "'messagesSentBuffered' can't be null";
        }
        if ($this->container['messagesSentFailed'] === null) {
            $invalidProperties[] = "'messagesSentFailed' can't be null";
        }
        if ($this->container['messagesSentRejected'] === null) {
            $invalidProperties[] = "'messagesSentRejected' can't be null";
        }
        if ($this->container['messagesSentParts'] === null) {
            $invalidProperties[] = "'messagesSentParts' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets replyRate
     *
     * @return float
     */
    public function getReplyRate()
    {
        return $this->container['replyRate'];
    }

    /**
     * Sets replyRate
     *
     * @param float $replyRate The number of incoming messages divided by the number of total messages.
     *
     * @return $this
     */
    public function setReplyRate($replyRate)
    {
        $this->container['replyRate'] = $replyRate;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime $date Time interval start: empty if the **by** parameter was set to **off**.
     *
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets deliveryRate
     *
     * @return float
     */
    public function getDeliveryRate()
    {
        return $this->container['deliveryRate'];
    }

    /**
     * Sets deliveryRate
     *
     * @param float $deliveryRate Message delivery rate:the number of delivered messages divided by the number of total messages.
     *
     * @return $this
     */
    public function setDeliveryRate($deliveryRate)
    {
        $this->container['deliveryRate'] = $deliveryRate;

        return $this;
    }

    /**
     * Gets costs
     *
     * @return float
     */
    public function getCosts()
    {
        return $this->container['costs'];
    }

    /**
     * Sets costs
     *
     * @param float $costs Cost for sent messages during this period. The costs are in the [Account](https://docs.textmagic.com/#tag/User) currency.
     *
     * @return $this
     */
    public function setCosts($costs)
    {
        $this->container['costs'] = $costs;

        return $this;
    }

    /**
     * Gets messagesReceived
     *
     * @return int
     */
    public function getMessagesReceived()
    {
        return $this->container['messagesReceived'];
    }

    /**
     * Sets messagesReceived
     *
     * @param int $messagesReceived Total received messages count.
     *
     * @return $this
     */
    public function setMessagesReceived($messagesReceived)
    {
        $this->container['messagesReceived'] = $messagesReceived;

        return $this;
    }

    /**
     * Gets messagesSentDelivered
     *
     * @return int
     */
    public function getMessagesSentDelivered()
    {
        return $this->container['messagesSentDelivered'];
    }

    /**
     * Sets messagesSentDelivered
     *
     * @param int $messagesSentDelivered Delivered messages count. As messages are retried for up to 48 hours, this value could change.
     *
     * @return $this
     */
    public function setMessagesSentDelivered($messagesSentDelivered)
    {
        $this->container['messagesSentDelivered'] = $messagesSentDelivered;

        return $this;
    }

    /**
     * Gets messagesSentAccepted
     *
     * @return int
     */
    public function getMessagesSentAccepted()
    {
        return $this->container['messagesSentAccepted'];
    }

    /**
     * Sets messagesSentAccepted
     *
     * @param int $messagesSentAccepted Messages accepted for delivery (in queue) but not yet delivered.
     *
     * @return $this
     */
    public function setMessagesSentAccepted($messagesSentAccepted)
    {
        $this->container['messagesSentAccepted'] = $messagesSentAccepted;

        return $this;
    }

    /**
     * Gets messagesSentBuffered
     *
     * @return int
     */
    public function getMessagesSentBuffered()
    {
        return $this->container['messagesSentBuffered'];
    }

    /**
     * Sets messagesSentBuffered
     *
     * @param int $messagesSentBuffered Messages buffered by endpoint cell phone operators.
     *
     * @return $this
     */
    public function setMessagesSentBuffered($messagesSentBuffered)
    {
        $this->container['messagesSentBuffered'] = $messagesSentBuffered;

        return $this;
    }

    /**
     * Gets messagesSentFailed
     *
     * @return int
     */
    public function getMessagesSentFailed()
    {
        return $this->container['messagesSentFailed'];
    }

    /**
     * Sets messagesSentFailed
     *
     * @param int $messagesSentFailed Messages that have failed for whatever reason, e.g. the destination phone was switched off for 48 hours or the recipient's phone account is out of service.
     *
     * @return $this
     */
    public function setMessagesSentFailed($messagesSentFailed)
    {
        $this->container['messagesSentFailed'] = $messagesSentFailed;

        return $this;
    }

    /**
     * Gets messagesSentRejected
     *
     * @return int
     */
    public function getMessagesSentRejected()
    {
        return $this->container['messagesSentRejected'];
    }

    /**
     * Sets messagesSentRejected
     *
     * @param int $messagesSentRejected Messages that were rejected: invalid Sender ID used (e.g. you cannot use the Sender ID or your own mobile number when sending to the United States and Canada.)
     *
     * @return $this
     */
    public function setMessagesSentRejected($messagesSentRejected)
    {
        $this->container['messagesSentRejected'] = $messagesSentRejected;

        return $this;
    }

    /**
     * Gets messagesSentParts
     *
     * @return int
     */
    public function getMessagesSentParts()
    {
        return $this->container['messagesSentParts'];
    }

    /**
     * Sets messagesSentParts
     *
     * @param int $messagesSentParts Total sent messages **parts** count. Note that this is not equal to the sent messages count, because one message could consist of 1 to 6 parts and users are charged per part, not per message.
     *
     * @return $this
     */
    public function setMessagesSentParts($messagesSentParts)
    {
        $this->container['messagesSentParts'] = $messagesSentParts;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


