<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Define all the backup steps that will be used by the backup_sertifier_activity_task
 * @package    mod_sertifier
 * @subpackage backup-moodle2
 * @copyright  Sertifier <hr@sertifier.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/sertifier/backup/moodle2/restore_sertifier_stepslib.php');

/**
 * Sertifier restore task that provides all the settings and steps to perform one complete restore of the activity
 */
class restore_sertifier_activity_task extends restore_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // No particular settings for this activity.
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        // Sertifier only has one structure step.
        $this->add_step(new restore_sertifier_activity_structure_step('sertifier_structure', 'sertifier.xml'));
    }

    /**
     * Define the contents in the activity that must be
     * processed by the link decoder
     */
    public static function define_decode_contents() {
        $contents = array();

        $contents[] = new restore_decode_content('sertifier', array('name'), 'sertifier');

        return $contents;
    }

    /**
     * Define the decoding rules for links belonging
     * to the activity to be executed by the link decoder
     */
    public static function define_decode_rules() {
        $rules = array();

        $rules[] = new restore_decode_rule('SERTIFIERINDEX', '/mod/sertifier/index.php?id=$1', 'course');
        $rules[] = new restore_decode_rule('SERTIFIERVIEWBYID', '/mod/sertifier/view.php?id=$1', 'course_module');

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * when restoring sertifier logs. It must return
     * one array of objects
     */
    public static function define_restore_log_rules() {
        $rules = array();

        $rules[] = new restore_log_rule('sertifier', 'add', 'view.php?id={course_module}', '{sertifier}');
        $rules[] = new restore_log_rule('sertifier', 'update', 'view.php?id={course_module}', '{sertifier}');
        $rules[] = new restore_log_rule('sertifier', 'view', 'view.php?id={course_module}', '{sertifier}');

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * when restoring course logs. It must return
     * one array of objects
     *
     * Note this rules are applied when restoring course logs
     * by the restore final task, but are defined here at
     * activity level. All them are rules not linked to any module instance (cmid = 0)
     */
    public static function define_restore_log_rules_for_course() {
        $rules = array();

        return $rules;
    }
}
