<?php
// This file is part of the Sertifier Certificate module for Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Certificate module capability definition
 *
 * @package    mod_sertifier
 * @copyright  Sertifier <hr@sertifier.com>
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$capabilities = array(

  'mod/sertifier:addinstance' => array(
      'riskbitmask' => RISK_XSS,
      'captype' => 'write',
      'contextlevel' => CONTEXT_COURSE,
      'archetypes' => array(
          'editingteacher' => CAP_ALLOW,
          'manager' => CAP_ALLOW
      ),
      'clonepermissionsfrom' => 'moodle/course:manageactivities'
  ),

  'mod/sertifier:view' => array(

      'captype' => 'read',
      'contextlevel' => CONTEXT_MODULE,
      'archetypes' => array(
          'student' => CAP_ALLOW,
          'teacher' => CAP_ALLOW,
          'editingteacher' => CAP_ALLOW,
          'manager' => CAP_ALLOW
      ),
      'clonepermissionsfrom' => 'mod/page:view'
  ),

  'mod/sertifier:manage' => array(

      'captype' => 'read',
      'contextlevel' => CONTEXT_MODULE,
      'archetypes' => array(
          'teacher' => CAP_ALLOW,
          'editingteacher' => CAP_ALLOW,
          'manager' => CAP_ALLOW
      )
  ),

);
