define("local_skill5/landing_handshake",["exports","core/notification"],(function(_exports,_notification){var obj;
/**
   * Landing page handshake module for Skill5 integration.
   *
   * @module     local_skill5/landing_handshake
   * @copyright  2025 Skill5
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_notification=(obj=_notification)&&obj.__esModule?obj:{default:obj};_exports.init=(skill5Origin,connectUrl,connectionAssistantUrl)=>{window.console.log("[Moodle] Handshake listener is active. Skill5 Origin:",skill5Origin),window.addEventListener("message",(event=>{const message=event.data;if(window.console.log("[Moodle] Received message from origin:",event.origin,"Message:",message),message&&"SKILL5_PAYMENT_COMPLETED"===message.type)event.origin===skill5Origin||event.origin.includes("skill5.com")?(window.console.log("[Moodle] Payment completed, forwarding to iframe:",message.payload),forwardMessageToIframe(message,skill5Origin)):window.console.warn("[Moodle] Payment message from unexpected origin:",event.origin);else if(event.origin===skill5Origin){if(message&&message.type)switch(message.type){case"SKILL5_IFRAME_READY":window.console.log("[Moodle] Received SKILL5_IFRAME_READY. Sending acknowledgment..."),event.source.postMessage({type:"MOODLE_LISTENER_READY"},event.origin);break;case"SKILL5_SEND_EMAIL":message.payload&&message.payload.email?handleEmailPayload(message.payload.email,connectUrl,connectionAssistantUrl):window.console.error("[Moodle] Email payload is missing or invalid:",message.payload);break;case"SKILL5_OPEN_STRIPE_CHECKOUT":message.payload&&message.payload.url?handleStripeCheckout(message.payload,skill5Origin):window.console.error("[Moodle] Stripe checkout payload is missing or invalid:",message.payload)}}else message&&message.type&&message.type.startsWith("SKILL5_")&&window.console.warn("[Moodle] Message from unexpected origin ignored:",event.origin)}))};const handleEmailPayload=(adminEmail,connectUrl,connectionAssistantUrl)=>{window.console.log("[Moodle] Received email payload:",adminEmail),window.console.log("[Moodle] Calling connect.php via fetch...");const url="".concat(connectUrl,"?email=").concat(encodeURIComponent(adminEmail));fetch(url,{method:"GET",credentials:"same-origin"}).then((response=>(window.console.log("[Moodle] Connect.php response received"),response.ok?(window.console.log("[Moodle] Redirecting to connection_assistant.php"),window.location.href=connectionAssistantUrl,!0):(window.console.error("[Moodle] Connect.php returned error:",response.status),_notification.default.alert("Connection Error","Connection failed. Please try again or contact support.","OK"))))).catch((error=>(window.console.error("[Moodle] Error calling connect.php:",error),_notification.default.alert("Connection Error","Connection failed. Please try again or contact support.","OK"))))},forwardMessageToIframe=(message,targetOrigin)=>{const iframeSelectors=["iframe#skill5-shop-iframe-container","iframe#skill5-lti-catalog-iframe-container","iframe#skill5-iframe-container"];window.console.log("[Moodle] Attempting to forward message to iframe. Target origin:",targetOrigin),window.console.log("[Moodle] Looking for iframes:",iframeSelectors);let iframeFound=!1;for(const selector of iframeSelectors){const skill5Iframe=document.querySelector(selector);if(window.console.log("[Moodle] Checking selector:",selector,"Found:",!!skill5Iframe),skill5Iframe&&skill5Iframe.contentWindow)try{skill5Iframe.contentWindow.postMessage(message,targetOrigin),window.console.log("[Moodle] Message forwarded to iframe successfully:",selector),iframeFound=!0;break}catch(error){window.console.error("[Moodle] Error forwarding message to iframe:",error)}}if(!iframeFound){window.console.error("[Moodle] Skill5 iframe not found. Cannot forward message.");const allIframes=document.querySelectorAll("iframe");window.console.log("[Moodle] All iframes on page:",allIframes.length),allIframes.forEach(((iframe,index)=>{window.console.log("[Moodle] Iframe",index,"- ID:",iframe.id,"Src:",iframe.src)}))}},handleStripeCheckout=(payload,skill5Origin)=>{if(window.console.log("[Moodle] Received checkout request:",payload),payload.url){const checkoutWindow=window.open(payload.url,"skill5_checkout","width=600,height=700,scrollbars=yes,resizable=yes");if(checkoutWindow){checkoutWindow.focus(),window.console.log("[Moodle] Checkout window opened successfully"),showMoodleNotification("stripe_redirecting","info");const checkPopupClosed=setInterval((()=>{if(checkoutWindow.closed){clearInterval(checkPopupClosed),window.console.log("[Moodle] Checkout popup closed, notifying iframe to check status");const message={type:"SKILL5_CHECKOUT_POPUP_CLOSED",payload:{sessionId:payload.sessionId,checkoutSessionId:payload.checkoutSessionId}};forwardMessageToIframe(message,skill5Origin)}}),500)}else window.console.warn("[Moodle] Popup may be blocked. Please allow popups for this site."),showMoodleNotification("stripe_popup_blocked","warning")}else window.console.error("[Moodle] Checkout URL not found in payload:",payload),showMoodleNotification("stripe_payment_error","error")},showMoodleNotification=function(messageKey){let type=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"info",message=messageKey;const messageMap={stripe_redirecting:"Redirecting to payment...",stripe_payment_error:"Error processing payment. Please try again.",stripe_popup_blocked:"Popup may be blocked. Please allow popups for this site.",stripe_checkout_opened:"Payment window opened successfully.",stripe_checkout_failed:"Failed to open payment window. Please try again."};messageMap[messageKey]&&(message=messageMap[messageKey]),window.console.log("[Moodle] [".concat(type.toUpperCase(),"] ").concat(message)),void 0!==_notification.default&&_notification.default.addNotification?_notification.default.addNotification({message:message,type:type}):"undefined"!=typeof M&&M.util&&M.util.add_notification?M.util.add_notification({message:message,type:type}):window.console.log("[Moodle] Notification: ".concat(message))}}));

//# sourceMappingURL=landing_handshake.min.js.map