define("mod_interactivevideo/player/rutube",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Rutube Player class
   *
   * @module     mod_interactivevideo/player/rutube
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.type="rutube",this.useAnimationFrame=!0,this.frequency=.25,this.support={playbackrate:!1,quality:!0,password:!1}}async getInfo(url,node){this.node=node;let self=this,videoId=/(?:https?:\/\/)?(?:www\.)?(?:rutube\.ru\/video\/(?:private\/)?)(.+)/.exec(url)[1],privateKey="",keys=url.split("/?p=");return keys.length>1&&(privateKey=keys[1],privateKey=privateKey.split("&")[0]),videoId=videoId.split("?")[0],new Promise((resolve=>{_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",data:{action:"get_from_url",contextid:M.cfg.contextid,url:"https://rutube.ru/api/play/options/".concat(videoId).concat(""!=privateKey?"?p=".concat(privateKey):""),sesskey:M.cfg.sesskey}}).done((function(data){void 0===data.html&&(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data}),self.posterImage=data.thumbnail_url,self.totaltime=data.duration/1e3,self.title=data.title;let iframeurl="https://rutube.ru/play/embed/".concat(videoId).concat(""!=privateKey?"?p=".concat(privateKey):"");(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,'" src="').concat(iframeurl,'" frameBorder="0" allow="clipboard-write; autoplay"\n                 webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>')),player[node]=document.getElementById(node),self.player=player[node],window.addEventListener("message",(function(event){var message="";try{message=JSON.parse(event.data)}catch(e){return}switch(message.type){case"player:ready":resolve({duration:self.totaltime,title:self.title,posterImage:self.posterImage});break;case"player:currentTime":self.currentTime=message.data.time}}))}))}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};this.showControls=opts.showControls||!1;const node=opts.node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),this.start=start,this.aspectratio=16/9;let videoId=/https:\/\/rutube\.ru\/video\/(?:private\/)?(.+)/.exec(url)[1],privateKey="",keys=url.split("/?p=");keys.length>1&&(privateKey=keys[1],privateKey=privateKey.split("&")[0]),videoId=videoId.split("?")[0],this.videoId=videoId;let self=this;_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",data:{action:"get_from_url",contextid:M.cfg.contextid,url:"https://rutube.ru/api/play/options/".concat(videoId).concat(""!=privateKey?"?p=".concat(privateKey):""),sesskey:M.cfg.sesskey}}).done((function(data){void 0===data.html&&(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data}),self.posterImage=data.thumbnail_url;let totaltime=data.duration/1e3-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=Number(totaltime.toFixed(2)),self.duration=self.end-self.start,self.currentTime=self.start;let html=(0,_jquery.default)(data.html);self.aspectratio=html.attr("width")/html.attr("height"),self.title=data.title;let iframeurl="https://rutube.ru/play/embed/".concat(videoId).concat(""!=privateKey?"?p=".concat(privateKey):"");(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="player" src="'.concat(iframeurl,'" frameBorder="0" allow="clipboard-write; autoplay"\n                 webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>')),player[node]=document.getElementById("player"),self.player=player[node],self.currentQuality="auto",window.addEventListener("message",(function(event){var message="";try{message=JSON.parse(event.data)}catch(e){return}switch(message.type){case"player:qualityList":self.qualities=message.data.list;break;case"player:currentQuality":self.currentQuality=message.data.quality.isAutoQuality?"auto":message.data.quality.quality;break;case"player:changeState":if("playing"===message.data.state){let currentTime=self.currentTime;if((0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),currentTime<self.start)return self.seek(self.start),self.ended=!1,self.paused=!1,void(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying");if(!self.ended&&currentTime>=self.end)return self.ended=!0,self.paused=!0,void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")}else"paused"===message.data.state||"pause"===message.data.state?(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")):"ended"!==message.data.state&&"stopped"!==message.data.state||(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"));break;case"player:ready":(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node));break;case"player:currentTime":self.currentTime=message.data.time,self.currentTime<self.start&&(self.currentTime=self.start,self.seek(self.start)),self.currentTime>self.end+self.frequency&&self.seek(self.end-self.frequency),"paused"===self.state&&(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:self.currentTime});break;case"player:rollState":"play"===message.data.state?((0,_jquery.default)(".video-block, #video-block").addClass("d-none"),(0,_jquery.default)("#start-screen").addClass("bg-transparent d-none"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0")):"complete"===message.data.state&&((0,_jquery.default)(".video-block, #video-block").removeClass("d-none"),(0,_jquery.default)("#start-screen").removeClass("bg-transparent d-none"));break;case"player:error":(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:message.data})}}))})).catch((function(error){(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:error})}))}doCommand(commandJSON){return player[this.node]?player[this.node].contentWindow.postMessage(JSON.stringify(commandJSON),"*"):null}play(){this.doCommand({type:"player:play",data:{}}),this.showControls||this.controlHidden||(this.doCommand({type:"player:hideControls",data:{}}),this.controlHidden=!0),this.paused=!1}async pause(){return await this.doCommand({type:"player:pause",data:{}}),this.paused=!0,!0}stop(starttime){this.doCommand({type:"player:stop",data:{}})}seek(time){if(time&&!isNaN(time))return time<0&&(time=0),this.ended=!1,this.doCommand({type:"player:setCurrentTime",data:{time:time}}),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),time}getCurrentTime(){return player[this.node]?this.currentTime:0}getDuration(){if(!player[this.node])return 0;return this.totaltime}isPaused(){return!player[this.node]||this.paused}isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return!!player[this.node]&&(this.ended||this.currentTime>=this.end)}ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){(0,_jquery.default)(this.player).remove(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}async getState(){if(!player[this.node])return"paused";return await player[this.node].isPaused()?"paused":"playing"}setRate(rate){player[this.node]&&player[this.node].setPlaybackRate(rate)}mute(){this.doCommand({type:"player:mute",data:{}}),this.muted=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0})}unMute(){this.doCommand({type:"player:unMute",data:{}}),this.doCommand({type:"player:setVolume",data:{volume:1}}),this.muted=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1})}isMuted(){return!!player[this.node]&&this.muted}async setQuality(quality){return this.doCommand({type:"player:changeQuality",data:{quality:quality}})}async getQualities(){return player[this.node]?{qualities:["auto",...this.qualities],qualitiesLabel:[M.util.get_string("auto","mod_interactivevideo"),...this.qualities],currentQuality:this.currentQuality}:null}async setCaption(language){return!1}originalPlayer(){return player[this.node]}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=rutube.min.js.map