define("mod_interactivevideo/player/vimeo",["exports","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_checkautoplay){var obj;
/**
   * Vimeo Player class
   *
   * @module     mod_interactivevideo/player/vimeo
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_checkautoplay=(obj=_checkautoplay)&&obj.__esModule?obj:{default:obj};let player={};var _default=class{constructor(){this.type="vimeo",this.useAnimationFrame=!1,this.frequency=.27,this.support={playbackrate:!0,quality:!0,password:!0}}async getInfo(url,node){return this.node=node,new Promise((resolve=>{let VimeoPlayer;const option={url:url,width:1080,height:720},vimeoEvents=player=>{player.on("loaded",(async function(){let title=await player.getVideoTitle(),duration=await player.getDuration();var posterUrl="https://vimeo.com/api/oembed.json?url="+encodeURIComponent(url);const oEmbed=await fetch(posterUrl);oEmbed.ok||resolve(null);const oEmbedData=await oEmbed.json();(403===oEmbedData.domain_status_code||oEmbedData.error)&&resolve(null);let posterImage=oEmbedData.thumbnail_url||"";resolve({duration:duration,title:title,posterImage:posterImage.replace(/_\d+x\d+/,"_720x405")})}))};if(VimeoPlayer)player[node]=new VimeoPlayer(node,option),vimeoEvents(player[node]);else try{require(["https://player.vimeo.com/api/player.js"],(function(Player){VimeoPlayer=Player,player[node]=new Player(node,option),vimeoEvents(player[node])}))}catch(e){return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.message})}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4],showControls=opts.showControls||!1;const node=opts.node||"player";let VimeoPlayer;this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),this.start=start,this.aspectratio=16/9;var posterUrl="https://vimeo.com/api/oembed.json?url="+encodeURIComponent(url);const oEmbed=await fetch(posterUrl);if(!oEmbed.ok)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"});document.getElementById("video-wrapper").style.display="block";const oEmbedData=await oEmbed.json();(403===oEmbedData.domain_status_code||oEmbedData.error)&&(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"}),this.posterImage=oEmbedData.thumbnail_url||"",this.title=oEmbedData.title,this.videoId=oEmbedData.video_id,this.posterImage=this.posterImage.replace(/_\d+x\d+/,"_720x405"),this.aspectratio=oEmbedData.width/oEmbedData.height;let self=this;const option={url:url,width:1080,height:720,autoplay:!showControls,controls:showControls,loop:!1,muted:!0,playsinline:!0,background:!1,byline:!1,portrait:!1,title:!1,transparent:!1,responsive:!1,start_time:start,end_time:end,pip:!1,fullscreen:!1,watch_full_video:!1,keyboard:!1,dnt:!0,chapters:showControls,interactive_markers:showControls,vimeo_logo:!1,initial_quality:"360p"};let ready=!1;const vimeoEvents=player=>{player.on("loaded",(async function(){const iframe=document.querySelector("#".concat(node," iframe"));iframe&&iframe.setAttribute("referrerpolicy","strict-origin");let duration=0;try{duration=await player.getDuration()}catch(e){return}if(duration>0){end=end?Math.min(end,duration-.1):duration-.1,end=Number(end.toFixed(2)),self.end=end,self.duration=self.end-self.start,self.totaltime=Number((duration-.1).toFixed(2)),self.title=await player.getVideoTitle(),player.disableTextTrack();let tracks=await player.getTextTracks();tracks&&tracks.length>0&&(tracks=tracks.map((track=>({label:track.label,code:track.language})))),opts.passwordprotected||(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,qualities:self.getQualities(),reloaded:reloaded}),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player.setVolume(1)}else{document.getElementById("video-wrapper").style.display="block";const startScreen=document.getElementById("start-screen");startScreen&&startScreen.classList.add("d-none");const videoBlock=document.querySelector(".video-block");videoBlock&&videoBlock.classList.add("no-pointer","bg-transparent");const annotationCanvas=document.getElementById("annotation-canvas");annotationCanvas&&annotationCanvas.classList.remove("d-none","w-0")}})),showControls||player.on("play",(async function(){ready||(await player.pause(),player.setCurrentTime(start),player.setVolume(1),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)))})),player.off("play"),player.on("play",(function(){ready&&(self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"))})),player.on("pause",(function(e){ready&&(self.paused=!0,e.seconds>=end?(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):(self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")))})),player.on("timeupdate",(async function(e){ready&&(e.seconds>=end?(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):await player.getPaused()?(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")):(self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")))})),player.on("playbackratechange",(function(e){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e.playbackRate})})),player.on("ended",(function(){ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),player.on("qualitychange",(function(e){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:e.quality})})),player.on("error",(function(e){if("NotAllowedError"!==e.name&&"appendVideoMetadata"!==e.method&&((0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.message}),!showControls)){const $videoblock=document.querySelector(".video-block");$videoblock&&$videoblock.classList.remove("no-pointer")}})),player.on("volumechange",(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:e.volume})}))};if(VimeoPlayer)player[node]=new VimeoPlayer(node,option),vimeoEvents(player[node]);else try{require(["https://player.vimeo.com/api/player.js"],(function(Player){VimeoPlayer=Player,player[node]=new Player(node,option),vimeoEvents(player[node])}))}catch(e){return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.message})}}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}async pause(){return!!player[this.node]&&(await player[this.node].pause(),this.paused=!0,!0)}stop(starttime){player[this.node]&&(player[this.node].setCurrentTime(starttime),player[this.node].pause())}async seek(time){return player[this.node]?(time<0&&(time=0),this.ended=!1,await player[this.node].setCurrentTime(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),time):time}async getCurrentTime(){return player[this.node]?player[this.node].getCurrentTime():0}async getDuration(){if(!player[this.node])return 0;return await player[this.node].getDuration()}async isPaused(){if(!player[this.node])return!0;if(this.paused)return!0;return await player[this.node].getPaused()}async isPlaying(){if(!player[this.node])return!1;if(this.paused)return!1;return!await player[this.node].getPaused()}async isEnded(){if(!player[this.node])return!1;if(this.ended)return!0;return await player[this.node].getEnded()}async ratio(){if(!player[this.node])return 16/9;return await player[this.node].getVideoWidth()/await player[this.node].getVideoHeight()}destroy(){player[this.node]&&player[this.node].destroy(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}async getState(){if(!player[this.node])return"paused";return await player[this.node].getPaused()?"paused":"playing"}setRate(rate){player[this.node]&&player[this.node].setPlaybackRate(rate)}mute(){player[this.node]&&player[this.node].setVolume(0)}unMute(){player[this.node]&&player[this.node].setVolume(1)}async isMuted(){if(!player[this.node])return!1;return 0===await player[this.node].getVolume()}setQuality(quality){return player[this.node]?(player[this.node].setQuality(quality),quality):quality}async getQualities(){if(!player[this.node])return null;let qualities=await player[this.node].getQualities();return{qualities:qualities.map((x=>x.id)),qualitiesLabel:qualities.map((x=>x.label)),currentQuality:qualities.find((x=>x.active)).id}}setCaption(track){return player[this.node]?(""!=track?player[this.node].enableTextTrack(track):player[this.node].disableTextTrack(),track):null}originalPlayer(){return player[this.node]}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=vimeo.min.js.map