define("mod_interactivevideo/player/panopto",["exports","core/event_dispatcher","jquery","core/str","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_str,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Panopto Player class
   *
   * @module     mod_interactivevideo/player/panopto
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var player={};var _default=class{constructor(){this.useAnimationFrame=!0,this.type="panopto",this.frequency=.25,this.support={playbackrate:!0,quality:!1}}async getInfo(url,node){var EmbedApi;this.node=node;const matches=url.match(/^[^/]+:\/\/([^/]*panopto\.[^/]+)\/Panopto\/.+\?id=(.+)$/),serverName=matches[1],sessionId=matches[2];return new Promise((resolve=>{var options={sessionId:sessionId,serverName:serverName,width:1080,height:720,videoParams:{interactivity:"none",showtitle:!1,autohide:!0,offerviewer:!1,autoplay:!0,showbrand:!1},events:{onReady:function(){player[node].muteVideo(),player[node].pauseVideo(),function(){player[node].unmuteVideo(),player[node].setVolume(1);let totaltime=Number(player[node].getDuration().toFixed(2));_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text/plain",data:{action:"get_from_url",contextid:M.cfg.contextid,url:url,sesskey:M.cfg.sesskey},complete:function(res){let doc=(new DOMParser).parseFromString(res.responseText,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");resolve({duration:totaltime,title:title,posterImage:poster})}})}()}}};if(window.EmbedApi)player[node]=new window.EmbedApi(node,options);else{var tag=document.createElement("script");tag.src="https://developers.panopto.com/scripts/embedapi.min.js",tag.type="text/javascript";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onPanoptoEmbedApiReady=function(){EmbedApi=window.EmbedApi,player[node]=new EmbedApi(node,options)}}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4],showControls=opts.showControls||!1;const node=opts.node||"player";var EmbedApi;this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0}),this.start=start,this.end=end;const matches=url.match(/^[^/]+:\/\/([^/]*panopto\.[^/]+)\/Panopto\/.+\?id=(.+)$/),serverName=matches[1],sessionId=matches[2];var ready=!1,self=this;self.aspectratio=16/9;let autoplayBlocked=!1;var options={sessionId:sessionId,serverName:serverName,width:1080,height:720,videoParams:{interactivity:"none",showtitle:!1,autohide:!0,offerviewer:!1,autoplay:!0,showbrand:!1,start:start,hideoverlay:!showControls},events:{onReady:function(){ready||(player[node].muteVideo(),player[node].pauseVideo(),function(){player[node].unmuteVideo(),player[node].setVolume(1);let totaltime=Number(player[node].getDuration().toFixed(2))-self.frequency;if(end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,opts.editform)_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text/plain",data:{action:"get_from_url",contextid:M.cfg.contextid,url:url,sesskey:M.cfg.sesskey},complete:function(res){let doc=(new DOMParser).parseFromString(res.responseText,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");self.title=title,self.posterImage=poster,ready||(ready=!0,autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),showControls||(0,_jquery.default)(".video-block, #video-block").removeClass("no-pointer"))}});else{let tracks=player[node].getCaptionTracks();player[node].disableCaptions(),tracks&&tracks.length>0&&(tracks=tracks.map(((track,i)=>({label:track,code:"code-"+i}))),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,reloaded:reloaded})),ready||(ready=!0,autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),showControls||(0,_jquery.default)(".video-block, #video-block").removeClass("no-pointer"))}}())},onIframeReady:async function(){player[node].muteVideo(),player[node].loadVideo(),player[node].pauseVideo()},onStateChange:function(state){if(!1!==ready)switch(state){case PlayerState.Ended:self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");break;case PlayerState.Playing:(player[node].getCurrentTime()>=self.end||player[node].getCurrentTime()<self.start)&&player[node].seekTo(self.start),(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),self.ended=!1,this.paused=!1;break;case PlayerState.Paused:if(this.paused=!0,!self.ended&&player[node].getCurrentTime()>=self.end-self.frequency)return(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),void(self.ended=!0);(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"),self.ended=!1}else player[node].pauseVideo()},onPlaybackRateChange:function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e})},onError:async function(error){if("playNotAllowed"!==error)"playWithSoundNotAllowed"!==error?(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:error}):ready||player[node].muteVideo();else if((0,_jquery.default)("#start-screen #play").removeClass("d-none"),(0,_jquery.default)("#start-screen #spinner").remove(),(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0"),opts.editform){if(!ready){const errorString=await(0,_str.getString)("errorplaynotallowed","mod_interactivevideo");(0,_jquery.default)("#video-wrapper").after('<div class="noautoplay small text-danger mt-n3 mb-3">'.concat(errorString,"</div>"))}}else autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)))},onLoginShown:function(){(0,_jquery.default)("#start-screen").addClass("d-none"),(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0")}}};if(window.EmbedApi)player[node]=new window.EmbedApi(node,options);else{var tag=document.createElement("script");tag.src="https://developers.panopto.com/scripts/embedapi.min.js",tag.type="text/javascript";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onPanoptoEmbedApiReady=function(){EmbedApi=window.EmbedApi,player[node]=new EmbedApi(node,options)}}}play(){player[this.node]&&(player[this.node].playVideo(),this.paused=!1)}pause(){player[this.node]&&(player[this.node].pauseVideo(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].seekTo(starttime),player[this.node].pauseVideo())}async seek(time){return player[this.node]?(this.ended=!1,new Promise((resolve=>{player[this.node].seekTo(time,!0),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)}))):time}getCurrentTime(){return player[this.node]?player[this.node].getCurrentTime():0}getDuration(){return player[this.node]?player[this.node].getDuration():0}isPaused(){return!player[this.node]||(!!this.paused||player[this.node].getState()==PlayerState.Paused)}isPlaying(){return!!player[this.node]&&(!this.paused&&player[this.node].getState()==PlayerState.Playing)}isEnded(){return!!player[this.node]&&(!!this.ended||(player[this.node].getState()==PlayerState.Ended||player[this.node].getCurrentTime()>=this.end))}ratio(){return 16/9}destroy(){player=null,(0,_jquery.default)("#".concat(this.node)).remove(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return player[this.node]?1===player[this.node].getState()?"playing":2===player[this.node].getState()?"paused":"stopped":"paused"}setRate(rate){return player[this.node]?(player[this.node].setPlaybackRate(rate),rate):rate}mute(){player[this.node]&&(player[this.node].muteVideo(),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].unmuteVideo(),player[this.node].setVolume(1),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&player[this.node].isMuted()}originalPlayer(){return player[this.node]}setCaption(track){player[this.node]&&!1!==player[this.node].hasCaptions()&&(track&&""!==track?(track=track.replace("code-",""),player[this.node].enableCaptions(track)):player[this.node].disableCaptions())}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=panopto.min.js.map