define("mod_interactivevideo/player/soundcloud",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * SoundCloud Player class
   *
   * @module     mod_interactivevideo/player/soundcloud
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var player={};var _default=class{constructor(){this.type="soundcloud",this.frequency=.25,this.support={playbackrate:!1,quality:!1,password:!1},this.useAnimationFrame=!1}async getInfo(url,node){this.node=node;let self=this;const data=await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_from_url",contextid:M.cfg.contextid,url:"https://soundcloud.com/oembed?format=json&url="+encodeURIComponent(url),sesskey:M.cfg.sesskey}});let json=JSON.parse(data);self.title=json.title,self.posterImage=json.thumbnail_url;let ready=!1,$parent=(0,_jquery.default)("#".concat(node)).parent();return(0,_jquery.default)("#".concat(node)).replaceWith(json.html),$parent.find("iframe").attr({id:node,width:"100%",height:"100%",allow:"autoplay; fullscreen;",allowfullscreen:"true"}),new Promise((resolve=>{let SC;const callback=function(){SC=window.SC||SC,player[node]=SC.Widget(node),self.player=player[node],self.player.bind(window.SC.Widget.Events.READY,(function(){self.player.getDuration((function(duration){self.totaltime=Number((duration/1e3).toFixed(2)),ready=!0,resolve({duration:self.totaltime,title:self.title,posterImage:self.posterImage})}))})),self.player.bind(window.SC.Widget.Events.PLAY_PROGRESS,(function(data){if(!ready)return;let currentTime=data.currentPosition/1e3;self.currentTime=currentTime}))};if(window.SC)callback();else{var tag=document.createElement("script");tag.src="https://w.soundcloud.com/player/api.js",tag.async=!0,tag.type="text/javascript";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=function(){SC=window.SC,callback()}}}))}async load(url,start,end){const node=(arguments.length>3&&void 0!==arguments[3]?arguments[3]:{}).node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),this.start=start,this.end=end;let self=this;(0,_jquery.default)(".video-block").remove(),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0");const data=await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_from_url",contextid:M.cfg.contextid,url:"https://soundcloud.com/oembed?format=json&url="+encodeURIComponent(url),sesskey:M.cfg.sesskey}});let json=JSON.parse(data);self.title=json.title,self.posterImage=json.thumbnail_url,self.aspectratio=16/9;let SC,ready=!1;(0,_jquery.default)("#".concat(node)).replaceWith(json.html),(0,_jquery.default)("#video-wrapper").find("iframe").attr({id:node,width:"100%",height:"100%",allow:"autoplay; fullscreen;",allowfullscreen:"true"});const callback=function(){SC=window.SC||SC,player[node]=SC.Widget(node),self.player=player[node],self.player.bind(window.SC.Widget.Events.READY,(function(){self.player.getDuration((function(duration){self.totaltime=Number((duration/1e3).toFixed(2)),self.end=end?Math.min(end,self.totaltime):self.totaltime,self.currentTime=start,self.ended=!1,self.player.seekTo(1e3*start),self.player.pause(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))}))})),self.player.bind(window.SC.Widget.Events.PLAY_PROGRESS,(function(data){if(!ready)return;let currentTime=data.currentPosition/1e3;if(self.currentTime=currentTime,!self.paused){if(!self.ended&&currentTime>=self.end)return self.ended=!0,void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");(self.ended||self.currentTime<self.start)&&(self.ended=!1,self.player.seekTo(1e3*self.start)),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")}})),self.player.bind(window.SC.Widget.Events.PLAY,(function(){ready&&(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"))})),self.player.bind(window.SC.Widget.Events.PAUSE,(function(){ready&&(self.paused=!0,self.ended||(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"))})),self.player.bind(window.SC.Widget.Events.FINISH,(function(){ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),self.player.bind(window.SC.Widget.Events.ERROR,(function(data){(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data})}))};if(window.SC)callback();else{var tag=document.createElement("script");tag.src="https://w.soundcloud.com/player/api.js",tag.async=!0,tag.type="text/javascript";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=function(){SC=window.SC,callback()}}}play(){this.player&&(this.player.play(),this.paused=!1)}pause(){return!!this.player&&(this.player.pause(),this.paused=!0,!0)}stop(starttime){this.player.seekTo(1e3*starttime),this.player.pause()}seek(time){return time=Math.min(time,this.end),time=Math.max(time,this.start),this.ended=!1,new Promise((resolve=>{this.player.seekTo(1e3*time),this.currentTime=time,(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)}))}getCurrentTime(){return new Promise((resolve=>{this.player.getPosition((function(position){resolve(position/1e3)}))}))}getDuration(){return this.totaltime}isPaused(){return!!this.paused||new Promise((resolve=>{this.player.isPaused((function(paused){resolve(paused)}))}))}isPlaying(){return!this.paused&&new Promise((resolve=>{this.player.isPaused((function(paused){resolve(!paused)}))}))}isEnded(){return this.ended||this.currentTime>=this.end}ratio(){return 16/9}destroy(){try{this.player.pause(),(0,_jquery.default)("#".concat(this.node)).remove()}catch(e){}player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return this.isPaused?"paused":"playing"}setRate(){return!1}mute(){this.player.setVolume(0),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0})}unMute(){this.player.setVolume(100),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1})}async isMuted(){return new Promise((resolve=>{this.player.getVolume((function(volume){resolve(0===volume)}))}))}originalPlayer(){return player[this.node]}setCaption(){}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=soundcloud.min.js.map