define("mod_interactivevideo/player/sproutvideo",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Sprout Video Player class
   *
   * @module     mod_interactivevideo/player/sproutvideo
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.type="sproutvideo",this.useAnimationFrame=!0,this.support={playbackrate:!0,quality:!0,password:!0},this.frequency=.1}async getInfo(url,node){this.node=node;let videoId=/(?:https?:\/\/)?(?:[^.]+\.)*(?:sproutvideo\.com\/(?:videos|embed)|vids\.io\/videos)\/(.+)/.exec(url)[1];url.includes("embed")||(videoId=videoId.split("/")[0]),this.videoId=videoId;let self=this;let data=await(async()=>{try{return await _jquery.default.ajax({url:"https://sproutvideo.com/oembed.json?url=https://sproutvideo.com/videos/".concat(videoId),type:"GET",dataType:"json"})}catch{return{error:!0}}})(),iframeurl="";if(data.error){if(iframeurl="https://videos.sproutvideo.com/embed/".concat(videoId),self.title="Private Video",self.aspectratio=16/9,!url.includes("embed"))return null}else{self.title=data.title,self.aspectratio=data.width/data.height,self.posterImage=data.thumbnail_url,iframeurl=(0,_jquery.default)(data.html).attr("src")}return iframeurl+="?fullscreenButton=false&volume=0",(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,"\" class='sproutvideo-player'\n                 src='").concat(iframeurl,'\' frameborder=\'0\' referrerpolicy="no-referrer-when-downgrade"\n                  allow="autoplay; fullscreen; picture-in-picture; encrypted-media;"></iframe>')),new Promise((resolve=>{const executeFunction=player=>{player.bind("ready",(function(){resolve({duration:player.getDuration(),title:player.getVideoTitle(),posterImage:self.posterImage})}))};if(window.SV)player[node]=new window.SV.Player({videoId:videoId.split("/")[0]}),executeFunction(player[node]);else{var tag=document.createElement("script");tag.src="https://c.sproutvideo.com/player_api.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=function(){player[node]=new window.SV.Player({videoId:videoId.split("/")[0]}),executeFunction(player[node])}}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),this.start=start,this.end=end;let videoId=/(?:https?:\/\/)?(?:[^.]+\.)*(?:sproutvideo\.com\/(?:videos|embed)|vids\.io\/videos)\/(.+)/.exec(url)[1];url.includes("embed")||(videoId=videoId.split("/")[0]),this.videoId=videoId;let ready=!1,self=this;self.ended=!1,self.paused=!1;const executeFunction=player=>{player.bind("ready",(function(){let totaltime=Number(player.getDuration()).toFixed(2)-self.frequency;end=end&&0!=end?Math.min(end,totaltime):totaltime,end=Number(end).toFixed(2),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player.setVolume(1)})),player.bind("qualityLevels",(function(event){self.qualities=event.data})),player.bind("qualityLevelChange",(function(event){(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:event.data.height})})),player.bind("rateChange",(function(event){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:event.data})})),player.bind("progress",(function(event){if(!ready)return void player.setVolume(0);let currentTime=event.data.time;currentTime<start&&player.seek(start),currentTime>=end&&(player.seek(start),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),self.ended=!0)})),player.bind("play",(function(){if(!ready)return void player.setVolume(0);let currentTime=player.getCurrentTime();(self.ended||currentTime>=end)&&player.seek(start),self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")})),player.bind("pause",(function(){ready&&(self.paused=!0,player.getCurrentTime()>=end?((0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),self.ended=!0):(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"))})),player.bind("completed",(function(){self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")})),player.bind("volume",(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:e.data})}))};let data=await(async()=>{try{return await _jquery.default.ajax({url:"https://sproutvideo.com/oembed.json?url=https://sproutvideo.com/videos/".concat(videoId),type:"GET",dataType:"json"})}catch{return{error:!0}}})(),iframeurl="";if(data.error)iframeurl="https://videos.sproutvideo.com/embed/".concat(videoId),self.title="Private Video",self.aspectratio=16/9,url.includes("embed")||(0,_event_dispatcher.dispatchEvent)("iv:playerError",{message:"Video not found"});else{self.title=data.title,self.aspectratio=data.width/data.height,self.posterImage=data.thumbnail_url,iframeurl=(0,_jquery.default)(data.html).attr("src")}if(iframeurl+="?fullscreenButton=false&volume=0",showControls||(iframeurl+="&showControls=false&bigPlayButton=false"),start>0&&(iframeurl+="&t=".concat(start)),_jquery.default.get(iframeurl).catch((()=>{(0,_event_dispatcher.dispatchEvent)("iv:playerError",{message:"Video not found"})})),(0,_jquery.default)(".video-block").remove(),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0"),(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,"\" class='sproutvideo-player'\n                 src='").concat(iframeurl,'\' frameborder=\'0\' referrerpolicy="no-referrer-when-downgrade"\n                  allow="autoplay; fullscreen; picture-in-picture; encrypted-media;"></iframe>')),window.SV)player[node]=new window.SV.Player({videoId:videoId.split("/")[0]}),executeFunction(player[node]);else{var tag=document.createElement("script");tag.src="https://c.sproutvideo.com/player_api.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=function(){player[node]=new window.SV.Player({videoId:videoId.split("/")[0]}),executeFunction(player[node])}}}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){player[this.node]&&(player[this.node].pause(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].seek(starttime),player[this.node].pause())}seek(time){if(!player[this.node])return time;time<0&&(time=0),this.ended=!1;let currentTime=this.getCurrentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),player[this.node].seek(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),!0}async getCurrentTime(){return player[this.node]?player[this.node].getCurrentTime():0}async getDuration(){if(!player[this.node])return 0;return await player[this.node].getDuration()}isPaused(){return!player[this.node]||this.paused}isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return!!player[this.node]&&this.ended}ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){player[this.node]?((0,_jquery.default)("#".concat(this.node)).remove(),player[this.node].unbind()):window.console.error("Player is not initialized."),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){if(!player[this.node])return"paused";return this.paused?"paused":"playing"}setRate(rate){player[this.node]&&player[this.node].setPlaybackRate(rate)}mute(){player[this.node]&&player[this.node].setVolume(0)}unMute(){player[this.node]&&player[this.node].setVolume(1)}isMuted(){return!!player[this.node]&&0===player[this.node].getVolume()}setQuality(quality){return player[this.node]?(player[this.node].setQualityLevel(quality),quality):quality}async getQualities(){if(!player[this.node])return null;let qualities=this.qualities,keys=qualities.map((x=>x.height));keys.unshift("auto");let values=qualities.map((x=>x.label));return values.unshift("Auto"),{qualities:keys,qualitiesLabel:values,currentQuality:player[this.node].getQualityLevel()}}setCaption(){return!player[this.node]&&null}originalPlayer(){return player[this.node]}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=sproutvideo.min.js.map