define("mod_interactivevideo/player/kinescope",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Kinescope Player class
   *
   * @module     mod_interactivevideo/player/kinescope
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.type="kinescope",this.useAnimationFrame=!1,this.support={playbackrate:!0,quality:!0,password:!0},this.frequency=.3}async getInfo(url,node){this.node=node;let videoId=/kinescope\.io\/(.*)/.exec(url)[1];this.videoId=videoId;let self=this;return new Promise((resolve=>{const playerEvents=function(playerFactory){window.playerFactory.create(node,{url:"https://kinescope.io/"+videoId,behaviour:{playsInline:!0,keyboard:!1,localStorage:!1,preload:!0},ui:{controls:!0}}).then((function(pl){pl.off(),pl.on(pl.Events.Ready,(async function(event){player[node]=event.target;let totaltime=Number(event.data.duration.toFixed(2));const response=await fetch(url),data=await response.text();let doc=(new DOMParser).parseFromString(data,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");self.title=title,self.posterImage=poster,resolve({duration:totaltime,title:title,posterImage:poster})}))}))};if(window.playerFactory)(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,'" class="kinescope-player"></iframe>')),playerEvents(window.playerFactory);else{var tag=document.createElement("script");tag.src="https://player.kinescope.io/latest/iframe.player.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onKinescopeIframeAPIReady=async function(playerFactory){window.playerFactory=playerFactory,playerEvents()}}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4];const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.start=start,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked");let videoId=/kinescope\.io\/(.*)/.exec(url)[1];this.videoId=videoId;let ready=!1,self=this;self.aspectratio=16/9;const playerEvents=function(playerFactory){playerFactory.create(node,{url:"https://kinescope.io/"+videoId,behaviour:{playsInline:!0,keyboard:!1,localStorage:!1,preload:!0},ui:{controls:showControls}}).then((function(pl){pl.on(pl.Events.Ready,(async function(event){player[node]=event.target;let totaltime=Number(event.data.duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.aspectratio=event.data.aspectRatio.ratio,self.end=end,self.totaltime=Number(totaltime.toFixed(2)),self.duration=self.end-self.start,self.texttracks=event.data.textTracks,self.qualities=event.data.qualities,player[node].disableTextTrack();let tracks=[];if(self.texttracks.length>0&&(self.texttracks.forEach((track=>{tracks.push({label:track.label,code:track.language})})),self.captions=tracks),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,qualities:self.getQualities(),reloaded:reloaded}),opts.editform){const response=await fetch(url),data=await response.text();let doc=(new DOMParser).parseFromString(data,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");self.title=title,self.posterImage=poster}await player[node].seekTo(start),await player[node].pause(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))})),pl.on(pl.Events.Play,(async function(event){if(!ready)return;self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay");await player[node].getCurrentTime()>=end&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),pl.on(pl.Events.Pause,(async function(event){ready&&(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"))})),pl.on(pl.Events.Ended,(function(event){ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),pl.on(pl.Events.TimeUpdate,(async function(event){if(!ready)return;let currentTime=await player[node].getCurrentTime();currentTime<start&&(await player[node].seekTo(start),self.ended=!1),currentTime>end+self.frequency?await player[node].seekTo(end-self.frequency):currentTime>=end?(self.ended=!0,await player[node].seekTo(end),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):self.paused||(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"))})),pl.on(pl.Events.QualityChanged,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:event.quality})})),pl.on(pl.Events.PlaybackRateChange,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerSpeedChange",{rate:event.playbackRate})})),pl.on(pl.Events.Waiting,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerBuffering")})),pl.on(pl.Events.VolumeChange,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:event.data.muted?0:1})}))}))};if(window.Kinescope){(0,_jquery.default)("#".concat(node)).parent().html('<iframe id="'.concat(node,'"></iframe>')),playerEvents(window.playerFactory)}else{var tag=document.createElement("script");tag.src="https://player.kinescope.io/latest/iframe.player.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onKinescopeIframeAPIReady=async function(playerFactory){window.playerFactory=playerFactory,playerEvents(playerFactory)}}}async play(){player[this.node]&&(await player[this.node].play(),this.paused=!1)}async pause(){player[this.node]&&(await player[this.node].pause(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].seekTo(starttime),player[this.node].pause())}async seek(time){if(!player[this.node])return time;time<0&&(time=0);let currentTime=await this.getCurrentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,player[this.node].seekTo(parseFloat(time)),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),time}async getCurrentTime(){return player[this.node]?await player[this.node].getCurrentTime():0}async getDuration(){if(!player[this.node])return 0;return await player[this.node].getDuration()}async isPaused(){if(!player[this.node])return!0;if(this.paused)return!0;return await player[this.node].isPaused()}async isPlaying(){if(!player[this.node])return!1;if(this.paused)return!1;return!await player[this.node].isPaused()}async isEnded(){if(!player[this.node])return!1;if(this.ended)return!0;return await player[this.node].isEnded()}async ratio(){return player[this.node]?this.aspectratio:16/9}async destroy(){player[this.node]?(player[this.node].off(),player[this.node].destroy()):(0,_jquery.default)("#".concat(this.node)).remove(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}async getState(){if(!player[this.node])return"paused";return await player[this.node].isPaused()?"paused":"playing"}setRate(rate){player[this.node]&&player[this.node].setPlaybackRate(rate)}mute(){player[this.node]&&player[this.node].mute()}unMute(){player[this.node]&&(player[this.node].unmute(),player[this.node].setVolume(1))}isMuted(){return!!player[this.node]&&player[this.node].isMuted()}async setQuality(quality){return player[this.node]?(await player[this.node].setVideoQuality(quality),quality):quality}async getQualities(){if(!player[this.node])return null;let qualities=await player[this.node].getVideoQualityList();return{qualities:qualities,qualitiesLabel:qualities.map((x=>"auto"==x?"Auto":x)),currentQuality:await player[this.node].getCurrentVideoQuality()}}async setCaption(language){return player[this.node]?("off"===language||""===language?await player[this.node].disableTextTrack():await player[this.node].enableTextTrack(language),language):null}originalPlayer(){return player[this.node]}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=kinescope.min.js.map