/**
 * Interactive Video module form
 *
 * @module     mod_interactivevideo/mod_form
 * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_interactivevideo/mod_form",["jquery","core/notification","core_form/modalform","core/str"],(function($,notification,ModalForm,str){return{init:function(id,usercontextid,videotypes){let totaltime,player,videowrapper=$("#video-wrapper"),endinput=$("input[name=endtime]"),startinput=$("input[name=starttime]"),startassistinput=$("input[name=startassist]"),endassistinput=$("input[name=endassist]"),totaltimeinput=$("input[name=totaltime]"),videourlinput=$("input[name=videourl]"),sourceinput=$("input[name=source]"),videoinput=$("input[name=video]"),uploadfield=$("#fitem_id_upload"),deletefield=$("#fitem_id_delete"),videofile=$("input[name=videofile]"),videotype=$("input[name=type]"),posterimage=$("input[name=posterimage]"),nameinput=$("input[name=name]");const convertSecondsToHMS=s=>{let hours=Math.floor(s/3600),minutes=Math.floor((s-3600*hours)/60),seconds=s-3600*hours-60*minutes;seconds=seconds.toFixed(2);let result=hours<10?"0"+hours:hours;return result+=":"+(minutes<10?"0"+minutes:minutes),result+=":"+(seconds<10?"0"+seconds:seconds),result};$(document).on("iv:playerReady","#player",(function(){!async function(){window.IVPLAYER=player,player.unMute(),player.audio&&videowrapper.addClass("audio"),videowrapper.show();let ratio=player.aspectratio;ratio<1&&(ratio=1),$("#video-wrapper").css("padding-bottom",1/ratio*100+"%"),""==$('[name="name"]').val()&&$('[name="name"]').val(player.title);const duration=player.totaltime||player.duration||0;totaltime=duration,totaltimeinput.val(totaltime),Number(endinput.val())>0&&Number(endinput.val())>totaltime&&(endinput.val(totaltime),endassistinput.val(convertSecondsToHMS(totaltime))),Number(startinput.val())>0&&Number(startinput.val())>totaltime&&(startinput.val(0),startassistinput.val("00:00:00.00")),"00:00:00.00"!=endassistinput.val()&&""!=endassistinput.val()||(endassistinput.val(convertSecondsToHMS(totaltime)),endinput.val(totaltime)),$("#videototaltime").text(player.live?await str.get_string("live","mod_interactivevideo"):convertSecondsToHMS(totaltime)),player.live?(startassistinput.prop("readonly",!0),endassistinput.prop("readonly",!0)):(startassistinput.prop("readonly",!1),endassistinput.prop("readonly",!1)),posterimage.val(player.posterImage)}()})),$(document).on("iv:playerError",(async function(){let strings=await str.get_strings([{key:"thereisanissueloadingvideo",component:"mod_interactivevideo"}]);videourlinput.addClass("is-invalid"),videourlinput.after('<div class="form-control-feedback invalid-feedback d-inline">'+strings[0]+"</div>")}));nameinput.on("contextmenu",(function(e){e.preventDefault(),nameinput.val(player.title)})),videourlinput.on("input",(async function(){$(".noautoplay").remove(),videourlinput.removeClass("is-invalid"),videourlinput.next(".form-control-feedback").remove();let currenttype=videotype.val();videotype.val(""),player&&player.destroy(),videowrapper.html('<div id="player" style="width:100%; max-width: 100%"></div>');let url=$(this).val().trim();if(""==url)return void videowrapper.hide();url!==videourlinput.attr("data-original")?(nameinput.val(""),startinput.val(0),endinput.val(0),startassistinput.val("00:00:00.00"),endassistinput.val("00:00:00.00")):(nameinput.val(nameinput.attr("data-original")),startinput.val(startinput.attr("data-original")),endinput.val(endinput.attr("data-original")),startassistinput.val(startassistinput.attr("data-original")),endassistinput.val(endassistinput.attr("data-original")));let defaultLoadFunction=type=>{require(["mod_interactivevideo/player/"+type],(function(VP){player=new VP,player.load(url,0,null,{showControls:!0,preload:!0,editform:!0})}))};if(videotypes.includes("yt")||"yt"==currenttype){if(new RegExp("(?:https?:\\/\\/)?(?:www\\.)?(?:youtube\\.com|youtu\\.be|youtube-nocookie\\.com)(?:\\/embed\\/|\\/watch\\?v=|\\/)([^\\/]+)","g").exec(url))return videowrapper.show(),videowrapper.html('<div id="player" class="w-100"></div>'),videotype.val("yt"),void defaultLoadFunction("yt")}if(videotypes.includes("vimeo")||"vimeo"==currenttype){let match=/(?:https?:\/\/)?(?:www\.)?(?:vimeo\.com)\/([^/]+)/g.exec(url);if(match?match[1]:null)return videowrapper.html('<div id="player" class="w-100"></div>'),videotype.val("vimeo"),void defaultLoadFunction("vimeo")}if(videotypes.includes("panopto")||"panopto"==currenttype){if(/(?:https?:\/\/)?(?:www\.)?(?:[^/]*panopto\.[^/]+)\/Panopto\/.+\?id=([^/]+)/g.exec(url))return videowrapper.show(),videotype.val("panopto"),void defaultLoadFunction("panopto")}if(videotypes.includes("dailymotion")||"dailymotion"==currenttype){if(/(?:https?:\/\/)?(?:www\.)?(?:dai\.ly|dailymotion\.com)\/(?:embed\/video\/|video\/|)([^/]+)/g.exec(url))return videowrapper.show(),videowrapper.html('<div id="player" class="w-100"></div>'),videotype.val("dailymotion"),void defaultLoadFunction("dailymotion")}if(videotypes.includes("wistia")||"wistia"==currenttype){let match=/(?:https?:\/\/)?(?:www\.)?(?:wistia\.com)\/medias\/([^/]+)/g.exec(url);if(match?match[1]:null)return videowrapper.show(),videotype.val("wistia"),void defaultLoadFunction("wistia")}if(videotypes.includes("rumble")||"rumble"==currenttype){let match=/https:\/\/rumble.com\/([a-zA-Z0-9]+)/.exec(url);if(match?match[1]:null)return videowrapper.show(),videotype.val("rumble"),void defaultLoadFunction("rumble")}if(videotypes.includes("sproutvideo")||"sproutvideo"==currenttype){let match=/(?:https?:\/\/)?(?:[^.]+\.)*(?:sproutvideo\.com\/(?:videos|embed)|vids\.io\/videos)\/([^/]+)/.exec(url);if(match?match[1]:null)return videowrapper.show(),videotype.val("sproutvideo"),void defaultLoadFunction("sproutvideo")}if(videotypes.includes("kinescope")||"kinescope"==currenttype){let match=/https:\/\/kinescope.io\/(.+)/.exec(url);if(match?match[1]:null)return videowrapper.show(),videotype.val("kinescope"),void defaultLoadFunction("kinescope")}if(videotypes.includes("rutube")||"rutube"==currenttype){let match=/https:\/\/rutube.ru\/video\/(?:private\/)?(.+)/.exec(url);if(match?match[1]:null)return videowrapper.show(),videotype.val("rutube"),void defaultLoadFunction("rutube")}if((videotypes.includes("videolink")||"html5video"==currenttype)&&await(url=>new Promise((resolve=>{if(url.includes(".m3u8")||url.includes(".mpd")){let video=document.createElement("video"),type=url.includes(".m3u8")?"application/vnd.apple.mpegurl":"application/dash+xml";return void(video.canPlayType(type)?resolve(!0):url.includes(".m3u8")?require(["mod_interactivevideo/player/hls"],(function(Hls){Hls.isSupported()?resolve(!0):resolve(!1)})):url.includes(".mpd")?require(["mod_interactivevideo/player/dash"],(function(dashjs){dashjs.MediaPlayer()?resolve(!0):resolve(!1)})):resolve(!1))}const existingVideo=document.querySelector("video");existingVideo&&existingVideo.remove();let video=document.createElement("video");video.src=url,video.addEventListener("canplay",(function(){resolve(!0)})),video.addEventListener("error",(function(){resolve(!1)}))})))(url))return videowrapper.html('<video id="player" class="w-100"></video>'),videotype.val("html5video"),void defaultLoadFunction("html5video");if(videotypes.includes("bunnystream")||"bunnystream"==currenttype){if(/https?:\/\/iframe|player\.mediadelivery\.net\/(?:embed|watch|play)\/\d+\/([a-zA-Z0-9-]+)/i.exec(url))return videowrapper.show(),videotype.val("bunnystream"),void defaultLoadFunction("bunnystream")}if(videotypes.includes("peertube")||"peertube"==currenttype){if(/https:\/\/([^/]+)\/w\/([^/]+)/.exec(url))return videowrapper.show(),videotype.val("peertube"),void defaultLoadFunction("peertube")}if(videotypes.includes("viostream")||"viostream"==currenttype){if(/(?:https?:\/\/)?(?:share\.viostream\.com)\/([a-zA-Z0-9]+)/i.exec(url))return videowrapper.show(),videotype.val("viostream"),void defaultLoadFunction("viostream")}if(videotypes.includes("vidyard")||"vidyard"==currenttype){if(/(?:https?:\/\/)?(?:share\.vidyard\.com)\/watch\/([a-zA-Z0-9]+)/i.exec(url))return videowrapper.show(),videotype.val("vidyard"),void defaultLoadFunction("vidyard")}if(videotypes.includes("vdocipher")||"vdocipher"==currenttype){if(/(?:https?:\/\/)?(?:www\.)?(?:[^.]+\.)*(?:vdocipher\.com)\/dashboard\/video\/([^/]+)/.exec(url))return videowrapper.show(),videotype.val("vdocipher"),void defaultLoadFunction("vdocipher")}if(videotypes.includes("dyntube")||"dyntube"==currenttype){if(/(?:https?:\/\/)?(?:videos\.dyntube\.com|dyntube\.com)\/(?:videos|iframes)\/([^/]+)/.exec(url))return videowrapper.show(),videotype.val("dyntube"),void defaultLoadFunction("dyntube")}if(videotypes.includes("spotify")||"spotify"==currenttype){if(/(?:https?:\/\/)?(?:open\.spotify\.com)\/(episode|track)\/([^/]+)/.exec(url))return videowrapper.show(),videotype.val("spotify"),void defaultLoadFunction("spotify")}if(videotypes.includes("soundcloud")||"soundcloud"==currenttype){if(/(?:https?:\/\/)?(?:www\.)?(?:soundcloud\.com)\/([^/]+)\/([^/]+)/.exec(url))return videowrapper.show(),videotype.val("soundcloud"),void defaultLoadFunction("soundcloud")}const strings=await str.get_strings([{key:"invalidvideourl",component:"mod_interactivevideo"},{key:"error",component:"core"}]);notification.alert(strings[1],strings[0]),videourlinput.val("").addClass("is-invalid"),videowrapper.hide()})),startassistinput.on("click",(function(e){(e.ctrlKey||e.metaKey)&&(startinput.val(0),startassistinput.val("00:00:00.00"))})),startassistinput.on("change blur",(async function(){if(startassistinput.removeClass("is-invalid"),startassistinput.next(".form-control-feedback").remove(),""==startassistinput.val())return;let strings=await str.get_strings([{key:"starttimelesstotaltime",component:"mod_interactivevideo"},{key:"starttimelessthanendtime",component:"mod_interactivevideo"},{key:"invalidtimestampformat",component:"mod_interactivevideo"}]);const parts=startassistinput.val().split(":");let time=3600*Number(parts[0])+60*Number(parts[1])+Number(parts[2]);startinput.val(time.toFixed(2)),Number(startinput.val())>totaltime?(startassistinput.addClass("is-invalid"),startassistinput.next(".form-control-feedback").remove(),startassistinput.after('<div class="form-control-feedback invalid-feedback d-inline">'+strings[0]+"</div>"),startassistinput.val(convertSecondsToHMS(totaltime))):Number(endinput.val())&&0!=Number(endinput.val())&&Number(startinput.val())>Number(endinput.val())?(startassistinput.addClass("is-invalid"),startassistinput.next(".form-control-feedback").remove(),startassistinput.after('<div class="form-control-feedback invalid-feedback d-inline">'+strings[1]+"</div>"),startassistinput.val(convertSecondsToHMS(endinput.val()))):Number(startinput.val())>=Number(endinput.val())&&endassistinput.val(convertSecondsToHMS(0))})),endassistinput.on("click",(function(e){(e.ctrlKey||e.metaKey)&&(endinput.val(totaltime),endassistinput.val(convertSecondsToHMS(totaltime)))})),endassistinput.on("change blur",(async function(){if(endassistinput.removeClass("is-invalid"),endassistinput.next(".invalid-feedback").remove(),""==endassistinput.val())return;const strings=await str.get_strings([{key:"endtimelesstotaltime",component:"mod_interactivevideo"},{key:"endtimegreaterstarttime",component:"mod_interactivevideo"},{key:"invalidtimestampformat",component:"mod_interactivevideo"}]),parts=endassistinput.val().split(":");let time=3600*Number(parts[0])+60*Number(parts[1])+Number(parts[2]);endinput.val(time.toFixed(2)),Number(endinput.val())>totaltime?(endassistinput.addClass("is-invalid"),endassistinput.next(".invalid-feedback").remove(),endassistinput.after('<div class="form-control-feedback invalid-feedback d-inline">'+strings[0]+"</div>"),endassistinput.val(convertSecondsToHMS(totaltime))):Number(startinput.val())&&Number(endinput.val())<Number(startinput.val())?(endassistinput.addClass("is-invalid"),endassistinput.next(".invalid-feedback").remove(),endassistinput.after('<div class="form-control-feedback invalid-feedback d-inline">'+strings[1]+"</div>"),endassistinput.val(convertSecondsToHMS(startinput.val()))):Number(startinput.val())>=Number(endinput.val())&&endassistinput.val(convertSecondsToHMS(totaltime))})),$(document).on("contextmenu","[data-timestamp]",(async function(e){e.preventDefault();const currentTime=await player.getCurrentTime();$(this).val(convertSecondsToHMS(currentTime)),$(this).trigger("change")})),$(document).on("click",".showmore",(function(e){e.preventDefault(),$("#instructions-text .clamp-2").removeClass("clamp-2")})),$(document).on("click",".showless",(function(e){e.preventDefault(),$("#instructions-text > div").addClass("clamp-2")})),$(document).on("click","#id_upload",(async function(){const data={contextid:M.cfg.contextid,id:id,usercontextid:usercontextid};let string=await str.get_string("uploadvideo","mod_interactivevideo");const form=new ModalForm({modalConfig:{title:string},formClass:"mod_interactivevideo\\form\\video_upload_form",args:data});form.show(),form.addEventListener(form.events.FORM_SUBMITTED,(async e=>{const url=e.detail.url;videofile.val(url);let name=e.detail.name;""==$('[name="name"]').val()&&$('[name="name"]').val(name.split(".").slice(0,-1).join(".")),videowrapper.html('<video id="player" class="w-100"></video>'),require(["mod_interactivevideo/player/html5video"],(function(VP){player=new VP,player.load(url,0,null,{showControls:!0,editform:!0})})),videoinput.val(e.detail.video),videotype.val("html5video"),uploadfield.css("display","none"),deletefield.css("display","flex")}))})),$(document).on("change","#id_source",(function(){"file"==$(this).val()?(uploadfield.css("display","flex"),deletefield.css("display","flex"),""==videoinput.val()||"0"==videoinput.val()?(uploadfield.css("display","flex"),deletefield.css("display","none")):(uploadfield.css("display","none"),deletefield.css("display","flex"))):(uploadfield.css("display","none"),deletefield.css("display","none"))})),$(document).on("click","#id_delete",(async function(){const strings=await str.get_strings([{key:"deletevideo",component:"mod_interactivevideo"},{key:"deletevideoconfirm",component:"mod_interactivevideo"},{key:"delete",component:"mod_interactivevideo"}]);try{notification.deleteCancelPromise(strings[0],strings[1],strings[2]).then((()=>{videoinput.val(""),videofile.val(""),videowrapper.empty().hide(),uploadfield.show(),deletefield.hide()})).catch((()=>{}))}catch{notification.saveCancel(strings[0],strings[1],strings[2],(function(){videoinput.val(""),videofile.val(""),videowrapper.empty().hide(),uploadfield.show(),deletefield.hide()}))}})),$(document).ready((function(){if(""!=videourlinput.val()&&(videourlinput.attr("data-original",videourlinput.val()),nameinput.attr("data-original",nameinput.val()),startinput.attr("data-original",startinput.val()),endinput.attr("data-original",endinput.val()),startassistinput.attr("data-original",startassistinput.val()),endassistinput.attr("data-original",endassistinput.val()),videourlinput.trigger("input")),"url"!=sourceinput.val())if(""!=videoinput.val()&&"0"!=videoinput.val()){uploadfield.css("display","none"),deletefield.css("display","flex");const url=videofile.val();videowrapper.html('<video id="player" class="w-100"></video>'),require(["mod_interactivevideo/player/html5video"],(function(VP){player=new VP,player.load(url,0,null,{showControls:!0,editform:!0})}))}else uploadfield.css("display","flex"),deletefield.css("display","none");else uploadfield.css("display","none"),deletefield.css("display","none");"0"==$("[name=completionunlocked]").val()&&($("#warning").removeClass("d-none"),$("[name=videourl], [name=startassist], [name=endassist]").prop("readonly","true"),$("#fitem_id_source, #fitem_id_delete, #fitem_id_upload").hide(),$("#id_upload").prop("disabled","true"),$("#id_delete").prop("disabled","true")),$("#background-loading").fadeOut(300);let $requirejsElements=$(".requirejs");$requirejsElements.length&&$requirejsElements.each((function(){let $this=$(this);require([$this.data("plugin")],(function(Module){(new Module).mform()}))})),setTimeout((function(){uploadfield.removeClass("d-none"),deletefield.removeClass("d-none")}),"file"!=sourceinput.val()?5e3:0)})),startassistinput.val(convertSecondsToHMS(startinput.val())),endassistinput.val(convertSecondsToHMS(endinput.val()))}}}));

//# sourceMappingURL=mod_form.min.js.map