/**
 * View page module
 *
 * @module     mod_interactivevideo/viewannotation
 * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_interactivevideo/viewannotation",["jquery","core/str","core/event_dispatcher","core/toast","mod_interactivevideo/quickform","mod_interactivevideo/libraries/jquery-ui"],(function($,str,eventDispatcher,Toast,quickform){const getString=str.get_string,{dispatchEvent:dispatchEvent}=eventDispatcher,ctRenderer={},isBS5=$("body").hasClass("bs-5"),bsAffix=isBS5?"-bs":"";let annotations,totaltime,activityType,contentTypes,displayoptions,releventAnnotations,completionid,player,lastrun,subvideo,viewedAnno=[];const $videoNav=$("#video-nav"),$interactionNav=$("#interactions-nav"),$loader=$("#background-loading");let $meta=$(".metadata"),$wrapper=$("#wrapper");const renderAnnotationItems=async(annos,start,totaltime)=>{$meta.empty(),$interactionNav.find("ul").empty(),$videoNav.find("ul").empty(),$(".annolistinchapter").empty(),1==displayoptions.preventseeking&&$videoNav.addClass("no-pointer-events"),annos.length>0&&(releventAnnotations=annos,window.IVANNO=annos);let actualduration=totaltime;const skipsegments=annos.filter((x=>"skipsegment"==x.type));skipsegments.length>0&&skipsegments.forEach((x=>{const length=Number(x.title)-Number(x.timestamp);actualduration-=length}));const completableAnno=annos.filter((x=>1==x.hascompletion)),actualAnnotationCounts=completableAnno.length,xp=completableAnno.map((x=>Number(x.xp))).reduce(((a,b)=>a+b),0),completedAnnos=completableAnno.filter((x=>1==x.completed)),xpEarned=completableAnno.map((x=>Number(x.earned))).reduce(((a,b)=>a+b),0)||0;if(actualAnnotationCounts>0&&$meta.append('<span class="d-inline-block iv-mr-3">\n            <i class="bi bi-stopwatch iv-mr-2"></i>'.concat((seconds=>{const hours=Math.floor(seconds/3600),minutes=Math.floor(seconds%3600/60),remainingSeconds=seconds%60;let string="";return hours>0&&(string+=hours+"h "),minutes>0&&(string+=minutes+"m "),remainingSeconds>0&&(string+=remainingSeconds+"s"),string})(Math.ceil(actualduration)),'</span>\n            <span class="d-inline-block iv-mr-3">\n        <i class="bi bi-bullseye iv-mr-2"></i>').concat(completedAnnos.length," / ").concat(actualAnnotationCounts,'</span>\n        <span class="d-inline-block"><i class="bi bi-star iv-mr-2"></i>').concat(xpEarned," / ").concat(xp,"</span>")),1==displayoptions.hidemainvideocontrols||1==displayoptions.hideinteractions)return 1==displayoptions.hidemainvideocontrols&&$wrapper.addClass("no-videonav"),void dispatchEvent("annotationitemsrendered",{annotations:annos,completed:completedAnnos.length,total:actualAnnotationCounts,xp:xpEarned,totalxp:xp});for(const x of annos){const renderer=ctRenderer[x.type];await renderer.renderItemOnVideoNavigation(x)}dispatchEvent("annotationitemsrendered",{annotations:annos,completed:completedAnnos.length,total:actualAnnotationCounts,xp:xpEarned,totalxp:xp});const chapteritems=annos.filter((x=>"skipsegment"!=x.type&&1==x.hascompletion));chapteritems.sort(((a,b)=>a.timestamp-b.timestamp)),chapteritems.forEach((x=>{const advanced=JSON.parse(x.advanced);("1"==advanced.visiblebeforecompleted&&!x.completed||"1"==advanced.visibleaftercompleted&&x.completed)&&$('[data-region="chapterlists"] li').each((function(){const cstart=$(this).data("start"),cend=$(this).data("end");x.timestamp>=cstart&&x.timestamp<cend&&$(this).find(".annolistinchapter").append('<li class="border-bottom anno d-flex align-items-center justify-content-between\n                         px-3 py-2 '.concat(x.completed?"completed":"",'" data-id="').concat(x.id,'" data-timestamp="').concat(x.timestamp,'">\n                         <span class="text-nowrap">\n                         <i class="small bi ').concat(x.completed?"bi-check-circle-fill text-success":"bi-circle",' iv-mr-2"></i>\n                         <i class="').concat(JSON.parse(x.prop).icon,' iv-mr-2"></i></span>\n                         <span class="flex-grow-1 text-truncate">').concat(x.formattedtitle,'</span>\n                         <span class="text-nowrap">').concat(x.xp,'<i class="bi bi-star iv-ml-1"></i></span></li>'))}))})),0==annos.length?$("#chaptertoggle").hide():$("#chaptertoggle").show(),dispatchEvent("chapterrendered",{annotations:annos})},fireConfetti=()=>{let confetti=window.confetti;var animationEnd=Date.now()+5e3,defaults={startVelocity:30,spread:360,ticks:60,zIndex:1055};const randomInRange=(min,max)=>Math.random()*(max-min)+min;var interval=setInterval((function(){var timeLeft=animationEnd-Date.now();if(timeLeft<=0)return clearInterval(interval);var particleCount=timeLeft/5e3*50;return confetti({...defaults,particleCount:particleCount,origin:{x:randomInRange(.1,.3),y:Math.random()-.2}}),confetti({...defaults,particleCount:particleCount,origin:{x:randomInRange(.7,.9),y:Math.random()-.2}}),!0}),250)};window.fireConfetti=fireConfetti;const pop=new Audio(M.cfg.wwwroot+"/mod/interactivevideo/sounds/pop.mp3"),point=new Audio(M.cfg.wwwroot+"/mod/interactivevideo/sounds/point-awarded.mp3");return window.IVAudio={pop:pop,point:point},{renderAnnotationItems:renderAnnotationItems,init:function(url,cmid,interaction,course,userid){let start=arguments.length>5&&void 0!==arguments[5]?arguments[5]:0,end=arguments.length>6?arguments[6]:void 0,completionpercentage=arguments.length>7?arguments[7]:void 0,gradeiteminstance=arguments.length>8?arguments[8]:void 0,grademax=arguments.length>9?arguments[9]:void 0,vtype=arguments.length>10?arguments[10]:void 0,preventskip=!(arguments.length>11&&void 0!==arguments[11])||arguments[11],moment=arguments.length>12&&void 0!==arguments[12]?arguments[12]:null,doptions=arguments.length>13&&void 0!==arguments[13]?arguments[13]:{},token=arguments.length>14&&void 0!==arguments[14]?arguments[14]:null,extendedcompletion=arguments.length>15&&void 0!==arguments[15]?arguments[15]:null,isPreviewMode=arguments.length>16&&void 0!==arguments[16]&&arguments[16],isCompleted=arguments.length>17&&void 0!==arguments[17]&&arguments[17],iseditor=arguments.length>18&&void 0!==arguments[18]&&arguments[18];doptions=$("#doptions").length>0?JSON.parse($("#doptions").text()):doptions;let $remainingtime=$("#remainingtime"),$currenttime=$("#currenttime"),$lightprogressbar=$("#lightprogressbar"),$duration=$("#duration"),$taskinfo=$("#taskinfo"),$seek=$("#seek"),$startscreen=$("#start-screen"),$endscreen=$("#end-screen"),$controller=$("#controller"),$videowrapper=$("#video-wrapper"),$wrapper=$("#wrapper"),$annotationcanvas=$("#annotation-canvas"),$rewindbutton=$("#rewindbutton"),$forwardbutton=$("#forwardbutton"),$body=$("body"),$progressbar=$videoNav.find("#progress"),$seekhead=$videoNav.find("#seekhead");quickform({contextid:M.cfg.contextid,courseid:course,cmid:cmid,interaction:interaction}),require(["theme_boost/bootstrap/modal"]),require(["theme_boost/bootstrap/tooltip"]),start=Number(start),isNaN(start)&&(start=0),end=Number(end),isNaN(end)&&(end=null),displayoptions=doptions,1==displayoptions.hidemainvideocontrols&&1==displayoptions.useoriginalvideocontrols&&$lightprogressbar.remove();let playerReady=!1,uprogress=null,timeended=null;"true"==localStorage.getItem("limitedwidth")&&0==displayoptions.hidemainvideocontrols&&($body.addClass("limited-width"),$controller.find("#expand i").removeClass("bi-file").addClass("bi-square")),"spotify"==vtype&&$body.addClass("limited-width");const convertSecondsToHMS=seconds=>{if(seconds<0)return"00:00";const h=Math.floor(seconds/3600),m=Math.floor(seconds%3600/60),s=Math.floor(seconds%3600%60);return(h>0?h+":":"")+(m<10?"0":"")+m+":"+(s<10?"0":"")+s},replaceProgressBars=async percentage=>{let livestring=await getString("live","mod_interactivevideo");return new Promise((resolve=>{let time=(percentage=percentage>100?100:percentage)/100*totaltime;$currenttime.text(convertSecondsToHMS(time)),$remainingtime.text(player.live?livestring:convertSecondsToHMS(totaltime-time)),$progressbar.css("width",percentage+"%"),$seekhead.css("left",percentage+"%"),$lightprogressbar.css("width",percentage+"%"),resolve(!0)}))},getAnnotations=()=>{const annnoitems=$.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_items",sesskey:M.cfg.sesskey,id:interaction,contextid:M.cfg.courseContextId,token:token,cmid:cmid}}),userprogress=$.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_progress",sesskey:M.cfg.sesskey,id:interaction,uid:userid,token:token,cmid:cmid,contextid:M.cfg.contextid,previewmode:isPreviewMode?1:0}}),getContentTypes=$.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_all_contenttypes",sesskey:M.cfg.sesskey,token:token,cmid:cmid,fromview:1,contextid:M.cfg.contextid}});$.when(annnoitems,userprogress,getContentTypes).done((async function(annos,progress,ct){annotations=JSON.parse(annos[0]),player.live&&(annotations=annotations.filter((x=>x.timestamp<0))),progress=JSON.parse(progress[0]),uprogress=progress,timeended=progress.timeended,contentTypes=JSON.parse(ct[0]),completionid=progress.id;let completiondetails=JSON.parse(progress.completiondetails||"[]");return"object"==typeof completiondetails&&(completiondetails=Object.values(completiondetails)),annotations=function(annotations,contentTypes,start,end){return annotations.filter((annotation=>!!contentTypes.some((y=>y.name===annotation.type))&&("skipsegment"===annotation.type?!(annotation.timestamp>end||annotation.title<start):annotation.timestamp>=start&&annotation.timestamp<=end||annotation.timestamp<0)))}(annotations,contentTypes,start,end),annotations=function(annotations,contentTypes,progress,start,end,completiondetails){const completedItems=""==progress.completeditems?[]:JSON.parse(progress.completeditems),contentTypeMap=new Map(contentTypes.map((ct=>[ct.name,ct])));return annotations.map((annotation=>{annotation.timestamp=Number(annotation.timestamp),annotation.xp=Number(annotation.xp);const completionitem=completiondetails.find((x=>JSON.parse(x).id==annotation.id));if(completionitem){let thisitem=JSON.parse(completionitem);annotation.earned=Number(thisitem.xp),thisitem.percent&&(annotation.earned=annotation.xp*thisitem.percent),annotation.earned>annotation.xp&&(annotation.earned=annotation.xp)}else annotation.earned=0;let advanced;"skipsegment"==annotation.type&&(annotation.title=Number(annotation.title),annotation.timestamp<start&&annotation.title>start&&(annotation.timestamp=start),annotation.title>end&&annotation.timestamp<end&&(annotation.title=end)),annotation.prop=JSON.stringify(contentTypeMap.get(annotation.type)),annotation.completed=completedItems.indexOf(annotation.id)>-1;try{advanced=JSON.parse(annotation.advanced)}catch(e){advanced=null}return annotation.rerunnable=advanced&&"1"===advanced.replaybehavior,annotation}))}(annotations,contentTypes,progress,start,end,completiondetails),annotations.sort(((a,b)=>a.type<b.type?-1:a.type>b.type?1:a.timestamp-b.timestamp)),releventAnnotations=function(annotations){const skipsegments=annotations.filter((annotation=>"skipsegment"==annotation.type));let releventAnnotations=[];return annotations.forEach((annotation=>{let shouldAdd=!0;skipsegments.forEach((skipsegment=>{Number(annotation.timestamp)>Number(skipsegment.timestamp)&&Number(annotation.timestamp)<Number(skipsegment.title)&&(shouldAdd=!1)})),shouldAdd&&(releventAnnotations.push(annotation),isPreviewMode&&(annotation.completed=!0,annotation.previewMode=!0))})),releventAnnotations}(annotations),window.ANNOS=releventAnnotations,releventAnnotations.length>0&&!releventAnnotations.find((x=>"chapter"==x.type))&&await async function(releventAnnotations,start,contentTypes){let startChapter=await getString("startchapter","mod_interactivevideo");releventAnnotations.unshift({id:0,title:startChapter,formattedtitle:startChapter,timestamp:start,type:"chapter",prop:JSON.stringify(contentTypes.find((x=>"chapter"==x.name))),xp:0,completed:!0,hide:!0})}(releventAnnotations,start,contentTypes),await async function(contentTypes,releventAnnotations,player,interaction,course,userid,completionpercentage,gradeiteminstance,grademax,vtype,preventskip,totaltime,start,end,cmid,token,completionid){const chapterContentType=contentTypes.find((x=>"chapter"==x.name));if(0==(contentTypes=contentTypes.filter((x=>releventAnnotations.map((y=>y.type)).includes(x.name)))).length)return void $("#chaptertoggle, #chapter-container-left, #chapter-container-right").remove();$("#chaptertoggle, #chapter-container-left, #chapter-container-right").removeClass("d-none");contentTypes.find((x=>"chapter"==x.name))||contentTypes.push(chapterContentType);await Promise.all(contentTypes.map((contentType=>new Promise((resolve=>{require([contentType.amdmodule],(function(Type){ctRenderer[contentType.name]=new Type(player,releventAnnotations,interaction,course,userid,completionpercentage,gradeiteminstance,grademax,vtype,preventskip,totaltime,start,end,contentType,cmid,token,displayoptions,completionid,extendedcompletion,{isPreviewMode:isPreviewMode,isCompleted:isCompleted,iseditor:iseditor,url:url}),resolve()}))}))))),await Promise.all(contentTypes.map((async contentType=>{try{await ctRenderer[contentType.name].init()}catch(error){}})))}(contentTypes,releventAnnotations,player,interaction,course,userid,completionpercentage,gradeiteminstance,grademax,vtype,preventskip,totaltime,start,end,cmid,token,completionid),await renderAnnotationItems(releventAnnotations,0,end-start),$("#play").removeClass("d-none"),$("#spinner").remove(),$("#video-info").removeClass("d-none"),new Promise((resolve=>{resolve()}))}))},runInteraction=async function(annotation){let force=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(subvideo)return;player.pause();let isPaused=await player.isPaused();if(isPaused){if(lastrun=annotation.id,viewedAnno=[],releventAnnotations.forEach((x=>{Number(x.timestamp)<=Number(annotation.timestamp)&&viewedAnno.push(Number(x.id))})),viewedAnno.push(Number(annotation.id)),viewedAnno=[...new Set(viewedAnno)],$("#annotation-modal").modal("hide"),$("#message").not("[data-placement=bottom]").not(".sticky").not("[data-id=".concat(annotation.id,"]")).remove(),$startscreen.fadeOut(300),$endscreen.fadeOut(300),preventskip){const theAnnotations=releventAnnotations.filter((x=>Number(x.timestamp)<Number(annotation.timestamp)&&0==x.completed&&1==x.hascompletion));if(theAnnotations.length>0){const theAnnotation=theAnnotations[0];return await player.pause(),await player.seek(theAnnotation.timestamp),runInteraction(theAnnotation),void Toast.add(await getString("youmustcompletethistaskfirst","mod_interactivevideo"),{type:"danger"})}}"side"==annotation.displayoptions&&$(".sidebar-nav-item[data-id=".concat(annotation.id,"]")).length>0&&!force?($body.hasClass("hassidebar")||$("#annotation-toggle").trigger("click"),$(".sidebar-nav-item[data-id=".concat(annotation.id,"]")).trigger("click")):(activityType=ctRenderer[annotation.type],setTimeout((()=>{activityType.runInteraction(annotation),$("#message.active").length>0&&$("#message.active").each((function(){const id=$(this).data("id");id!=annotation.id&&($(this).removeClass("active"),dispatchEvent("interactionclose",{annotation:{id:id}}))})),dispatchEvent("interactionrun",{annotation:annotation})}),100))}else runInteraction(annotation)},shareMoment=async()=>{if(!moment)return;const urlParams=new URLSearchParams(window.location.search);urlParams.delete("t");const newurl=window.location.protocol+"//"+window.location.host+window.location.pathname+"?"+urlParams.toString();window.history.replaceState(null,null,newurl)},updateTime=async duration=>{duration=Number(duration);let toUpdatetime=!1;return end&&0!=end||(toUpdatetime=!0),(!start||start>=duration||start<0||start>=duration)&&(toUpdatetime=!0),start=start>duration?0:start,toUpdatetime&&await $.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"update_videotime",sesskey:M.cfg.sesskey,id:interaction,cmid:cmid,courseid:course,start:start,end:end&&0!=end?end:duration,contextid:M.cfg.contextid}}),end=!end||0==end||end>duration?duration:end,{start:start,end:end}};let loaded=!1,lookbacktime=0;const onLoaded=async function(){let reloaded=arguments.length>0&&void 0!==arguments[0]&&arguments[0],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,$changecaption=$("#changecaption");if(e){const captions=e.detail.tracks;if(captions&&captions.length>0){$changecaption.removeClass("d-none"),$changecaption.find(".dropdown-menu").html('<a class="dropdown-item changecaption px-3" data-lang="" href="#">\n                     <i class="bi fa-fw bi-check"></i>'.concat(await getString("off","mod_interactivevideo"),"</a>"));let menu="";captions.forEach(((caption,i)=>{if(menu+='<a class="dropdown-item changecaption text-white px-3"\n                         data-lang="'.concat(caption.code,'" href="#"><i class="bi fa-fw"></i>').concat(caption.label,"</a>"),i==captions.length-1){$changecaption.find(".dropdown-menu").append(menu);const lang=localStorage.getItem("caption-".concat(userid));lang&&lang.length&&$changecaption.find('[data-lang="'.concat(lang,'"]')).trigger("click")}}))}else $changecaption.addClass("d-none")}if(loaded)return;1==displayoptions.passwordprotected&&player.support.password&&($startscreen.removeClass("d-none"),$(".video-block").removeClass("no-pointer bg-transparent")),loaded=!0,window.IVPLAYER=player,lookbacktime=Math.max(.5,player.frequency),0==player.support.playbackrate?$("#changerate").addClass("d-none"):$("#changerate").removeClass("d-none"),0==player.support.quality?$("#changequality").addClass("d-none"):$("#changequality").removeClass("d-none");const duration=player.totaltime;reloaded||({start:start,end:end}=await updateTime(duration)),totaltime=end-start,player.live||$duration.text(convertSecondsToHMS(totaltime));let ratio=16/9;displayoptions.usefixedratio&&0!=displayoptions.usefixedratio||(ratio=player.aspectratio),$videowrapper.css("padding-bottom",1/ratio*100+"%");let gap="125px";if($body.hasClass("embed-mode")?1==displayoptions.hidemainvideocontrols?$("#wrapper").css({width:"calc(100dvh * "+ratio+")"}):$("#wrapper").css({width:"calc((100dvh - 55px) * "+ratio+")"}):(1==displayoptions.hidemainvideocontrols&&(gap="75px"),$("#wrapper").css({width:"calc((100dvh - "+gap+" - 2rem) * "+ratio+")"})),$wrapper.attr("data-ratio",ratio),$wrapper.attr("data-gap",gap),$startscreen.find("#start").focus(),!reloaded){let resizeTimeout,vwrapper=document.querySelector("#video-wrapper"),lastExpandVisible=null;const updateExpandVisibility=()=>{const shouldShow=vwrapper.clientWidth>1050;shouldShow!==lastExpandVisible&&($controller.find("#expand").toggleClass("d-none",!shouldShow),lastExpandVisible=shouldShow)};if(new ResizeObserver((()=>{clearTimeout(resizeTimeout),resizeTimeout=setTimeout(updateExpandVisibility,100)})).observe(vwrapper),updateExpandVisibility(),$body.hasClass("embed-mode"))return;$("#annotation-content")[0].scrollIntoView({behavior:"smooth",block:"end",inline:"nearest"})}},onReady=async function(){let reloaded=arguments.length>0&&void 0!==arguments[0]&&arguments[0],main=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if((window.braveEthereum||window.braveSolana)&&!player.allowAutoplay)return player.destroy(),Toast.add(await getString("braveautoplay","mod_interactivevideo"),{type:"danger",autohide:!1}),void setTimeout((()=>{$("#toast-0").css("margin-top","70px"),$("#interactivevideo-container").addClass("no-pointer-events")}),500);if(!reloaded){player.pause();if(!await player.isPaused())return player.live||await player.seek(start),void onReady()}if(loaded||await onLoaded(reloaded),player.audio&&$annotationcanvas.addClass("bg-black"),$("#annotation-canvas").removeClass("w-0 d-none"),$(".video-block").css("background","transparent"),0==displayoptions.useoriginalvideocontrols&&$(".video-block").removeClass("no-pointer"),reloaded?main?await renderAnnotationItems(releventAnnotations,0,end-start):await renderAnnotationItems([],0,end-start):await getAnnotations(),player.live)return $currenttime.next().removeClass("d-md-inline"),$currenttime.removeClass("d-md-inline"),$duration.text(await getString("live","mod_interactivevideo")),$remainingtime.text(await getString("live","mod_interactivevideo")),$taskinfo.addClass("no-pointer-events"),end=Number.MAX_SAFE_INTEGER,void replaceProgressBars(100);$currenttime.next().addClass("d-md-inline"),$currenttime.addClass("d-md-inline"),reloaded||($seekhead.draggable({containment:"#video-nav",axis:"x",cursor:"col-resize",start:async function(event,ui){await player.isPaused()||player.pause(),$(this).addClass("active"),$taskinfo.addClass("no-pointer-events"),$("#message").not("[data-placement=bottom]").not(".sticky").remove(),$endscreen.fadeOut(300),$seek.append('<div id="position"><div id="timelabel"></div></div>');let $position=$("#position");const relX=ui.position.left;$position.css("left",relX+"px");const percentage=relX/$(this).width(),formattedTime=convertSecondsToHMS(percentage*totaltime);$position.find("#timelabel").text(formattedTime)},drag:async function(event,ui){let timestamp=ui.position.left/$videoNav.width()*totaltime+start,percentage=ui.position.left/$videoNav.width();await replaceProgressBars(100*percentage),$seek.find("#position").css("left",ui.position.left+"px"),$seek.find("#position #timelabel").text(convertSecondsToHMS(timestamp-start)),await player.seek(timestamp)},stop:async function(){lastrun=null,viewedAnno=[],setTimeout((function(){$taskinfo.removeClass("no-pointer-events")}),200),setTimeout((function(){$("#seekhead").removeClass("active"),$seek.find("#position").remove()}),1e3),player.play()}}),dispatchEvent("timeupdate",{time:start}))};let lastSaved;const onPaused=async function(){let savepoint=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(playerReady&&($("#playpause").find("i").removeClass("bi-pause-fill").addClass("bi-play-fill"),$("#playpause").attr("data-original-title",await getString("playtooltip","mod_interactivevideo")),!player.live&&(cancelAnimationFrame(playingInterval),!subvideo&&(savepoint||$body.hasClass("embed-mode")||$body.hasClass("iframe")||$body.hasClass("mobileapp")||navigator.userAgent.includes("MoodleMobile")||$body.hasClass("embed"))))){let t=await player.getCurrentTime(),watchedpoint=Math.round(t);if(Math.abs(watchedpoint-lastSaved)<5&&watchedpoint!=Math.round(end)||watchedpoint<start+5)return;lastSaved=watchedpoint,fetch(M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",{method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded"},body:new URLSearchParams({action:"update_watchedpoint",sesskey:M.cfg.sesskey,completionid:completionid,watchedpoint:watchedpoint,contextid:M.cfg.contextid}).toString(),keepalive:!0})}};let videoEnded=!1;const onEnded=async()=>{if(!playerReady)return;if(videoEnded||player.live)return;if(await player.isPlaying())return player.pause(),void onEnded();onPaused(),dispatchEvent("timeupdate",{time:end}),$("#restart").removeClass("d-none").fadeIn(300),$endscreen.removeClass("d-none").fadeIn(300),dispatchEvent("ended",{time:end}),replaceProgressBars(100),videoEnded=!0,viewedAnno=[],timeended||$.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"update_timeended",sesskey:M.cfg.sesskey,completionid:completionid,contextid:M.cfg.contextid,courseid:course,interactivevideo:interaction,userid:userid,updatestate:extendedcompletion&&1==JSON.parse(extendedcompletion).watchtillend?1:0},success:function(data){try{data=JSON.parse(data)}catch{return}data&&(timeended=!0,dispatchEvent("completionupdated",{response:JSON.stringify({overallcomplete:data.overallcomplete})}))}})},onSeek=async t=>{if(!playerReady)return;if(player.live)return;t=t?Number(t):await player.getCurrentTime(),firstPlay||(window.resumetime=t),t>start&&t<end&&($endscreen.addClass("d-none"),$startscreen.addClass("d-none"));replaceProgressBars((t-start)/totaltime*100),dispatchEvent("timeupdate",{time:t}),viewedAnno=[],releventAnnotations.forEach((x=>{Number(x.timestamp)<t&&viewedAnno.push(Number(x.id))})),lastrun&&releventAnnotations.find((x=>x.id==lastrun)).timestamp>t&&(lastrun=null)};let visualized=!1,playingInterval=null,firstPlay=!1;const onPlaying=async()=>{if(!playerReady)return;if(player.live)return;firstPlay||(dispatchEvent("iv:playerStart"),replaceProgressBars(window.resumetime?(window.resumetime-start)/totaltime*100:0),viewedAnno=[],firstPlay=!0,window.resumetime&&window.resumetime>start&&window.resumetime<end&&(player.allowAutoplay?await player.seek(window.resumetime):(await player.pause(),await player.seek(window.resumetime),player.play())),player.unMute(),dispatchEvent("iv:playerStarted"));const intervalFunction=async function(){const isPlaying=await player.isPlaying(),isEnded=await player.isEnded(),isPaused=await player.isPaused();if(isEnded)return void onEnded();if(isPaused)return void onPaused();if(!isPlaying)return void("spotify"!=player.type&&"rutube"!=player.type&&"yt"!=player.type||(player.pause(),cancelAnimationFrame(playingInterval)));let t=await player.getCurrentTime();if(t=Number(t),t>end)return void onEnded();videoEnded=!1,dispatchEvent("timeupdate",{time:t});const time=Number(t.toFixed(2));let percentagePlayed=(t-start)/totaltime;if(percentagePlayed=percentagePlayed>1?1:percentagePlayed,replaceProgressBars(100*percentagePlayed),subvideo)return;const theAnnotation=releventAnnotations.find((x=>((t-lookbacktime).toFixed(2)<=x.timestamp&&(t+player.frequency).toFixed(2)>=x.timestamp||time==x.timestamp)&&0!=x.id&&!viewedAnno.includes(Number(x.id))));if(theAnnotation){if(viewedAnno=[],releventAnnotations.forEach((x=>{Number(x.timestamp)<t&&viewedAnno.push(Number(x.id))})),$interactionNav.find('.annotation[data-id="'+theAnnotation.id+'"] .item').trigger("mouseover").addClass("active"),isBS5&&$interactionNav.find('.annotation[data-id="'+theAnnotation.id+'"] [data-bs-toggle=tooltip]').tooltip("show"),setTimeout((function(){$interactionNav.find('.annotation[data-id="'+theAnnotation.id+'"] .item').trigger("mouseout").removeClass("active"),isBS5&&$interactionNav.find('.annotation[data-id="'+theAnnotation.id+'"] [data-bs-toggle=tooltip]').tooltip("hide")}),2e3),lastrun&&theAnnotation.id==lastrun)return;if(isPreviewMode)return;!theAnnotation.completed||theAnnotation.rerunnable?(replaceProgressBars((theAnnotation.timestamp-start)/totaltime*100),time<theAnnotation.timestamp-player.frequency&&await player.seek(theAnnotation.timestamp),runInteraction(theAnnotation)):theAnnotation.completed&&(time<theAnnotation.timestamp-player.frequency&&await player.seek(theAnnotation.timestamp),viewedAnno.push(Number(theAnnotation.id)))}};if(player.useAnimationFrame){const animate=async()=>{await player.isPlaying()&&(intervalFunction(),playingInterval=requestAnimationFrame(animate))};playingInterval=requestAnimationFrame(animate)}else{await player.isPlaying()&&intervalFunction()}},onPlay=async()=>{playerReady&&($body.removeClass("disablekb"),player.audio&&!visualized&&(player.visualizer(),visualized=!0),$body.hasClass("mobiletheme")&&!$wrapper.hasClass("fullscreen")&&$("#fullscreen").trigger("click"),$("#playpause").find("i").removeClass("bi-play-fill").addClass("bi-pause-fill"),$("#playpause").attr("data-original-title",await getString("pausetooltip","mod_interactivevideo")),$("#message.active").length>0&&$("#message.active").each((function(){const mid=$(this).data("id");mid&&($(this).removeClass("active"),dispatchEvent("interactionclose",{annotation:{id:mid}}))})),$("#annotation-modal").modal("hide"),$("#message").not("[data-placement=bottom]").not(".sticky").remove(),videoEnded?viewedAnno=[]:($endscreen.fadeOut(300),$startscreen.fadeOut(300),$("#restart").addClass("d-none")),1!=displayoptions.autohidecontrols||$body.hasClass("embed-mode")||$body.hasClass("mobileapp")||$body.hasClass("iframe")||setTimeout((function(){$videowrapper.is(":hover")||$controller.addClass("fadeOut")}),5e3))};require(["mod_interactivevideo/player/"+vtype],(function(VideoPlayer){player=new VideoPlayer,player.poster=$("#posterimagehidden").attr("src"),player.doptions=doptions,player.title=$("#titlehidden").val(),1==displayoptions.passwordprotected&&player.support.password&&($startscreen.addClass("d-none"),$(".video-block").addClass("no-pointer bg-transparent"),$annotationcanvas.removeClass("d-none w-0")),player.load(url,start,end,{showControls:1==displayoptions.useoriginalvideocontrols,customStart:!0,preload:!1,autoplay:1==displayoptions.autoplay,passwordprotected:1==displayoptions.passwordprotected&&player.support.password})}));let $toast=$(".toast-wrapper").detach();$wrapper.append($toast),$(document).on("click",".completion-required",(async function(e){e.preventDefault(),e.stopImmediatePropagation(),Toast.add(await getString("youmustcompletethistaskfirst","mod_interactivevideo"),{type:"danger"})}));const handleUnskippable=async t=>{if(t||(t=await player.getCurrentTime()),!t)return!1;if(releventAnnotations){const theAnnotation=releventAnnotations.find((x=>Number(x.timestamp)<Number(t.toFixed(2))&&0==x.completed&&0==JSON.parse(x.advanced).advskippable&&1==x.hascompletion));if(theAnnotation)return await player.pause(),await player.seek(theAnnotation.timestamp),runInteraction(theAnnotation),Toast.add(await getString("youmustcompletethistaskfirst","mod_interactivevideo"),{type:"danger"}),replaceProgressBars((theAnnotation.timestamp-start)/totaltime*100),!0}return!1};$(document).on("timeupdate",(async function(e){if(!playerReady||isPreviewMode||player.live)return;const t=e.originalEvent.detail.time;if(preventskip&&releventAnnotations){const theAnnotations=releventAnnotations.filter((x=>Number(x.timestamp)<Number(t.toFixed(2))&&0==x.completed&&1==x.hascompletion));if(theAnnotations.length>0){const theAnnotation=theAnnotations[0];await player.pause(),await player.seek(theAnnotation.timestamp),runInteraction(theAnnotation),Toast.add(await getString("youmustcompletethistaskfirst","mod_interactivevideo"),{type:"danger"}),replaceProgressBars((theAnnotation.timestamp-start)/totaltime*100)}}handleUnskippable(t)})),$(document).on("click","#message #refresh",(function(e){e.preventDefault(),e.stopImmediatePropagation(),$(this).tooltip("hide");const id=$(this).data("id"),annotation=releventAnnotations.find((x=>x.id==id));$(this).closest("#message").remove(),dispatchEvent("interactionrefresh",{annotation:annotation}),runInteraction(annotation,!0)})),$(document).on("click","#fullscreen",(async function(e){if(e.preventDefault(),!playerReady)return;let elem=document.getElementById("wrapper");$("#fullscreen").toggleClass("active"),$wrapper.hasClass("fullscreen")?document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen?document.webkitExitFullscreen():document.msExitFullscreen&&document.msExitFullscreen():elem.requestFullscreen?elem.requestFullscreen():elem.mozRequestFullScreen?elem.mozRequestFullScreen():elem.webkitRequestFullscreen?elem.webkitRequestFullscreen():elem.msRequestFullscreen?elem.msRequestFullscreen():elem.webkitEnterFullscreen?elem.webkitEnterFullscreen():(Toast.add(await getString("fullscreenisnotsupported","mod_interactivevideo"),{type:"danger"}),$("#fullscreen").remove())})),$(document).on("fullscreenchange",(async function(){if(document.fullscreenElement)$wrapper.addClass("fullscreen"),$("#interactivevideo-container").addClass("fullscreen"),$videowrapper.css("padding-bottom","0"),$wrapper.find("[data".concat(bsAffix,'-toggle="tooltip"]')).tooltip({container:"#wrapper",boundary:"window"}),$controller.addClass("bg-black").removeClass("bg-dark");else{$wrapper.removeClass("fullscreen"),$("#interactivevideo-container").removeClass("fullscreen");let ratio=16/9;displayoptions.usefixedratio&&0!=displayoptions.usefixedratio||(ratio=player.aspectratio),$videowrapper.css("padding-bottom",1/ratio*100+"%"),$controller.addClass("bg-dark").removeClass("bg-black")}$wrapper.find("#fullscreen i").toggleClass("bi-fullscreen bi-fullscreen-exit")})),$(document).on("visibilitychange",(async function(){if(displayoptions.pauseonblur&&1==displayoptions.pauseonblur){if(!playerReady)return;"hidden"==document.visibilityState&&(player.pause(),onPaused(!0))}})),$(document).on("click","#controller #expand",(function(e){e.preventDefault(),$body.toggleClass("limited-width"),localStorage.setItem("limitedwidth",$body.hasClass("limited-width")),$(this).find("i").toggleClass("bi-square bi-file")})),$(document).on("click","#controller #share",(async function(e){e.preventDefault(),e.stopImmediatePropagation();let time=await player.getCurrentTime();const url=window.location.href;let shareurl=url+(url.indexOf("?")>0?"&":"?")+"t="+Math.round(time);shareurl=shareurl.replace(/&embed=1/g,""),await navigator.clipboard.writeText(shareurl);const copied=await getString("copiedtoclipboard","mod_interactivevideo");Toast.add(copied,{type:"success",autohide:!0,delay:2e3})})),$(document).on("mouseenter","#video-nav #seek",(function(e){if(!playerReady)return;$(this).append('<div id="position"><div id="timelabel"></div></div>');let $position=$("#position");const parentOffset=$(this).offset(),relX=e.pageX-parentOffset.left;$position.css("left",relX+"px");const percentage=relX/$(this).width(),formattedTime=convertSecondsToHMS(percentage*totaltime);$position.find("#timelabel").text(formattedTime)})),$(document).on("mousemove","#video-nav #seek",(function(e){if(!playerReady)return;const parentOffset=$(this).offset(),relX=e.pageX-parentOffset.left,percentage=relX/$(this).width(),formattedTime=convertSecondsToHMS(percentage*totaltime);$("#position").css("left",relX+"px"),$("#position #timelabel").text(formattedTime)})),$(document).on("mouseleave","#video-nav #seek",(function(){$("#position").remove()})),$(document).on("click","#interactions-nav .annotation, #video-nav .annotation",(async function(e){e.preventDefault(),e.stopImmediatePropagation();const timestamp=$(this).data("timestamp");if(await handleUnskippable(timestamp))return;if($loader.fadeIn(300),$(this).hasClass("no-click"))return void Toast.add(await getString("youcannotviewthisannotationyet","mod_interactivevideo"),{type:"danger"});if(await player.getCurrentTime()==timestamp&&lastrun)return void $loader.fadeOut(300);lastrun=null;await player.isPaused()||player.pause(),await replaceProgressBars((timestamp-start)/totaltime*100),await player.seek(Number(timestamp));const id=$(this).data("id"),theAnnotation=releventAnnotations.find((x=>x.id==id));runInteraction(theAnnotation),$loader.fadeOut(300);const preceedingAnno=releventAnnotations.filter((x=>x.timestamp<timestamp)).map((x=>Number(x.id)));viewedAnno=preceedingAnno,viewedAnno.push(id),viewedAnno=[...new Set(viewedAnno)]})),$(document).on("click","#seek",(async function(e){if(!playerReady)return;if(e.preventDefault(),e.stopImmediatePropagation(),$videoNav.hasClass("no-click"))return void Toast.add(await getString("seekingdisabled","mod_interactivevideo"),{type:"danger"});$startscreen.fadeOut(300),$endscreen.fadeOut(300);const parentOffset=$(this).offset(),percentage=(e.pageX-parentOffset.left)/$(this).width();await replaceProgressBars(100*percentage),$loader.fadeIn(300),await player.seek(percentage*totaltime+start);await player.isPlaying()&&!videoEnded||await player.play(),viewedAnno=[],setTimeout((()=>{$("#position").remove(),$loader.fadeOut(300)}),300)})),$(document).on("click","#start-screen #play",(async function(e){if(e.preventDefault(),$(this).hasClass("reload"))location.reload();else{$startscreen.find(".h1").addClass("trantohide"),$startscreen.fadeOut(300),$(this).addClass("d-none"),$videoNav.removeClass("d-none");try{player.play()}catch(error){}}})),$(document).on("click","#end-screen #restart",(async function(e){e.preventDefault(),dispatchEvent("iv:playerRestart"),$("#message").remove(),$body.hasClass("hassidebar")&&($("#annotation-toggle").trigger("click"),$("#annotation-sidebar, #annotation-toggle").remove(),$body.removeClass("hassidebar"),$(".iv-sidebar").addClass("hide")),viewedAnno=[],lastrun=null,$loader.fadeIn(300),await player.seek(start),replaceProgressBars(0),$endscreen.fadeOut(300),$(this).addClass("d-none"),$videoNav.removeClass("d-none"),player.play(),$loader.fadeOut(300)})),$(document).on("click","#video-wrapper .video-block",(async function(e){if(!playerReady)return;if(e.preventDefault(),player.live&&(firstPlay=!0),!firstPlay)return void player.play();await player.isPlaying()?await player.pause():player.play()})),$(document).on("iv:playerStarted",(async function(){$("#playpause").find("i").removeClass("bi-play-fill").addClass("bi-pause-fill"),$("#playpause").attr("data-original-title",await getString("pausetooltip","mod_interactivevideo"))})),$(document).on("click","#playpause",(async function(e){if(!playerReady)return;e.preventDefault(),$(this).tooltip("hide");if(await player.isPlaying())await player.pause();else{await player.getCurrentTime()>=end?$endscreen.find("#restart").trigger("click"):player.play()}})),$(document).on("click","li.anno",(async function(e){e.preventDefault();const id=$(this).data("id");$("li.annotation[data-id=".concat(id,"]")).trigger("click"),$(this).closest("#chapter-container-left").length>0&&$("#chaptertoggle .btn").trigger("click")})),$(document).on("click","#toolbar #annotation-toggle",(function(e){e.preventDefault(),$body.addClass("hassidebar"),$("#annotation-sidebar").removeClass("hide");const current=$("#sidebar-nav .sidebar-nav-item.active").data("id");current&&dispatchEvent("interactionrun",{annotation:releventAnnotations.find((x=>x.id==current))})})),1!=displayoptions.autohidecontrols||$body.hasClass("embed-mode")||$body.hasClass("mobileapp")||$body.hasClass("iframe")||($videowrapper.on("mouseleave",(function(){setTimeout((function(){$videowrapper.is(":hover")||$controller.addClass("fadeOut")}),3e3)})),$videowrapper.on("mouseenter",(function(){setTimeout((function(){$videowrapper.is(":hover")&&$controller.removeClass("fadeOut")}),1e3)}))),$(document).on("click","#mute",(async function(e){e.preventDefault(),$(this).tooltip("hide"),$(this).toggleClass("active"),$(this).hasClass("active")?(player.mute(),$(this).attr("data-original-title",await getString("unmutetooltip","mod_interactivevideo"))):(player.unMute(),$(this).attr("data-original-title",await getString("mutetooltip","mod_interactivevideo"))),$(this).find("i").toggleClass("bi-volume-mute bi-volume-up"),$(this).tooltip("show")})),$(document).on("click",".changerate",(function(e){e.preventDefault();const rate=$(this).data("rate");player.setRate(rate),$(".changerate").find("i").removeClass("bi-check"),$(this).find("i").addClass("bi-check")})),$("#changequality").on("shown.bs.dropdown",(async function(){let quality=await player.getQualities();$("#qualitieslist").empty();let currentQuality=quality.currentQuality;null===currentQuality&&(currentQuality=$(this).data("current"));let qualities=quality.qualities,qualitiesLabel=quality.qualitiesLabel;qualities.forEach(((q,i)=>{$("#qualitieslist").append('<a class="dropdown-item changequality text-white px-3" data-quality="'.concat(q,'"\n                         href="#"><i class="bi ').concat(q==currentQuality?"bi-check":"",' fa-fw"></i>').concat(qualitiesLabel[i],"</a>"))})),$(this).find("[data".concat(bsAffix,"-toggle=dropdown]")).dropdown("update")})),$(document).on("click",".changequality",(function(e){e.preventDefault();const quality=$(this).data("quality");player.setQuality(quality),$(".changequality").find("i").removeClass("bi-check"),$(this).find("i").addClass("bi-check")})),$(document).on("click","#changecaption .changecaption",(function(e){e.preventDefault();const lang=$(this).data("lang");player.setCaption(lang),$("#changecaption .changecaption").find("i").removeClass("bi-check"),$(this).find("i").addClass("bi-check"),""==lang?$("#changecaption .btn i").removeClass("bi-badge-cc-fill").addClass("bi-badge-cc"):$("#changecaption .btn i").removeClass("bi-badge-cc").addClass("bi-badge-cc-fill"),localStorage.setItem("caption-".concat(userid),lang)})),0==displayoptions.preventseeking&&($rewindbutton.on("click",(async function(){let t=await player.getCurrentTime()-5;t<start&&(t=start),await player.seek(t)})),$forwardbutton.on("click",(async function(){let t=await player.getCurrentTime()+5;t>end&&(t=end),await player.seek(t)}))),$(document).one("iv:playerReady",(function(){onReady()})),$(document).on("iv:playerDestroyed",(function(){playerReady=!1}));const addPlayerEvents=function(){$(document).on("iv:playerPaused",(function(){$(".tooltip").remove(),dispatchEvent("videoPaused"),onPaused()})),$(document).on("iv:playerPlaying",(function(){onPlaying()})),$(document).on("iv:playerPlay",(function(){onPlay(),$loader.fadeOut(300)})),$(document).on("iv:playerEnded",(function(){onEnded()})),$(document).on("iv:playerSeek",(function(e){player.live||onSeek(e.detail.time)})),$(document).on("iv:playerLoaded",(function(e){const reloaded=e.detail.reloaded||!1;onLoaded(reloaded,e)})),$(document).on("iv:playerError",(async function(){$annotationcanvas.removeClass("d-none w-0"),$startscreen.addClass("d-none"),$(".video-block").addClass("no-pointer bg-transparent"),$("#spinner").remove(),$("#player").is(":empty")?$("#player").html('<div class="alert alert-danger d-flex text-center h-100 rounded-0\n                         align-items-center justify-content-center">\n                        <img src="'.concat(M.cfg.wwwroot,'/mod/interactivevideo/pix/404-error.png" alt="Error" class="w-25">\n                        </div>')):Toast.add(await getString("thereisanissueloadingvideo","mod_interactivevideo"),{type:"danger"})})),$(document).on("iv:playerRateChange",(function(e){$(".changerate").find("i").removeClass("bi-check"),$('.changerate[data-rate="'.concat(e.originalEvent.detail.rate,'"]')).find("i").addClass("bi-check")})),$(document).on("iv:playerQualityChange",(function(e){$("#changequality").attr("data-current",e.originalEvent.detail.quality),$(".changequality").find("i").removeClass("bi-check"),$('.changequality[data-quality="'.concat(e.originalEvent.detail.quality,'"]')).find("i").addClass("bi-check")}))};addPlayerEvents(),$(document).on("annotationitemsrendered",(function(){try{$wrapper.find("[data".concat(bsAffix,'-toggle="tooltip"]')).tooltip({container:"#wrapper",boundary:"window"})}catch(error){}if(1==displayoptions.disableinteractionclickuntilcompleted&&$interactionNav.find("li:not(.completed)").addClass("no-click"),1==displayoptions.disableinteractionclick&&$interactionNav.find("li").addClass("no-click"),1==displayoptions.preventseeking&&($interactionNav.find("li").addClass("no-click"),$videoNav.addClass("no-click")),$interactionNav.find("li").length>0&&$taskinfo.removeClass("border-0"),playerReady||(playerReady=!0),!isPreviewMode&&!firstPlay){let autoplay=1==displayoptions.autoplay,time=start;$(".intro-content").hasClass("hasintro")&&(autoplay=!1),(uprogress.lastviewed>start&&uprogress.lastviewed<end-5||moment)&&(autoplay=!0,time=moment?Number(moment):uprogress.lastviewed,time=time>=end||time<start?start:time),window.resumetime=time,replaceProgressBars((time-start)/totaltime*100),player.live&&replaceProgressBars(100);const noautoplay=new URLSearchParams(window.location.search).get("da");autoplay&&player.allowAutoplay&&"1"!=noautoplay&&setTimeout((async()=>{try{player.unMute()}catch(error){}moment||$("#play").trigger("click")}),1e3),shareMoment()}})),$("[data".concat(bsAffix,'-toggle="tooltip"]')).on("click",(function(){$(this).tooltip("hide")})),window.addEventListener("beforeunload",(function(){player.pause(),onPaused(!0),$(document).off(),cancelAnimationFrame(playingInterval)})),$(document).on("interactionrun",(function(e){const annotation=e.originalEvent.detail.annotation;let windowAnnos=window.ANNOS,windowAnno=windowAnnos.find((x=>x.id==annotation.id));windowAnno&&(windowAnno.starttime=windowAnno.starttime?windowAnno.starttime:(new Date).getTime(),windowAnno.newstarttime=(new Date).getTime(),windowAnno.completedtime=windowAnno.completedtime?windowAnno.completedtime:null,windowAnno.duration=windowAnno.duration>0?windowAnno.duration:0),windowAnnos=windowAnnos.filter((x=>x.id!=annotation.id)),windowAnnos.push(windowAnno),window.ANNOS=windowAnnos})),$(document).on("interactionclose interactionrefresh",(function(e){const annotation=e.originalEvent.detail.annotation;let windowAnnos=window.ANNOS,windowAnno=windowAnnos.find((x=>x.id==annotation.id));windowAnno&&(windowAnno.duration=windowAnno.duration+((new Date).getTime()-windowAnno.newstarttime)),windowAnnos=windowAnnos.filter((x=>x.id!=annotation.id)),windowAnnos.push(windowAnno),window.ANNOS=windowAnnos})),$(document).on("completionupdated",(async function(e){if(JSON.parse(e.originalEvent.detail.response).overallcomplete)if(JSON.parse(e.originalEvent.detail.response).overallcomplete>0){if(isCompleted)return;isCompleted=!0,fireConfetti(),Toast.add(await getString("congratulationsyoucompletethisactivity","mod_interactivevideo"),{type:"success"}),$("#completiondropdown").html('<i class="fs-25px bi bi-check-circle-fill text-success"></i>')}else isCompleted=!1,$("#completiondropdown").html('<i class="fs-25px bi bi-check-circle text-white"></i>');const annotation=e.originalEvent.detail.target;if(!annotation)return;let windowAnnos=window.ANNOS,windowAnno=windowAnnos.find((x=>x.id==annotation.id));windowAnno&&("mark-done"==e.originalEvent.detail.action?windowAnno.completedtime=(new Date).getTime():windowAnno.completedtime=null),windowAnnos=windowAnnos.filter((x=>x.id!=annotation.id)),windowAnnos.push(windowAnno),window.ANNOS=windowAnnos,$("#message[data-id="+annotation.id+"]").addClass("active");let anno=releventAnnotations.find((x=>x.id==annotation.id)),advanced=anno.advanced;advanced=advanced?JSON.parse(advanced):{},0==advanced.advdismissible&&anno.completed?$("#controller, #video-wrapper, .sidebar-nav-item").removeClass("completion-required"):0!=advanced.advdismissible||anno.completed||($controller.addClass("completion-required"),"bottom"!=$("#message.active").data("placement")&&"side"!=$("#message.active").data("placement")||$("#video-wrapper").addClass("completion-required"),"side"==$("#message.active").data("placement")&&$(".sidebar-nav-item").addClass("completion-required")),anno.completed?$(".sidebar-nav-item[data-id="+annotation.id+"]").addClass("completed"):$(".sidebar-nav-item[data-id="+annotation.id+"]").removeClass("completed")})),$(document).on("iv:autoplayBlocked",(async function(e){e.preventDefault(),!1===e.originalEvent.detail.requireVideoBlock&&$(".video-block").remove(),Toast.add(await getString("autoplayblocked","mod_interactivevideo"),{type:"default",autohide:!0,delay:5e3})}));const updatePlayer=async newPlayer=>{player=newPlayer,start=newPlayer.start,end=newPlayer.end,vtype=newPlayer.type,loaded=!1;let types=Object.keys(ctRenderer);return await Promise.all(types.map((async type=>ctRenderer[type].setPlayer(newPlayer,start,end,vtype))))};$(document).on("iv:playerReload",(async function(e){playerReady=!0,viewedAnno=[],lastrun=null,videoEnded=!1;let detail=e.originalEvent.detail;subvideo="series"==detail.behavior&&!detail.main,detail.player&&(detail.player.subvideo=subvideo,await updatePlayer(detail.player,detail.behavior)),onReady(!0,detail.main),replaceProgressBars(detail.currentTime/(end-start)*100)})),$(document).on("click","#message[data-placement]:not(.active)",(function(e){e.preventDefault(),$(this).addClass("active"),dispatchEvent("interactionrun",{annotation:releventAnnotations.find((x=>x.id==$(this).data("id")))})})),document.addEventListener("keydown",(async function(e){if("body"===document.activeElement.tagName.toLowerCase()&&!$body.hasClass("disablekb")&&!(e.ctrlKey||e.metaKey||e.altKey))switch(e.code){case"Space":e.preventDefault(),await player.isPaused()?player.play():player.pause();break;case"KeyC":e.preventDefault(),$("#chaptertoggle .btn").trigger("click");break;case"KeyM":if(e.preventDefault(),$("#mute").length>0)$("#mute").trigger("click");else{await player.isMuted()?player.unMute():player.mute()}break;case"KeyF":e.preventDefault(),$("#fullscreen").trigger("click");break;case"KeyR":e.preventDefault(),$endscreen.find("#restart").trigger("click");break;case"KeyS":e.preventDefault(),$controller.find("#share").trigger("click");break;case"KeyE":e.preventDefault(),$controller.find("#expand").length>0?$controller.find("#expand").trigger("click"):($body.toggleClass("limited-width"),localStorage.setItem("limitedwidth",$body.hasClass("limited-width")));break;case"ArrowLeft":e.preventDefault(),$rewindbutton.trigger("click");break;case"ArrowRight":e.preventDefault(),$forwardbutton.trigger("click")}}))}}}));

//# sourceMappingURL=viewannotation.min.js.map