<?php
/**
 *
 * @package     mod_lanebs
 * @category    HealthCheck
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\HealthCheck;

use mod_lanebs\AuthService\AuthFactory;
use mod_lanebs\Support\Client\BaseClientService;
use mod_lanebs\Support\Client\NullClientLogger;
use mod_lanebs\Token\TokenFactory;

final class HealthCheckFactory
{
    public static function create(): HealthCheckInterface
    {
        return new HealthCheck(
            new BaseClientService(new NullClientLogger()),
            TokenFactory::create(),
            AuthFactory::create()
        );
    }
}