<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Logger
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\Logger;

use mod_lanebs\Support\Client\BaseClientService;
use mod_lanebs\Support\Client\ClientLoggerFactory;
use mod_lanebs\Support\Config;
use mod_lanebs\Token\TokenFactory;

final class LoggerFactory
{
    public static function create(): LoggerInterface
    {
        static $instance;
        if (!$instance) {
            $instance = new Logger(
                Config::baseUrl(),
                TokenFactory::create(),
                new BaseClientService(ClientLoggerFactory::create()),
                Config::version()
            );
        }

        return $instance;
    }
}