<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Support
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\Support;

final class Config
{
    public const DEFAULT = [
        'base_url' => 'https://c.lanbook.com',
        'auth_url' => 'https://security.lanbook.com',
        'moodle_api' => 'https://moodle-api.e.lanbook.com',
        'search_api' => 'http://212.41.20.23:8080',
        'reader_url' => 'https://reader.lanbook.com',
        'profile_url' => 'https://profile.e.lanbook.com',
    ];

    /**
     * @return void
     */
    public static function installConfig(): void
    {
        foreach (self::DEFAULT as $name => $value) {
            self::set($name, $value);
        }
    }

    /**
     * @param string $name
     * @param mixed $value
     * @return void
     */
    public static function set(string $name, mixed $value): void
    {
        set_config($name, $value, 'mod_lanebs');
    }

    /**
     * @param string $name
     * @return mixed
     * @noinspection PhpDocMissingThrowsInspection
     */
    public static function get(string $name): mixed
    {
        /** @noinspection PhpUnhandledExceptionInspection */
        return get_config('mod_lanebs', $name);
    }

    public static function version(): int
    {
        return (int)self::get('version');
    }

    public static function baseUrl(): ?string
    {
        return self::get('base_url') ?: null;
    }

    public static function authUrl(): ?string
    {
        return self::get('auth_url') ?: null;
    }

    public static function moodleApi(): ?string
    {
        return self::get('moodle_api') ?: null;
    }
}