<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_lanebs
 * @category    string
 * @copyright   2020 Senin Yurii <katorsi@mail.ru>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Integration with ELS Lan';
$string['modulename'] = 'Integration with ELS Lan';
$string['modulename_help'] = 'The plugin allows you to add content from EBS Lan to the course: chapters and paragraphs of textbooks, articles from scientific journals, educational videos. Video instructions for working with the EUK constructor are here: <a href="https://vk.com/video-177041626_456239072" target="_blank">https://vk.com/video-177041626_456239072</a>';
$string['lanebsname'] = 'Resource name';
$string['lanebsname_help'] = 'Enter the name of the library';
$string['button_desc'] = 'Check resource';
$string['lanebs:name'] = 'Resource name';
$string['lanebs:name_desc'] = '';
$string['lanebs:name_default'] = 'Integration with ELS Lan';
$string['lanebs:token'] = 'Access token';
$string['lanebs:token_desc'] = 'Token for API';
$string['lanebs:login'] = 'Login';
$string['lanebs:login_desc'] = '';
$string['lanebs:login_default'] = '';
$string['lanebs:token'] = 'Token';
$string['lanebs:token_desc'] = '';
$string['pluginadministration'] = '';
$string['modulenameplural'] = 'Integration with ELS Lan';
$string['title_modal_search'] = 'Search resource';
$string['search_str'] = 'Search string';
$string['search_placeholder_str'] = 'Enter the name of the resource';
$string['button_label_str'] = 'Search button';
$string['button_str'] = 'Search';
$string['cancel_str'] = 'Close';
$string['lanebs:get_tree'] = 'Right for get tree catalog';
$string['lanebs:get_constructor'] = 'Right for get Lan Constructor';
$string['lanebs:addinstance'] = 'Right for get lanebs instance';
$string['title_modal_book'] = 'Preview';
$string['content_error'] = 'Check resource';
$string['lanebsbutton'] = 'Resource selection';
$string['lanebsbutton_help'] = 'Find the required resource in the window and click "Add"';
$string['lanebs_filter_by_category'] = 'Choose by category';
$string['lanebs_filter_by_name'] = 'By name';
$string['lanebs_filter_by_author'] = 'By author';
$string['lanebs_filter_by_toc'] = 'By toc';
$string['lanebs_filter_by_spo'] = 'vocational education only';
$string['lanebs_filter_by_vo'] = 'higher education only';
$string['lanebs_filter_by_all'] = 'all';
$string['lanebs_read'] = 'Read with';
$string['lanebs_read_page'] = 'page';
$string['lanebs_read_pg'] = 'pg';
$string['lanebs_cover'] = 'Cover';
$string['lanebs_view'] = 'View';
$string['lanebs_error_textbox'] = 'Text box not found';
$string['lanebs_error_search'] = 'Search button not found';
$string['lanebs_error_book'] = 'Choose the book firstly';
$string['lanebs_show_desc'] = 'Show description';
$string['lanebs_add'] = 'Add';
$string['lanebs_preshow'] = 'Preshow';
$string['lanebs_error_empty_search'] = 'Books not found';
$string['lanebs_BACK'] = 'BACK';
$string['lanebs_auth_error'] = 'Access token is empty or invalid';
$string['lanebs_error_close'] = 'Close button not found';
$string['lanebs_prev'] = 'Previous';
$string['lanebs_next'] = 'Next';
$string['lanebs_from'] = 'from';
$string['lanebs_copy_attention'] = 'Save module before copy!';
$string['lanebs_copy_error'] = 'Error. Repeat copy process';
$string['video_button_desc'] = 'Choose video';
$string['title_modal_video'] = 'Choosing video';
$string['submit_button'] = 'Submit';
$string['player_title'] = 'Video player';
$string['video_materials'] = 'Video materials:';
$string['choosen_resourse'] = 'Choosen resourse';
$string['page_number'] = 'Page Number';
$string['biblio_record'] = 'Bibliographic record';
$string['video'] = 'Video';
$string['copy_paste'] = 'Copy/Paste settings';
$string['copy_settings'] = 'Copy settings';
$string['paste_settings'] = 'Paste settings';
$string['plugin_title'] = 'Library Integration';
$string['subscriber_token'] = 'Subscriber token';
$string['token_desc'] = 'Subscriber token for reader access';
$string['lan_constructor'] = 'Go to materials selection';
$string['privacy:metadata'] = 'The LANEBS module does not store any personal data';
$string['lanebs_role'] = 'WS Role for Lan Constructor';
$string['lanebs_title'] = 'EBS Lan Constructor';
$string['lanebs_link_info'] = 'Video instructions for working with the Constructor:';

$string['connection_parameters'] = 'Connection parameters';
$string['checking_plugin'] = 'Checking the plugin';
$string['instruction'] = 'Instruction';

$string['unity_list'] = 'Single list of sources';
$string['placeholder'] = 'will be filled in automatically';
