<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin administration pages are defined here.
 *
 * @package     mod_lanebs
 * @category    admin
 * @copyright   2020 Senin Yurii <katorsi@mail.ru>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once __DIR__ . '/lib.php';
/**
 * @var admin_root $ADMIN
 * @var admin_settingpage $settings
 * @var string $section -- modsettinglanebs
 */

$ADMIN->add(
    'modsettings',
    new admin_category('modlanebsfolder', new lang_string('pluginname', 'mod_lanebs'))
);


$settings = new admin_settingpage(
    $section,
    get_string('connection_parameters', 'mod_lanebs'),
    'moodle/site:config'
);

if ($ADMIN->fulltree) {
    // TODO: Define the plugin settings page.
    // https://docs.moodle.org/dev/Admin_settings
    
    $settings->add(new admin_setting_configtext(
        'lanebs/token',
        get_string('lanebs:token', 'mod_lanebs'),
        get_string('lanebs:token_desc', 'mod_lanebs'),
        ''
    ));
    
    /*
    $settings->add(new admin_setting_configtext(
        'mod_lanebs/base_url',
        'base_url',
        '',
        'https://c.lanbook.com'
    ));


    $settings->add(new admin_setting_configtext(
        'mod_lanebs/auth_url',
        'auth_url',
        '',
        'https://security.lanbook.com'
    ));

    $settings->add(new admin_setting_configtext(
        'mod_lanebs/moodle_api',
        'moodle_api',
        '',
        'https://moodle-api.e.lanbook.com'
    ));

    $settings->add(new admin_setting_configtext(
        'mod_lanebs/search_api',
        'search_api',
        '',
        'http://212.41.20.23:8080'
    ));

    $settings->add(new admin_setting_configtext(
        'mod_lanebs/reader_url',
        'reader_url',
        '',
        'https://reader.lanbook.com'
    ));

    $settings->add(new admin_setting_configtext(
        'mod_lanebs/profile_url',
        'profile_url',
        '',
        'https://profile.e.lanbook.com'
    ));
    
    */
    
    // -----------------------------------------------------------------------------------------------------------------
    $url = new moodle_url('/mod/lanebs/health_check.php');
    $link = html_writer::link(
        $url,
        get_string('checking_plugin', 'mod_lanebs'),
        [
            'class' => 'btn btn-secondary',
            'target' => '_blank'
        ]
    );
    $html = html_writer::div($link, 'col text-center');
    $settings->add(new admin_setting_heading('lanebs/heath_check', $html, ''));
    // -----------------------------------------------------------------------------------------------------------------
    
    $token = get_config('lanebs', 'token');
    if ($token) {
        $data = array(
            'type' => 'install'
        );
        if (!function_exists('send_stat')) {
            require(__DIR__ . '/locallib.php');
        }
        send_stat($data);
    }
}

$ADMIN->add('modlanebsfolder', $settings);

$settings = null;

$page = new admin_externalpage(
    'mod_lanebs_health_check',
    get_string('checking_plugin', 'mod_lanebs'),
    new moodle_url('/mod/lanebs/health_check.php')
);

$ADMIN->add('modlanebsfolder', $page);
