<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Content
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\tests\Content;

use advanced_testcase;
use mod_lanebs\Content\ContentFactory;
use mod_lanebs\Content\ContentInterface;
use mod_lanebs\Support\Config;

final class ContentService_test extends advanced_testcase
{
    protected ContentInterface $service;

    protected function setUp(): void
    {
        if (!defined('TEST_MOD_LANEBS_TOKEN') || !TEST_MOD_LANEBS_TOKEN) {
            $this->markTestSkipped('empty TEST_MOD_LANEBS_TOKEN');
        }
        $this->resetAfterTest();

        Config::installConfig();
        set_config('token', TEST_MOD_LANEBS_TOKEN, 'mod_lanebs');
        $this->service = ContentFactory::create();
    }

    public function test_getCategories(): void
    {
        $result = $this->service->getCategories();
        $result = json_decode($result);
        $this->assertNotEmpty($result);
    }
}