<?php

declare(strict_types=1);

namespace mod_lanebs\tests;

use advanced_testcase;

final class LangTest extends advanced_testcase
{
    protected function loadLangFile(string $lang): array
    {
        require __DIR__ . '/../lang/' . $lang . '/lanebs.php';
        /** @var array<string, string> $string */
        return $string;
    }

    public function test_diffPack(): void
    {
        $en = $this->loadLangFile('en');
        $en = array_keys($en);

        $ru = $this->loadLangFile('ru');
        $ru = array_keys($ru);

        $diff = array_diff($en, $ru);
        $this->assertEmpty($diff, implode(', ' . PHP_EOL, $diff));

        $diff = array_diff($ru, $en);
        $this->assertEmpty($diff);
    }
}