<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Token
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\tests\Token;

use advanced_testcase;
use mod_lanebs\Token\TokenFactory;

final class Token_test extends advanced_testcase
{
    protected const ASSERT_TOKEN = 'test_token';

    protected function setUp(): void
    {
        $this->resetAfterTest();
        parent::setUp();
    }

    public function test_nullable(): void
    {
        $this->assertNull(TokenFactory::create()->get());
    }

    public function test_userToken(): void
    {
        global $USER;
        $service = TokenFactory::create();
        $this->assertNull($service->get());

        $this->setAdminUser();
        $USER->profile['mod_lanebs_token'] = self::ASSERT_TOKEN;

        $this->assertEquals(self::ASSERT_TOKEN, $service->get());
    }

    public function test_configToken(): void
    {
        $service = TokenFactory::create();
        $this->assertNull($service->get());
        set_config('token', self::ASSERT_TOKEN, 'mod_lanebs');

        $this->assertEquals(self::ASSERT_TOKEN, $service->get());
    }

    public function test_priority(): void
    {
        global $USER;
        $service = TokenFactory::create();
        $this->assertNull($service->get());

        $this->setAdminUser();
        $USER->profile['mod_lanebs_token'] = 'fail';
        set_config('token', self::ASSERT_TOKEN, 'mod_lanebs');

        $this->assertEquals(self::ASSERT_TOKEN, $service->get());
    }
}