# Релиз

Релиз версии собирается из трех значений, пример:

```PHP
$plugin->release = '1.2.3';
//                  X.Y.Z
```

* 1 (X) -- инкремент для поддержки Moodle.
* 2 (Y) -- инкремент для новой фичи или большого рефакторинга.
* 3 (Z) -- инкремент для исправления багов.

## Поддержка Moodle

* Релиз `1.Y.Z` будет поддерживать moodle c 3.7 по 4.2
* Релиз `2.Y.Z` будет поддерживать moodle c 4.3 по 4.4

## Добавление новой фичи

При добавлении новой фичи мы увеличиваем `Y` инкремент

* 2.0.0 -- Состоялся большой рефакторинг и была добавлена диагностика
* 2.1.0 -- Диагностика была расширена
* 2.2.0 -- Добавлена возможность формирования единого списка литературы.
  Улучшен пользовательский интерфейс.
* и тд.

## Исправление ошибок

Если же была обнаружена какая либо ошибка в плагине, то под исправления будет повышен третий инкремент `Z`.

К примеру:

* 2.0.0
* 2.0.1
* 2.0.2
* и тд

# Версия

В мудле самое главное это версия плагина поэтому важно и в ней найти четкую иерархию.

```PHP
$plugin->version = 2024090900.00;
```

Если бы мы не поддерживали старые версии, то можно было ставить дату релиза в версию каждый раз когда мы обновляли X или
Y инкремент.
Но мы еще должны поддерживать старую версию `1.Y.Z`

Поэтомы мы заимствуем то как это делает Moodle.
Версия Moodle это помесь даты + инкремент версии + добавочное число.

```PHP
$version  = 2024042200.01;              // 20240422      = branching date YYYYMMDD - do not modify!
                                        //         RR    = release increments - 00 in DEV branches.
                                        //           .XX = incremental changes.
```

Что позволяет обновлять сам Moodle без всяких проблем.
И при обновлении всегда будет числовая версия больше чем обновляемая.

Пример:
Допустим релиз 1.0.0 вышел 2024.01.01 тогда версия будет `2024010100.00`
Если будут найдены баги, то изменяем `.XX` то есть `2024010100.01` и тд

| release | version       | Moodle    |
|---------|---------------|-----------|
| 1.0.0   | 2024010100.00 | 3.7-4.2   |
| 1.0.1   | 2024010100.01 | 3.7-4.2   |
| 1.0.2   | 2024010100.02 | 3.7-4.2   |
| ------  | ------------- | --------- |
| 1.1.0   | 2024010101.00 | 3.7-4.2   |
| 1.1.1   | 2024010101.01 | 3.7-4.2   |
| ------  | ------------- | --------- |
| 2.0.0   | 2024020100.00 | 4.3-4.4   |
| 2.1.0   | 2024020101.00 | 4.3-4.4   |

Но есть проблема, старые версии шли в разнобой, поэтому эту схему применим с версии 2.2.0 а в качестве адоновой даты
возьмем 2.1.0 т.к. она последняя на момент принятия этой схемы.

Чтобы не запутаться буду ввести историю:

| release | version       | Moodle    |
|---------|---------------|-----------|
| 1.3.13  | 2024012829    | 3.7-4.2   |
| 1.3.14  | 2024012830    | 3.7-4.2   |
| 1.3.15  | 2024012831    | 3.7-4.2   |
| ------  | ------------- | --------- |
| 2.0.0   | 2024053000    | 4.3-4.4   |
| 2.0.1   | 2024053001    | 4.3-4.4   |
| 2.0.2   | 2024053002    | 4.3-4.4   |
| 2.1.0   | 2024090900    | 4.3-4.4   |
| 2.2.0   | 2024090902.00 | 4.3-4.4   |

