<?php
$services = array(
    'lab_ebsservice' => array(
        'functions' => array('mod_lanebs_search_books', 'mod_lanebs_book_content', 'mod_lanebs_category_tree', 'mod_lanebs_auth', 'mod_lanebs_lanebs_info', 'mod_lanebs_toc_name', 'mod_lanebs_toc_videos', 'mod_lanebs_video_stat'),
        'requiredcapability' => 'mod/lanebs:get_tree',
        'restrictedusers' => 1,
        'enabled' => 1,
        'shortname' => 'LanEbsIntegration',
        'downloadfiles' => 0,
        'uploadfiles' => 0,
    ),
    'lan_constructor_service' => array(
        'functions' => array('mod_lanebs_create_mod_lanebs', 'mod_lanebs_get_service_token', 'mod_lanebs_get_subscriber_token', 'mod_lanebs_get_reader_token', 'mod_lanebs_get_script_names', 'mod_lanebs_create_mod_quiz', 'mod_lanebs_send_log'),
        'requiredcapability' => 'mod/lanebs:get_constructor',
        'restrictedusers' => 1,
        'enabled' => 1,
        'shortname' => 'LanConstructor',
        'downloadfiles' => 0,
        'uploadfiles' => 0,
    ),
);

$functions = array(
    'mod_lanebs_search_books' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'search_books',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get book list',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree'
    ),
    'mod_lanebs_book_content' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'book_content',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get reader with book content',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree'
    ),
    'mod_lanebs_category_tree' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'category_tree',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get category tree',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_auth' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'auth',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Authorized in ELS',
        'type'  => 'read',
        'ajax'  => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_lanebs_info' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'lanebs_info',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get information about lanebs module',
        'type'  => 'read',
        'ajax'  => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_toc_name' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'toc_name',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get TOC by page number',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_toc_videos' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'toc_videos',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Get TOC videos by book ID',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_create_mod_lanebs' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'create_mod_lanebs',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Create lanebs module',
        'type' => 'write',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_get_service_token' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'get_service_token',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Get service token',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_get_subscriber_token' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'get_subscriber_token',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Get subscriber token',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_get_reader_token' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'get_reader_token',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Get reader token',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_get_script_names' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'get_script_names',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Get script names',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_video_stat' => array(
        'classname' => 'mod_lanebs_external',
        'methodname' => 'video_stat',
        'classpath' => 'mod/lanebs/externallib.php',
        'description' => 'Send video stat',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_tree',
    ),
    'mod_lanebs_create_mod_quiz' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'create_mod_quiz',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Create mod_quiz',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
    'mod_lanebs_send_log' => array(
        'classname' => 'mod_lanebs_constructor_external',
        'methodname' => 'send_log',
        'classpath' => 'mod/lanebs/constructor_externallib.php',
        'description' => 'Send log to C',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => 'lanebs:get_constructor',
    ),
);