<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    AuthService
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\tests\AuthService;

use advanced_testcase;
use mod_lanebs\AuthService\Auth;
use mod_lanebs\Support\Client\BaseClientService;
use mod_lanebs\Support\Client\ClientLoggerInterface;
use mod_lanebs\Token\TokenInterface;

final class Auth_test extends advanced_testcase
{
    protected function setUp(): void
    {
        if (
            !defined('TEST_MOD_LANEBS_AUTH_URL') ||
            !TEST_MOD_LANEBS_AUTH_URL ||
            !defined('TEST_MOD_LANEBS_TOKEN') ||
            !TEST_MOD_LANEBS_TOKEN
        ) {
            $this->markTestSkipped('empty TEST_MOD_LANEBS_AUTH_URL or TEST_MOD_LANEBS_TOKEN');
        }
        $this->resetAfterTest();
        parent::setUp(); // TODO: Change the autogenerated stub
    }

    protected function getService(): Auth
    {
        $token = new class implements TokenInterface {
            public function get(): ?string
            {
                return TEST_MOD_LANEBS_TOKEN;
            }
        };

        $logger = new class implements ClientLoggerInterface {
            public function log($result, string $url, array $params = [], array $options = [], $info = []): void
            {
            }
        };

        return new Auth(
            TEST_MOD_LANEBS_AUTH_URL,
            $token,
            new BaseClientService($logger)
        );
    }

    public function test_raw(): void
    {
        $data = $this->getService()->raw();
        $this->assertNotEmpty($data);
    }

    public function test_auth_or_get(): void
    {
        $service = $this->getService();
        $data = $service->auth();
        $this->assertTrue(isset($data->jwt->access_token));
        $this->assertEquals($data->jwt->access_token, $service->get());
    }
}